/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.models.local;

import com.intellij.internal.ml.ModelMetadataReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/ml/models/local/ZipModelMetadataReader;", "Lcom/intellij/internal/ml/ModelMetadataReader;", "zipFile", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "allKnown", "", "binaryFeatures", "categoricalFeatures", "extractVersion", "featureOrderDirect", "", "floatFeatures", "resourceContent", "fileName", "tryGetResourceAsStream", "Ljava/io/InputStream;", "intellij.platform.ml.impl"})
@SourceDebugExtension(value={"SMAP\nZipModelMetadataReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipModelMetadataReader.kt\ncom/intellij/internal/ml/models/local/ZipModelMetadataReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n179#2,2:31\n1#3:33\n*S KotlinDebug\n*F\n+ 1 ZipModelMetadataReader.kt\ncom/intellij/internal/ml/models/local/ZipModelMetadataReader\n*L\n18#1:31,2\n*E\n"})
public class ZipModelMetadataReader
implements ModelMetadataReader {
    @NotNull
    private final ZipFile zipFile;

    public ZipModelMetadataReader(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        this.zipFile = zipFile;
    }

    @NotNull
    public String binaryFeatures() {
        return this.resourceContent("binary.json");
    }

    @NotNull
    public String floatFeatures() {
        return this.resourceContent("float.json");
    }

    @NotNull
    public String categoricalFeatures() {
        return this.resourceContent("categorical.json");
    }

    @NotNull
    public String allKnown() {
        return this.resourceContent("all_features.json");
    }

    @NotNull
    public List<String> featureOrderDirect() {
        return StringsKt.lines((CharSequence)this.resourceContent("features_order.txt"));
    }

    @Nullable
    public String extractVersion() {
        return null;
    }

    @Nullable
    public final InputStream tryGetResourceAsStream(@NotNull String fileName) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ZipEntry it = (ZipEntry)element$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)fileName, (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        ZipEntry zipEntry = v2;
        if (zipEntry == null) {
            return null;
        }
        ZipEntry entry2 = zipEntry;
        return this.zipFile.getInputStream(entry2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String resourceContent(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        InputStream stream = this.tryGetResourceAsStream(fileName);
        if (stream == null) {
            throw new IllegalStateException("Can't find necessary '" + fileName + "' resource in zip file");
        }
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }
}

