/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSplitter
implements Splitter {
    public static final int MIN_RANGE_LENGTH = 3;

    protected static void addWord(@NotNull Consumer<? super TextRange> consumer, boolean ignore, @Nullable TextRange found) {
        boolean tooShort;
        if (consumer == null) {
            BaseSplitter.$$$reportNull$$$0(0);
        }
        if (found == null || ignore) {
            return;
        }
        boolean bl = tooShort = found.getEndOffset() - found.getStartOffset() <= 3;
        if (tooShort) {
            return;
        }
        consumer.consume((Object)found);
    }

    protected static boolean isAllWordsAreUpperCased(@NotNull String text2, @NotNull List<? extends TextRange> words2) {
        if (text2 == null) {
            BaseSplitter.$$$reportNull$$$0(1);
        }
        if (words2 == null) {
            BaseSplitter.$$$reportNull$$$0(2);
        }
        for (TextRange textRange : words2) {
            StringCharacterIterator it = new StringCharacterIterator(text2, textRange.getStartOffset(), textRange.getEndOffset(), textRange.getStartOffset());
            char c = it.first();
            while (c != '\uffff') {
                if (!Character.isUpperCase(c)) {
                    return false;
                }
                c = it.next();
            }
        }
        return true;
    }

    protected static boolean containsShortWord(@NotNull List<? extends TextRange> words2) {
        if (words2 == null) {
            BaseSplitter.$$$reportNull$$$0(3);
        }
        for (TextRange textRange : words2) {
            if (textRange.getLength() >= 3) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(5);
        }
        return BaseSplitter.subRange(range, matcher.start(), matcher.end());
    }

    @NotNull
    protected static TextRange matcherRange(@NotNull TextRange range, @NotNull Matcher matcher, int group) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            BaseSplitter.$$$reportNull$$$0(7);
        }
        return BaseSplitter.subRange(range, matcher.start(group), matcher.end(group));
    }

    @NotNull
    protected static TextRange subRange(@NotNull TextRange range, int start2, int end) {
        if (range == null) {
            BaseSplitter.$$$reportNull$$$0(8);
        }
        TextRange textRange = TextRange.from((int)(range.getStartOffset() + start2), (int)(end - start2));
        if (textRange == null) {
            BaseSplitter.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    protected static boolean badSize(int from, int till) {
        int l = till - from;
        return l <= 3;
    }

    @NotNull
    protected static List<TextRange> excludeByPattern(String text2, TextRange range, @NotNull Pattern toExclude, int groupToInclude) {
        int till;
        boolean addLast;
        int from;
        SmartList toCheck;
        block12: {
            SmartList smartList;
            if (toExclude == null) {
                BaseSplitter.$$$reportNull$$$0(10);
            }
            toCheck = new SmartList();
            from = range.getStartOffset();
            addLast = true;
            try {
                Matcher matcher = toExclude.matcher(BaseSplitter.newBombedCharSequence(text2, range));
                while (matcher.find()) {
                    TextRange contentFound;
                    BaseSplitter.checkCancelled();
                    TextRange found = BaseSplitter.matcherRange(range, matcher);
                    till = found.getStartOffset();
                    if (range.getEndOffset() - found.getEndOffset() < 3) {
                        addLast = false;
                    }
                    if (!BaseSplitter.badSize(from, till)) {
                        toCheck.add(new TextRange(from, till));
                    }
                    if (groupToInclude > 0 && BaseSplitter.badSize((contentFound = BaseSplitter.matcherRange(range, matcher, groupToInclude)).getEndOffset(), contentFound.getStartOffset())) {
                        toCheck.add(contentFound);
                    }
                    from = found.getEndOffset();
                }
                till = range.getEndOffset();
                if (!BaseSplitter.badSize(from, till)) break block12;
                smartList = toCheck;
            }
            catch (ProcessCanceledException e) {
                List<TextRange> list2 = Collections.singletonList(range);
                if (list2 == null) {
                    BaseSplitter.$$$reportNull$$$0(13);
                }
                return list2;
            }
            if (smartList == null) {
                BaseSplitter.$$$reportNull$$$0(11);
            }
            return smartList;
        }
        if (addLast) {
            toCheck.add(new TextRange(from, till));
        }
        SmartList smartList = toCheck;
        if (smartList == null) {
            BaseSplitter.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    protected static CharSequence newBombedCharSequence(String text2, TextRange range) {
        return BaseSplitter.newBombedCharSequence(range.substring(text2));
    }

    protected static CharSequence newBombedCharSequence(String substring) {
        final long myTime = System.currentTimeMillis() + 500L;
        return new StringUtil.BombedCharSequence(substring){

            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static void checkCancelled() {
        if (ApplicationManager.getApplication() != null) {
            ProgressIndicatorProvider.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/BaseSplitter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "subRange";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeByPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWord";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAllWordsAreUpperCased";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsShortWord";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matcherRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subRange";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "excludeByPattern";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 11, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

