/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.tasks.Task;
import com.intellij.tasks.context.WorkingContextManager;
import org.jetbrains.annotations.NonNls;

public abstract class LoadContextUndoableAction
extends GlobalUndoableAction {
    protected final WorkingContextManager myManager;
    private final boolean myClear;
    @NonNls
    private static final String SNAPSHOT = "snapshot";

    public static LoadContextUndoableAction createAction(WorkingContextManager manager, boolean clear2, final String contextName2) {
        return new LoadContextUndoableAction(manager, clear2){

            @Override
            protected void doLoad() {
                this.myManager.loadContext(contextName2);
            }
        };
    }

    public static LoadContextUndoableAction createAction(WorkingContextManager manager, boolean clear2, final Task task) {
        return new LoadContextUndoableAction(manager, clear2){

            @Override
            protected void doLoad() {
                this.myManager.restoreContext(task);
            }
        };
    }

    private LoadContextUndoableAction(WorkingContextManager manager, boolean clear2) {
        this.myManager = manager;
        this.myClear = clear2;
    }

    public void undo() throws UnexpectedUndoException {
        this.myManager.clearContext();
        this.myManager.loadContext(SNAPSHOT);
    }

    public void redo() {
        this.myManager.saveContext(SNAPSHOT, null);
        if (this.myClear) {
            this.myManager.clearContext();
        }
        this.doLoad();
    }

    protected abstract void doLoad();
}

