/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomCompletionContributor;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValueReference<T>
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider,
ResolvingHint {
    private final GenericDomValue<T> myGenericValue;

    public GenericDomValueReference(GenericDomValue<T> domValue) {
        super((PsiElement)DomUtil.getValueElement(domValue));
        this.myGenericValue = domValue;
        assert (DomUtil.hasXml(domValue));
        this.setRangeInElement(this.createTextRange());
    }

    protected final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myGenericValue.getManager().getProject());
    }

    protected TextRange createTextRange() {
        GenericDomValue<T> genericDomValue = this.myGenericValue;
        if (genericDomValue instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)genericDomValue;
            XmlAttributeValue attributeValue2 = genericAttributeValue.getXmlAttributeValue();
            if (attributeValue2 == null) {
                return TextRange.from((int)0, (int)genericAttributeValue.getXmlAttribute().getTextLength());
            }
            int length = attributeValue2.getTextLength();
            return length < 2 ? TextRange.from((int)0, (int)length) : new TextRange(1, length - 1);
        }
        XmlTag tag = this.myGenericValue.getXmlTag();
        assert (tag != null);
        return XmlTagUtil.getTrimmedValueRange(tag);
    }

    protected final GenericDomValue<T> getGenericValue() {
        return this.myGenericValue;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    protected PsiElement resolveInner(T o) {
        Converter<T> converter = this.getConverter();
        if (converter instanceof ResolvingConverter) {
            return ((ResolvingConverter)converter).resolve(o, this.getConvertContext());
        }
        if (o instanceof PsiElement) {
            return (PsiElement)o;
        }
        if (o instanceof DomElement) {
            DomTarget target = DomTarget.getTarget((DomElement)o);
            return target == null ? null : PomService.convertToPsi((PsiTarget)target);
        }
        if (o instanceof MergedObject) {
            List list2 = ((MergedObject)o).getImplementations();
            for (Object o1 : list2) {
                PsiElement psiElement = this.resolveInner(o1);
                if (psiElement == null) continue;
                return psiElement;
            }
        }
        return o != null ? this.getElement() : null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Converter<T> converter;
        if (element == null) {
            GenericDomValueReference.$$$reportNull$$$0(0);
        }
        if ((converter = this.getConverter()) instanceof ResolvingConverter) {
            PomTarget target;
            Object value = this.myGenericValue.getValue();
            if (value instanceof DomElement && element instanceof PomTargetPsiElementImpl && (target = ((PomTargetPsiElementImpl)element).getTarget()) instanceof DomTarget && value.equals(((DomTarget)target).getDomElement())) {
                return true;
            }
            return ((ResolvingConverter)converter).isReferenceTo(element, this.getStringValue(), value, this.getConvertContext());
        }
        return super.isReferenceTo(element);
    }

    private String getStringValue() {
        return this.myGenericValue.getStringValue();
    }

    public Converter<T> getConverter() {
        return WrappingConverter.getDeepestConverter(this.myGenericValue.getConverter(), this.myGenericValue);
    }

    @Nullable
    public PsiElement resolve() {
        Object value = this.myGenericValue.getValue();
        return value == null ? null : this.resolveInner(value);
    }

    @NotNull
    public String getCanonicalText() {
        String string2 = StringUtil.notNullize((String)this.getStringValue());
        if (string2 == null) {
            GenericDomValueReference.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        ConvertContext context = this.getConvertContext();
        String string2 = this.getConverter().getErrorMessage(this.getStringValue(), context);
        if (string2 == null) {
            GenericDomValueReference.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public final ConvertContext getConvertContext() {
        return ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler(this.myGenericValue));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Converter<T> converter;
        if (newElementName == null) {
            GenericDomValueReference.$$$reportNull$$$0(3);
        }
        if ((converter = this.getConverter()) instanceof ResolvingConverter) {
            ((ResolvingConverter)converter).handleElementRename(this.myGenericValue, this.getConvertContext(), newElementName);
            return this.myGenericValue.getXmlTag();
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Converter<T> converter;
        if (element == null) {
            GenericDomValueReference.$$$reportNull$$$0(4);
        }
        if ((converter = this.getConverter()) instanceof ResolvingConverter) {
            ((ResolvingConverter)converter).bindReference(this.myGenericValue, this.getConvertContext(), element);
            return this.myGenericValue.getXmlTag();
        }
        if (element instanceof XmlTag) {
            DomElement domElement = this.myGenericValue.getManager().getDomElement((XmlTag)element);
            if (domElement != null) {
                this.myGenericValue.setValue(domElement);
            } else {
                this.myGenericValue.setStringValue(((XmlTag)element).getName());
            }
            return this.myGenericValue.getXmlTag();
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        Converter converter = this.getConverter();
        if ((converter instanceof EnumConverter || converter == ResolvingConverter.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated(this.getElement())) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                GenericDomValueReference.$$$reportNull$$$0(5);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result2 = new ArrayList<Object>();
            ConvertContext convertContext = this.getConvertContext();
            for (Object variant : resolvingConverter.getVariants(convertContext)) {
                LookupElement lookupElement = resolvingConverter.createLookupElement(variant);
                if (lookupElement != null) {
                    result2.add(lookupElement);
                    continue;
                }
                String name = converter.toString(variant, convertContext);
                if (name == null) continue;
                result2.add(ElementPresentationManager.getInstance().createVariant(variant, name, ((ResolvingConverter)converter).getPsiElement(variant)));
            }
            for (String string2 : resolvingConverter.getAdditionalVariants(convertContext)) {
                result2.add(LookupValueFactory.createLookupValue((String)string2, null));
            }
            Object[] objectArray = result2.toArray();
            if (objectArray == null) {
                GenericDomValueReference.$$$reportNull$$$0(6);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            GenericDomValueReference.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        Converter<T> converter = this.getConverter();
        return !(converter instanceof ResolvingConverter) || ((ResolvingConverter)converter).canResolveTo(elementClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/GenericDomValueReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/GenericDomValueReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

