/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.webSymbols.customElements.json.CustomElementsContribution;
import com.intellij.webSymbols.customElements.json.DeclarationBase;
import com.intellij.webSymbols.customElements.json.Deprecated;
import com.intellij.webSymbols.customElements.json.ExportBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"declarations", "deprecated", "description", "exports", "kind", "path", "summary"})
public class JavaScriptModule
implements CustomElementsContribution {
    @JsonProperty(value="declarations")
    @JsonPropertyDescription(value="The declarations of a module.\n\nFor documentation purposes, all declarations that are reachable from\nexports should be described here. Ie, functions and objects that may be\nproperties of exported objects, or passed as arguments to functions.")
    private List<DeclarationBase> declarations = new ArrayList<DeclarationBase>();
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the module is deprecated.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A markdown description of the module.")
    private String description;
    @JsonProperty(value="exports")
    @JsonPropertyDescription(value="The exports of a module. This includes JavaScript exports and\ncustom element definitions.")
    private List<ExportBase> exports = new ArrayList<ExportBase>();
    @JsonProperty(value="kind")
    private Kind kind;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Path to the javascript file needed to be imported. \n(not the path for example to a typescript file.)")
    private String path;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A markdown summary suitable for display in a listing.")
    private String summary;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="declarations")
    public List<DeclarationBase> getDeclarations() {
        return this.declarations;
    }

    @JsonProperty(value="declarations")
    public void setDeclarations(List<DeclarationBase> declarations) {
        this.declarations = declarations;
    }

    @Override
    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description2) {
        this.description = description2;
    }

    @JsonProperty(value="exports")
    public List<ExportBase> getExports() {
        return this.exports;
    }

    @JsonProperty(value="exports")
    public void setExports(List<ExportBase> exports) {
        this.exports = exports;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path2) {
        this.path = path2;
    }

    @Override
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary2) {
        this.summary = summary2;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static enum Kind {
        JAVASCRIPT_MODULE("javascript-module");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

