/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.json.JsonBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SuggestEnumValuesFix
extends PsiUpdateModCommandQuickFix {
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public SuggestEnumValuesFix(JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = JsonBundle.message("replace.with.allowed.value", new Object[0]);
        if (string2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    protected void applyFix(@NotNull Project project2, @NotNull PsiElement initialElement, @NotNull ModPsiUpdater updater) {
        if (project2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(2);
        }
        if (initialElement == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(4);
        }
        PsiFile file = initialElement.getContainingFile();
        PsiElement element = this.myQuickFixAdapter.adjustValue(initialElement);
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get(project2);
        JsonSchemaObject object = jsonSchemaService.getSchemaObject(updater.getOriginalFile(file));
        if (object == null) {
            return;
        }
        List<LookupElement> variants = JsonSchemaCompletionContributor.getCompletionVariants(object, element, element, CompletionType.BASIC);
        if (variants.isEmpty()) {
            return;
        }
        updater.templateBuilder().field(element, (Expression)new ConstantNode(variants.get(0).getLookupString()).withLookupItems(variants));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

