/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.RootJsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectBackedByJacksonBase;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectBackedByJacksonFactory;
import com.jetbrains.jsonSchema.impl.light.nodes.RootJsonSchemaObjectBackedByJackson;
import com.jetbrains.jsonSchema.impl.light.nodes.RootJsonSchemaObjectBackedByJacksonKt;
import com.jetbrains.jsonSchema.impl.light.versions.JsonSchemaInterpretationStrategy;
import com.jetbrains.jsonSchema.impl.light.versions.JsonSchemaInterpretationStrategyKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00130\u0017H\u0002J+\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u00012\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001b\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0014H\u0016JR\u0010#\u001a\b\u0012\u0004\u0012\u0002H%0$\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010'\u001a\u00020\u00032\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140)2 \u0010*\u001a\u001c\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140)\u0012\u0006\u0012\u0004\u0018\u0001H%0+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020\u0014H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\u0014H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/jsonSchema/impl/light/nodes/RootJsonSchemaObjectBackedByJackson;", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectBackedByJacksonBase;", "Lcom/jetbrains/jsonSchema/impl/RootJsonSchemaObject;", "Lcom/fasterxml/jackson/databind/JsonNode;", "rootNode", "schemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getSchemaFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "schemaInterpretationStrategy", "Lcom/jetbrains/jsonSchema/impl/light/versions/JsonSchemaInterpretationStrategy;", "getSchemaInterpretationStrategy", "()Lcom/jetbrains/jsonSchema/impl/light/versions/JsonSchemaInterpretationStrategy;", "schemaObjectFactory", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectBackedByJacksonFactory;", "checkHasInjections", "", "collectValuesWithKey", "", "", "expectedKey", "storeIn", "Lcom/intellij/openapi/util/Key;", "getChildSchemaObjectByName", "parentSchemaObject", "childNodeRelativePointer", "", "(Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectBackedByJacksonBase;[Ljava/lang/String;)Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectBackedByJacksonBase;", "getFileUrl", "getRawFile", "getRootSchemaObject", "getSchemaObjectByAbsoluteJsonPointer", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "jsonPointer", "indexSchema", "Lkotlin/sequences/Sequence;", "T", "", "root", "parentPointer", "", "retrieveDataFromNode", "Lkotlin/Function2;", "resolveDynamicAnchor", "anchor", "resolveId", "id", "intellij.json"})
@ApiStatus.Internal
public final class RootJsonSchemaObjectBackedByJackson
extends JsonSchemaObjectBackedByJacksonBase
implements RootJsonSchemaObject<JsonNode, JsonSchemaObjectBackedByJacksonBase> {
    @Nullable
    private final VirtualFile schemaFile;
    @NotNull
    private final JsonSchemaObjectBackedByJacksonFactory schemaObjectFactory;
    @NotNull
    private final JsonSchemaInterpretationStrategy schemaInterpretationStrategy;

    public RootJsonSchemaObjectBackedByJackson(@NotNull JsonNode rootNode, @Nullable VirtualFile schemaFile) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        super(rootNode, "/");
        this.schemaFile = schemaFile;
        this.schemaObjectFactory = new JsonSchemaObjectBackedByJacksonFactory(this);
        this.schemaInterpretationStrategy = JsonSchemaInterpretationStrategyKt.computeJsonSchemaVersion(this.getSchema());
    }

    @Nullable
    public final VirtualFile getSchemaFile() {
        return this.schemaFile;
    }

    @Override
    @NotNull
    public JsonSchemaInterpretationStrategy getSchemaInterpretationStrategy() {
        return this.schemaInterpretationStrategy;
    }

    @Nullable
    public JsonSchemaObjectBackedByJacksonBase getChildSchemaObjectByName(@NotNull JsonSchemaObjectBackedByJacksonBase parentSchemaObject, String ... childNodeRelativePointer) {
        Intrinsics.checkNotNullParameter((Object)parentSchemaObject, (String)"parentSchemaObject");
        Intrinsics.checkNotNullParameter((Object)childNodeRelativePointer, (String)"childNodeRelativePointer");
        return this.schemaObjectFactory.getChildSchemaObjectByName(parentSchemaObject, Arrays.copyOf(childNodeRelativePointer, childNodeRelativePointer.length));
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectByAbsoluteJsonPointer(@NotNull String jsonPointer2) {
        Intrinsics.checkNotNullParameter((Object)jsonPointer2, (String)"jsonPointer");
        return this.schemaObjectFactory.getSchemaObjectByAbsoluteJsonPointer(jsonPointer2);
    }

    public final boolean checkHasInjections() {
        return (Boolean)this.getOrComputeValue(RootJsonSchemaObjectBackedByJacksonKt.access$getINJECTIONS_MAP_KEY$p(), (Function0)new Function0<Boolean>(this){
            final /* synthetic */ RootJsonSchemaObjectBackedByJackson this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence $this$any$iv = RootJsonSchemaObjectBackedByJackson.indexSchema$default(this.this$0, this.this$0.getRawSchemaNode(), null, checkHasInjections.1.INSTANCE, 2, null);
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl2 = false;
                        if (!it) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
    }

    @Override
    @Nullable
    public String getFileUrl() {
        VirtualFile virtualFile = this.schemaFile;
        return virtualFile != null ? virtualFile.getUrl() : null;
    }

    @Override
    @Nullable
    public VirtualFile getRawFile() {
        return this.schemaFile;
    }

    @Override
    @NotNull
    public RootJsonSchemaObjectBackedByJackson getRootSchemaObject() {
        return this;
    }

    @Override
    @Nullable
    public String resolveId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string2 = this.getSchemaInterpretationStrategy().getIdKeyword();
        if (string2 == null) {
            return null;
        }
        String schemaFeature = string2;
        return this.collectValuesWithKey(schemaFeature, (Key<Map<String, String>>)RootJsonSchemaObjectBackedByJacksonKt.access$getIDS_MAP_KEY$p()).get(id);
    }

    @Override
    @Nullable
    public String resolveDynamicAnchor(@NotNull String anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        String string2 = this.getSchemaInterpretationStrategy().getDynamicAnchorKeyword();
        if (string2 == null) {
            return null;
        }
        String schemaFeature = string2;
        return this.collectValuesWithKey(schemaFeature, (Key<Map<String, String>>)RootJsonSchemaObjectBackedByJacksonKt.access$getDYNAMIC_ANCHORS_MAP_KEY$p()).get(anchor);
    }

    private final Map<String, String> collectValuesWithKey(String expectedKey, Key<Map<String, String>> storeIn) {
        return this.getOrComputeValue(storeIn, (Function0)new Function0<Map<String, ? extends String>>(this, expectedKey){
            final /* synthetic */ RootJsonSchemaObjectBackedByJackson this$0;
            final /* synthetic */ String $expectedKey;
            {
                this.this$0 = $receiver;
                this.$expectedKey = $expectedKey;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return MapsKt.toMap((Sequence)RootJsonSchemaObjectBackedByJackson.indexSchema$default(this.this$0, this.this$0.getRawSchemaNode(), null, (Function2)new Function2<JsonNode, List<? extends String>, Pair<? extends String, ? extends String>>(this.$expectedKey){
                    final /* synthetic */ String $expectedKey;
                    {
                        this.$expectedKey = $expectedKey;
                        super(2);
                    }

                    @Nullable
                    public final Pair<String, String> invoke(@NotNull JsonNode node, @NotNull List<String> parentPointer) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter(parentPointer, (String)"parentPointer");
                        if (!node.isTextual() || !Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(parentPointer), (Object)this.$expectedKey)) {
                            return null;
                        }
                        String leafNodeText = node.asText();
                        String jsonPointer2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)parentPointer, (int)(parentPointer.size() - 1)), (CharSequence)"/", (CharSequence)"/", null, (int)0, null, (Function1)collectValuesWithKey.jsonPointer.1.INSTANCE, (int)28, null);
                        return TuplesKt.to((Object)leafNodeText, (Object)jsonPointer2);
                    }
                }, 2, null));
            }
        });
    }

    private final <T> Sequence<T> indexSchema(JsonNode root, List<String> parentPointer, Function2<? super JsonNode, ? super List<String>, ? extends T> retrieveDataFromNode) {
        Sequence sequence;
        if (root.isObject()) {
            Iterator iterator = root.fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
            sequence = SequencesKt.flatMap((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)new Function1<Map.Entry<String, JsonNode>, Sequence<? extends T>>(retrieveDataFromNode, root, parentPointer, this){
                final /* synthetic */ Function2<JsonNode, List<String>, T> $retrieveDataFromNode;
                final /* synthetic */ JsonNode $root;
                final /* synthetic */ List<String> $parentPointer;
                final /* synthetic */ RootJsonSchemaObjectBackedByJackson this$0;
                {
                    this.$retrieveDataFromNode = $retrieveDataFromNode;
                    this.$root = $root;
                    this.$parentPointer = $parentPointer;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<T> invoke(Map.Entry<String, JsonNode> entry2) {
                    Intrinsics.checkNotNull(entry2);
                    String name = entry2.getKey();
                    JsonNode objectField = entry2.getValue();
                    Object retrievedValue = this.$retrieveDataFromNode.invoke((Object)this.$root, this.$parentPointer);
                    if (retrievedValue != null) {
                        Object[] objectArray = new Object[]{retrievedValue};
                        return SequencesKt.sequenceOf((Object[])objectArray);
                    }
                    Intrinsics.checkNotNull((Object)objectField);
                    return RootJsonSchemaObjectBackedByJackson.access$indexSchema(this.this$0, objectField, CollectionsKt.plus((Collection)this.$parentPointer, (Object)name), this.$retrieveDataFromNode);
                }
            });
        } else if (root.isArray()) {
            Object retrievedValue = retrieveDataFromNode.invoke((Object)root, parentPointer);
            if (retrievedValue != null) {
                Object[] objectArray = new Object[]{retrievedValue};
                return SequencesKt.sequenceOf((Object[])objectArray);
            }
            Iterator iterator = root.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            sequence = SequencesKt.flatMapIndexedSequence((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function2)new Function2<Integer, JsonNode, Sequence<? extends T>>(this, parentPointer, retrieveDataFromNode){
                final /* synthetic */ RootJsonSchemaObjectBackedByJackson this$0;
                final /* synthetic */ List<String> $parentPointer;
                final /* synthetic */ Function2<JsonNode, List<String>, T> $retrieveDataFromNode;
                {
                    this.this$0 = $receiver;
                    this.$parentPointer = $parentPointer;
                    this.$retrieveDataFromNode = $retrieveDataFromNode;
                    super(2);
                }

                @NotNull
                public final Sequence<T> invoke(int index, JsonNode arrayItem) {
                    Intrinsics.checkNotNull((Object)arrayItem);
                    return RootJsonSchemaObjectBackedByJackson.access$indexSchema(this.this$0, arrayItem, CollectionsKt.plus((Collection)this.$parentPointer, (Object)String.valueOf(index)), this.$retrieveDataFromNode);
                }
            });
        } else if (root.isTextual()) {
            Object retrievedValue = retrieveDataFromNode.invoke((Object)root, parentPointer);
            sequence = UtilKt.sequenceOfNotNull((Object)retrievedValue);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    static /* synthetic */ Sequence indexSchema$default(RootJsonSchemaObjectBackedByJackson rootJsonSchemaObjectBackedByJackson, JsonNode jsonNode, List list2, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return rootJsonSchemaObjectBackedByJackson.indexSchema(jsonNode, list2, function2);
    }

    public static final /* synthetic */ Sequence access$indexSchema(RootJsonSchemaObjectBackedByJackson $this, JsonNode root, List parentPointer, Function2 retrieveDataFromNode) {
        return $this.indexSchema(root, parentPointer, retrieveDataFromNode);
    }
}

