/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayValidation
implements JsonSchemaValidation {
    public static final ArrayValidation INSTANCE = new ArrayValidation();

    @Override
    public void validate(@NotNull JsonValueAdapter propValue, @NotNull JsonSchemaObject schema, @Nullable JsonSchemaType schemaType, @NotNull JsonValidationHost consumer, @NotNull JsonComplianceCheckerOptions options) {
        if (propValue == null) {
            ArrayValidation.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            ArrayValidation.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ArrayValidation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            ArrayValidation.$$$reportNull$$$0(3);
        }
        ArrayValidation.checkArray(propValue, schema, consumer, options);
    }

    private static void checkArray(JsonValueAdapter value, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        JsonArrayValueAdapter asArray = value.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        ArrayValidation.checkArrayItems(value, elements, schema, consumer, options);
    }

    private static void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(4);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(5);
        }
        ArrayValidation.validateUniqueItems(array, list2, schema, consumer);
        ArrayValidation.validateAgainstContainsSchema(array, list2, schema, consumer, options);
        ArrayValidation.validateIndividualItems(list2, schema, consumer);
        ArrayValidation.validateArrayLength(array, list2, schema, consumer);
        ArrayValidation.validateArrayLengthHeuristically(array, list2, schema, consumer);
    }

    private static void validateIndividualItems(@NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer) {
        block6: {
            block5: {
                if (list2 == null) {
                    ArrayValidation.$$$reportNull$$$0(6);
                }
                if (schema.getItemsSchema() == null) break block5;
                for (JsonValueAdapter item : list2) {
                    consumer.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), item);
                }
                break block6;
            }
            if (schema.getItemsSchemaList() == null) break block6;
            Iterator<? extends JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    consumer.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                    consumer.error(JsonBundle.message("schema.validation.array.no.extra", new Object[0]), arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema.getAdditionalItemsSchema() == null) continue;
                consumer.checkObjectBySchemaRecordErrors(schema.getAdditionalItemsSchema(), arrayValue);
            }
        }
    }

    protected static void validateArrayLengthHeuristically(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(7);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(8);
        }
        if (schema.getMinLength() != null && list2.size() < schema.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxLength() != null && list2.size() > schema.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxLength()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    protected static void validateArrayLength(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(9);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(10);
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.shorter.than", schema.getMinItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            consumer.error(JsonBundle.message("schema.validation.array.longer.than", schema.getMaxItems()), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    protected static void validateAgainstContainsSchema(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(11);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(12);
        }
        if (schema.getContainsSchema() != null) {
            boolean match2 = false;
            for (JsonValueAdapter item : list2) {
                JsonValidationHost checker = consumer.checkByMatchResult(item, consumer.resolve(schema.getContainsSchema(), array), options);
                if (checker != null && !checker.isValid()) continue;
                match2 = true;
                break;
            }
            if (!match2) {
                consumer.error(JsonBundle.message("schema.validation.array.not.contains", new Object[0]), array.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
    }

    protected static void validateUniqueItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema, JsonValidationHost consumer) {
        if (array == null) {
            ArrayValidation.$$$reportNull$$$0(13);
        }
        if (list2 == null) {
            ArrayValidation.$$$reportNull$$$0(14);
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array.getDelegate(), schema);
            assert (walker != null);
            for (JsonValueAdapter adapter : list2) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry2 : valueTexts.entrySet()) {
                if (((Collection)entry2.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item : (Collection)entry2.getValue()) {
                    if (!item.shouldCheckAsValue()) continue;
                    consumer.error(JsonBundle.message("schema.validation.not.unique", new Object[0]), item.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/ArrayValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArrayItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateIndividualItems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validateArrayLengthHeuristically";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "validateArrayLength";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAgainstContainsSchema";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "validateUniqueItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

