/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.NotAllowedPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternInterner;

public class PatternBuilder {
    private final EmptyPattern empty;
    protected final NotAllowedPattern notAllowed;
    protected final PatternInterner interner;

    public PatternBuilder() {
        this.empty = new EmptyPattern();
        this.notAllowed = new NotAllowedPattern();
        this.interner = new PatternInterner();
    }

    public PatternBuilder(PatternBuilder patternBuilder) {
        this.empty = patternBuilder.empty;
        this.notAllowed = patternBuilder.notAllowed;
        this.interner = new PatternInterner(patternBuilder.interner);
    }

    Pattern makeEmpty() {
        return this.empty;
    }

    Pattern makeNotAllowed() {
        return this.notAllowed;
    }

    Pattern makeGroup(Pattern pattern2, Pattern pattern3) {
        if (pattern2 == this.empty) {
            return pattern3;
        }
        if (pattern3 == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed || pattern3 == this.notAllowed) {
            return this.notAllowed;
        }
        GroupPattern groupPattern = new GroupPattern(pattern2, pattern3);
        return this.interner.intern(groupPattern);
    }

    Pattern makeInterleave(Pattern pattern2, Pattern pattern3) {
        if (pattern2 == this.empty) {
            return pattern3;
        }
        if (pattern3 == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed || pattern3 == this.notAllowed) {
            return this.notAllowed;
        }
        InterleavePattern interleavePattern = new InterleavePattern(pattern2, pattern3);
        return this.interner.intern(interleavePattern);
    }

    Pattern makeChoice(Pattern pattern2, Pattern pattern3) {
        if (pattern2 == this.empty && pattern3.isNullable()) {
            return pattern3;
        }
        if (pattern3 == this.empty && pattern2.isNullable()) {
            return pattern2;
        }
        ChoicePattern choicePattern = new ChoicePattern(pattern2, pattern3);
        return this.interner.intern(choicePattern);
    }

    Pattern makeOneOrMore(Pattern pattern2) {
        if (pattern2 == this.empty || pattern2 == this.notAllowed || pattern2 instanceof OneOrMorePattern) {
            return pattern2;
        }
        OneOrMorePattern oneOrMorePattern = new OneOrMorePattern(pattern2);
        return this.interner.intern(oneOrMorePattern);
    }

    Pattern makeOptional(Pattern pattern2) {
        return this.makeChoice(pattern2, this.empty);
    }

    Pattern makeZeroOrMore(Pattern pattern2) {
        return this.makeOptional(this.makeOneOrMore(pattern2));
    }
}

