/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.dtd;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.input.CommentTrimmer;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupMember;
import com.thaiopensource.xml.dtd.om.AttributeGroupVisitor;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeVisitor;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupVisitor;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupVisitor;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.TokenizedDatatype;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.om.TopLevelVisitor;
import com.thaiopensource.xml.em.ExternalId;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Converter {
    private final Dtd dtd;
    private final ErrorReporter er;
    private final SchemaCollection sc = new SchemaCollection();
    private final Options options;
    private boolean hadAny = false;
    private boolean hadDefaultValue = false;
    private final Map elementNameTable = new Hashtable();
    private final Map attlistDeclTable = new Hashtable();
    private final Set definedNames = new HashSet();
    private final Map prefixTable = new Hashtable();
    private final Map attributeNamesTable = new Hashtable();
    private Set attributeNames = null;
    private String defaultNamespace = null;
    private String annotationPrefix = null;
    private String colonReplacement = null;
    private String elementDeclPattern = null;
    private String attlistDeclPattern = null;
    private String anyName = null;
    private static final int ELEMENT_DECL = 1;
    private static final int ATTLIST_DECL = 2;
    private static final int ELEMENT_REF = 4;
    private static final String SEPARATORS = ".-_";
    private static final String DEFAULT_PATTERN = "#.%";
    private final String[] ELEMENT_KEYWORDS = new String[]{"element", "elem", "e"};
    private final String[] ATTLIST_KEYWORDS = new String[]{"attlist", "attributes", "attribs", "atts", "a"};
    private final String[] ANY_KEYWORDS = new String[]{"any", "ANY", "anyElement"};

    public Converter(Dtd dtd, ErrorReporter errorReporter, Options options) {
        this.dtd = dtd;
        this.er = errorReporter;
        this.options = options;
    }

    public SchemaCollection convert() {
        try {
            this.dtd.accept(new Analyzer());
            this.chooseNames();
            GrammarPattern grammarPattern = new GrammarPattern();
            this.sc.setMainUri(this.dtd.getUri());
            this.sc.getSchemaDocumentMap().put(this.dtd.getUri(), new SchemaDocument(grammarPattern, this.dtd.getEncoding()));
            ComponentOutput componentOutput = new ComponentOutput(grammarPattern);
            this.dtd.accept(componentOutput);
            this.outputUndefinedElements(grammarPattern.getComponents());
            if (this.options.generateStart) {
                this.outputStart(grammarPattern.getComponents());
            }
            this.outputAny(grammarPattern.getComponents());
            componentOutput.finish();
            return this.sc;
        }
        catch (Exception exception) {
            throw (RuntimeException)exception;
        }
    }

    private void chooseNames() {
        this.chooseAny();
        this.chooseColonReplacement();
        this.chooseDeclPatterns();
        this.choosePrefixes();
        this.chooseAnnotationPrefix();
    }

    private void chooseAny() {
        if (!this.hadAny) {
            return;
        }
        if (this.options.anyName != null) {
            if (!this.definedNames.contains(this.options.anyName)) {
                this.anyName = this.options.anyName;
                this.definedNames.add(this.anyName);
                return;
            }
            this.warning("cannot_use_any_name");
        }
        int n = 0;
        while (true) {
            int n2 = 0;
            while (n2 < this.ANY_KEYWORDS.length) {
                this.anyName = Converter.repeatChar('_', n) + this.ANY_KEYWORDS[n2];
                if (!this.definedNames.contains(this.anyName)) {
                    this.definedNames.add(this.anyName);
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void choosePrefixes() {
        if (this.options.defaultNamespace != null) {
            if (this.defaultNamespace != null && !this.defaultNamespace.equals(this.options.defaultNamespace)) {
                this.warning("default_namespace_conflict");
            }
            this.defaultNamespace = this.options.defaultNamespace;
        } else if (this.defaultNamespace == null) {
            this.defaultNamespace = SchemaBuilder.INHERIT_NS;
        }
        Iterator iterator = this.options.prefixMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2 = iterator.next();
            String string2 = (String)entry2.getKey();
            String string3 = (String)entry2.getValue();
            String string4 = (String)this.prefixTable.get(string2);
            if (string4 == null) {
                this.warning("irrelevant_prefix", string2);
                continue;
            }
            if (!string4.equals("") && !string4.equals(string3)) {
                this.warning("prefix_conflict", string2);
            }
            this.prefixTable.put(string2, string3);
        }
    }

    private void chooseAnnotationPrefix() {
        if (!this.hadDefaultValue) {
            return;
        }
        if (this.options.annotationPrefix != null) {
            if (this.prefixTable.get(this.options.annotationPrefix) == null) {
                this.annotationPrefix = this.options.annotationPrefix;
                return;
            }
            this.warning("cannot_use_annotation_prefix");
        }
        int n = 0;
        while (true) {
            this.annotationPrefix = Converter.repeatChar('_', n) + "a";
            if (this.prefixTable.get(this.annotationPrefix) == null) {
                return;
            }
            ++n;
        }
    }

    private void chooseColonReplacement() {
        if (this.options.colonReplacement != null) {
            this.colonReplacement = this.options.colonReplacement;
            if (this.colonReplacementOk()) {
                return;
            }
            this.warning("cannot_use_colon_replacement");
            this.colonReplacement = null;
        }
        if (this.colonReplacementOk()) {
            return;
        }
        int n = 1;
        while (true) {
            int n2 = 0;
            while (n2 < SEPARATORS.length()) {
                this.colonReplacement = Converter.repeatChar(SEPARATORS.charAt(n2), n);
                if (this.colonReplacementOk()) {
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean colonReplacementOk() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.elementNameTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = this.mungeQName((String)iterator.next());
            if (hashSet.contains(string2)) {
                return false;
            }
            hashSet.add(string2);
        }
        return true;
    }

    private void chooseDeclPatterns() {
        if (this.options.elementDeclPattern != null) {
            if (this.patternOk(this.options.elementDeclPattern, null)) {
                this.elementDeclPattern = this.options.elementDeclPattern;
            } else {
                this.warning("cannot_use_element_decl_pattern");
            }
        }
        if (this.options.attlistDeclPattern != null) {
            if (this.patternOk(this.options.attlistDeclPattern, this.elementDeclPattern)) {
                this.attlistDeclPattern = this.options.attlistDeclPattern;
            } else {
                this.warning("cannot_use_attlist_decl_pattern");
            }
        }
        if (this.elementDeclPattern != null && this.attlistDeclPattern != null) {
            return;
        }
        String string2 = this.namingPattern();
        if (this.elementDeclPattern == null) {
            this.elementDeclPattern = this.patternOk("%", this.attlistDeclPattern) ? "%" : this.choosePattern(string2, this.ELEMENT_KEYWORDS, this.attlistDeclPattern);
        }
        if (this.attlistDeclPattern == null) {
            this.attlistDeclPattern = this.choosePattern(string2, this.ATTLIST_KEYWORDS, this.elementDeclPattern);
        }
    }

    private String choosePattern(String string2, String[] stringArray, String string3) {
        while (true) {
            int n = 0;
            while (n < stringArray.length) {
                String string4 = Converter.substitute(string2, '#', stringArray[n]);
                if (this.patternOk(string4, string3)) {
                    return string4;
                }
                ++n;
            }
            string2 = string2.substring(0, 1) + string2.substring(1, 2) + string2.substring(1, 2) + string2.substring(2);
        }
    }

    private String namingPattern() {
        int n;
        String string2;
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.definedNames.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            n = 0;
            while (n < SEPARATORS.length()) {
                char c = SEPARATORS.charAt(n);
                int n2 = string2.indexOf(c);
                if (n2 > 0) {
                    Converter.inc(hashtable, string2.substring(0, n2 + 1) + "%");
                }
                if ((n2 = string2.lastIndexOf(c)) >= 0 && n2 < string2.length() - 1) {
                    Converter.inc(hashtable, "%" + string2.substring(n2));
                }
                ++n;
            }
        }
        string2 = null;
        n = 0;
        Iterator iterator2 = hashtable.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2 = iterator2.next();
            int n3 = (Integer)entry2.getValue();
            if (string2 != null && n3 <= n) continue;
            n = n3;
            string2 = (String)entry2.getKey();
        }
        if (string2 == null) {
            return DEFAULT_PATTERN;
        }
        if (string2.charAt(0) == '%') {
            return string2.substring(0, 2) + "#";
        }
        return "#" + string2.substring(string2.length() - 2);
    }

    private static void inc(Map map, String string2) {
        Integer n = (Integer)map.get(string2);
        if (n == null) {
            map.put(string2, new Integer(1));
        } else {
            map.put(string2, new Integer(n + 1));
        }
    }

    private boolean patternOk(String string2, String string3) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.elementNameTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = this.mungeQName((String)iterator.next());
            String string5 = Converter.substitute(string2, '%', string4);
            if (this.definedNames.contains(string5)) {
                return false;
            }
            if (string3 == null) continue;
            String string6 = Converter.substitute(string3, '%', string4);
            if (hashSet.contains(string5) || hashSet.contains(string6) || string5.equals(string6)) {
                return false;
            }
            hashSet.add(string5);
            hashSet.add(string6);
        }
        return true;
    }

    private void noteDef(String string2) {
        this.definedNames.add(string2);
    }

    private void noteElementName(String string2, int n) {
        Integer n2 = (Integer)this.elementNameTable.get(string2);
        if (n2 != null) {
            if (n2 == (n |= n2.intValue())) {
                return;
            }
        } else {
            this.noteNamePrefix(string2);
        }
        this.elementNameTable.put(string2, new Integer(n));
    }

    private void noteAttlist(String string2, AttributeGroup attributeGroup) {
        Vector<AttributeGroup> vector = (Vector<AttributeGroup>)this.attlistDeclTable.get(string2);
        if (vector == null) {
            vector = new Vector<AttributeGroup>();
            this.attlistDeclTable.put(string2, vector);
        }
        vector.add(attributeGroup);
    }

    private void noteAttribute(String string2, String string3) {
        if (string2.equals("xmlns")) {
            if (string3 != null) {
                if (this.defaultNamespace != null && !this.defaultNamespace.equals(string3)) {
                    this.error("INCONSISTENT_DEFAULT_NAMESPACE");
                } else {
                    this.defaultNamespace = string3;
                }
            }
        } else if (string2.startsWith("xmlns:")) {
            if (string3 != null) {
                String string4 = string2.substring(6);
                String string5 = (String)this.prefixTable.get(string4);
                if (string5 != null && !string5.equals("") && !string5.equals(string3)) {
                    this.error("INCONSISTENT_PREFIX", string4);
                } else if (!string4.equals("xml")) {
                    this.prefixTable.put(string4, string3);
                }
            }
        } else {
            if (string3 != null) {
                this.hadDefaultValue = true;
            }
            this.noteNamePrefix(string2);
        }
    }

    private void noteNamePrefix(String string2) {
        int n = string2.indexOf(58);
        if (n < 0) {
            return;
        }
        String string3 = string2.substring(0, n);
        if (this.prefixTable.get(string3) == null && !string3.equals("xml")) {
            this.prefixTable.put(string3, "");
        }
    }

    private int nameFlags(String string2) {
        Integer n = (Integer)this.elementNameTable.get(string2);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private String elementDeclName(String string2) {
        return Converter.substitute(this.elementDeclPattern, '%', this.mungeQName(string2));
    }

    private String attlistDeclName(String string2) {
        return Converter.substitute(this.attlistDeclPattern, '%', this.mungeQName(string2));
    }

    private String mungeQName(String string2) {
        if (this.colonReplacement == null) {
            int n = string2.indexOf(58);
            if (n < 0) {
                return string2;
            }
            return string2.substring(n + 1);
        }
        return Converter.substitute(string2, ':', this.colonReplacement);
    }

    private static String repeatChar(char c, int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    private static String substitute(String string2, char c, String string3) {
        int n = string2.indexOf(c);
        if (n < 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, n));
        stringBuffer.append(string3);
        stringBuffer.append(string2.substring(n + 1));
        return stringBuffer.toString();
    }

    private void outputStart(List list2) {
        ChoicePattern choicePattern = new ChoicePattern();
        int n = 5;
        while (true) {
            boolean bl = false;
            Iterator iterator = this.elementNameTable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                if (((Integer)entry2.getValue() & n) != 1) continue;
                bl = true;
                choicePattern.getChildren().add(Converter.ref(this.elementDeclName((String)entry2.getKey())));
            }
            if (bl) break;
            if (n == 1) {
                return;
            }
            n = 1;
        }
        list2.add(new DefineComponent(DefineComponent.START, choicePattern));
    }

    private void outputAny(List list2) {
        if (!this.hadAny) {
            return;
        }
        if (this.options.strictAny) {
            DefineComponent defineComponent = new DefineComponent(this.anyName, new TextPattern());
            defineComponent.setCombine(Combine.CHOICE);
            list2.add(defineComponent);
        } else {
            GroupPattern groupPattern = new GroupPattern();
            groupPattern.getChildren().add(new ZeroOrMorePattern(new AttributePattern(new AnyNameNameClass(), new TextPattern())));
            groupPattern.getChildren().add(Converter.ref(this.anyName));
            ChoicePattern choicePattern = new ChoicePattern();
            choicePattern.getChildren().add(new ElementPattern(new AnyNameNameClass(), groupPattern));
            choicePattern.getChildren().add(new TextPattern());
            list2.add(new DefineComponent(this.anyName, new ZeroOrMorePattern(choicePattern)));
        }
    }

    private void outputUndefinedElements(List list2) {
        Vector vector = new Vector();
        vector.addAll(this.elementNameTable.keySet());
        Collections.sort(vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (((Integer)this.elementNameTable.get(string2) & 1) != 0) continue;
            DefineComponent defineComponent = new DefineComponent(this.elementDeclName(string2), new NotAllowedPattern());
            defineComponent.setCombine(Combine.CHOICE);
            list2.add(defineComponent);
        }
    }

    private static Pattern ref(String string2) {
        return new RefPattern(string2);
    }

    private void error(String string2) {
        this.er.error(string2, null);
    }

    private void error(String string2, String string3) {
        this.er.error(string2, string3, null);
    }

    private void warning(String string2) {
        this.er.warning(string2, null);
    }

    private void warning(String string2, String string3) {
        this.er.warning(string2, string3, null);
    }

    private static String[] valueType(Datatype datatype) {
        datatype = datatype.deref();
        switch (datatype.getType()) {
            case 0: {
                return new String[]{"", "string"};
            }
            case 1: {
                return new String[]{"http://www.w3.org/2001/XMLSchema-datatypes", ((TokenizedDatatype)datatype).getTypeName()};
            }
        }
        return new String[]{"", "token"};
    }

    private Pattern convert(ModelGroup modelGroup) throws Exception {
        ModelGroupOutput modelGroupOutput = new ModelGroupOutput();
        modelGroup.accept(modelGroupOutput);
        return modelGroupOutput.pattern;
    }

    private Pattern convert(Datatype datatype) throws Exception {
        DatatypeOutput datatypeOutput = new DatatypeOutput();
        datatype.accept(datatypeOutput);
        return datatypeOutput.pattern;
    }

    private Pattern convert(AttributeGroup attributeGroup) throws Exception {
        GroupPattern groupPattern = new GroupPattern();
        attributeGroup.accept(new AttributeGroupOutput(groupPattern));
        switch (groupPattern.getChildren().size()) {
            case 0: {
                return new EmptyPattern();
            }
            case 1: {
                return (Pattern)groupPattern.getChildren().get(0);
            }
        }
        return groupPattern;
    }

    private NameClass convertQName(String string2, boolean bl) {
        String string3;
        int n = string2.indexOf(58);
        if (n < 0) {
            return new NameNameClass(bl ? this.defaultNamespace : "", string2);
        }
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1);
        if (string4.equals("xml")) {
            string3 = "http://www.w3.org/XML/1998/namespace";
        } else {
            string3 = (String)this.prefixTable.get(string4);
            if (string3.equals("")) {
                this.error("UNDECLARED_PREFIX", string4);
                string3 = "##" + string4;
                this.prefixTable.put(string4, string3);
            }
        }
        NameNameClass nameNameClass = new NameNameClass(string3, string5);
        nameNameClass.setPrefix(string4);
        return nameNameClass;
    }

    private class SignificanceDetector
    extends VisitorBase {
        boolean significant = false;

        private SignificanceDetector() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void modelGroupDef(String string2, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        public void attributeGroupDef(String string2, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        public void enumGroupDef(String string2, EnumGroup enumGroup) {
            this.significant = true;
        }

        public void datatypeDef(String string2, Datatype datatype) {
            this.significant = true;
        }
    }

    private class DuplicateAttributeDetector
    implements AttributeGroupVisitor {
        private boolean containsDuplicate = false;
        private final List names = new Vector();

        private DuplicateAttributeDetector() {
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            String string2 = nameSpec.getValue();
            if (Converter.this.attributeNames.contains(string2)) {
                this.containsDuplicate = true;
            }
            this.names.add(string2);
        }

        public void attributeGroupRef(String string2, AttributeGroup attributeGroup) throws Exception {
            attributeGroup.accept(this);
        }
    }

    private class ModelGroupOutput
    implements ModelGroupVisitor {
        private Pattern pattern;

        private ModelGroupOutput() {
        }

        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                this.pattern = new NotAllowedPattern();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                ChoicePattern choicePattern = new ChoicePattern();
                this.pattern = choicePattern;
                List list2 = choicePattern.getChildren();
                int n = 0;
                while (n < modelGroupArray.length) {
                    list2.add(Converter.this.convert(modelGroupArray[n]));
                    ++n;
                }
            }
        }

        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                this.pattern = new EmptyPattern();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                GroupPattern groupPattern = new GroupPattern();
                this.pattern = groupPattern;
                List list2 = groupPattern.getChildren();
                int n = 0;
                while (n < modelGroupArray.length) {
                    list2.add(Converter.this.convert(modelGroupArray[n]));
                    ++n;
                }
            }
        }

        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            this.pattern = new OneOrMorePattern(Converter.this.convert(modelGroup));
        }

        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            this.pattern = new ZeroOrMorePattern(Converter.this.convert(modelGroup));
        }

        public void optional(ModelGroup modelGroup) throws Exception {
            this.pattern = new OptionalPattern(Converter.this.convert(modelGroup));
        }

        public void modelGroupRef(String string2, ModelGroup modelGroup) {
            this.pattern = Converter.ref(string2);
        }

        public void elementRef(NameSpec nameSpec) {
            this.pattern = Converter.ref(Converter.this.elementDeclName(nameSpec.getValue()));
        }

        public void pcdata() {
            this.pattern = new TextPattern();
        }

        public void any() {
            this.pattern = Converter.ref(Converter.this.anyName);
            if (((Converter)Converter.this).options.strictAny) {
                this.pattern = new ZeroOrMorePattern(this.pattern);
            }
        }
    }

    private class EnumGroupOutput
    implements EnumGroupVisitor {
        private final List list;

        EnumGroupOutput(ChoicePattern choicePattern) {
            this.list = choicePattern.getChildren();
        }

        public void enumValue(String string2) {
            this.list.add(new ValuePattern("", "token", string2));
        }

        public void enumGroupRef(String string2, EnumGroup enumGroup) {
            this.list.add(Converter.ref(string2));
        }
    }

    private class DatatypeOutput
    implements DatatypeVisitor {
        Pattern pattern;

        private DatatypeOutput() {
        }

        public void cdataDatatype() {
            this.pattern = new DataPattern("", "string");
        }

        public void tokenizedDatatype(String string2) {
            this.pattern = new DataPattern("http://www.w3.org/2001/XMLSchema-datatypes", string2);
        }

        public void enumDatatype(EnumGroup enumGroup) throws Exception {
            if (enumGroup.getMembers().length == 0) {
                this.pattern = new NotAllowedPattern();
            } else {
                ChoicePattern choicePattern = new ChoicePattern();
                this.pattern = choicePattern;
                enumGroup.accept(new EnumGroupOutput(choicePattern));
            }
        }

        public void notationDatatype(EnumGroup enumGroup) throws Exception {
            this.enumDatatype(enumGroup);
        }

        public void datatypeRef(String string2, Datatype datatype) {
            this.pattern = Converter.ref(string2);
        }
    }

    private class AttributeGroupOutput
    implements AttributeGroupVisitor {
        final List group;

        AttributeGroupOutput(GroupPattern groupPattern) {
            this.group = groupPattern.getChildren();
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) throws Exception {
            Pattern pattern2;
            Object object;
            String string2 = nameSpec.getValue();
            if (Converter.this.attributeNames.contains(string2)) {
                return;
            }
            Converter.this.attributeNames.add(string2);
            if (string2.equals("xmlns") || string2.startsWith("xmlns:")) {
                return;
            }
            String string3 = attributeDefault.getDefaultValue();
            String string4 = attributeDefault.getFixedValue();
            if (string4 != null) {
                object = Converter.valueType(datatype);
                pattern2 = new ValuePattern(object[0], object[1], string4);
            } else {
                pattern2 = datatype.getType() != 0 ? Converter.this.convert(datatype) : new TextPattern();
            }
            object = new AttributePattern(Converter.this.convertQName(string2, false), pattern2);
            if (string3 != null) {
                AttributeAnnotation attributeAnnotation = new AttributeAnnotation("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue", string3);
                attributeAnnotation.setPrefix(Converter.this.annotationPrefix);
                ((Annotated)object).getAttributeAnnotations().add(attributeAnnotation);
            }
            if (!attributeDefault.isRequired()) {
                this.group.add(new OptionalPattern((Pattern)object));
            } else {
                this.group.add(object);
            }
        }

        public void attributeGroupRef(String string2, AttributeGroup attributeGroup) throws Exception {
            DuplicateAttributeDetector duplicateAttributeDetector = new DuplicateAttributeDetector();
            attributeGroup.accept(duplicateAttributeDetector);
            if (duplicateAttributeDetector.containsDuplicate) {
                attributeGroup.accept(this);
            } else {
                this.group.add(Converter.ref(string2));
                Converter.this.attributeNames.addAll(duplicateAttributeDetector.names);
            }
        }
    }

    private class ComponentOutput
    extends VisitorBase {
        private final List components;
        private final Annotated grammar;
        private List comments = null;

        ComponentOutput(GrammarPattern grammarPattern) {
            this.components = grammarPattern.getComponents();
            this.grammar = grammarPattern;
        }

        void finish() {
            if (this.comments != null) {
                this.grammar.getFollowingElementAnnotations().addAll(this.comments);
            }
        }

        private void addComponent(Component component) {
            if (this.comments != null) {
                if (this.components.isEmpty()) {
                    this.grammar.getLeadingComments().addAll(this.comments);
                } else {
                    component.getLeadingComments().addAll(this.comments);
                }
                this.comments = null;
            }
            this.components.add(component);
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            Object object;
            Object object2;
            GroupPattern groupPattern = new GroupPattern();
            if (((Converter)Converter.this).options.inlineAttlistDecls) {
                object2 = (List)Converter.this.attlistDeclTable.get(nameSpec.getValue());
                if (object2 != null) {
                    Converter.this.attributeNames = new HashSet();
                    object = new AttributeGroupOutput(groupPattern);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ((AttributeGroup)iterator.next()).accept((AttributeGroupVisitor)object);
                    }
                }
            } else {
                groupPattern.getChildren().add(Converter.ref(Converter.this.attlistDeclName(nameSpec.getValue())));
            }
            object2 = Converter.this.convert(modelGroup);
            if (groupPattern.getChildren().size() > 0) {
                if (object2 instanceof GroupPattern) {
                    groupPattern.getChildren().addAll(((GroupPattern)object2).getChildren());
                } else {
                    groupPattern.getChildren().add(object2);
                }
                object2 = groupPattern;
            }
            this.addComponent(new DefineComponent(Converter.this.elementDeclName(nameSpec.getValue()), new ElementPattern(Converter.this.convertQName(nameSpec.getValue(), true), (Pattern)object2)));
            if (!((Converter)Converter.this).options.inlineAttlistDecls && (Converter.this.nameFlags(nameSpec.getValue()) & 2) == 0) {
                object = new DefineComponent(Converter.this.attlistDeclName(nameSpec.getValue()), new EmptyPattern());
                ((DefineComponent)object).setCombine(Combine.INTERLEAVE);
                this.addComponent((Component)object);
            }
            if (Converter.this.anyName != null && ((Converter)Converter.this).options.strictAny) {
                object = new DefineComponent(Converter.this.anyName, Converter.ref(Converter.this.elementDeclName(nameSpec.getValue())));
                ((DefineComponent)object).setCombine(Combine.CHOICE);
                this.addComponent((Component)object);
            }
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            Object object;
            Pattern pattern2;
            if (((Converter)Converter.this).options.inlineAttlistDecls) {
                return;
            }
            String string2 = nameSpec.getValue();
            Converter.this.attributeNames = (Set)Converter.this.attributeNamesTable.get(string2);
            if (Converter.this.attributeNames == null) {
                Converter.this.attributeNames = new HashSet();
                Converter.this.attributeNamesTable.put(string2, Converter.this.attributeNames);
            }
            if ((pattern2 = Converter.this.convert(attributeGroup)) instanceof EmptyPattern) {
                object = (List)Converter.this.attlistDeclTable.get(string2);
                if (object.get(0) != attributeGroup) {
                    return;
                }
                Converter.this.attributeNames = new HashSet();
                int n = 1;
                int n2 = object.size();
                while (n < n2) {
                    if (!(Converter.this.convert((AttributeGroup)object.get(n)) instanceof EmptyPattern)) {
                        return;
                    }
                    ++n;
                }
            }
            object = new DefineComponent(Converter.this.attlistDeclName(string2), pattern2);
            ((DefineComponent)object).setCombine(Combine.INTERLEAVE);
            this.addComponent((Component)object);
        }

        public void modelGroupDef(String string2, ModelGroup modelGroup) throws Exception {
            this.addComponent(new DefineComponent(string2, Converter.this.convert(modelGroup)));
        }

        public void attributeGroupDef(String string2, AttributeGroup attributeGroup) throws Exception {
            Pattern pattern2;
            Converter.this.attributeNames = new HashSet();
            AttributeGroupMember[] attributeGroupMemberArray = attributeGroup.getMembers();
            GroupPattern groupPattern = new GroupPattern();
            AttributeGroupOutput attributeGroupOutput = new AttributeGroupOutput(groupPattern);
            int n = 0;
            while (n < attributeGroupMemberArray.length) {
                attributeGroupMemberArray[n].accept(attributeGroupOutput);
                ++n;
            }
            switch (groupPattern.getChildren().size()) {
                case 0: {
                    pattern2 = new EmptyPattern();
                    break;
                }
                case 1: {
                    pattern2 = (Pattern)groupPattern.getChildren().get(0);
                    break;
                }
                default: {
                    pattern2 = groupPattern;
                }
            }
            this.addComponent(new DefineComponent(string2, pattern2));
        }

        public void enumGroupDef(String string2, EnumGroup enumGroup) throws Exception {
            Pattern pattern2;
            ChoicePattern choicePattern = new ChoicePattern();
            enumGroup.accept(new EnumGroupOutput(choicePattern));
            switch (choicePattern.getChildren().size()) {
                case 0: {
                    pattern2 = new NotAllowedPattern();
                    break;
                }
                case 1: {
                    pattern2 = (Pattern)choicePattern.getChildren().get(0);
                    break;
                }
                default: {
                    pattern2 = choicePattern;
                }
            }
            this.addComponent(new DefineComponent(string2, pattern2));
        }

        public void datatypeDef(String string2, Datatype datatype) throws Exception {
            this.addComponent(new DefineComponent(string2, Converter.this.convert(datatype)));
        }

        public void comment(String string2) {
            if (this.comments == null) {
                this.comments = new Vector();
            }
            this.comments.add(new Comment(CommentTrimmer.trimComment(string2)));
        }

        public void externalIdRef(String string2, ExternalId externalId, String string3, String string4, TopLevel[] topLevelArray) throws Exception {
            if (string3 == null) {
                super.externalIdRef(string2, externalId, string3, string4, topLevelArray);
                return;
            }
            SignificanceDetector significanceDetector = new SignificanceDetector();
            try {
                significanceDetector.externalIdRef(string2, externalId, string3, string4, topLevelArray);
                if (!significanceDetector.significant) {
                    return;
                }
            }
            catch (Exception exception) {
                throw (RuntimeException)exception;
            }
            if (Converter.this.sc.getSchemaDocumentMap().get(string3) != null) {
                super.externalIdRef(string2, externalId, string3, string4, topLevelArray);
                return;
            }
            IncludeComponent includeComponent = new IncludeComponent(string3);
            includeComponent.setNs(Converter.this.defaultNamespace);
            this.addComponent(includeComponent);
            GrammarPattern grammarPattern = new GrammarPattern();
            ComponentOutput componentOutput = new ComponentOutput(grammarPattern);
            int n = 0;
            while (n < topLevelArray.length) {
                topLevelArray[n].accept(componentOutput);
                ++n;
            }
            componentOutput.finish();
            Converter.this.sc.getSchemaDocumentMap().put(string3, new SchemaDocument(grammarPattern, string4));
        }
    }

    private class Analyzer
    extends VisitorBase
    implements ModelGroupVisitor,
    AttributeGroupVisitor {
        private Analyzer() {
        }

        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            Converter.this.noteElementName(nameSpec.getValue(), 1);
            modelGroup.accept(this);
        }

        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            Converter.this.noteElementName(nameSpec.getValue(), 2);
            Converter.this.noteAttlist(nameSpec.getValue(), attributeGroup);
            attributeGroup.accept(this);
        }

        public void modelGroupDef(String string2, ModelGroup modelGroup) throws Exception {
            Converter.this.noteDef(string2);
            modelGroup.accept(this);
        }

        public void attributeGroupDef(String string2, AttributeGroup attributeGroup) throws Exception {
            Converter.this.noteDef(string2);
            attributeGroup.accept(this);
        }

        public void enumGroupDef(String string2, EnumGroup enumGroup) {
            Converter.this.noteDef(string2);
        }

        public void datatypeDef(String string2, Datatype datatype) {
            Converter.this.noteDef(string2);
        }

        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            int n = 0;
            while (n < modelGroupArray.length) {
                modelGroupArray[n].accept(this);
                ++n;
            }
        }

        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            int n = 0;
            while (n < modelGroupArray.length) {
                modelGroupArray[n].accept(this);
                ++n;
            }
        }

        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void optional(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        public void modelGroupRef(String string2, ModelGroup modelGroup) {
        }

        public void elementRef(NameSpec nameSpec) {
            Converter.this.noteElementName(nameSpec.getValue(), 4);
        }

        public void pcdata() {
        }

        public void any() {
            Converter.this.hadAny = true;
        }

        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            Converter.this.noteAttribute(nameSpec.getValue(), attributeDefault.getDefaultValue());
        }

        public void attributeGroupRef(String string2, AttributeGroup attributeGroup) {
        }
    }

    private static abstract class VisitorBase
    implements TopLevelVisitor {
        private VisitorBase() {
        }

        public void processingInstruction(String string2, String string3) throws Exception {
        }

        public void comment(String string2) throws Exception {
        }

        public void flagDef(String string2, Flag flag) throws Exception {
        }

        public void includedSection(Flag flag, TopLevel[] topLevelArray) throws Exception {
            int n = 0;
            while (n < topLevelArray.length) {
                topLevelArray[n].accept(this);
                ++n;
            }
        }

        public void ignoredSection(Flag flag, String string2) throws Exception {
        }

        public void internalEntityDecl(String string2, String string3) throws Exception {
        }

        public void externalEntityDecl(String string2, ExternalId externalId) throws Exception {
        }

        public void notationDecl(String string2, ExternalId externalId) throws Exception {
        }

        public void nameSpecDef(String string2, NameSpec nameSpec) throws Exception {
        }

        public void overriddenDef(Def def, boolean bl) throws Exception {
        }

        public void externalIdDef(String string2, ExternalId externalId) throws Exception {
        }

        public void externalIdRef(String string2, ExternalId externalId, String string3, String string4, TopLevel[] topLevelArray) throws Exception {
            int n = 0;
            while (n < topLevelArray.length) {
                topLevelArray[n].accept(this);
                ++n;
            }
        }

        public void paramDef(String string2, String string3) throws Exception {
        }

        public void attributeDefaultDef(String string2, AttributeDefault attributeDefault) throws Exception {
        }
    }

    static class Options {
        boolean inlineAttlistDecls;
        boolean generateStart = true;
        boolean strictAny;
        String elementDeclPattern;
        String attlistDeclPattern;
        String colonReplacement;
        String anyName;
        String annotationPrefix;
        String defaultNamespace;
        final Map prefixMap = new HashMap();

        Options() {
        }
    }
}

