/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate.test;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.parse.compact.CompactParseInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.test.Compare;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CompactTestDriver {
    private final XMLReaderCreator xrc = new Jaxp11XMLReaderCreator();
    private ErrorHandler eh;
    private final InputFormat inputFormat = new CompactParseInputFormat();
    private OutputFormat outputFormat;
    private OutputFormat compactOutputFormat;
    private String toDir;
    private String toExt;
    private static final String XML_DIR = "xml";
    private static final String XSD_DIR = "xsd";
    private static final String COMPACT_DIR = "compact";
    private static final String OUT_DIR = "out";
    private static final String CORRECT_SCHEMA_NAME = "c";
    private static final String INCORRECT_SCHEMA_NAME = "i";
    private static final String COMPACT_EXTENSION = ".rnc";
    private static final String XML_EXTENSION = ".rng";
    private static final String XSD_EXTENSION = ".xsd";
    private static final String OUTPUT_ENCODING = "UTF-8";
    private static final int LINE_LENGTH = 72;
    private static final int INDENT = 2;

    private CompactTestDriver() {
    }

    public static void main(String[] stringArray) throws IOException {
        System.exit(new CompactTestDriver().doMain(stringArray));
    }

    private int doMain(String[] stringArray) throws IOException {
        this.eh = new ErrorHandlerImpl(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(stringArray[0]))));
        if (stringArray[2].equals(XSD_DIR)) {
            this.outputFormat = new XsdOutputFormat();
            this.toExt = XSD_EXTENSION;
            this.toDir = XSD_DIR;
        } else {
            this.outputFormat = new RngOutputFormat();
            this.compactOutputFormat = new RncOutputFormat();
            this.toExt = XML_EXTENSION;
            this.toDir = XML_DIR;
        }
        return this.runTestSuite(new File(stringArray[1])) ? 0 : 1;
    }

    private boolean runTestSuite(File file) throws IOException {
        boolean bl = true;
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory() && !this.runTestCase(file2)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private boolean runTestCase(File file) throws IOException {
        File file2;
        File file3 = new File(file, this.toDir);
        File file4 = new File(file, COMPACT_DIR);
        File file5 = new File(file, OUT_DIR);
        File file6 = new File(file4, "c.rnc");
        File file7 = new File(file4, "i.rnc");
        boolean bl = true;
        if (file6.exists()) {
            file2 = new File(file5, CORRECT_SCHEMA_NAME + this.toExt);
            if (!this.run(file6, file2, this.outputFormat, this.toExt) || !this.compareDir(file3, file5)) {
                bl = false;
                CompactTestDriver.failed(file6);
            } else if (this.toExt.equals(XML_EXTENSION)) {
                this.cleanDir(file5);
                File file8 = new File(file5, "c.rnc");
                if (!(this.run(file6, file8, this.compactOutputFormat, COMPACT_EXTENSION) && this.run(file8, file2, this.outputFormat, this.toExt) && this.compareDir(file3, file5))) {
                    bl = false;
                    CompactTestDriver.failed(file6);
                }
            }
        }
        if (file7.exists() && this.run(file7, file2 = new File(file5, INCORRECT_SCHEMA_NAME + this.toExt), this.outputFormat, this.toExt)) {
            bl = false;
            CompactTestDriver.failed(file7);
        }
        return bl;
    }

    private boolean compareDir(File file, File file2) {
        try {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file3 = new File(file, stringArray[n]);
                if (file3.isDirectory() ? !this.compareDir(file3, new File(file2, stringArray[n])) : !Compare.compare(file3, new File(file2, stringArray[n]), this.xrc)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        return false;
    }

    private void cleanDir(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                this.cleanDir(file2);
            }
            file2.delete();
            ++n;
        }
    }

    private static void failed(File file) {
        System.err.println(file.toString() + " failed");
    }

    private boolean run(File file, File file2, OutputFormat outputFormat, String string2) throws IOException {
        try {
            SchemaCollection schemaCollection = this.inputFormat.load(UriOrFile.fileToUri(file), new String[0], null, this.eh);
            LocalOutputDirectory localOutputDirectory = new LocalOutputDirectory(schemaCollection.getMainUri(), file2, string2, null, 72, 2);
            localOutputDirectory.setEncoding(OUTPUT_ENCODING);
            outputFormat.output(schemaCollection, localOutputDirectory, new String[0], null, this.eh);
            return true;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (InvalidParamsException invalidParamsException) {
            return false;
        }
        catch (InputFailedException inputFailedException) {
            return false;
        }
        catch (OutputFailedException outputFailedException) {
            return false;
        }
    }
}

