/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H'J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H'J6\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0018H'J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$H'J\u0012\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\u0018H'J\u0012\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$H'J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0018H\u0017JB\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0007H\u0017J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H&J \u0010,\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006/\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMap;", "", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "hasNameMappings", "", "getHasNameMappings", "()Z", "outFile", "", "getOutFile", "()Ljava/lang/String;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrl", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceMappings", "sourceIndex", "getRawSource", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getSourceContent", "getSourceLineByRawLocation", "rawLine", "rawColumn", "getSourceMappingsInLine", "", "sourceLine", "processSourceMappingsInLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "intellij.platform.scriptDebugger.backend"})
public interface SourceMap {
    @ApiStatus.Internal
    @Nullable
    public String getOutFile();

    @ApiStatus.Internal
    @NotNull
    public Url[] getSources();

    @ApiStatus.Internal
    @NotNull
    public Mappings getGeneratedMappings();

    @ApiStatus.Internal
    public boolean getHasNameMappings();

    @ApiStatus.Internal
    @NotNull
    public SourceResolver getSourceResolver();

    @ApiStatus.Internal
    @NotNull
    public Mappings findSourceMappings(int var1);

    @ApiStatus.Internal
    public int findSourceIndex(@NotNull Url var1, @Nullable VirtualFile var2, @Nullable Lazy<? extends SourceFileResolver> var3, boolean var4);

    @ApiStatus.Internal
    @Nullable
    default public Mappings findSourceMappings(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int sourceIndex = this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
        return sourceIndex >= 0 ? this.findSourceMappings(sourceIndex) : null;
    }

    @ApiStatus.Internal
    default public int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        MappingEntry mappingEntry = this.getGeneratedMappings().get(rawLine, rawColumn);
        return mappingEntry != null ? mappingEntry.getSourceLine() : -1;
    }

    @ApiStatus.Internal
    public int findSourceIndex(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int var1, int var2);

    @ApiStatus.Internal
    default public boolean processSourceMappingsInLine(int sourceIndex, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor) {
        Intrinsics.checkNotNullParameter((Object)mappingProcessor, (String)"mappingProcessor");
        return mappingProcessor.processIterable(this.getSourceMappingsInLine(sourceIndex, sourceLine));
    }

    @ApiStatus.Internal
    @NotNull
    default public Iterable<MappingEntry> getSourceMappingsInLine(@NotNull Url sourceUrl, int sourceLine, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int sourceIndex = this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
        return sourceIndex >= 0 ? this.getSourceMappingsInLine(sourceIndex, sourceLine) : (Iterable<MappingEntry>)CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public String getRawSource(@NotNull MappingEntry var1);

    @ApiStatus.Internal
    @Nullable
    public String getSourceContent(@NotNull MappingEntry var1);

    @ApiStatus.Internal
    @Nullable
    public String getSourceContent(int var1);
}

