/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.BaseBinder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteDb;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u001d\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/sqlite/IntBinder;", "Lorg/jetbrains/sqlite/BaseBinder;", "paramCount", "", "batchCountHint", "(II)V", "batch", "", "addBatch", "", "bind", "v1", "v2", "v3", "bindParams", "pointer", "", "db", "Lorg/jetbrains/sqlite/SqliteDb;", "bindParams$intellij_platform_sqlite", "ensureCapacity", "count", "ensureCapacity$intellij_platform_sqlite", "executeBatch", "Lorg/jetbrains/sqlite/NativeDB;", "executeBatch$intellij_platform_sqlite", "toString", "", "intellij.platform.sqlite"})
public final class IntBinder
extends BaseBinder {
    @NotNull
    private int[] batch;

    public IntBinder(int paramCount, int batchCountHint) {
        super(paramCount, null);
        this.batch = new int[paramCount * batchCountHint];
    }

    public /* synthetic */ IntBinder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(n, n2);
    }

    public final void bind(int v1) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
    }

    public final void bind(int v1, int v2) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
    }

    public final void bind(int v1, int v2, int v3) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
    }

    public final void ensureCapacity$intellij_platform_sqlite(int count) {
        int expectedSize = count * this.getParamCount$intellij_platform_sqlite();
        if (expectedSize > this.batch.length) {
            int[] newBatch = new int[expectedSize];
            ArraysKt.copyInto$default((int[])this.batch, (int[])newBatch, (int)0, (int)0, (int)0, (int)14, null);
            this.batch = newBatch;
        }
    }

    @Override
    public void bindParams$intellij_platform_sqlite(long pointer, @NotNull SqliteDb db) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean bl2 = bl = this.getBatchQueryCount() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int[] nArray = this.batch;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            int value = nArray[i];
            int status = db.bind_int(pointer, index + 1, value) & 0xFF;
            if (status == 0) continue;
            throw SqliteDb.newException$default(db, status, null, 2, null);
        }
    }

    @NotNull
    public String toString() {
        String string2 = Arrays.toString(this.batch);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    public void addBatch() {
        this.batchPosition += this.getParamCount$intellij_platform_sqlite();
        int n = this.getBatchQueryCount();
        this.setBatchQueryCount(n + 1);
        if (this.batchPosition + this.getParamCount$intellij_platform_sqlite() > this.batch.length) {
            int[] newBatch = new int[this.batch.length * 2];
            ArraysKt.copyInto$default((int[])this.batch, (int[])newBatch, (int)0, (int)0, (int)0, (int)14, null);
            this.batch = newBatch;
        }
    }

    @Override
    public void executeBatch$intellij_platform_sqlite(long pointer, @NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        db.executeBatch(pointer, this.getBatchQueryCount(), this.getParamCount$intellij_platform_sqlite(), this.batch);
    }
}

