/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.extensions;

import com.intellij.idea.HardwareAgentRequired;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class HardwareAgentRequiredExecutionCondition
implements ExecutionCondition {
    private static final boolean RUN_WITH_HARDWARE_REQUIREMENT = Boolean.getBoolean("idea.hardware.agent.required");
    private static final boolean IS_LOCAL_RUN = System.getenv("TEAMCITY_VERSION") == null;
    private static final ConditionEvaluationResult ENABLED_LOCALLY = ConditionEvaluationResult.enabled((String)"Enabled locally");
    private static final ConditionEvaluationResult MET_HARDWARE_REQUIREMENT = ConditionEvaluationResult.enabled((String)"Hardware requirement met");
    private static final ConditionEvaluationResult UNMET_HARDWARE_REQUIREMENT = ConditionEvaluationResult.disabled((String)"Unmet hardware requirement");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context2) {
        if (IS_LOCAL_RUN) {
            return ENABLED_LOCALLY;
        }
        boolean hasAnnotation = AnnotationSupport.findAnnotation((Optional)context2.getTestClass(), HardwareAgentRequired.class).isPresent();
        return hasAnnotation == RUN_WITH_HARDWARE_REQUIREMENT ? MET_HARDWARE_REQUIREMENT : UNMET_HARDWARE_REQUIREMENT;
    }
}

