/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.JavaCodeInsightTestCase;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MultiFileTestCase
extends JavaCodeInsightTestCase {
    protected boolean myDoCompare = true;

    protected void doTest(PerformAction performAction) {
        this.doTest(performAction, this.getTestName(true));
    }

    protected void doTest(PerformAction performAction, boolean lowercaseFirstLetter) {
        this.doTest(performAction, this.getTestName(lowercaseFirstLetter));
    }

    protected void doTest(PerformAction performAction, String testName2) {
        try {
            String path = this.getTestDataPath() + this.getTestRoot() + testName2;
            String pathBefore = path + "/before";
            VirtualFile rootDir = this.createTestProjectStructure(pathBefore, false);
            this.prepareProject(rootDir);
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            String pathAfter = path + "/after";
            VirtualFile rootAfter = LocalFileSystem.getInstance().findFileByPath(pathAfter.replace(File.separatorChar, '/'));
            IndexingTestUtil.waitUntilIndexesAreReady(this.getProject());
            performAction.performAction(rootDir, rootAfter);
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> PostprocessReformattingAspect.getInstance((Project)this.myProject).doPostponedFormatting());
            FileDocumentManager.getInstance().saveAllDocuments();
            if (this.myDoCompare) {
                this.compareResults(rootAfter, rootDir);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void compareResults(VirtualFile rootAfter, VirtualFile rootDir) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(rootAfter, rootDir);
    }

    protected void prepareProject(VirtualFile rootDir) {
        PsiTestUtil.addSourceContentToRoots(this.myModule, rootDir);
    }

    @Override
    @NotNull
    @NonNls
    protected abstract String getTestRoot();

    protected static interface PerformAction {
        public void performAction(VirtualFile var1, VirtualFile var2) throws Exception;
    }
}

