/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public final class MavenDependencyUtil {
    private static final List<RemoteRepositoryDescription> REPOS_FOR_TESTING = List.of(new RemoteRepositoryDescription("central-proxy", "Maven Central Proxy", "https://cache-redirector.jetbrains.com/repo1.maven.org/maven2"), new RemoteRepositoryDescription("intellij-dependencies", "IntelliJ Dependencies", "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/ij/intellij-dependencies"));

    public static void addFromMaven(@NotNull ModifiableRootModel model2, String mavenCoordinates) {
        if (model2 == null) {
            MavenDependencyUtil.$$$reportNull$$$0(0);
        }
        MavenDependencyUtil.addFromMaven(model2, mavenCoordinates, true);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model2, String mavenCoordinates, boolean includeTransitiveDependencies) {
        if (model2 == null) {
            MavenDependencyUtil.$$$reportNull$$$0(1);
        }
        MavenDependencyUtil.addFromMaven(model2, mavenCoordinates, includeTransitiveDependencies, DependencyScope.COMPILE);
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model2, String mavenCoordinates, boolean includeTransitiveDependencies, DependencyScope dependencyScope) {
        if (model2 == null) {
            MavenDependencyUtil.$$$reportNull$$$0(2);
        }
        MavenDependencyUtil.addFromMaven(model2, mavenCoordinates, includeTransitiveDependencies, dependencyScope, Collections.emptyList());
    }

    public static void addFromMaven(@NotNull ModifiableRootModel model2, String mavenCoordinates, boolean includeTransitiveDependencies, DependencyScope dependencyScope, List<RemoteRepositoryDescription> additionalRepositories) {
        if (model2 == null) {
            MavenDependencyUtil.$$$reportNull$$$0(3);
        }
        List remoteRepositoryDescriptions = ContainerUtil.concat(MavenDependencyUtil.getRemoteRepositoryDescriptions(), additionalRepositories);
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates, includeTransitiveDependencies);
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)model2.getProject(), (RepositoryLibraryProperties)libraryProperties, (boolean)false, (boolean)false, null, (Collection)remoteRepositoryDescriptions);
        LibraryTable.ModifiableModel tableModel = model2.getModuleLibraryTable().getModifiableModel();
        Library library = tableModel.createLibrary(mavenCoordinates, RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        if (roots.isEmpty()) {
            throw new IllegalStateException(String.format("No roots for '%s'", mavenCoordinates));
        }
        for (OrderRoot root2 : roots) {
            libraryModel.addRoot(root2.getFile(), root2.getType());
        }
        ((LibraryEx.ModifiableModelEx)libraryModel).setProperties((LibraryProperties)libraryProperties);
        LibraryOrderEntry libraryOrderEntry = model2.findLibraryOrderEntry(library);
        if (libraryOrderEntry == null) {
            throw new IllegalStateException("Unable to find registered library " + mavenCoordinates);
        }
        libraryOrderEntry.setScope(dependencyScope);
        libraryModel.commit();
        tableModel.commit();
    }

    @NotNull
    public static List<RemoteRepositoryDescription> getRemoteRepositoryDescriptions() {
        List<RemoteRepositoryDescription> list = REPOS_FOR_TESTING;
        if (list == null) {
            MavenDependencyUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/MavenDependencyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/MavenDependencyUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositoryDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFromMaven";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

