/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.resources.providers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.junit5.resources.providers.ResourceProvider;
import com.intellij.testFramework.junit5.resources.providers.ResourceStorage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/junit5/resources/providers/DisposableProvider;", "Lcom/intellij/testFramework/junit5/resources/providers/ResourceProvider;", "Lcom/intellij/openapi/Disposable;", "()V", "needsApplication", "", "getNeedsApplication", "()Z", "resourceType", "Lkotlin/reflect/KClass;", "getResourceType", "()Lkotlin/reflect/KClass;", "create", "storage", "Lcom/intellij/testFramework/junit5/resources/providers/ResourceStorage;", "(Lcom/intellij/testFramework/junit5/resources/providers/ResourceStorage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "destroy", "", "resource", "(Lcom/intellij/openapi/Disposable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class DisposableProvider
implements ResourceProvider<Disposable> {
    @NotNull
    private final KClass<Disposable> resourceType = Reflection.getOrCreateKotlinClass(Disposable.class);
    private final boolean needsApplication;

    @Override
    @NotNull
    public KClass<Disposable> getResourceType() {
        return this.resourceType;
    }

    @Override
    @Nullable
    public Object create(@NotNull ResourceStorage storage, @NotNull Continuation<? super Disposable> $completion) {
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        return checkedDisposable;
    }

    @Override
    public boolean getNeedsApplication() {
        return this.needsApplication;
    }

    @Override
    @Nullable
    public Object destroy(@NotNull Disposable resource, @NotNull Continuation<? super Unit> $completion) {
        boolean bl;
        Intrinsics.checkNotNull((Object)resource, (String)"null cannot be cast to non-null type com.intellij.openapi.util.CheckedDisposable");
        CheckedDisposable cfr_ignored_0 = (CheckedDisposable)resource;
        boolean bl2 = bl = !((CheckedDisposable)resource).isDisposed();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = resource + " already disposed";
            throw new AssertionError((Object)string);
        }
        Disposer.dispose((Disposable)resource);
        return Unit.INSTANCE;
    }
}

