/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tracing.ide;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.tracing.Tracer;
import com.intellij.tracing.ide.TracingBundle;
import com.intellij.tracing.ide.TracingService;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/tracing/ide/TracingProjectTaskListener;", "Lcom/intellij/task/ProjectTaskListener;", "()V", "span", "Lcom/intellij/tracing/Tracer$Span;", "finished", "", "result", "Lcom/intellij/task/ProjectTaskManager$Result;", "handleException", "tracingService", "Lcom/intellij/tracing/ide/TracingService;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "mergeFiles", "", "files", "", "Ljava/nio/file/Path;", "readEntries", "trace", "showNotificationNotification", "mergedFile", "started", "context", "Lcom/intellij/task/ProjectTaskContext;", "Companion", "intellij.platform.tracing.ide"})
@SourceDebugExtension(value={"SMAP\nTracingProjectTaskListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracingProjectTaskListener.kt\ncom/intellij/tracing/ide/TracingProjectTaskListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 TracingProjectTaskListener.kt\ncom/intellij/tracing/ide/TracingProjectTaskListener\n*L\n23#1:100\n*E\n"})
public final class TracingProjectTaskListener
implements ProjectTaskListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Tracer.Span span;
    @NotNull
    private static final Logger log;

    public void started(@NotNull ProjectTaskContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TracingService tracingService = TracingService.Companion.getInstance();
        if (!tracingService.isTracingEnabled()) {
            return;
        }
        try {
            Path filePath = TracingService.Companion.createPath(TracingService.TraceKind.Ide);
            tracingService.registerIdeTrace(filePath);
            tracingService.bindJpsTraceIfExistsToCurrentSession();
            Tracer.runTracer((int)0, (Path)filePath, (long)1L, arg_0 -> TracingProjectTaskListener.started$lambda$0((Function1)new Function1<Exception, Unit>(this, tracingService){
                final /* synthetic */ TracingProjectTaskListener this$0;
                final /* synthetic */ TracingService $tracingService;
                {
                    this.this$0 = $receiver;
                    this.$tracingService = $tracingService;
                    super(1);
                }

                public final void invoke(Exception exception) {
                    Intrinsics.checkNotNull((Object)exception);
                    TracingProjectTaskListener.access$handleException(this.this$0, this.$tracingService, exception);
                }
            }, arg_0));
            this.span = Tracer.start((String)"Build");
        }
        catch (IOException e) {
            this.handleException(tracingService, e);
        }
    }

    public void finished(@NotNull ProjectTaskManager.Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TracingService tracingService = TracingService.Companion.getInstance();
        if (!tracingService.isTracingEnabled()) {
            return;
        }
        Tracer.Span span = this.span;
        if (span != null) {
            span.complete();
        }
        Tracer.finishTracer(arg_0 -> TracingProjectTaskListener.finished$lambda$1((Function1)new Function1<Exception, Unit>(this, tracingService){
            final /* synthetic */ TracingProjectTaskListener this$0;
            final /* synthetic */ TracingService $tracingService;
            {
                this.this$0 = $receiver;
                this.$tracingService = $tracingService;
                super(1);
            }

            public final void invoke(Exception exception) {
                Intrinsics.checkNotNull((Object)exception);
                TracingProjectTaskListener.access$handleException(this.this$0, this.$tracingService, exception);
            }
        }, arg_0));
        List<Path> filesToMerge = tracingService.drainFilesToMerge();
        AppExecutorUtil.getAppExecutorService().execute(() -> TracingProjectTaskListener.finished$lambda$2(this, filesToMerge, tracingService));
    }

    private final void handleException(TracingService tracingService, Exception e) {
        tracingService.clearPathsToMerge();
        log.warn((Throwable)e);
    }

    private final void showNotificationNotification(Path mergedFile) {
        Notification notification = new Notification("BuildTracing", TracingBundle.Companion.message("notification.content.tracing.file.was.created", new Object[0]), NotificationType.INFORMATION);
        String string = TracingBundle.Companion.message("action.open.trace.directory.in.file.manager.text", new Object[0]);
        notification.addAction(new AnAction(mergedFile, string){
            final /* synthetic */ Path $mergedFile;
            {
                this.$mergedFile = $mergedFile;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PsiNavigationSupport.getInstance().openDirectoryInSystemFileManager(this.$mergedFile.getParent().toFile());
            }
        });
        notification.notify(null);
    }

    @NotNull
    public final String mergeFiles(@NotNull List<? extends Path> files) throws IOException {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        StringBuilder $this$mergeFiles_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$mergeFiles_u24lambda_u243.append("[\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        for (Path path : files) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            List<String> entries = this.readEntries(path);
            for (String entry : entries) {
                StringBuilder stringBuilder3 = $this$mergeFiles_u24lambda_u243.append(entry);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
        }
        StringBuilder stringBuilder4 = $this$mergeFiles_u24lambda_u243.append("]\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final List<String> readEntries(Path trace) {
        File file = trace.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return CollectionsKt.dropLast((List)SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)TextStreamsKt.lineSequence((BufferedReader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n))), (int)1)), (int)1);
    }

    private static final void started$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void finished$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void finished$lambda$2(TracingProjectTaskListener this$0, List $filesToMerge, TracingService $tracingService) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filesToMerge, (String)"$filesToMerge");
        Intrinsics.checkNotNullParameter((Object)$tracingService, (String)"$tracingService");
        try {
            String mergedText = this$0.mergeFiles($filesToMerge);
            Path mergedFilePath = TracingService.Companion.createPath(TracingService.TraceKind.Merged);
            Files.createDirectories(mergedFilePath.getParent(), new FileAttribute[0]);
            PathsKt.writeText$default((Path)mergedFilePath, (CharSequence)mergedText, null, (OpenOption[])new OpenOption[0], (int)2, null);
            Path path = mergedFilePath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            this$0.showNotificationNotification(path);
        }
        catch (IOException e) {
            this$0.handleException($tracingService, e);
        }
    }

    public static final /* synthetic */ void access$handleException(TracingProjectTaskListener $this, TracingService tracingService, Exception e) {
        $this.handleException(tracingService, e);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TracingProjectTaskListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/tracing/ide/TracingProjectTaskListener$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.tracing.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

