/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.stats.completion.storage.FilePathProvider;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\rH\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/stats/completion/storage/UniqueFilesProvider;", "Lcom/intellij/stats/completion/storage/FilePathProvider;", "baseFileName", "", "rootDirectoryPath", "logsDirectoryName", "storageSizeLimit", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "cleanupOldFiles", "", "getDataFiles", "", "Ljava/io/File;", "getStatsDataDirectory", "getUniqueFile", "listChunks", "Lcom/intellij/stats/completion/storage/UniqueFilesProvider$Chunk;", "asChunk", "filesOnly", "Lkotlin/sequences/Sequence;", "Chunk", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nUniqueFilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueFilesProvider.kt\ncom/intellij/stats/completion/storage/UniqueFilesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n1789#2,3:96\n1549#2:100\n1620#2,3:101\n1#3:99\n603#4:104\n*S KotlinDebug\n*F\n+ 1 UniqueFilesProvider.kt\ncom/intellij/stats/completion/storage/UniqueFilesProvider\n*L\n32#1:96,3\n55#1:100\n55#1:101,3\n67#1:104\n*E\n"})
public class UniqueFilesProvider
implements FilePathProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseFileName;
    @NotNull
    private final String rootDirectoryPath;
    @NotNull
    private final String logsDirectoryName;
    private final int storageSizeLimit;
    private static final int MAX_STORAGE_SEND_SIZE = 0x1E00000;

    public UniqueFilesProvider(@NotNull String baseFileName, @NotNull String rootDirectoryPath, @NotNull String logsDirectoryName, int storageSizeLimit) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkNotNullParameter((Object)rootDirectoryPath, (String)"rootDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)logsDirectoryName, (String)"logsDirectoryName");
        this.baseFileName = baseFileName;
        this.rootDirectoryPath = rootDirectoryPath;
        this.logsDirectoryName = logsDirectoryName;
        this.storageSizeLimit = storageSizeLimit;
    }

    public /* synthetic */ UniqueFilesProvider(String string, String string2, String string3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0x1E00000;
        }
        this(string, string2, string3, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanupOldFiles() {
        void $this$fold$iv;
        List<File> files = this.getDataFiles();
        Iterable iterable = files;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void file;
            File file2 = (File)element$iv;
            long totalSize = accumulator$iv;
            boolean bl = false;
            accumulator$iv = totalSize + file.length();
        }
        long storageSize = accumulator$iv;
        if (storageSize > (long)this.storageSizeLimit) {
            long fileSize;
            Iterator<File> iterator = files.iterator();
            for (long currentSize = storageSize; iterator.hasNext() && currentSize > (long)this.storageSizeLimit; currentSize -= fileSize) {
                File file = iterator.next();
                fileSize = file.length();
                Files.delete(file.toPath());
            }
        }
    }

    @Override
    @NotNull
    public File getUniqueFile() {
        Integer currentMaxIndex;
        Comparable comparable;
        File dir = this.getStatsDataDirectory();
        Iterator iterator = ((Iterable)this.listChunks()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            Chunk it = (Chunk)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getNumber());
            while (iterator.hasNext()) {
                Chunk it2 = (Chunk)iterator.next();
                $i$a$-maxOfOrNull-UniqueFilesProvider$getUniqueFile$currentMaxIndex$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getNumber());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = currentMaxIndex = (Integer)comparable;
        int newIndex = n != null ? n + 1 : 0;
        return new File(dir, this.baseFileName + "_" + newIndex + ".gz");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> getDataFiles() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.listChunks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chunk chunk = (Chunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public File getStatsDataDirectory() {
        File dir = new File(this.rootDirectoryPath, this.logsDirectoryName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private final List<Chunk> listChunks() {
        Sequence $this$sortedBy$iv = SequencesKt.mapNotNull(this.filesOnly(this.getStatsDataDirectory()), (Function1)((Function1)new Function1<File, Chunk>(this){
            final /* synthetic */ UniqueFilesProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Chunk invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return UniqueFilesProvider.access$asChunk(this.this$0, it);
            }
        }));
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Chunk it = (Chunk)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getNumber());
                it = (Chunk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getNumber()));
            }
        }));
    }

    private final Sequence<File> filesOnly(File $this$filesOnly) {
        Object[] files = $this$filesOnly.listFiles(UniqueFilesProvider::filesOnly$lambda$4);
        if (files == null) {
            String diagnostics = !$this$filesOnly.exists() ? "file does not exist" : (!$this$filesOnly.isDirectory() ? "file is not a directory" : ($this$filesOnly.isFile() ? "file should be a directory but it is a file" : "unknown error"));
            throw new Exception("Invalid directory path: " + FilesKt.relativeTo((File)$this$filesOnly, (File)new File(PathManager.getSystemPath())) + ". Info: " + diagnostics);
        }
        return ArraysKt.asSequence((Object[])files);
    }

    private final Chunk asChunk(File $this$asChunk) {
        if (!$this$asChunk.isFile()) {
            return null;
        }
        String filename = $this$asChunk.getName();
        Intrinsics.checkNotNull((Object)filename);
        if (!StringsKt.startsWith$default((String)filename, (String)this.baseFileName, (boolean)false, (int)2, null)) {
            return null;
        }
        Integer number = Companion.extractChunkNumber(filename);
        return number == null ? null : new Chunk($this$asChunk, number);
    }

    private static final boolean filesOnly$lambda$4(File it) {
        return it.isFile();
    }

    public static final /* synthetic */ Chunk access$asChunk(UniqueFilesProvider $this, File $receiver) {
        return $this.asChunk($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/stats/completion/storage/UniqueFilesProvider$Chunk;", "", "file", "Ljava/io/File;", "number", "", "(Ljava/io/File;I)V", "getFile", "()Ljava/io/File;", "getNumber", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.statsCollector"})
    private static final class Chunk {
        @NotNull
        private final File file;
        private final int number;

        public Chunk(@NotNull File file, int number) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.number = number;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final int getNumber() {
            return this.number;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final int component2() {
            return this.number;
        }

        @NotNull
        public final Chunk copy(@NotNull File file, int number) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Chunk(file, number);
        }

        public static /* synthetic */ Chunk copy$default(Chunk chunk, File file, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                file = chunk.file;
            }
            if ((n2 & 2) != 0) {
                n = chunk.number;
            }
            return chunk.copy(file, n);
        }

        @NotNull
        public String toString() {
            return "Chunk(file=" + this.file + ", number=" + this.number + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Integer.hashCode(this.number);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Chunk)) {
                return false;
            }
            Chunk chunk = (Chunk)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)chunk.file)) {
                return false;
            }
            return this.number == chunk.number;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/stats/completion/storage/UniqueFilesProvider$Companion;", "", "()V", "MAX_STORAGE_SEND_SIZE", "", "extractChunkNumber", "filename", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer extractChunkNumber(@NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            return StringsKt.toIntOrNull((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)filename, (String)"_", null, (int)2, null), (String)".gz", null, (int)2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

