/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.logger.ClientSessionValidator;
import com.intellij.stats.completion.logger.EventLoggerWithValidation;
import com.intellij.stats.completion.logger.LogFileManager;
import com.intellij.stats.completion.storage.FilePathProvider;
import com.intellij.stats.completion.tracker.CompletionFileLogger;
import com.intellij.stats.completion.tracker.CompletionFileLoggerProviderKt;
import com.intellij.stats.completion.tracker.CompletionLogger;
import com.intellij.stats.completion.tracker.CompletionLoggerProvider;
import com.intellij.stats.completion.tracker.InstallationIdProvider;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/stats/completion/tracker/CompletionFileLoggerProvider;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/stats/completion/tracker/CompletionLoggerProvider;", "()V", "eventLogger", "Lcom/intellij/stats/completion/logger/EventLoggerWithValidation;", "dispose", "", "newCompletionLogger", "Lcom/intellij/stats/completion/tracker/CompletionLogger;", "languageName", "", "shouldLogElementFeatures", "", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nCompletionFileLoggerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionFileLoggerProvider.kt\ncom/intellij/stats/completion/tracker/CompletionFileLoggerProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,34:1\n40#2,3:35\n40#2,3:38\n*S KotlinDebug\n*F\n+ 1 CompletionFileLoggerProvider.kt\ncom/intellij/stats/completion/tracker/CompletionFileLoggerProvider\n*L\n13#1:35,3\n20#1:38,3\n*E\n"})
public final class CompletionFileLoggerProvider
extends CompletionLoggerProvider
implements Disposable {
    @NotNull
    private final EventLoggerWithValidation eventLogger;

    public CompletionFileLoggerProvider() {
        boolean $i$f$service = false;
        Class<FilePathProvider> serviceClass$iv = FilePathProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.eventLogger = new EventLoggerWithValidation(new LogFileManager((FilePathProvider)object, 0, 2, null), new ClientSessionValidator());
    }

    @Override
    public void dispose() {
        this.eventLogger.dispose();
    }

    @Override
    @NotNull
    public CompletionLogger newCompletionLogger(@NotNull String languageName, boolean shouldLogElementFeatures) {
        Intrinsics.checkNotNullParameter((Object)languageName, (String)"languageName");
        boolean $i$f$service = false;
        Class<InstallationIdProvider> serviceClass$iv = InstallationIdProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String installationUID = ((InstallationIdProvider)object).installationId();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String completionUID = string;
        String bucket = String.valueOf(EventLogConfiguration.Companion.getInstance().getBucket());
        return new CompletionFileLogger(CompletionFileLoggerProviderKt.access$shortedUUID(installationUID), CompletionFileLoggerProviderKt.access$shortedUUID(completionUID), bucket, languageName, shouldLogElementFeatures, this.eventLogger);
    }
}

