/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.MetaContactListServiceLick;

public class TestSupportForMultipleProviders
extends TestCase {
    private MclSlickFixture fixture = new MclSlickFixture(((Object)((Object)this)).getClass().getName());

    public TestSupportForMultipleProviders(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        this.fixture = null;
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSupportForMultipleProviders("testAddProviders"));
        suite.addTest((Test)new TestSupportForMultipleProviders("testMergingContactsFromDifferentProviders"));
        return suite;
    }

    public void testAddProviders() {
        MclSlickFixture.mockP1ServiceRegistration = MetaContactListServiceLick.registerMockProviderService(MclSlickFixture.mockP1);
        MclSlickFixture.mockP2ServiceRegistration = MetaContactListServiceLick.registerMockProviderService(MclSlickFixture.mockP2);
        MclSlickFixture.metaP1Grp1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MclSlickFixture.mockP1Grp1);
        TestSupportForMultipleProviders.assertNotNull((String)"The MCL impl ignored a newly added proto provider.", (Object)MclSlickFixture.metaP1Grp1);
        MclSlickFixture.assertGroupEquals(MclSlickFixture.mockP1Grp1, MclSlickFixture.metaP1Grp1, false);
        MclSlickFixture.metaP2Grp1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MclSlickFixture.mockP2Grp1);
        TestSupportForMultipleProviders.assertNotNull((String)"The MCL impl ignored a newly added proto provider.", (Object)MclSlickFixture.metaP2Grp1);
        MclSlickFixture.assertGroupEquals(MclSlickFixture.mockP2Grp1, MclSlickFixture.metaP2Grp1, false);
    }

    public void testMergingContactsFromDifferentProviders() {
        MetaContact metaEmilP1 = this.fixture.metaClService.findMetaContactByContact((Contact)MclSlickFixture.emilP1);
        TestSupportForMultipleProviders.assertNotNull((String)("No meta contact found for " + MclSlickFixture.emilP1.getDisplayName()), (Object)metaEmilP1);
        this.fixture.metaClService.moveContact((Contact)MclSlickFixture.emilP2, metaEmilP1);
        TestSupportForMultipleProviders.assertEquals((String)("Contact " + MclSlickFixture.emilP2.getDisplayName() + " was not added to metacontact " + metaEmilP1.getDisplayName()), (int)2, (int)metaEmilP1.getContactCount());
        ContactGroup newGrpP2 = MclSlickFixture.mockPresOpSetP2.getServerStoredContactListRoot().getGroup(MclSlickFixture.metaP1Grp1.getGroupName());
        TestSupportForMultipleProviders.assertNotNull((String)("Contact " + MclSlickFixture.emilP2.getDisplayName() + " was not moved to the proper group inside provider 2"), (Object)newGrpP2);
        MetaContactGroup newGrpP2MetaWrapper = this.fixture.metaClService.findMetaContactGroupByContactGroup(newGrpP2);
        TestSupportForMultipleProviders.assertNotNull((String)"Strange Error", (Object)newGrpP2MetaWrapper);
        TestSupportForMultipleProviders.assertSame((String)("Contact group " + newGrpP2 + " was not added to the right meta contact group"), (Object)MclSlickFixture.metaP1Grp1, (Object)newGrpP2MetaWrapper);
    }
}

