/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class TrackingSpacer
extends JComponent {
    private final JComponent fComponent;
    private final TrackingDimension fTrackingDimension;
    private final int fDelta;

    public TrackingSpacer(JComponent componentToTrack, TrackingDimension trackingDimension, int delta) {
        this.fComponent = componentToTrack;
        this.fTrackingDimension = trackingDimension;
        this.fDelta = delta;
        this.fComponent.addComponentListener(this.createComponentListner());
        this.doTrackedComponentResized();
    }

    private void doTrackedComponentResized() {
        this.setPreferredSize(this.fTrackingDimension.createDimension(this.fComponent, this.fDelta));
        this.revalidate();
    }

    private ComponentListener createComponentListner() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TrackingSpacer.this.doTrackedComponentResized();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrackingDimension {
        WIDTH{

            Dimension createDimension(JComponent component, int delta) {
                return new Dimension(component.getWidth() + delta, 1);
            }
        }
        ,
        HEIGHT{

            Dimension createDimension(JComponent component, int delta) {
                return new Dimension(1, component.getHeight() + delta);
            }
        };


        abstract Dimension createDimension(JComponent var1, int var2);
    }
}

