/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui;

import com.sun.jna.platform.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.PopupDialogImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommDefaultTheme;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommLookAndFeel;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.SingleWindowContainer;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationGroup;
import net.java.sip.communicator.impl.gui.main.UINotificationListener;
import net.java.sip.communicator.impl.gui.main.UINotificationManager;
import net.java.sip.communicator.impl.gui.main.account.AccountRegWizardContainerImpl;
import net.java.sip.communicator.impl.gui.main.account.NewAccountDialog;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomAutoOpenConfigDialog;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatManager;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindowManager;
import net.java.sip.communicator.impl.gui.main.chatroomslist.ChatRoomTableDialog;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigurationFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.login.DefaultSecurityAuthority;
import net.java.sip.communicator.impl.gui.main.login.LoginRendererSwingImpl;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.plugin.desktoputil.ConfigFormUtils;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.CreateAccountWindow;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.PopupDialog;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.event.ChatListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.LoginManager;
import net.java.sip.communicator.util.account.LoginRenderer;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class UIServiceImpl
implements UIService,
ShutdownService,
ServiceListener,
PropertyChangeListener,
UINotificationListener {
    private static final Logger logger = Logger.getLogger(UIServiceImpl.class);
    private PopupDialogImpl popupDialog;
    private AccountRegWizardContainerImpl wizardContainer;
    private final List<WeakReference<PluginComponentListener>> pluginComponentListeners = new ArrayList<WeakReference<PluginComponentListener>>();
    private static final List<net.java.sip.communicator.service.gui.Container> supportedContainers = new ArrayList<net.java.sip.communicator.service.gui.Container>();
    private static final Hashtable<WindowID, ExportedWindow> exportedWindows;
    private MainFrame mainFrame;
    private LoginManager loginManager;
    private final ChatWindowManager chatWindowManager = new ChatWindowManager();
    private final ConferenceChatManager conferenceChatManager = new ConferenceChatManager();
    private ConfigurationFrame configurationFrame;
    private final HistoryWindowManager historyWindowManager = new HistoryWindowManager();
    private SingleWindowContainer singleWindowContainer;

    public UIServiceImpl() {
        UINotificationManager.addNotificationListener(this);
    }

    void loadApplicationGui() {
        this.setDefaultThemePack();
        if (ConfigurationUtils.isSingleWindowInterfaceEnabled()) {
            this.singleWindowContainer = new SingleWindowContainer();
        }
        this.mainFrame = new MainFrame();
        if (UIManager.getLookAndFeel() instanceof SIPCommLookAndFeel) {
            this.initCustomFonts();
        }
        this.mainFrame.setContactList(GuiActivator.getContactListService());
        this.mainFrame.initBounds();
        GuiActivator.getUIService().registerExportedWindow(this.mainFrame);
        this.loginManager = new LoginManager((LoginRenderer)new LoginRendererSwingImpl());
        this.popupDialog = new PopupDialogImpl();
        this.wizardContainer = new AccountRegWizardContainerImpl(this.mainFrame);
        if (ConfigurationUtils.isTransparentWindowEnabled()) {
            try {
                WindowUtils.setWindowTransparent((Window)((Object)this.mainFrame), (boolean)true);
            }
            catch (UnsupportedOperationException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                ConfigurationUtils.setTransparentWindowEnabled((boolean)false);
            }
        }
        if (ConfigurationUtils.isApplicationVisible() || Boolean.getBoolean("disable-tray") || ConfigurationUtils.isMinimizeInsteadOfHide()) {
            this.mainFrame.setFrameVisible(true);
        }
        SwingUtilities.invokeLater(new RunLoginGui());
        this.initExportedWindows();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addKeyEventDispatcher(new KeyBindingsDispatching(focusManager));
        this.maybeShowMasterPasswordMissingWarningDialog();
    }

    public Iterator<net.java.sip.communicator.service.gui.Container> getSupportedContainers() {
        return Collections.unmodifiableList(supportedContainers).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePluginEvent(PluginComponentFactory factory, int eventID) {
        PluginComponentEvent evt = new PluginComponentEvent(factory, eventID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will dispatch the following plugin component event: " + evt));
        }
        List<WeakReference<PluginComponentListener>> list = this.pluginComponentListeners;
        synchronized (list) {
            Iterator<WeakReference<PluginComponentListener>> i = this.pluginComponentListeners.iterator();
            block7: while (i.hasNext()) {
                PluginComponentListener l = (PluginComponentListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                switch (evt.getEventID()) {
                    case 1: {
                        l.pluginComponentAdded(evt);
                        continue block7;
                    }
                    case 2: {
                        l.pluginComponentRemoved(evt);
                        continue block7;
                    }
                }
                logger.error((Object)("Unknown event type " + evt.getEventID()));
            }
        }
    }

    public boolean isVisible() {
        return this.mainFrame.isFrameVisible();
    }

    public void setVisible(boolean isVisible) {
        this.mainFrame.setFrameVisible(isVisible);
    }

    public void setLocation(int x, int y) {
        this.mainFrame.setLocation(x, y);
    }

    public Point getLocation() {
        return this.mainFrame.getLocation();
    }

    public Dimension getSize() {
        return this.mainFrame.getSize();
    }

    public void setSize(int width, int height) {
        this.mainFrame.setSize(width, height);
    }

    public void minimize() {
        this.mainFrame.minimize();
    }

    public void maximize() {
        this.mainFrame.maximize();
    }

    public void restore() {
        if (this.mainFrame.isFrameVisible()) {
            if (this.mainFrame.getState() == 1) {
                this.mainFrame.setState(0);
            }
            this.mainFrame.toFront();
        } else {
            this.mainFrame.setFrameVisible(true);
        }
    }

    public void resize(int width, int height) {
        this.mainFrame.setSize(width, height);
    }

    public void move(int x, int y) {
        this.mainFrame.setLocation(x, y);
    }

    public void bringToFront() {
        if (this.mainFrame.getState() == 1) {
            this.mainFrame.setState(0);
        }
        this.mainFrame.requestFocus();
        this.mainFrame.setAlwaysOnTop(true);
        this.mainFrame.toFront();
        this.mainFrame.setAlwaysOnTop(false);
    }

    public void setMainWindowCanHide(boolean canHide) {
        this.mainFrame.updateCloseAction(canHide);
    }

    public void initExportedWindows() {
        this.registerExportedWindow(new AddContactDialog((Frame)((Object)this.mainFrame)));
    }

    public void registerExportedWindow(ExportedWindow window) {
        exportedWindows.put(window.getIdentifier(), window);
    }

    public void unregisterExportedWindow(ExportedWindow window) {
        WindowID identifier = window.getIdentifier();
        ExportedWindow removed = exportedWindows.remove(identifier);
        if (removed != null && !removed.equals(window)) {
            exportedWindows.put(identifier, removed);
            Iterator<Map.Entry<WindowID, ExportedWindow>> entryIt = exportedWindows.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry<WindowID, ExportedWindow> entry = entryIt.next();
                if (!window.equals(entry.getValue())) continue;
                entryIt.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginComponentListener(PluginComponentListener listener) {
        List<WeakReference<PluginComponentListener>> list = this.pluginComponentListeners;
        synchronized (list) {
            Iterator<WeakReference<PluginComponentListener>> i = this.pluginComponentListeners.iterator();
            boolean contains = false;
            while (i.hasNext()) {
                PluginComponentListener l = (PluginComponentListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                contains = true;
            }
            if (!contains) {
                this.pluginComponentListeners.add(new WeakReference<PluginComponentListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginComponentListener(PluginComponentListener listener) {
        List<WeakReference<PluginComponentListener>> list = this.pluginComponentListeners;
        synchronized (list) {
            Iterator<WeakReference<PluginComponentListener>> i = this.pluginComponentListeners.iterator();
            while (i.hasNext()) {
                PluginComponentListener l = (PluginComponentListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    public Iterator<WindowID> getSupportedExportedWindows() {
        return Collections.unmodifiableMap(exportedWindows).keySet().iterator();
    }

    public ExportedWindow getExportedWindow(WindowID windowID, Object[] params) {
        ExportedWindow win = exportedWindows.get(windowID);
        if (win != null) {
            win.setParams(params);
        }
        return win;
    }

    public ExportedWindow getExportedWindow(WindowID windowID) {
        return this.getExportedWindow(windowID, null);
    }

    public boolean isExportedWindowSupported(WindowID windowID) {
        return exportedWindows.containsKey(windowID);
    }

    public PopupDialog getPopupDialog() {
        return this.popupDialog;
    }

    public ChatPanel getChat(Contact contact) {
        return this.getChat(contact, null);
    }

    public ChatPanel getChat(Contact contact, String escapedMessageUID) {
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
        if (metaContact == null) {
            return null;
        }
        return this.chatWindowManager.getContactChat(metaContact, true, escapedMessageUID);
    }

    public ChatPanel getChat(ChatRoom chatRoom) {
        return this.chatWindowManager.getMultiChat(chatRoom, true);
    }

    public ChatPanel getCurrentChat() {
        return this.chatWindowManager.getSelectedChat();
    }

    public String getCurrentPhoneNumber() {
        return null;
    }

    public void setCurrentPhoneNumber(String phoneNumber) {
    }

    public boolean isContainerSupported(net.java.sip.communicator.service.gui.Container containderID) {
        return supportedContainers.contains(containderID);
    }

    public WizardContainer getAccountRegWizardContainer() {
        return this.wizardContainer;
    }

    public SecurityAuthority getDefaultSecurityAuthority(ProtocolProviderService protocolProvider) {
        SecurityAuthority secAuthority = GuiActivator.getSecurityAuthority(protocolProvider.getProtocolName());
        if (secAuthority == null) {
            secAuthority = GuiActivator.getSecurityAuthority();
        }
        if (secAuthority == null) {
            secAuthority = new DefaultSecurityAuthority(protocolProvider);
        }
        return secAuthority;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public ConferenceChatManager getConferenceChatManager() {
        return this.conferenceChatManager;
    }

    public ChatWindowManager getChatWindowManager() {
        return this.chatWindowManager;
    }

    public HistoryWindowManager getHistoryWindowManager() {
        return this.historyWindowManager;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    private void setDefaultThemePack() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        UIManager.put("ToolTip.background", new Color(GuiActivator.getResources().getColor("service.gui.TOOLTIP_BACKGROUND")));
        toolTipManager.setInitialDelay(500);
        toolTipManager.setDismissDelay(60000);
        toolTipManager.setEnabled(true);
        UIManager.put("ClassLoader", this.getClass().getClassLoader());
        String laf = UIManager.getSystemLookAndFeelClassName();
        boolean lafIsSet = false;
        if (laf != null) {
            String gtkLookAndFeel;
            block16: {
                gtkLookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                if ((OSUtils.IS_FREEBSD || OSUtils.IS_LINUX) && laf.equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
                    try {
                        String kdeFullSession = System.getenv("KDE_FULL_SESSION");
                        if (kdeFullSession == null || kdeFullSession.length() == 0) break block16;
                        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
                            if (!gtkLookAndFeel.equals(lafi.getClassName())) continue;
                            laf = gtkLookAndFeel;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block16;
                        throw (ThreadDeath)t;
                    }
                }
            }
            try {
                UIManager.setLookAndFeel(laf);
                lafIsSet = true;
                UIDefaults uiDefaults = UIManager.getDefaults();
                if (OSUtils.IS_WINDOWS) {
                    this.fixWindowsUIDefaults(uiDefaults);
                }
                if (laf.equals(gtkLookAndFeel) || laf.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                    uiDefaults.put("ScrollPaneUI", new MetalLookAndFeel().getDefaults().get("ScrollPaneUI"));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
        if (!lafIsSet) {
            try {
                SIPCommLookAndFeel lf = new SIPCommLookAndFeel();
                SIPCommLookAndFeel.setCurrentTheme(new SIPCommDefaultTheme());
                if (Boolean.parseBoolean(GuiActivator.getResources().getSettingsString("impl.gui.IS_LOOK_AND_FEEL_DECORATED"))) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                UIManager.setLookAndFeel(lf);
            }
            catch (UnsupportedLookAndFeelException ex) {
                logger.error((Object)"The provided Look & Feel is not supported.", (Throwable)ex);
            }
        }
    }

    private void fixWindowsUIDefaults(UIDefaults uiDefaults) {
        Object defaultGUIFont;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object menuFont = toolkit.getDesktopProperty("win.menu.font");
        Object messageboxFont = toolkit.getDesktopProperty("win.messagebox.font");
        if (messageboxFont != null && messageboxFont.equals(menuFont) && (defaultGUIFont = toolkit.getDesktopProperty("win.defaultGUI.font")) != null && !defaultGUIFont.equals(messageboxFont)) {
            Object messageFont = uiDefaults.get("OptionPane.font");
            Object controlFont = uiDefaults.get("Panel.font");
            if (messageFont != null && !messageFont.equals(controlFont)) {
                uiDefaults.put("OptionPane.font", controlFont);
                uiDefaults.put("OptionPane.messageFont", controlFont);
                uiDefaults.put("OptionPane.buttonFont", controlFont);
                uiDefaults.put("Button.font", messageFont);
                uiDefaults.put("CheckBox.font", messageFont);
                uiDefaults.put("ComboBox.font", messageFont);
                uiDefaults.put("EditorPane.font", messageFont);
                uiDefaults.put("FormattedTextField.font", messageFont);
                uiDefaults.put("Label.font", messageFont);
                uiDefaults.put("List.font", messageFont);
                uiDefaults.put("RadioButton.font", messageFont);
                uiDefaults.put("Panel.font", messageFont);
                uiDefaults.put("PasswordField.font", messageFont);
                uiDefaults.put("ProgressBar.font", messageFont);
                uiDefaults.put("ScrollPane.font", messageFont);
                uiDefaults.put("Slider.font", messageFont);
                uiDefaults.put("Spinner.font", messageFont);
                uiDefaults.put("TabbedPane.font", messageFont);
                uiDefaults.put("Table.font", messageFont);
                uiDefaults.put("TableHeader.font", messageFont);
                uiDefaults.put("TextField.font", messageFont);
                uiDefaults.put("TextPane.font", messageFont);
                uiDefaults.put("TitledBorder.font", messageFont);
                uiDefaults.put("ToggleButton.font", messageFont);
                uiDefaults.put("Tree.font", messageFont);
                uiDefaults.put("Viewport.font", messageFont);
            }
        }
        uiDefaults.put("TextArea.font", uiDefaults.get("TextField.font"));
    }

    public void serviceChanged(ServiceEvent event) {
        Object sService = GuiActivator.bundleContext.getService(event.getServiceReference());
        if (!(sService instanceof PluginComponentFactory)) {
            return;
        }
        PluginComponentFactory factory = (PluginComponentFactory)sService;
        switch (event.getType()) {
            case 1: {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Handling registration of a new Plugin Component.");
                }
                this.firePluginEvent(factory, 1);
                break;
            }
            case 4: {
                this.firePluginEvent(factory, 2);
            }
        }
    }

    public static Object getBorderLayoutConstraintsFromContainer(Object containerConstraints) {
        String layoutConstraint = null;
        if (containerConstraints == null) {
            return null;
        }
        if (containerConstraints.equals("Start")) {
            layoutConstraint = "Before";
        } else if (containerConstraints.equals("End")) {
            layoutConstraint = "After";
        } else if (containerConstraints.equals("Top")) {
            layoutConstraint = "North";
        } else if (containerConstraints.equals("Bottom")) {
            layoutConstraint = "South";
        } else if (containerConstraints.equals("Left")) {
            layoutConstraint = "West";
        } else if (containerConstraints.equals("Right")) {
            layoutConstraint = "East";
        }
        return layoutConstraint;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("impl.gui.IS_TRANSPARENT_WINDOW_ENABLED")) {
            String isTransparentString = (String)evt.getNewValue();
            boolean isTransparentWindowEnabled = Boolean.parseBoolean(isTransparentString);
            try {
                WindowUtils.setWindowTransparent((Window)((Object)this.mainFrame), (boolean)isTransparentWindowEnabled);
            }
            catch (UnsupportedOperationException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                if (isTransparentWindowEnabled) {
                    ResourceManagementService resources = GuiActivator.getResources();
                    new ErrorDialog((Frame)((Object)this.mainFrame), resources.getI18NString("service.gui.ERROR"), resources.getI18NString("service.gui.TRANSPARENCY_NOT_ENABLED")).showDialog();
                }
                ConfigurationUtils.setTransparentWindowEnabled((boolean)false);
            }
        } else if (propertyName.equals("impl.gui.WINDOW_TRANSPARENCY")) {
            this.mainFrame.repaint();
        }
    }

    private void initCustomFonts() {
        JLayeredPane layeredPane = this.mainFrame.getLayeredPane();
        ResourceManagementService resources = GuiActivator.getResources();
        String fontName = resources.getSettingsString("service.gui.FONT_NAME");
        int fontSize = resources.getSettingsInt("service.gui.FONT_SIZE");
        Font font = new Font(fontName, 1, fontSize);
        for (int i = 0; i < layeredPane.getComponentCount(); ++i) {
            layeredPane.getComponent(i).setFont(font);
        }
    }

    public boolean useMacOSXScreenMenuBar() {
        return OSUtils.IS_MAC;
    }

    public void beginShutdown() {
        try {
            for (ChatPanel cp : this.chatWindowManager.getAllChats()) {
                this.chatWindowManager.closeChat(cp);
            }
            if (this.mainFrame != null) {
                this.mainFrame.dispose();
            }
        }
        finally {
            System.exit(0);
        }
    }

    public ConfigurationContainer getConfigurationContainer() {
        if (this.configurationFrame == null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                block4: {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                UIServiceImpl.this.getConfigurationContainer();
                            }
                        });
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Error creating config frame in swing thread");
                        if (this.configurationFrame != null) break block4;
                        this.configurationFrame = new ConfigurationFrame(this.mainFrame);
                    }
                }
                return this.configurationFrame;
            }
            this.configurationFrame = new ConfigurationFrame(this.mainFrame);
        }
        return this.configurationFrame;
    }

    public List<Chat> getChats() {
        return new ArrayList<Chat>(this.chatWindowManager.getChatPanels());
    }

    public MetaContact getChatContact(Chat chat) {
        Object contact = ((ChatPanel)chat).getChatSession().getDescriptor();
        if (contact instanceof MetaContact) {
            return (MetaContact)contact;
        }
        return null;
    }

    public void addWindowListener(WindowListener l) {
        this.mainFrame.addWindowListener(l);
    }

    public void removeWindowListener(WindowListener l) {
        this.mainFrame.removeWindowListener(l);
    }

    public Collection<Chat> getAllChats() {
        return new ArrayList<Chat>(this.getChatWindowManager().getAllChats());
    }

    public SingleWindowContainer getSingleWindowContainer() {
        return this.singleWindowContainer;
    }

    public void addChatListener(ChatListener listener) {
        this.getChatWindowManager().addChatListener(listener);
    }

    public void removeChatListener(ChatListener listener) {
        this.getChatWindowManager().removeChatListener(listener);
    }

    public void repaintUI() {
        Window[] windows;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIServiceImpl.this.repaintUI();
                }
            });
            return;
        }
        if (UIManager.getLookAndFeel() instanceof SIPCommLookAndFeel) {
            ((SIPCommLookAndFeel)UIManager.getLookAndFeel()).loadSkin();
        }
        Constants.reload();
        ImageLoader.clearCache();
        for (Window win : windows = net.java.sip.communicator.plugin.desktoputil.WindowUtils.getWindows()) {
            this.reloadComponents(win);
            ComponentUtils.updateComponentTreeUI((Component)win);
        }
    }

    private void reloadComponents(Window window) {
        if (window instanceof Skinnable) {
            ((Skinnable)window).loadSkin();
        }
        this.reloadComponents((Container)window);
    }

    private void reloadComponents(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            JPopupMenu jpm;
            Component c = container.getComponent(i);
            if (c instanceof Skinnable) {
                ((Skinnable)c).loadSkin();
            }
            if (c instanceof JComponent && (jpm = ((JComponent)c).getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == c) {
                if (jpm instanceof Skinnable) {
                    ((Skinnable)jpm).loadSkin();
                }
                this.reloadComponents(jpm);
            }
            if (c instanceof JMenu) {
                Component[] children = null;
                children = ((JMenu)c).getMenuComponents();
                for (int ii = 0; ii < children.length; ++ii) {
                    if (children[ii] instanceof Skinnable) {
                        ((Skinnable)children[ii]).loadSkin();
                    }
                    if (!(children[ii] instanceof Container)) continue;
                    this.reloadComponents((Container)children[ii]);
                }
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.reloadComponents((Container)c);
        }
    }

    public CreateAccountWindow getCreateAccountWindow() {
        return new NewAccountDialog();
    }

    public void createCall(String[] participants) {
        if (participants.length != 1) {
            throw new IllegalArgumentException("participants");
        }
        CallManager.createCall(participants[0], null);
    }

    public void startChat(String[] participants) {
        this.startChat(participants, false);
    }

    public void startChat(String[] participants, boolean isSmsEnabled) {
        if (participants.length != 1) {
            throw new IllegalArgumentException("participants");
        }
        this.getChatWindowManager().startChat(participants[0], isSmsEnabled);
    }

    public void openChatRoomWindow(ChatRoomWrapper chatRoom) {
        ChatWindowManager chatWindowManager = this.getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(chatRoom, true);
        chatWindowManager.openChat(chatPanel, true);
    }

    public void closeChatRoomWindow(ChatRoomWrapper chatRoom) {
        ChatWindowManager chatWindowManager = this.getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(chatRoom, false);
        if (chatPanel != null) {
            chatWindowManager.closeChat(chatPanel);
        }
    }

    public ContactList createContactListComponent(ContactListContainer clContainer) {
        return new TreeContactList(clContainer);
    }

    public Collection<Call> getInProgressCalls() {
        return CallManager.getInProgressCalls();
    }

    public void showAddChatRoomDialog() {
        ChatRoomTableDialog.showChatRoomTableDialog();
    }

    public void showChatRoomAutoOpenConfigDialog(ProtocolProviderService pps, String chatRoomId) {
        ChatRoomAutoOpenConfigDialog.showChatRoomAutoOpenConfigDialog(pps, chatRoomId);
    }

    @Override
    public void notificationReceived(UINotification notification) {
        this.forwardNotificationCount();
    }

    @Override
    public void notificationCleared(UINotification notification) {
        this.forwardNotificationCount();
    }

    private void forwardNotificationCount() {
        int count = 0;
        for (UINotificationGroup g : UINotificationManager.getNotificationGroups()) {
            Iterator<UINotification> it = UINotificationManager.getUnreadNotifications(g);
            while (it.hasNext()) {
                count += it.next().getUnreadObjects();
            }
        }
        GuiActivator.getSystrayService().setNotificationCount(count);
    }

    private void maybeShowMasterPasswordMissingWarningDialog() {
        if (GuiActivator.getCredentialsStorageService().isUsingMasterPassword() || !ConfigurationUtils.showMasterPasswordWarning()) {
            return;
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(this);
                    return;
                }
                ResourceManagementService i18n = GuiActivator.getResources();
                MessageDialog dialog = new MessageDialog((Frame)((Object)UIServiceImpl.this.mainFrame), i18n.getI18NString("plugin.securityconfig.masterpassword.USE_MASTER_PASSWORD"), i18n.getI18NString("plugin.securityconfig.masterpassword.NO_MP_WARNING"), null, true);
                switch (dialog.showDialog()) {
                    case 2: {
                        ConfigurationUtils.setShowMasterPasswordWarning((boolean)false);
                    }
                    case 0: {
                        ConfigurationContainer configContainer = UIServiceImpl.this.getConfigurationContainer();
                        ConfigurationForm configForm = ConfigFormUtils.getConfigForm((String)"GENERAL_TYPE", (String)"net.java.sip.communicator.plugin.securityconfig.SecurityConfigurationPanel");
                        if (configForm == null) break;
                        configContainer.setSelected(configForm);
                        configContainer.setVisible(true);
                    }
                }
            }
        }, 10000L);
    }

    static {
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_TOOL_BAR);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_GROUP_RIGHT_BUTTON_MENU);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_TOOLS_MENU);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_HELP_MENU);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_TOOL_BAR);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_CALL_HISTORY);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_MAIN_TABBED_PANE);
        supportedContainers.add(net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_HELP_MENU);
        exportedWindows = new Hashtable();
    }

    private static class KeyBindingsDispatching
    implements KeyEventDispatcher {
        private final KeyboardFocusManager focusManager;

        KeyBindingsDispatching(KeyboardFocusManager focusManager) {
            this.focusManager = focusManager;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                Window w = this.focusManager.getActiveWindow();
                JRootPane rpane = null;
                if (w instanceof JFrame) {
                    rpane = ((JFrame)w).getRootPane();
                }
                if (w instanceof JDialog) {
                    rpane = ((JDialog)w).getRootPane();
                }
                if (rpane == null) {
                    return false;
                }
                Object binding = rpane.getInputMap(1).get(KeyStroke.getKeyStrokeForEvent(e));
                if (binding == null) {
                    return false;
                }
                Action actObj = rpane.getActionMap().get(binding);
                if (actObj != null && actObj instanceof UIAction) {
                    ((UIAction)actObj).actionPerformed(new ActionEvent(w, -1, (String)binding));
                    return true;
                }
            }
            return false;
        }
    }

    private class RunLoginGui
    implements Runnable {
        private RunLoginGui() {
        }

        @Override
        public void run() {
            UIServiceImpl.this.loginManager.runLogin();
        }
    }
}

