/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.Wizard;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardModel;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.service.gui.WizardPage;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard w) {
        this.wizard = w;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (evt.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (evt.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void nextButtonPressed() {
        this.wizard.startCommittingPage();
        new Thread(new PageCommitThread()).start();
    }

    private void backButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPage page = model.getCurrentWizardPage();
        page.pageBack();
        Object backPageIdentifier = page.getBackPageIdentifier();
        this.wizard.setCurrentPage(backPageIdentifier);
    }

    void resetButtonsToPanelRules() {
        WizardModel model = this.wizard.getModel();
        WizardPage page = model.getCurrentWizardPage();
        model.setCancelButtonText(this.wizard.getCancelButtonDefaultText());
        Object backPageIdentifier = page.getBackPageIdentifier();
        model.setBackButtonEnabled(backPageIdentifier != null && !"DEFAULT".equals(backPageIdentifier));
        model.setBackButtonText(this.wizard.getBackButtonDefaultText());
        model.setNextFinishButtonEnabled(page.getNextPageIdentifier() != null);
        if (page.getNextPageIdentifier().equals("FINISH")) {
            model.setNextFinishButtonText(this.wizard.getFinishButtonDefaultText());
        } else {
            model.setNextFinishButtonText(this.wizard.getNextButtonDefaultText());
        }
    }

    private class PageCommitThread
    implements Runnable {
        private PageCommitThread() {
        }

        @Override
        public void run() {
            WizardModel model = WizardController.this.wizard.getModel();
            final WizardPage page = model.getCurrentWizardPage();
            try {
                page.commitPage();
            }
            catch (Exception ex) {
                WizardController.this.wizard.stopCommittingPage();
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), ex.getMessage(), (Throwable)ex).showDialog();
                return;
            }
            WizardController.this.wizard.stopCommittingPage();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object nextPageIdentifier = page.getNextPageIdentifier();
                    if (nextPageIdentifier.equals("FINISH")) {
                        WizardController.this.wizard.close(0);
                    } else {
                        WizardController.this.wizard.setCurrentPage(nextPageIdentifier);
                    }
                }
            });
        }
    }
}

