/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.account.AccountListCellRenderer;
import net.java.sip.communicator.impl.gui.main.account.AccountListModel;
import net.java.sip.communicator.impl.gui.main.account.AccountRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.account.AccountsConfigurationPanel;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class AccountList
extends JList
implements ProviderPresenceStatusListener,
RegistrationStateChangeListener,
ServiceListener,
MouseListener {
    private final Logger logger = Logger.getLogger(AccountList.class);
    static final String ACCOUNT_STATE_CHANGED = "ACCOUNT_STATE_CHANGED";
    private final AccountListModel accountListModel = new AccountListModel();
    private final JButton editButton;
    private final AccountRightButtonMenu rightButtonMenu = new AccountRightButtonMenu();
    private EnableAccountWorker enableAccountWorker;

    public AccountList(AccountsConfigurationPanel parentConfigPanel) {
        this.setModel(this.accountListModel);
        this.setCellRenderer(new AccountListCellRenderer());
        this.addMouseListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point = e.getPoint();
                    AccountList.this.setSelectedIndex(AccountList.this.getRow(point));
                    AccountList.this.rightButtonMenu.setAccount(AccountList.this.getSelectedAccount());
                    SwingUtilities.convertPointToScreen(point, AccountList.this);
                    AccountList.this.rightButtonMenu.setInvoker(AccountList.this);
                    AccountList.this.rightButtonMenu.setLocation(point.x, point.y);
                    AccountList.this.rightButtonMenu.setVisible(true);
                }
            }
        });
        this.accountsInit();
        GuiActivator.bundleContext.addServiceListener((ServiceListener)this);
        this.editButton = parentConfigPanel.getEditButton();
    }

    private int getRow(Point point) {
        return this.locationToIndex(point);
    }

    private void accountsInit() {
        AccountManager accountManager = GuiActivator.getAccountManager();
        for (AccountID accountID : accountManager.getStoredAccounts()) {
            if (accountID.isHidden() || accountID.isConfigHidden()) continue;
            Account uiAccount = null;
            if (accountManager.isAccountLoaded(accountID)) {
                ProtocolProviderService protocolProvider = AccountUtils.getRegisteredProviderForAccount((AccountID)accountID);
                if (protocolProvider != null) {
                    uiAccount = new Account(protocolProvider);
                    protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
                    OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                    if (presence != null) {
                        presence.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
                    }
                }
            } else {
                uiAccount = new Account(accountID);
            }
            if (uiAccount == null) continue;
            this.accountListModel.addAccount(uiAccount);
        }
    }

    public Account getSelectedAccount() {
        return (Account)this.getSelectedValue();
    }

    public void providerStatusChanged(final ProviderPresenceStatusChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountList.this.providerStatusChanged(evt);
                }
            });
            return;
        }
        this.accountListModelContentChanged(evt.getProvider());
    }

    public void providerStatusMessageChanged(PropertyChangeEvent evt) {
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getServiceReference().getBundle().getState() == 16) {
            return;
        }
        Object sourceService = GuiActivator.bundleContext.getService(event.getServiceReference());
        if (!(sourceService instanceof ProtocolProviderService)) {
            return;
        }
        ProtocolProviderService protocolProvider = (ProtocolProviderService)sourceService;
        if (protocolProvider.getAccountID().isHidden() && protocolProvider.getAccountID().isConfigHidden()) {
            return;
        }
        if (event.getType() == 1) {
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            if (presence != null) {
                presence.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
            }
            this.addAccount(protocolProvider);
        } else if (event.getType() == 4) {
            this.removeAccount(protocolProvider);
        }
    }

    private void addAccount(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountList.this.addAccount(protocolProvider);
                }
            });
            return;
        }
        Account account = this.accountListModel.getAccount(protocolProvider.getAccountID());
        if (account != null) {
            account.setProtocolProvider(protocolProvider);
        } else {
            this.accountListModel.addAccount(new Account(protocolProvider));
        }
        this.repaint();
    }

    private void removeAccount(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountList.this.removeAccount(protocolProvider);
                }
            });
            return;
        }
        Account account = this.accountListModel.getAccount(protocolProvider.getAccountID());
        if (account != null && account.isEnabled()) {
            this.accountListModel.removeAccount(account);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.editButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatchEventToCheckBox(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void registrationStateChanged(final RegistrationStateChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountList.this.registrationStateChanged(evt);
                }
            });
            return;
        }
        this.accountListModelContentChanged(evt.getProvider());
    }

    private void accountListModelContentChanged(ProtocolProviderService protocolProvider) {
        Enumeration accounts = this.accountListModel.elements();
        while (accounts.hasMoreElements()) {
            Account account = (Account)accounts.nextElement();
            ProtocolProviderService accountProvider = account.getProtocolProvider();
            if (accountProvider != protocolProvider) continue;
            this.accountListModel.contentChanged(account);
        }
    }

    private void dispatchEventToCheckBox(MouseEvent event) {
        if (this.enableAccountWorker != null) {
            this.logger.warn((Object)"Enable account worker is already running");
            return;
        }
        int mouseIndex = this.locationToIndex(event.getPoint());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Account list: index under mouse found:" + mouseIndex));
        }
        if (mouseIndex < 0) {
            return;
        }
        Account account = (Account)this.getModel().getElementAt(mouseIndex);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Account list: element at mouse index:" + account.getName()));
        }
        AccountListCellRenderer renderer = (AccountListCellRenderer)((Object)this.getCellRenderer().getListCellRendererComponent(this, account, mouseIndex, true, true));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Account list: renderer bounds for mouse index:" + renderer.getBounds()));
        }
        Rectangle r = this.getCellBounds(mouseIndex, mouseIndex);
        int translatedX = event.getX() - r.x;
        int translatedY = event.getY() - r.y;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Account list: find component at:" + translatedX + ", " + translatedY));
        }
        if (renderer.isOverCheckBox(translatedX, translatedY)) {
            JCheckBox checkBox = account.getEnableCheckBox();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Account list: checkBox set selected" + !checkBox.isSelected()));
            }
            checkBox.setSelected(!checkBox.isSelected());
            this.enableAccountWorker = new EnableAccountWorker(account, checkBox.isSelected());
            this.enableAccountWorker.start();
        }
    }

    private void enableAccount(Account account, boolean enable) {
        account.setEnabled(enable);
        AccountManager accountManager = GuiActivator.getAccountManager();
        AccountID accountID = account.getAccountID();
        try {
            if (enable) {
                accountManager.loadAccount(accountID);
            } else {
                accountManager.unloadAccount(accountID);
            }
            this.firePropertyChange(ACCOUNT_STATE_CHANGED, !enable, enable);
        }
        catch (OperationFailedException ofex) {
            throw new UndeclaredThrowableException(ofex);
        }
    }

    public void ensureAccountRemoved(final AccountID accountID) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountList.this.ensureAccountRemoved(accountID);
                }
            });
            return;
        }
        Account account = this.accountListModel.getAccount(accountID);
        if (account != null) {
            this.accountListModel.removeAccount(account);
        }
    }

    private class EnableAccountWorker
    extends SwingWorker {
        private Account account;
        private boolean enable;

        EnableAccountWorker(Account account, boolean enable) {
            this.account = account;
            this.enable = enable;
        }

        protected Object construct() throws Exception {
            AccountList.this.enableAccount(this.account, this.enable);
            return null;
        }

        protected void finished() {
            AccountList.this.enableAccountWorker = null;
            AccountList.this.repaint();
        }
    }
}

