/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.Wizard;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.account.AccountRegSummaryPage;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.DesktopAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AccountRegWizardContainerImpl
extends Wizard
implements WizardContainer,
ServiceListener {
    private static final Logger logger = Logger.getLogger(AccountRegWizardContainerImpl.class);
    private final AccountRegSummaryPage summaryPage;
    private AccountRegistrationWizard currentWizard;
    private final ConfigurationService configService = GuiActivator.getConfigurationService();
    private final Map<String, AccountRegistrationWizard> registeredWizards = new Hashtable<String, AccountRegistrationWizard>();

    public AccountRegWizardContainerImpl(MainFrame mainFrame) {
        super((Frame)((Object)mainFrame));
        Collection accountWizardRefs;
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT_REGISTRATION_WIZARD"));
        this.summaryPage = new AccountRegSummaryPage(this);
        this.registerWizardPage(this.summaryPage.getIdentifier(), this.summaryPage);
        try {
            accountWizardRefs = GuiActivator.bundleContext.getServiceReferences(AccountRegistrationWizard.class, null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (accountWizardRefs != null && !accountWizardRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + accountWizardRefs.size() + " already installed providers."));
            }
            for (ServiceReference serRef : accountWizardRefs) {
                String protocolName = (String)serRef.getProperty("PROTOCOL_NAME");
                AccountRegistrationWizard wizard = (AccountRegistrationWizard)GuiActivator.bundleContext.getService(serRef);
                this.addAccountRegistrationWizard(protocolName, wizard);
            }
        }
        GuiActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccountRegistrationWizard(String protocolName, AccountRegistrationWizard wizard) {
        Map<String, AccountRegistrationWizard> map = this.registeredWizards;
        synchronized (map) {
            this.registeredWizards.put(protocolName, wizard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccountRegistrationWizard(String protocolName, AccountRegistrationWizard wizard) {
        Map<String, AccountRegistrationWizard> map = this.registeredWizards;
        synchronized (map) {
            this.registeredWizards.remove(protocolName);
        }
    }

    public AccountRegSummaryPage getSummaryPage() {
        return this.summaryPage;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider) {
        AccountRegistrationWizard wizard = this.getProtocolWizard(protocolProvider);
        this.setCurrentWizard(wizard);
        wizard.setModification(true);
        this.summaryPage.setModification(protocolProvider);
        if (protocolProvider != null && protocolProvider.getAccountID().isReadOnly()) {
            this.setDisabled(this.cardPanel.getComponents());
        }
        wizard.loadAccount(protocolProvider);
    }

    private void setDisabled(Component[] components) {
        for (Component c : components) {
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).setEditable(false);
            } else if (c instanceof JComboBox || c instanceof AbstractButton) {
                c.setEnabled(false);
            }
            if (!(c instanceof Container)) continue;
            this.setDisabled(((Container)c).getComponents());
        }
    }

    public AccountRegistrationWizard getProtocolWizard(ProtocolProviderService protocolProvider) {
        AccountRegistrationWizard res = this.registeredWizards.get(protocolProvider.getProtocolDisplayName());
        if (res == null) {
            for (AccountRegistrationWizard wizard : this.registeredWizards.values()) {
                if (!wizard.getProtocolName().equals(protocolProvider.getProtocolName())) continue;
                res = wizard;
                break;
            }
        }
        return res;
    }

    public void saveAccountWizard(ProtocolProviderService protocolProvider, AccountRegistrationWizard wizard) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = this.configService.getPropertyNamesByPrefix(prefix, true);
        boolean savedAccount = false;
        for (String accountRootPropName : accounts) {
            String accountUID = this.configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            this.configService.setProperty(accountRootPropName + ".wizard", (Object)wizard.getClass().getName().replace('.', '_'));
            savedAccount = true;
        }
        if (!savedAccount) {
            String accountPackage = prefix + ".acc" + Long.toString(System.currentTimeMillis());
            this.configService.setProperty(accountPackage, (Object)protocolProvider.getAccountID().getAccountUniqueID());
            this.configService.setProperty(accountPackage + ".wizard", (Object)wizard);
        }
    }

    public AccountRegistrationWizard getCurrentWizard() {
        return this.currentWizard;
    }

    public void setCurrentWizard(AccountRegistrationWizard wizard) {
        this.currentWizard = wizard;
        if (wizard instanceof DesktopAccountRegistrationWizard) {
            this.summaryPage.setPreferredSize(((DesktopAccountRegistrationWizard)this.currentWizard).getSize());
        }
        Iterator i = wizard.getPages();
        while (i.hasNext()) {
            WizardPage page = (WizardPage)i.next();
            this.registerWizardPage(page.getIdentifier(), page);
        }
        this.setCurrentPage(wizard.getFirstPageIdentifier());
        try {
            this.setWizzardIcon(ImageIO.read(new ByteArrayInputStream(wizard.getPageImage())));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void unregisterWizardPages() {
        Iterator i = this.getCurrentWizard().getPages();
        while (i.hasNext()) {
            WizardPage page = (WizardPage)i.next();
            this.unregisterWizardPage(page.getIdentifier());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (!GuiActivator.isStarted) {
            return;
        }
        ServiceReference serRef = event.getServiceReference();
        Object sService = GuiActivator.bundleContext.getService(serRef);
        if (!(sService instanceof AccountRegistrationWizard)) {
            return;
        }
        String protocolName = (String)serRef.getProperty("PROTOCOL_NAME");
        AccountRegistrationWizard wizard = (AccountRegistrationWizard)sService;
        switch (event.getType()) {
            case 1: {
                logger.info((Object)"Handling registration of a new Account Wizard.");
                this.addAccountRegistrationWizard(protocolName, wizard);
                break;
            }
            case 4: {
                this.removeAccountRegistrationWizard(protocolName, wizard);
            }
        }
    }

    @Override
    protected void close(boolean isEscaped) {
        this.summaryPage.dispose();
    }
}

