/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import com.explodingpixels.macwidgets.HudWindow;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallTitleListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.ViewCertificateFrame;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetTLS;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.GuiUtils;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.MediaType;

public class CallInfoFrame
implements CallTitleListener,
PropertyChangeListener,
HyperlinkListener {
    private CallConference callConference;
    private final JDialog callInfoWindow;
    private final JEditorPane infoTextPane;
    private String fontColor;
    private final ResourceManagementService resources = GuiActivator.getResources();
    private boolean hasCallInfo;
    private final String CERTIFICATE_URL = "jitsi://viewCertificate";

    public CallInfoFrame(CallConference callConference) {
        this.callConference = callConference;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.infoTextPane = this.createGeneralInfoPane();
        Caret caret = this.infoTextPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        scrollPane.getViewport().add(this.infoTextPane);
        this.callInfoWindow = this.createCallInfoWindow(GuiActivator.getResources().getI18NString("service.gui.callinfo.TECHNICAL_CALL_INFO"));
        this.callInfoWindow.getContentPane().add(scrollPane);
        this.hasCallInfo = this.constructCallInfo();
    }

    private JDialog createCallInfoWindow(String title) {
        Object callInfoWindow = null;
        if (OSUtils.IS_MAC) {
            HudWindow window = new HudWindow();
            JDialog dialog = window.getJDialog();
            dialog.setTitle(title);
            callInfoWindow = window.getJDialog();
            ((Dialog)callInfoWindow).setResizable(true);
            this.fontColor = "FFFFFF";
        } else {
            SIPCommDialog dialog = new SIPCommDialog(false);
            callInfoWindow = dialog;
            ((Dialog)callInfoWindow).setTitle(title);
            this.fontColor = "000000";
        }
        return callInfoWindow;
    }

    private JEditorPane createGeneralInfoPane() {
        JEditorPane infoTextPane = new JEditorPane();
        infoTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        infoTextPane.setOpaque(false);
        infoTextPane.setEditable(false);
        infoTextPane.setContentType("text/html");
        infoTextPane.addHyperlinkListener(this);
        return infoTextPane;
    }

    private String getLineString(String labelText, String infoText) {
        return "<b>" + labelText + "</b> : " + infoText + "<br/>";
    }

    private boolean constructCallInfo() {
        OperationSetTLS opSetTls;
        TransportProtocol preferredTransport;
        boolean isConfFocus;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><p align=\"left\"><font color=\"" + this.fontColor + "\" size=\"3\">");
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.CALL_INFORMATION"), ""));
        List calls = this.callConference.getCalls();
        if (calls.size() <= 0) {
            return false;
        }
        Call aCall = (Call)calls.get(0);
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.CALL_IDENTITY"), aCall.getProtocolProvider().getAccountID().getDisplayName()));
        int callPeerCount = this.callConference.getCallPeerCount();
        if (callPeerCount > 1) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.PEER_COUNT"), String.valueOf(callPeerCount)));
        }
        if (isConfFocus = this.callConference.isConferenceFocus()) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.IS_CONFERENCE_FOCUS"), String.valueOf(isConfFocus)));
        }
        if ((preferredTransport = aCall.getProtocolProvider().getTransportProtocol()) != TransportProtocol.UNKNOWN) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.CALL_TRANSPORT"), preferredTransport.toString()));
        }
        if ((opSetTls = (OperationSetTLS)aCall.getProtocolProvider().getOperationSet(OperationSetTLS.class)) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.TLS_PROTOCOL"), opSetTls.getProtocol()));
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.TLS_CIPHER_SUITE"), opSetTls.getCipherSuite()));
            stringBuffer.append("<b><a href=\"").append("jitsi://viewCertificate").append("\">").append(this.resources.getI18NString("service.gui.callinfo.VIEW_CERTIFICATE")).append("</a></b><br/>");
        }
        this.constructCallPeersInfo(stringBuffer);
        stringBuffer.append("</font></p></body></html>");
        this.infoTextPane.setText(stringBuffer.toString());
        this.infoTextPane.revalidate();
        this.infoTextPane.repaint();
        return true;
    }

    private void constructCallPeersInfo(StringBuffer stringBuffer) {
        for (CallPeer callPeer : this.callConference.getCallPeers()) {
            if (callPeer instanceof MediaAwareCallPeer) {
                ((MediaAwareCallPeer)callPeer).getMediaHandler().addPropertyChangeListener((PropertyChangeListener)this);
            }
            stringBuffer.append("<br/>");
            this.constructPeerInfo(callPeer, stringBuffer);
        }
    }

    private void constructPeerInfo(CallPeer callPeer, StringBuffer stringBuffer) {
        CallPeerMediaHandler callPeerMediaHandler;
        stringBuffer.append(this.getLineString(callPeer.getAddress(), ""));
        if (callPeer.getCallDurationStartTime() != 0L) {
            Date startTime = new Date(callPeer.getCallDurationStartTime());
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.CALL_DURATION"), GuiUtils.formatTime((long)startTime.getTime(), (long)System.currentTimeMillis())));
        }
        if (callPeer instanceof MediaAwareCallPeer && (callPeerMediaHandler = ((MediaAwareCallPeer)callPeer).getMediaHandler()) != null) {
            MediaStream mediaStream = callPeerMediaHandler.getStream(MediaType.AUDIO);
            if (mediaStream != null && mediaStream.isStarted()) {
                stringBuffer.append("<br/>");
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.AUDIO_INFO"), ""));
                this.appendStreamEncryptionMethod(stringBuffer, callPeerMediaHandler, mediaStream, MediaType.AUDIO);
                this.constructAudioVideoInfo(callPeerMediaHandler, mediaStream, stringBuffer, MediaType.AUDIO);
            }
            if ((mediaStream = callPeerMediaHandler.getStream(MediaType.VIDEO)) != null && mediaStream.isStarted()) {
                stringBuffer.append("<br/>");
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.VIDEO_INFO"), ""));
                this.appendStreamEncryptionMethod(stringBuffer, callPeerMediaHandler, mediaStream, MediaType.VIDEO);
                this.constructAudioVideoInfo(callPeerMediaHandler, mediaStream, stringBuffer, MediaType.VIDEO);
            }
            stringBuffer.append("<br/>");
            String iceState = callPeerMediaHandler.getICEState();
            if (iceState != null && !iceState.equals("Terminated")) {
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_STATE"), this.resources.getI18NString("service.gui.callinfo.ICE_STATE." + iceState.toUpperCase())));
            }
            stringBuffer.append("<br/>");
            long harvestingTime = callPeerMediaHandler.getTotalHarvestingTime();
            if (harvestingTime != 0L) {
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.TOTAL_HARVESTING_TIME"), harvestingTime + " " + this.resources.getI18NString("service.gui.callinfo.HARVESTING_MS_FOR") + " " + callPeerMediaHandler.getNbHarvesting() + " " + this.resources.getI18NString("service.gui.callinfo.HARVESTS")));
            }
            String[] harvesterNames = new String[]{"GoogleTurnCandidateHarvester", "GoogleTurnSSLCandidateHarvester", "HostCandidateHarvester", "JingleNodesHarvester", "StunCandidateHarvester", "TurnCandidateHarvester", "UPNPHarvester"};
            for (int i = 0; i < harvesterNames.length; ++i) {
                harvestingTime = callPeerMediaHandler.getHarvestingTime(harvesterNames[i]);
                if (harvestingTime == 0L) continue;
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.HARVESTING_TIME") + " " + harvesterNames[i], harvestingTime + " " + this.resources.getI18NString("service.gui.callinfo.HARVESTING_MS_FOR") + " " + callPeerMediaHandler.getNbHarvesting(harvesterNames[i]) + " " + this.resources.getI18NString("service.gui.callinfo.HARVESTS")));
            }
        }
    }

    private void constructAudioVideoInfo(CallPeerMediaHandler<?> callPeerMediaHandler, MediaStream mediaStream, StringBuffer stringBuffer, MediaType mediaType) {
        InetSocketAddress iceRemoteHostAddress;
        InetSocketAddress iceRemoteReflexiveAddress;
        InetSocketAddress iceRemoteRelayedAddress;
        InetSocketAddress iceLocalRelayedAddress;
        InetSocketAddress iceLocalReflexiveAddress;
        InetSocketAddress iceLocalHostAddress;
        MediaStreamStats2 mediaStreamStats = mediaStream.getMediaStreamStats();
        if (mediaStreamStats == null) {
            return;
        }
        mediaStreamStats.updateStats();
        if (mediaType == MediaType.VIDEO) {
            Dimension downloadVideoSize = mediaStreamStats.getDownloadVideoSize();
            Dimension uploadVideoSize = mediaStreamStats.getUploadVideoSize();
            if (downloadVideoSize != null || uploadVideoSize != null) {
                stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.VIDEO_SIZE"), "&darr; " + this.videoSizeToString(downloadVideoSize) + " &uarr; " + this.videoSizeToString(uploadVideoSize)));
            } else {
                return;
            }
        }
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.CODEC"), mediaStreamStats.getEncoding() + " / " + mediaStreamStats.getEncodingClockRate() + " Hz"));
        boolean displayedIpPort = false;
        String iceCandidateExtendedType = callPeerMediaHandler.getICECandidateExtendedType(mediaType.toString());
        if (iceCandidateExtendedType != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_CANDIDATE_EXTENDED_TYPE"), iceCandidateExtendedType));
            displayedIpPort = true;
        }
        if ((iceLocalHostAddress = callPeerMediaHandler.getICELocalHostAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_LOCAL_HOST_ADDRESS"), iceLocalHostAddress.getAddress().getHostAddress() + "/" + iceLocalHostAddress.getPort()));
            displayedIpPort = true;
        }
        if ((iceLocalReflexiveAddress = callPeerMediaHandler.getICELocalReflexiveAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_LOCAL_REFLEXIVE_ADDRESS"), iceLocalReflexiveAddress.getAddress().getHostAddress() + "/" + iceLocalReflexiveAddress.getPort()));
            displayedIpPort = true;
        }
        if ((iceLocalRelayedAddress = callPeerMediaHandler.getICELocalRelayedAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_LOCAL_RELAYED_ADDRESS"), iceLocalRelayedAddress.getAddress().getHostAddress() + "/" + iceLocalRelayedAddress.getPort()));
            displayedIpPort = true;
        }
        if ((iceRemoteRelayedAddress = callPeerMediaHandler.getICERemoteRelayedAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_REMOTE_RELAYED_ADDRESS"), iceRemoteRelayedAddress.getAddress().getHostAddress() + "/" + iceRemoteRelayedAddress.getPort()));
            displayedIpPort = true;
        }
        if ((iceRemoteReflexiveAddress = callPeerMediaHandler.getICERemoteReflexiveAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_REMOTE_REFLEXIVE_ADDRESS"), iceRemoteReflexiveAddress.getAddress().getHostAddress() + "/" + iceRemoteReflexiveAddress.getPort()));
            displayedIpPort = true;
        }
        if ((iceRemoteHostAddress = callPeerMediaHandler.getICERemoteHostAddress(mediaType.toString())) != null) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ICE_REMOTE_HOST_ADDRESS"), iceRemoteHostAddress.getAddress().getHostAddress() + "/" + iceRemoteHostAddress.getPort()));
            displayedIpPort = true;
        }
        if (!displayedIpPort) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.LOCAL_IP"), mediaStreamStats.getLocalIPAddress() + " / " + String.valueOf(mediaStreamStats.getLocalPort())));
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.REMOTE_IP"), mediaStreamStats.getRemoteIPAddress() + " / " + String.valueOf(mediaStreamStats.getRemotePort())));
        }
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.BANDWITH"), "&darr; " + (int)mediaStreamStats.getReceiveStats().getBitrate() / 1024 + " Kbps  &uarr; " + (int)mediaStreamStats.getSendStats().getBitrate() / 1024 + " Kbps"));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.LOSS_RATE"), "&darr;" + (int)(mediaStreamStats.getReceiveStats().getLossRate() * 100.0) + "% &uarr; " + (int)(mediaStreamStats.getSendStats().getLossRate() * 100.0) + "%"));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.DECODED_WITH_FEC"), String.valueOf(mediaStreamStats.getNbFec())));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.DISCARDED_PERCENT"), String.valueOf((int)mediaStreamStats.getPercentDiscarded() + "%")));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.DISCARDED_TOTAL"), String.valueOf(mediaStreamStats.getNbDiscarded()) + " (" + mediaStreamStats.getNbDiscardedLate() + " late, " + mediaStreamStats.getNbDiscardedFull() + " full, " + mediaStreamStats.getNbDiscardedShrink() + " shrink, " + mediaStreamStats.getNbDiscardedReset() + " reset)"));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.ADAPTIVE_JITTER_BUFFER"), mediaStreamStats.isAdaptiveBufferEnabled() ? "enabled" : "disabled"));
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.JITTER_BUFFER_DELAY"), "~" + mediaStreamStats.getJitterBufferDelayMs() + "ms; currently in queue: " + mediaStreamStats.getPacketQueueCountPackets() + "/" + mediaStreamStats.getPacketQueueSize() + " packets"));
        long sendRttMs = mediaStreamStats.getSendStats().getRtt();
        long recvRttMs = mediaStreamStats.getReceiveStats().getRtt();
        if (recvRttMs != -1L || sendRttMs != -1L) {
            stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.RTT"), (recvRttMs != -1L ? "&darr; " + recvRttMs + " ms" : "") + (sendRttMs != -1L ? "&uarr; " + sendRttMs + " ms" : "")));
        }
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.JITTER"), "&darr; " + (int)mediaStreamStats.getReceiveStats().getJitter() + " ms &uarr; " + (int)mediaStreamStats.getSendStats().getJitter() + " ms"));
    }

    @Override
    public void callTitleChanged(CallPanel callContainer) {
        String selectedText = this.infoTextPane.getSelectedText();
        if (selectedText != null && selectedText.length() > 0) {
            return;
        }
        this.hasCallInfo = this.constructCallInfo();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.callInfoWindow.pack();
            this.callInfoWindow.setPreferredSize(new Dimension(300, 450));
            this.callInfoWindow.setSize(300, 450);
            this.callInfoWindow.setLocationRelativeTo(null);
        }
        this.callInfoWindow.setVisible(isVisible);
    }

    public boolean isVisible() {
        return this.callInfoWindow.isVisible();
    }

    public boolean hasCallInfo() {
        return this.hasCallInfo;
    }

    public void dispose() {
        this.callInfoWindow.dispose();
    }

    private void appendStreamEncryptionMethod(StringBuffer stringBuffer, CallPeerMediaHandler<?> callPeerMediaHandler, MediaStream mediaStream, MediaType mediaType) {
        String rtpType;
        SrtpControl srtpControl;
        String transportProtocolString = "";
        StreamConnector.Protocol transportProtocol = mediaStream.getTransportProtocol();
        if (transportProtocol != null) {
            transportProtocolString = transportProtocol.toString();
        }
        if ((srtpControl = callPeerMediaHandler.getEncryptionMethod(mediaType)) != null) {
            String info = srtpControl instanceof ZrtpControl ? "ZRTP " + ((ZrtpControl)srtpControl).getCipherString() : srtpControl.getSrtpControlType().toString();
            rtpType = this.resources.getI18NString("service.gui.callinfo.MEDIA_STREAM_SRTP") + " (" + this.resources.getI18NString("service.gui.callinfo.KEY_EXCHANGE_PROTOCOL") + ": " + info + ")";
        } else {
            rtpType = this.resources.getI18NString("service.gui.callinfo.MEDIA_STREAM_RTP");
        }
        stringBuffer.append(this.getLineString(this.resources.getI18NString("service.gui.callinfo.MEDIA_STREAM_TRANSPORT_PROTOCOL"), transportProtocolString + " / " + rtpType));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("IceProcessingState")) {
            this.callTitleChanged(null);
        }
    }

    private String videoSizeToString(Dimension videoSize) {
        if (videoSize == null) {
            return this.resources.getI18NString("service.gui.callinfo.NA");
        }
        return (int)videoSize.getWidth() + " x " + (int)videoSize.getHeight();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        List calls;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "jitsi://viewCertificate".equals(e.getDescription()) && !(calls = this.callConference.getCalls()).isEmpty()) {
            Call aCall = (Call)calls.get(0);
            Certificate[] chain = ((OperationSetTLS)aCall.getProtocolProvider().getOperationSet(OperationSetTLS.class)).getServerCertificates();
            ViewCertificateFrame certFrame = new ViewCertificateFrame(chain, null, this.resources.getI18NString("service.gui.callinfo.TLS_CERTIFICATE_CONTENT"));
            certFrame.setVisible(true);
        }
    }
}

