/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallTransferHandler;
import net.java.sip.communicator.impl.gui.main.call.OneToOneCallPeerPanel;
import net.java.sip.communicator.impl.gui.main.call.SwingCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.UIVideoHandler2;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.OSUtils;

public class OneToOneCallPanel
extends TransparentPanel
implements SwingCallRenderer,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(OneToOneCallPanel.class);
    private static final long serialVersionUID = 0L;
    private final Call call;
    private final CallPanel callContainer;
    private final CallPeer callPeer;
    private JCheckBox enableDesktopRemoteControl;
    private final JLabel nameLabel = new JLabel("", 0);
    private OneToOneCallPeerPanel peerPanel;
    private JPanel southPanel;
    private JComponent topBar;

    public OneToOneCallPanel(CallPanel callContainer, CallPeer callPeer, UIVideoHandler2 uiVideoHandler) {
        super((LayoutManager)new BorderLayout());
        this.callContainer = callContainer;
        this.callPeer = callPeer;
        this.call = this.callPeer.getCall();
        this.addCallPeerPanel(callPeer, uiVideoHandler);
        int preferredHeight = 400;
        if (GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.call.HIDE_PLACEHOLDER_PIC", false)) {
            preferredHeight = 128;
        }
        this.setPreferredSize(new Dimension(400, preferredHeight));
        this.setTransferHandler((TransferHandler)((Object)new CallTransferHandler(this.call)));
        this.callContainer.addPropertyChangeListener("fullScreen", this);
    }

    private void addCallPeerPanel(CallPeer peer, UIVideoHandler2 uiVideoHandler) {
        if (this.peerPanel == null) {
            this.peerPanel = new OneToOneCallPeerPanel(this, peer, uiVideoHandler);
            this.nameLabel.setText(this.getPeerDisplayText(peer, this.peerPanel.getPeerName()));
            this.topBar = this.createTopComponent();
            this.topBar.setVisible(!this.isFullScreen());
            this.topBar.add(this.nameLabel);
            this.add(this.topBar, "North");
            this.add((Component)((Object)this.peerPanel));
        }
    }

    public void addDesktopSharingComponents() {
        OperationSetDesktopSharingServer opSetDesktopSharingServer = (OperationSetDesktopSharingServer)this.callPeer.getProtocolProvider().getOperationSet(OperationSetDesktopSharingServer.class);
        if (opSetDesktopSharingServer != null && opSetDesktopSharingServer.isRemoteControlAvailable(this.callPeer)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Add desktop sharing related components.");
            }
            if (this.enableDesktopRemoteControl == null) {
                this.enableDesktopRemoteControl = new JCheckBox(GuiActivator.getResources().getI18NString("service.gui.ENABLE_DESKTOP_REMOTE_CONTROL"));
                this.southPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
                this.southPanel.add(this.enableDesktopRemoteControl);
                this.enableDesktopRemoteControl.setAlignmentX(0.5f);
                this.enableDesktopRemoteControl.setOpaque(false);
                this.enableDesktopRemoteControl.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        CallManager.enableDesktopRemoteControl(OneToOneCallPanel.this.callPeer, e.getStateChange() == 1);
                    }
                });
            }
            if (OSUtils.IS_MAC) {
                this.southPanel.setOpaque(true);
                this.southPanel.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND")));
            }
            this.add(this.southPanel, "South");
        }
        this.revalidate();
        this.repaint();
    }

    private JComponent createTopComponent() {
        Object topComponent = null;
        if (OSUtils.IS_MAC) {
            Color macPanelBackground = new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND"));
            if (this.callContainer.getCallWindow() instanceof Window) {
                UnifiedToolBar macToolbarPanel = new UnifiedToolBar();
                MacUtils.makeWindowLeopardStyle(this.callContainer.getCallWindow().getFrame().getRootPane());
                macToolbarPanel.getComponent().setLayout(new BorderLayout());
                macToolbarPanel.disableBackgroundPainter();
                macToolbarPanel.installWindowDraggerOnWindow(this.callContainer.getCallWindow().getFrame());
                topComponent = macToolbarPanel.getComponent();
            } else {
                topComponent = new TransparentPanel((LayoutManager)new BorderLayout());
                topComponent.setOpaque(true);
                topComponent.setBackground(macPanelBackground);
            }
            this.peerPanel.setOpaque(!this.isFullScreen());
            this.peerPanel.setBackground(macPanelBackground);
        } else {
            TransparentPanel panel = new TransparentPanel((LayoutManager)new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            topComponent = panel;
        }
        return topComponent;
    }

    public void dispose() {
        this.callContainer.removePropertyChangeListener("fullScreen", this);
        if (this.peerPanel != null) {
            this.peerPanel.dispose();
        }
    }

    @Override
    public CallPanel getCallContainer() {
        return this.callContainer;
    }

    public CallPeer getCallPeer() {
        return this.callPeer;
    }

    public SwingCallPeerRenderer getCallPeerRenderer(CallPeer callPeer) {
        return this.callPeer.equals(callPeer) ? this.peerPanel : null;
    }

    private String getPeerDisplayText(CallPeer peer, String displayName) {
        String peerAddress = peer.getAddress();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            return peerAddress;
        }
        if (!displayName.equalsIgnoreCase(peerAddress)) {
            return displayName + " (" + peerAddress + ")";
        }
        return displayName;
    }

    boolean isFullScreen() {
        return this.callContainer.isFullScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if ("fullScreen".equals(propertyName) && this.callContainer.equals(ev.getSource())) {
            try {
                boolean fullScreen = this.isFullScreen();
                if (this.topBar != null) {
                    this.topBar.setVisible(!fullScreen);
                }
                if (OSUtils.IS_MAC && this.peerPanel != null) {
                    this.peerPanel.setOpaque(!fullScreen);
                }
            }
            finally {
                this.firePropertyChange(propertyName, ev.getOldValue(), ev.getNewValue());
            }
        }
    }

    public void removeDesktopSharingComponents() {
        if (this.southPanel != null) {
            this.remove(this.southPanel);
            this.enableDesktopRemoteControl.setSelected(false);
        }
        this.revalidate();
        this.repaint();
    }

    public void setPeerName(String name) {
        this.nameLabel.setText(this.getPeerDisplayText(this.callPeer, name));
    }

    public void startCallTimer() {
        this.callContainer.startCallTimer();
    }

    public void stopCallTimer() {
        this.callContainer.stopCallTimer();
    }

    public boolean isCallTimerStarted() {
        return this.callContainer.isCallTimerStarted();
    }

    public void updateHoldButtonState() {
        this.callContainer.updateHoldButtonState();
    }
}

