/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CloseLocalVisualComponentButton;
import net.java.sip.communicator.impl.gui.main.call.DesktopSharingMouseAndKeyboardListener;
import net.java.sip.communicator.impl.gui.main.call.InputVolumeControlButton;
import net.java.sip.communicator.impl.gui.main.call.OneToOneCallPanel;
import net.java.sip.communicator.impl.gui.main.call.OutputVolumeControlButton;
import net.java.sip.communicator.impl.gui.main.call.ParanoiaTimerSecurityPanel;
import net.java.sip.communicator.impl.gui.main.call.SecurityPanel;
import net.java.sip.communicator.impl.gui.main.call.SecurityStatusLabel;
import net.java.sip.communicator.impl.gui.main.call.SwingCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.UIVideoHandler2;
import net.java.sip.communicator.impl.gui.main.call.ZrtpSecurityPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SoundLevelIndicator;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.call.CallPeerRenderer;
import net.java.sip.communicator.service.gui.call.CallRenderer;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityStatusEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.call.CallPeerAdapter;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.util.swing.VideoContainer;

public class OneToOneCallPeerPanel
extends TransparentPanel
implements SwingCallPeerRenderer,
PropertyChangeListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(OneToOneCallPeerPanel.class);
    private static final long serialVersionUID = 0L;
    public static final String HIDE_PLACEHOLDER_PIC_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_PLACEHOLDER_PIC";
    private final CallPeer callPeer;
    private final Call call;
    private final CallPeerAdapter callPeerAdapter;
    private final SwingCallRenderer callRenderer;
    private final JLabel callStatusLabel = new JLabel();
    private final VideoContainer center;
    private Component closeLocalVisualComponentButton;
    private final DesktopSharingMouseAndKeyboardListener desktopSharingMouseAndKeyboardListener;
    private boolean disposed = false;
    private final JLabel dtmfLabel = new JLabel();
    private JTextComponent errorMessageComponent;
    private final JLabel holdStatusLabel = new JLabel();
    private InputVolumeControlButton localLevel;
    private Component localVideo;
    private final JLabel muteStatusLabel = new JLabel();
    private ImageIcon peerImage;
    private String peerName;
    private final JLabel photoLabel;
    private DisplayNameAndImageChangeListener detailsChangeListener = null;
    private Component remoteLevel;
    private Component remoteVideo;
    private ImageID securityImageID = ImageLoader.SECURE_BUTTON_OFF;
    private SecurityPanel<?> securityPanel;
    private final SecurityStatusLabel securityStatusLabel = new SecurityStatusLabel();
    private final Component statusBar;
    private final UIVideoHandler2 uiVideoHandler;
    private boolean dtmfEnabled = true;
    private final Observer uiVideoHandlerObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            OneToOneCallPeerPanel.this.updateViewFromModel();
        }
    };
    private final Runnable updateViewFromModelInEventDispatchThread = new Runnable(){

        @Override
        public void run() {
            if (!OneToOneCallPeerPanel.this.disposed) {
                OneToOneCallPeerPanel.this.updateViewFromModelInEventDispatchThread();
            }
        }
    };

    public OneToOneCallPeerPanel(SwingCallRenderer callRenderer, CallPeer callPeer, UIVideoHandler2 uiVideoHandler) {
        OperationSetDesktopSharingClient desktopSharingClient;
        this.callRenderer = callRenderer;
        this.callPeer = callPeer;
        this.call = callPeer.getCall();
        this.uiVideoHandler = uiVideoHandler;
        this.detailsChangeListener = new DisplayNameAndImageChangeListener();
        this.peerName = CallManager.getPeerDisplayName(callPeer, this.detailsChangeListener);
        this.securityPanel = SecurityPanel.create(this, callPeer, null);
        ImageIcon icon = this.getPhotoLabelIcon();
        this.photoLabel = icon != null ? new JLabel(icon) : new JLabel();
        this.center = this.createCenter();
        this.statusBar = this.createStatusBar();
        this.setPeerImage(CallManager.getPeerImage(callPeer));
        this.setLayout(new GridBagLayout());
        GridBagConstraints cnstrnts = new GridBagConstraints();
        if (this.center != null) {
            cnstrnts.fill = 1;
            cnstrnts.gridx = 0;
            cnstrnts.gridy = 1;
            cnstrnts.weightx = 1.0;
            cnstrnts.weighty = 1.0;
            this.add((Component)this.center, cnstrnts);
        }
        if (this.statusBar != null) {
            cnstrnts.fill = 0;
            cnstrnts.gridx = 0;
            cnstrnts.gridy = 3;
            cnstrnts.weightx = 0.0;
            cnstrnts.weighty = 0.0;
            cnstrnts.insets = new Insets(5, 0, 0, 0);
            this.add(this.statusBar, cnstrnts);
        }
        this.createSoundLevelIndicators();
        this.initSecuritySettings();
        this.callPeerAdapter = new CallPeerAdapter(callPeer, (CallPeerRenderer)this);
        uiVideoHandler.addObserver(this.uiVideoHandlerObserver);
        if (callRenderer instanceof Component) {
            ((Component)((Object)callRenderer)).addPropertyChangeListener("fullScreen", this);
        }
        this.desktopSharingMouseAndKeyboardListener = (desktopSharingClient = (OperationSetDesktopSharingClient)callPeer.getProtocolProvider().getOperationSet(OperationSetDesktopSharingClient.class)) != null ? new DesktopSharingMouseAndKeyboardListener(callPeer, desktopSharingClient, this) : null;
        this.updateViewFromModel();
    }

    private void sizePhotoLabel() {
        if (this.photoLabel.getIcon() != null) {
            this.photoLabel.setPreferredSize(new Dimension(90, 90));
        } else {
            this.photoLabel.setPreferredSize(new Dimension(0, 0));
        }
    }

    private VideoContainer createCenter() {
        this.sizePhotoLabel();
        return this.createVideoContainer(this.photoLabel);
    }

    private void createSoundLevelIndicators() {
        TransparentPanel localLevelPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 0));
        TransparentPanel remoteLevelPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 0));
        this.localLevel = new InputVolumeControlButton(this.call.getConference(), ImageLoader.MICROPHONE, ImageLoader.MUTE_BUTTON, false, false);
        this.remoteLevel = new OutputVolumeControlButton(this.call.getConference(), ImageLoader.HEADPHONE, false, false).getComponent();
        final SoundLevelIndicator localLevelIndicator = new SoundLevelIndicator(0, 127);
        final SoundLevelIndicator remoteLevelIndicator = new SoundLevelIndicator(0, 127);
        localLevelPanel.add((Component)((Object)this.localLevel), (Object)"West");
        localLevelPanel.add((Component)localLevelIndicator, (Object)"Center");
        remoteLevelPanel.add(this.remoteLevel, (Object)"West");
        remoteLevelPanel.add((Component)remoteLevelIndicator, (Object)"Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)localLevelPanel, constraints);
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 0, 10, 0);
        this.add((Component)remoteLevelPanel, constraints);
        if (!GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.call.DISABLE_SOUND_LEVEL_INDICATORS", false)) {
            this.callPeer.addStreamSoundLevelListener(new SoundLevelListener(){

                public void soundLevelChanged(Object source, int level) {
                    remoteLevelIndicator.updateSoundLevel(level);
                }
            });
            if (this.call != null) {
                this.call.addLocalUserSoundLevelListener(new SoundLevelListener(){

                    public void soundLevelChanged(Object source, int level) {
                        localLevelIndicator.updateSoundLevel(level);
                    }
                });
            }
        }
    }

    private Component createStatusBar() {
        this.callStatusLabel.setForeground(Color.WHITE);
        this.dtmfLabel.setForeground(Color.WHITE);
        this.callStatusLabel.setText(this.callPeer.getState().getLocalizedStateString());
        PeerStatusPanel statusPanel = new PeerStatusPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        statusPanel.add(this.securityStatusLabel, constraints);
        this.initSecurityStatusLabel();
        ++constraints.gridx;
        statusPanel.add(this.holdStatusLabel, constraints);
        ++constraints.gridx;
        statusPanel.add(this.muteStatusLabel, constraints);
        ++constraints.gridx;
        this.callStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 12));
        statusPanel.add(this.callStatusLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        statusPanel.add(this.dtmfLabel, constraints);
        return statusPanel;
    }

    private VideoContainer createVideoContainer(Component noVideoComponent) {
        Container oldParent = noVideoComponent.getParent();
        if (oldParent != null) {
            oldParent.remove(noVideoComponent);
        }
        return new VideoContainer(noVideoComponent, false);
    }

    public void dispose() {
        this.disposed = true;
        if (this.detailsChangeListener != null) {
            this.detailsChangeListener.setInterested(false);
        }
        this.callPeerAdapter.dispose();
        this.uiVideoHandler.deleteObserver(this.uiVideoHandlerObserver);
        if (this.callRenderer instanceof Component) {
            ((Component)((Object)this.callRenderer)).removePropertyChangeListener("fullScreen", this);
        }
    }

    @Override
    public CallPanel getCallPanel() {
        return this.callRenderer.getCallContainer();
    }

    public CallRenderer getCallRenderer() {
        return this.callRenderer;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public String getPeerName() {
        return this.peerName;
    }

    private boolean isComponentEnabled(String componentHidePropertyName) {
        return !GuiActivator.getConfigurationService().getBoolean(componentHidePropertyName, false);
    }

    private ImageIcon getPhotoLabelIcon() {
        return this.peerImage == null && this.isComponentEnabled(HIDE_PLACEHOLDER_PIC_PROP) ? new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO)) : this.peerImage;
    }

    private void initSecuritySettings() {
        CallPeerSecurityStatusEvent securityEvent = this.callPeer.getCurrentSecuritySettings();
        if (securityEvent instanceof CallPeerSecurityOnEvent) {
            this.securityOn((CallPeerSecurityOnEvent)securityEvent);
        }
    }

    private void initSecurityStatusLabel() {
        this.securityStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.securityStatusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object ctrl = OneToOneCallPeerPanel.this.securityPanel.getSecurityControl();
                if (ctrl instanceof ZrtpControl && ctrl.getSecureCommunicationStatus()) {
                    OneToOneCallPeerPanel.this.setSecurityPanelVisible(!OneToOneCallPeerPanel.this.callRenderer.getCallContainer().getCallWindow().getFrame().getGlassPane().isVisible());
                }
            }
        });
    }

    public boolean isLocalVideoVisible() {
        return this.uiVideoHandler.isLocalVideoVisible();
    }

    public void loadSkin() {
        if (this.localLevel != null) {
            this.localLevel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.MICROPHONE)));
        }
        if (this.remoteLevel != null && this.remoteLevel instanceof Skinnable) {
            ((Skinnable)this.remoteLevel).loadSkin();
        }
        if (this.muteStatusLabel.getIcon() != null) {
            this.muteStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.MUTE_STATUS_ICON)));
        }
        if (this.holdStatusLabel.getIcon() != null) {
            this.holdStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HOLD_STATUS_ICON)));
        }
        this.securityStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(this.securityImageID)));
        if (this.peerImage == null) {
            if (this.isComponentEnabled(HIDE_PLACEHOLDER_PIC_PROP)) {
                this.photoLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO)));
            } else {
                this.photoLabel.setIcon(null);
            }
            this.sizePhotoLabel();
        }
    }

    public void printDTMFTone(char dtmfChar) {
        this.dtmfLabel.setText(this.dtmfLabel.getText() + dtmfChar);
        if (this.dtmfLabel.getBorder() == null) {
            this.dtmfLabel.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 5));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("fullScreen".equals(ev.getPropertyName())) {
            this.updateViewFromModel();
        }
    }

    private void redispatchMouseEvent(Component glassPane, MouseEvent e) {
        Point componentPoint;
        Object component;
        Point glassPanePoint = e.getPoint();
        Point securityPanelPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, this.securityPanel);
        if (securityPanelPoint.y > 0) {
            component = this.securityPanel;
            componentPoint = securityPanelPoint;
        } else {
            Container contentPane = this.callRenderer.getCallContainer().getCallWindow().getFrame().getContentPane();
            Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, contentPane);
            component = SwingUtilities.getDeepestComponentAt(contentPane, containerPoint.x, containerPoint.y);
            componentPoint = SwingUtilities.convertPoint(contentPane, glassPanePoint, component);
        }
        if (component != null) {
            ((Component)component).dispatchEvent(new MouseEvent((Component)component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
        e.consume();
    }

    public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent evt) {
        if (Boolean.parseBoolean(GuiActivator.getResources().getSettingsString("impl.gui.PARANOIA_UI"))) {
            SrtpControl srtpControl = null;
            if (this.callPeer instanceof MediaAwareCallPeer) {
                srtpControl = evt.getSecurityController();
            }
            this.securityPanel = new ParanoiaTimerSecurityPanel<SrtpControl>(srtpControl);
            this.setSecurityPanelVisible(true);
        }
    }

    public void securityOff(final CallPeerSecurityOffEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.securityOff(evt);
                }
            });
            return;
        }
        if (evt.getSessionType() == 1) {
            this.securityStatusLabel.setText("");
            this.securityStatusLabel.setSecurityOff();
            if (this.securityStatusLabel.getBorder() == null) {
                this.securityStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 3));
            }
        }
        this.securityPanel.securityOff(evt);
    }

    public void securityOn(final CallPeerSecurityOnEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.securityOn(evt);
                }
            });
            return;
        }
        if (evt == null) {
            this.securityStatusLabel.setSecurityOn();
            return;
        }
        SrtpControl srtpControl = evt.getSecurityController();
        if (!srtpControl.requiresSecureSignalingTransport() || this.callPeer.getProtocolProvider().isSignalingTransportSecure()) {
            if (srtpControl instanceof ZrtpControl) {
                this.securityStatusLabel.setText("zrtp");
                if (!((ZrtpControl)srtpControl).isSecurityVerified()) {
                    this.securityStatusLabel.setSecurityPending();
                } else {
                    this.securityStatusLabel.setSecurityOn();
                }
            } else {
                this.securityStatusLabel.setSecurityOn();
            }
        }
        if (!srtpControl.getClass().isInstance(this.securityPanel.getSecurityControl()) || this.securityPanel instanceof ParanoiaTimerSecurityPanel) {
            this.setSecurityPanelVisible(false);
            this.securityPanel = SecurityPanel.create(this, this.callPeer, srtpControl);
            if (srtpControl instanceof ZrtpControl) {
                ((ZrtpSecurityPanel)this.securityPanel).setSecurityStatusLabel(this.securityStatusLabel);
            }
        }
        this.securityPanel.securityOn(evt);
        boolean isSecurityLowPriority = Boolean.parseBoolean(GuiActivator.getResources().getSettingsString("impl.gui.I_DONT_CARE_THAT_MUCH_ABOUT_SECURITY"));
        if (srtpControl instanceof ZrtpControl && !isSecurityLowPriority && (!((ZrtpControl)srtpControl).isSecurityVerified() || ((ZrtpSecurityPanel)this.securityPanel).isZidAorMismatch())) {
            this.setSecurityPanelVisible(true);
        }
        this.revalidate();
    }

    public void securityPending() {
        this.securityStatusLabel.setSecurityPending();
    }

    public void securityTimeout(final CallPeerSecurityTimeoutEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.securityTimeout(evt);
                }
            });
            return;
        }
        if (this.securityPanel != null) {
            this.securityPanel.securityTimeout(evt);
        }
    }

    public void setErrorReason(final String reason) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setErrorReason(reason);
                }
            });
            return;
        }
        if (this.errorMessageComponent == null) {
            this.errorMessageComponent = new JTextPane();
            JTextPane textPane = (JTextPane)this.errorMessageComponent;
            textPane.setEditable(false);
            textPane.setOpaque(false);
            StyledDocument doc = textPane.getStyledDocument();
            SimpleAttributeSet standard = new SimpleAttributeSet();
            StyleConstants.setAlignment(standard, 1);
            StyleConstants.setFontFamily(standard, textPane.getFont().getFamily());
            StyleConstants.setFontSize(standard, 12);
            doc.setParagraphAttributes(0, 0, standard, true);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add(this.errorMessageComponent, constraints);
            this.revalidate();
        }
        this.errorMessageComponent.setText(reason);
        if (this.isVisible()) {
            this.errorMessageComponent.repaint();
        }
    }

    public void setLocalVideoVisible(boolean visible) {
        this.uiVideoHandler.setLocalVideoVisible(visible);
    }

    public void setMute(final boolean isMute) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setMute(isMute);
                }
            });
            return;
        }
        if (isMute) {
            this.muteStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.MUTE_STATUS_ICON)));
            this.muteStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        } else {
            this.muteStatusLabel.setIcon(null);
            this.muteStatusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        if (this.localLevel.isSelected() != isMute) {
            this.localLevel.setSelected(isMute);
        }
        this.revalidate();
        this.repaint();
    }

    public void setOnHold(final boolean isOnHold) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setOnHold(isOnHold);
                }
            });
            return;
        }
        if (isOnHold) {
            this.holdStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HOLD_STATUS_ICON)));
            this.holdStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        } else {
            this.holdStatusLabel.setIcon(null);
            this.holdStatusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    public void setPeerImage(byte[] image) {
        if (image != null && image.length > 0) {
            this.peerImage = ImageUtils.getScaledRoundedIcon((byte[])image, (int)100, (int)100);
            if (this.peerImage == null) {
                this.peerImage = this.getPhotoLabelIcon();
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OneToOneCallPeerPanel.this.photoLabel.setIcon(OneToOneCallPeerPanel.this.peerImage);
                        OneToOneCallPeerPanel.this.sizePhotoLabel();
                        OneToOneCallPeerPanel.this.photoLabel.repaint();
                    }
                });
            } else {
                this.photoLabel.setIcon(this.peerImage);
                this.sizePhotoLabel();
                this.photoLabel.repaint();
            }
        }
    }

    public void setPeerName(final String name) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setPeerName(name);
                }
            });
            return;
        }
        this.peerName = name;
        ((OneToOneCallPanel)this.callRenderer).setPeerName(name);
    }

    public void setPeerState(final CallPeerState oldState, final CallPeerState newState, final String stateString) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setPeerState(oldState, newState, stateString);
                }
            });
            return;
        }
        this.callStatusLabel.setText(stateString);
        if (newState == CallPeerState.CONNECTED && !CallPeerState.isOnHold((CallPeerState)oldState) && !this.securityStatusLabel.isSecurityStatusSet()) {
            this.securityStatusLabel.setSecurityOff();
        }
    }

    public void setSecurityPanelVisible(final boolean isVisible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OneToOneCallPeerPanel.this.setSecurityPanelVisible(isVisible);
                }
            });
            return;
        }
        final JFrame callFrame = this.callRenderer.getCallContainer().getCallWindow().getFrame();
        final JPanel glassPane = (JPanel)callFrame.getGlassPane();
        if (!isVisible) {
            this.securityPanel.setVisible(false);
            glassPane.setVisible(false);
            glassPane.removeAll();
        } else {
            glassPane.setLayout(null);
            glassPane.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OneToOneCallPeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    OneToOneCallPeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    OneToOneCallPeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    OneToOneCallPeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    OneToOneCallPeerPanel.this.redispatchMouseEvent(glassPane, e);
                }
            });
            Point securityLabelPoint = this.securityStatusLabel.getLocation();
            Point newPoint = SwingUtilities.convertPoint(this.securityStatusLabel.getParent(), securityLabelPoint.x, securityLabelPoint.y, callFrame);
            this.securityPanel.setBeginPoint(new Point((int)newPoint.getX() + 15, 0));
            this.securityPanel.setBounds(0, (int)newPoint.getY() - 5, this.getWidth(), 130);
            glassPane.add((Component)((Object)this.securityPanel));
            this.securityPanel.setVisible(true);
            glassPane.setVisible(true);
            glassPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (glassPane.isVisible()) {
                        glassPane.setVisible(false);
                        callFrame.removeComponentListener(this);
                    }
                }
            });
        }
    }

    private void updateViewFromModel() {
        if (!this.disposed) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateViewFromModelInEventDispatchThread();
            } else {
                SwingUtilities.invokeLater(this.updateViewFromModelInEventDispatchThread);
            }
        }
    }

    private void updateViewFromModelInEventDispatchThread() {
        if (this.disposed) {
            return;
        }
        OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)this.callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
        Component remoteVideo = null;
        Component localVideo = null;
        if (videoTelephony != null) {
            boolean remoteVideoChanged;
            List remoteVideos = videoTelephony.getVisualComponents(this.callPeer);
            if (remoteVideos != null && !remoteVideos.isEmpty()) {
                remoteVideo = (Component)remoteVideos.get(0);
            }
            if (this.uiVideoHandler.isLocalVideoVisible()) {
                try {
                    localVideo = videoTelephony.getLocalVisualComponent(this.callPeer);
                }
                catch (OperationFailedException ofe) {
                    logger.warn((Object)"Failed to retrieve local video to be displayed.", (Throwable)ofe);
                }
            }
            boolean localVideoChanged = localVideo != this.localVideo || localVideo != null && !UIVideoHandler2.isAncestor((Container)this.center, localVideo);
            boolean bl = remoteVideoChanged = remoteVideo != this.remoteVideo || remoteVideo != null && !UIVideoHandler2.isAncestor((Container)this.center, remoteVideo);
            if (remoteVideoChanged) {
                if (this.desktopSharingMouseAndKeyboardListener != null) {
                    this.desktopSharingMouseAndKeyboardListener.setVideoComponent(remoteVideo);
                }
                CallPanel callPanel = this.callRenderer.getCallContainer();
                if (remoteVideo != null) {
                    callPanel.addRemoteVideoSpecificComponents(this.callPeer);
                } else {
                    callPanel.removeRemoteVideoSpecificComponents();
                }
            }
            if (localVideoChanged || remoteVideoChanged) {
                if (localVideoChanged && !remoteVideoChanged && localVideo == null) {
                    if (this.localVideo != null) {
                        this.center.remove(this.localVideo);
                        this.localVideo = null;
                        if (this.closeLocalVisualComponentButton != null) {
                            this.center.remove(this.closeLocalVisualComponentButton);
                        }
                    }
                } else {
                    this.center.removeAll();
                    this.localVideo = null;
                    this.remoteVideo = null;
                    if (localVideo != null) {
                        if (this.closeLocalVisualComponentButton == null) {
                            this.closeLocalVisualComponentButton = new CloseLocalVisualComponentButton(this.uiVideoHandler);
                        }
                        this.center.add(this.closeLocalVisualComponentButton, (Object)"CLOSE_LOCAL_BUTTON", -1);
                        this.center.add(localVideo, (Object)"LOCAL", -1);
                        this.localVideo = localVideo;
                    }
                    if (remoteVideo != null) {
                        this.center.add(remoteVideo, (Object)"CENTER_REMOTE", -1);
                        this.remoteVideo = remoteVideo;
                    }
                }
            }
        }
    }

    public void setDtmfToneEnabled(boolean enabled) {
        this.dtmfEnabled = enabled;
    }

    public boolean isDtmfToneEnabled() {
        return this.dtmfEnabled;
    }

    private class DisplayNameAndImageChangeListener
    implements CallManager.DetailsResolveListener {
        private boolean interested = true;

        private DisplayNameAndImageChangeListener() {
        }

        @Override
        public void displayNameUpdated(String displayName) {
            OneToOneCallPeerPanel.this.setPeerName(displayName);
        }

        @Override
        public void imageUpdated(byte[] image) {
            OneToOneCallPeerPanel.this.setPeerImage(image);
        }

        @Override
        public boolean isInterested() {
            return this.interested;
        }

        public void setInterested(boolean value) {
            this.interested = value;
        }
    }

    private static class PeerStatusPanel
    extends TransparentPanel {
        private static final long serialVersionUID = 0L;

        public PeerStatusPanel(LayoutManager layout) {
            super(layout);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                g.setColor(Color.DARK_GRAY);
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
            }
            finally {
                g.dispose();
            }
        }
    }
}

