/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.PreCallDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;

public class ReceivedCallDialog
extends PreCallDialog
implements ActionListener,
CallListener,
Skinnable {
    private final Call incomingCall;
    private List<DisplayNameAndImageChangeListener> detailsResolvers = new ArrayList<DisplayNameAndImageChangeListener>();

    public ReceivedCallDialog(Call call, boolean video, boolean existingCall, boolean desktopStreaming) {
        super(GuiActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME") + " " + (desktopStreaming ? GuiActivator.getResources().getI18NString("service.gui.INCOMING_SCREEN_SHARE_STATUS").toLowerCase() : GuiActivator.getResources().getI18NString("service.gui.INCOMING_CALL_STATUS").toLowerCase()), video, existingCall);
        this.incomingCall = call;
        OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
        basicTelephony.addCallListener((CallListener)this);
        this.initCallLabel(this.getCallLabels());
    }

    private void initCallLabel(JLabel[] callLabel) {
        Iterator peersIter = this.incomingCall.getCallPeers();
        String textAddress = "";
        String textAccount = "";
        ImageIcon imageIcon = ImageUtils.scaleIconWithinBounds((Image)ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO), (int)40, (int)45);
        Hashtable<CallPeer, String> peerNamesTable = new Hashtable<CallPeer, String>();
        while (peersIter.hasNext()) {
            CallPeer peer = (CallPeer)peersIter.next();
            String peerAddress = this.getPeerDisplayAddress(peer);
            textAccount = peer.getProtocolProvider().getAccountID().getDisplayName();
            DisplayNameAndImageChangeListener listener = new DisplayNameAndImageChangeListener(peer, peerNamesTable);
            this.detailsResolvers.add(listener);
            String displayName = CallManager.getPeerDisplayName(peer, listener);
            if (displayName != null) {
                peerNamesTable.put(peer, displayName);
            }
            if (StringUtils.isNotEmpty((CharSequence)peerAddress)) {
                textAddress = callLabel[2].getText() + this.trimPeerAddressToUsername(peerAddress);
            }
            if (peersIter.hasNext()) {
                textAddress = textAddress + ", ";
                continue;
            }
            byte[] image = CallManager.getPeerImage(peer);
            if (image == null || image.length <= 0) continue;
            imageIcon = ImageUtils.getScaledRoundedIcon((byte[])image, (int)50, (int)50);
        }
        this.updateTextDisplayName(peerNamesTable);
        callLabel[0].setIcon(imageIcon);
        callLabel[2].setText(textAddress);
        callLabel[2].setForeground(Color.GRAY);
        if (textAccount != null) {
            callLabel[3].setText(GuiActivator.getResources().getI18NString("service.gui.TO") + " " + textAccount);
        }
    }

    private void updateTextDisplayName(final Hashtable<CallPeer, String> peerNamesTable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceivedCallDialog.this.updateTextDisplayName(peerNamesTable);
                }
            });
            return;
        }
        boolean hasMorePeers = false;
        String textDisplayName = "";
        Iterator peersIter = this.incomingCall.getCallPeers();
        JLabel label = this.getCallLabels()[1];
        while (peersIter.hasNext()) {
            CallPeer peer = (CallPeer)peersIter.next();
            if (peersIter.hasNext()) {
                textDisplayName = label.getText() + peerNamesTable.get(peer) + ", ";
                hasMorePeers = true;
                continue;
            }
            textDisplayName = GuiActivator.getResources().getI18NString("service.gui.IS_CALLING", new String[]{peerNamesTable.get(peer)});
        }
        if (hasMorePeers) {
            textDisplayName = GuiActivator.getResources().getI18NString("service.gui.ARE_CALLING", new String[]{textDisplayName});
        }
        label.setText(textDisplayName);
    }

    public void callEnded(CallEvent event) {
        if (event.getSourceCall().equals((Object)this.incomingCall)) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        for (DisplayNameAndImageChangeListener listener : this.detailsResolvers) {
            listener.setInterested(false);
        }
        try {
            OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)this.incomingCall.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            basicTelephony.removeCallListener((CallListener)this);
        }
        finally {
            super.dispose();
        }
    }

    public void incomingCallReceived(CallEvent event) {
    }

    public void outgoingCallCreated(CallEvent event) {
    }

    @Override
    public void callButtonPressed() {
        CallManager.answerCall(this.incomingCall);
    }

    @Override
    public void mergeCallButtonPressed() {
        CallManager.answerCallInFirstExistingCall(this.incomingCall);
    }

    @Override
    public void videoCallButtonPressed() {
        CallManager.answerVideoCall(this.incomingCall);
    }

    @Override
    public void hangupButtonPressed() {
        CallManager.hangupCall(this.incomingCall);
    }

    private String getPeerDisplayAddress(CallPeer peer) {
        String peerAddress = peer.getAddress();
        if (StringUtils.isBlank((CharSequence)peerAddress)) {
            return null;
        }
        return peerAddress.equalsIgnoreCase(peer.getDisplayName()) ? null : peerAddress;
    }

    private String trimPeerAddressToUsername(String peerAddress) {
        if (ConfigurationUtils.isHideDomainInReceivedCallDialogEnabled() && peerAddress != null && !peerAddress.startsWith("@")) {
            return peerAddress.split("@")[0];
        }
        return peerAddress;
    }

    private class DisplayNameAndImageChangeListener
    implements CallManager.DetailsResolveListener {
        private CallPeer peer;
        private Hashtable<CallPeer, String> peerNamesTable;
        private boolean interested = true;

        private DisplayNameAndImageChangeListener(CallPeer peer, Hashtable<CallPeer, String> peerNamesTable) {
            this.peer = peer;
            this.peerNamesTable = peerNamesTable;
        }

        @Override
        public void displayNameUpdated(String displayName) {
            if (displayName != null) {
                this.peerNamesTable.put(this.peer, displayName);
                ReceivedCallDialog.this.updateTextDisplayName(this.peerNamesTable);
            }
        }

        @Override
        public void imageUpdated(byte[] image) {
            if (image != null) {
                ImageUtils.setScaledLabelImage((JLabel)ReceivedCallDialog.this.getCallLabels()[0], (byte[])image, (int)50, (int)50);
            }
        }

        @Override
        public boolean isInterested() {
            return this.interested;
        }

        public void setInterested(boolean value) {
            this.interested = value;
        }
    }
}

