/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import net.java.sip.communicator.service.contactsource.ContactChangedEvent;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactRemovedEvent;
import net.java.sip.communicator.service.contactsource.SourceContact;
import org.apache.commons.lang3.StringUtils;

public class ResolveAddressToDisplayNameContactQueryListener
implements ContactQueryListener {
    private ContactQuery query;
    private String resolvedName = null;
    private byte[] resolvedImage;

    public ResolveAddressToDisplayNameContactQueryListener(ContactQuery query) {
        this.query = query;
        if (this.query != null) {
            this.query.addContactQueryListener((ContactQueryListener)this);
        }
    }

    public void contactChanged(ContactChangedEvent event) {
    }

    public void contactReceived(ContactReceivedEvent event) {
        SourceContact contact = event.getContact();
        if (contact != null) {
            if (!this.isFoundName()) {
                this.resolvedName = contact.getDisplayName();
            }
            if (!this.isFoundImage()) {
                this.resolvedImage = contact.getImage();
            }
            if (this.isFoundName() && this.isFoundImage()) {
                this.stop();
            }
        }
    }

    public void contactRemoved(ContactRemovedEvent event) {
    }

    public void queryStatusChanged(ContactQueryStatusEvent event) {
        this.stop();
    }

    public boolean isRunning() {
        return this.query != null;
    }

    public synchronized void stop() {
        if (this.query != null) {
            this.query.removeContactQueryListener((ContactQueryListener)this);
            this.query.cancel();
            this.query = null;
        }
    }

    public boolean isFoundName() {
        return StringUtils.isNotEmpty((CharSequence)this.resolvedName);
    }

    public boolean isFoundImage() {
        return this.resolvedImage != null;
    }

    public String getResolvedName() {
        return this.resolvedName;
    }

    public byte[] getResolvedImage() {
        return this.resolvedImage;
    }
}

