/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.ConferenceCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferenceMemberPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferencePeerPanel;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityStatusEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelListener;
import net.java.sip.communicator.util.skin.Skinnable;

public class ConferenceFocusPanel
extends TransparentPanel
implements ConferenceCallPeerRenderer,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final BasicConferenceCallPanel callRenderer;
    private final Map<ConferenceMember, ConferenceMemberPanel> conferenceMemberPanels = new Hashtable<ConferenceMember, ConferenceMemberPanel>();
    private final GridBagConstraints cnstrnts;
    private final CallPeer focusPeer;
    private final FocusPeerListener focusPeerListener = new FocusPeerListener();
    private ConferencePeerPanel focusPeerPanel;
    private boolean dtmfEnabled = true;

    public ConferenceFocusPanel(BasicConferenceCallPanel callRenderer, CallPeer callPeer) {
        super((LayoutManager)new GridBagLayout());
        this.focusPeer = callPeer;
        this.callRenderer = callRenderer;
        this.cnstrnts = new GridBagConstraints();
        this.cnstrnts.fill = 1;
        this.cnstrnts.gridx = 0;
        this.cnstrnts.gridy = 0;
        this.cnstrnts.insets = new Insets(0, 0, 3, 0);
        this.cnstrnts.weightx = 1.0;
        this.cnstrnts.weighty = 0.0;
        this.addFocusPeerPanel();
        this.focusPeer.addCallPeerConferenceListener((CallPeerConferenceListener)this.focusPeerListener);
        if (ConferencePeerPanel.isSoundLevelIndicatorEnabled()) {
            this.focusPeer.addConferenceMembersSoundLevelListener((ConferenceMembersSoundLevelListener)this.focusPeerListener);
        }
        for (ConferenceMember conferenceMember : this.focusPeer.getConferenceMembers()) {
            this.addConferenceMemberPanel(conferenceMember);
        }
    }

    private void addConferenceMemberPanel(ConferenceMember conferenceMember) {
        if (CallManager.isLocalUser(conferenceMember)) {
            return;
        }
        if (CallManager.addressesAreEqual(conferenceMember.getAddress(), this.focusPeer.getAddress())) {
            return;
        }
        if (this.conferenceMemberPanels.containsKey(conferenceMember)) {
            return;
        }
        ConferenceMemberPanel conferenceMemberPanel = new ConferenceMemberPanel((SwingCallRenderer)this.callRenderer, conferenceMember, false);
        this.conferenceMemberPanels.put(conferenceMember, conferenceMemberPanel);
        this.add((Component)((Object)conferenceMemberPanel), this.cnstrnts);
        ++this.cnstrnts.gridy;
        this.initSecuritySettings();
        this.packWindow();
    }

    private void addFocusPeerPanel() {
        this.focusPeerPanel = new ConferencePeerPanel(this.callRenderer, this.focusPeer);
        this.add((Component)((Object)this.focusPeerPanel), this.cnstrnts);
        ++this.cnstrnts.gridy;
        this.packWindow();
    }

    private void packWindow() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (window != null) {
            window.pack();
        }
    }

    public void dispose() {
        this.focusPeer.removeCallPeerConferenceListener((CallPeerConferenceListener)this.focusPeerListener);
        this.focusPeer.removeConferenceMembersSoundLevelListener((ConferenceMembersSoundLevelListener)this.focusPeerListener);
        if (this.focusPeerPanel != null) {
            this.focusPeerPanel.dispose();
        }
        for (ConferenceMemberPanel conferenceMemberPanel : this.conferenceMemberPanels.values()) {
            conferenceMemberPanel.dispose();
        }
    }

    @Override
    public CallPanel getCallPanel() {
        return this.getCallRenderer().getCallContainer();
    }

    public SwingCallRenderer getCallRenderer() {
        return this.callRenderer;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void initSecuritySettings() {
        CallPeerSecurityStatusEvent securityEvent = this.focusPeer.getCurrentSecuritySettings();
        if (securityEvent instanceof CallPeerSecurityOnEvent) {
            this.securityOn((CallPeerSecurityOnEvent)securityEvent);
        }
    }

    public boolean isLocalVideoVisible() {
        return this.focusPeerPanel.isLocalVideoVisible();
    }

    public void loadSkin() {
    }

    protected void onCallPeerConferenceEvent(final CallPeerConferenceEvent ev) {
        switch (ev.getEventID()) {
            case 2: 
            case 3: {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.onCallPeerConferenceEventInEventDispatchThread(ev);
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConferenceFocusPanel.this.onCallPeerConferenceEventInEventDispatchThread(ev);
                    }
                });
                break;
            }
        }
    }

    protected void onCallPeerConferenceEventInEventDispatchThread(CallPeerConferenceEvent ev) {
        ConferenceMember conferenceMember = ev.getConferenceMember();
        switch (ev.getEventID()) {
            case 2: {
                this.addConferenceMemberPanel(conferenceMember);
                break;
            }
            case 3: {
                this.removeConferenceMemberPanel(conferenceMember);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            int height = this.getHeight();
            int width = this.getWidth();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, width, height);
            g.setColor(Color.DARK_GRAY);
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, height - 1, width, height - 1);
        }
        finally {
            g.dispose();
        }
    }

    public void printDTMFTone(char dtmfChar) {
        this.focusPeerPanel.printDTMFTone(dtmfChar);
    }

    private void removeConferenceMemberPanel(ConferenceMember conferenceMember) {
        ConferenceMemberPanel conferenceMemberPanel = this.conferenceMemberPanels.remove(conferenceMember);
        if (conferenceMemberPanel != null) {
            this.remove((Component)((Object)conferenceMemberPanel));
            conferenceMemberPanel.dispose();
            this.packWindow();
        }
    }

    public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent securityNegotiationStartedEvent) {
    }

    public void securityOff(CallPeerSecurityOffEvent evt) {
        this.focusPeerPanel.securityOff(evt);
        for (ConferenceMemberPanel member : this.conferenceMemberPanels.values()) {
            member.securityOff(evt);
        }
    }

    public void securityOn(CallPeerSecurityOnEvent evt) {
        this.focusPeerPanel.securityOn(evt);
        for (ConferenceMemberPanel member : this.conferenceMemberPanels.values()) {
            member.securityOn(evt);
        }
    }

    public void securityPending() {
        this.focusPeerPanel.securityPending();
    }

    public void securityTimeout(CallPeerSecurityTimeoutEvent evt) {
    }

    public void setErrorReason(String reason) {
        this.focusPeerPanel.setErrorReason(reason);
    }

    public void setLocalVideoVisible(boolean isVisible) {
        this.focusPeerPanel.setLocalVideoVisible(isVisible);
    }

    public void setMute(boolean isMute) {
        this.focusPeerPanel.setMute(isMute);
    }

    public void setOnHold(boolean isOnHold) {
        this.focusPeerPanel.setOnHold(isOnHold);
    }

    public void setPeerImage(byte[] image) {
        this.focusPeerPanel.setPeerImage(image);
    }

    public void setPeerName(String name) {
        this.focusPeerPanel.setPeerName(name);
    }

    public void setPeerState(CallPeerState oldState, CallPeerState newState, String stateString) {
        this.focusPeerPanel.setPeerState(oldState, newState, stateString);
    }

    public void setSecurityPanelVisible(boolean visible) {
    }

    public void enableVideoIndicator(ConferenceMember confMember, boolean enable) {
        if (!this.conferenceMemberPanels.containsKey(confMember)) {
            return;
        }
        ConferenceMemberPanel confMemberPanel = this.conferenceMemberPanels.get(confMember);
        confMemberPanel.enableVideoIndicator(enable);
    }

    public void enableVideoIndicator(boolean enable) {
        this.focusPeerPanel.enableVideoIndicator(enable);
    }

    public void setDtmfToneEnabled(boolean enabled) {
        this.dtmfEnabled = enabled;
    }

    public boolean isDtmfToneEnabled() {
        return this.dtmfEnabled;
    }

    private class FocusPeerListener
    extends CallPeerConferenceAdapter
    implements ConferenceMembersSoundLevelListener {
        private FocusPeerListener() {
        }

        protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
            ConferenceFocusPanel.this.onCallPeerConferenceEvent(ev);
        }

        public void soundLevelChanged(ConferenceMembersSoundLevelEvent ev) {
            Map levels = ev.getLevels();
            String address = ConferenceFocusPanel.this.focusPeerPanel.getCallPeerContactAddress();
            for (Map.Entry e : levels.entrySet()) {
                ConferenceMember key = (ConferenceMember)e.getKey();
                Integer value = (Integer)e.getValue();
                if (!CallManager.addressesAreEqual(key.getAddress(), address)) continue;
                ConferenceFocusPanel.this.focusPeerPanel.updateSoundBar(value);
                break;
            }
            for (Map.Entry entry : ConferenceFocusPanel.this.conferenceMemberPanels.entrySet()) {
                ConferenceMember member = (ConferenceMember)entry.getKey();
                Integer memberSoundLevel = (Integer)levels.get(member);
                ((ConferenceMemberPanel)entry.getValue()).updateSoundBar(memberSoundLevel == null ? 0 : memberSoundLevel);
            }
        }
    }
}

