/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.chat.ChatOperationReasonDialog;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatContactRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
Skinnable {
    private static final long serialVersionUID = -4069653895234333083L;
    private Logger logger = Logger.getLogger(ChatContactRightButtonMenu.class);
    private final JMenuItem kickItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.KICK"));
    private final JMenuItem banItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.BAN"));
    private final JMenuItem changeRoomSubjectItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CHANGE_ROOM_SUBJECT"));
    private final JMenuItem changeNicknameItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME"));
    private final JMenuItem grantOwnershipItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.GRANT_OWNERSHIP"));
    private final JMenuItem grantAdminItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.GRANT_ADMIN"));
    private final JMenuItem grantMembershipItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.GRANT_MEMBERSHIP"));
    private final JMenuItem grantModeratorItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.GRANT_MODERATOR"));
    private final JMenuItem grantVoiceItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.GRANT_VOICE"));
    private final JMenuItem revokeOwnershipItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REVOKE_OWNERSHIP"));
    private final JMenuItem revokeAdminItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REVOKE_ADMIN"));
    private final JMenuItem revokeMembershipItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REVOKE_MEMBERSHIP"));
    private final JMenuItem revokeModeratorItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REVOKE_MODERATOR"));
    private final JMenuItem revokeVoiceItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.REVOKE_VOICE"));
    private final JMenuItem sendPrivateMessageItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SEND_PRIVATE_MESSAGE"));
    private final ChatPanel chatPanel;
    private final ChatContact<?> chatContact;
    private ChatRoom room;

    public ChatContactRightButtonMenu(ChatPanel chatPanel, ChatContact<?> chatContact) {
        this.chatPanel = chatPanel;
        this.chatContact = chatContact;
        Object descriptor = chatPanel.getChatSession().getDescriptor();
        if (descriptor instanceof ChatRoomWrapper) {
            this.room = ((ChatRoomWrapper)descriptor).getChatRoom();
        }
        this.setLocation(this.getLocation());
        this.init();
    }

    private void init() {
        this.kickItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.KICK"));
        this.banItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.BAN"));
        this.grantAdminItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.GRANT_ADMIN"));
        this.grantMembershipItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.GRANT_MEMBERSHIP"));
        this.grantModeratorItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.GRANT_MODERATOR"));
        this.grantOwnershipItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.GRANT_OWNERSHIP"));
        this.grantVoiceItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.GRANT_VOICE"));
        this.revokeAdminItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REVOKE_ADMIN"));
        this.revokeMembershipItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REVOKE_MEMBERSHIP"));
        this.revokeModeratorItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REVOKE_MODERATOR"));
        this.revokeOwnershipItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REVOKE_OWNERSHIP"));
        this.revokeVoiceItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REVOKE_VOICE"));
        this.changeNicknameItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CHANGE_NICKNAME"));
        this.changeRoomSubjectItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CHANGE_ROOM_SUBJECT"));
        this.sendPrivateMessageItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEND_PRIVATE_MESSAGE"));
        this.kickItem.addActionListener(this);
        this.banItem.addActionListener(this);
        this.changeNicknameItem.addActionListener(this);
        this.changeRoomSubjectItem.addActionListener(this);
        this.grantAdminItem.addActionListener(this);
        this.grantMembershipItem.addActionListener(this);
        this.grantModeratorItem.addActionListener(this);
        this.grantOwnershipItem.addActionListener(this);
        this.grantVoiceItem.addActionListener(this);
        this.revokeAdminItem.addActionListener(this);
        this.revokeMembershipItem.addActionListener(this);
        this.revokeModeratorItem.addActionListener(this);
        this.revokeOwnershipItem.addActionListener(this);
        this.revokeVoiceItem.addActionListener(this);
        this.sendPrivateMessageItem.addActionListener(this);
        this.kickItem.setName("kickItem");
        this.banItem.setName("banItem");
        this.changeNicknameItem.setName("changeNicknameItem");
        this.changeRoomSubjectItem.setName("changeRoomSubjectItem");
        this.grantAdminItem.setName("grantAdminItem");
        this.grantMembershipItem.setName("grantMembershipItem");
        this.grantModeratorItem.setName("grantModeratorItem");
        this.grantOwnershipItem.setName("grantOwnershipItem");
        this.grantVoiceItem.setName("grantVoiceItem");
        this.revokeAdminItem.setName("revokeAdminItem");
        this.revokeMembershipItem.setName("revokeMembershipItem");
        this.revokeModeratorItem.setName("revokeModeratorItem");
        this.revokeOwnershipItem.setName("revokeOwnershipItem");
        this.revokeVoiceItem.setName("revokeVoiceItem");
        this.sendPrivateMessageItem.setName("sendPrivateMessageItem");
        this.loadSkin();
        ChatRoomMemberRole role = this.chatContact.getName().equals(this.room.getUserNickname()) ? this.room.getUserRole() : ((ChatRoomMember)this.chatContact.getDescriptor()).getRole();
        int roleIndex = role.getRoleIndex();
        String roleName = role.getLocalizedRoleName();
        JLabel jl_username = new JLabel(" " + this.chatContact.getName() + " (" + GuiActivator.getResources().getI18NString(roleName) + ") ");
        jl_username.setFont(jl_username.getFont().deriveFont(1));
        this.add(jl_username);
        this.addSeparator();
        if (this.chatContact.getName().equals(this.room.getUserNickname())) {
            if (roleIndex >= 50) {
                this.add(this.changeRoomSubjectItem);
            }
            this.add(this.changeNicknameItem);
        } else {
            if (!ConfigurationUtils.isPrivateMessagingInChatRoomDisabled()) {
                this.add(this.sendPrivateMessageItem);
            }
            if (this.room.getUserRole().getRoleIndex() >= 50) {
                if (roleIndex <= 40) {
                    this.add(this.kickItem);
                    if (this.room.getUserRole().getRoleIndex() >= 60 && roleIndex < 50) {
                        this.add(this.banItem);
                    }
                    this.addSeparator();
                }
                if (roleIndex <= 20) {
                    this.add(this.grantVoiceItem);
                } else if (roleIndex == 40 || roleIndex == 30) {
                    this.add(this.revokeVoiceItem);
                }
            }
            if (this.room.getUserRole().getRoleIndex() >= 60) {
                if (roleIndex < 40) {
                    this.add(this.grantMembershipItem);
                }
                if (roleIndex < 50) {
                    this.add(this.grantModeratorItem);
                } else if (roleIndex == 50) {
                    this.add(this.revokeModeratorItem);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String menuItemName = ((JMenuItem)e.getSource()).getName();
        if (menuItemName.equals("kickItem")) {
            ChatOperationReasonDialog reasonDialog = new ChatOperationReasonDialog();
            int result = reasonDialog.showDialog();
            if (result == 0) {
                new KickParticipantThread(this.room, reasonDialog.getReason()).start();
            }
        } else if (menuItemName.equals("banItem")) {
            ChatOperationReasonDialog reasonDialog = new ChatOperationReasonDialog();
            int result = reasonDialog.showDialog();
            if (result == 0) {
                new BanParticipantThread(this.room, reasonDialog.getReason()).start();
            }
        } else if (menuItemName.equals("changeRoomSubjectItem")) {
            ChatOperationReasonDialog reasonDialog = new ChatOperationReasonDialog(this.chatPanel.getChatContainer().getFrame(), GuiActivator.getResources().getI18NString("service.gui.CHANGE_ROOM_SUBJECT"), GuiActivator.getResources().getI18NString("service.gui.CHANGE_ROOM_SUBJECT_LABEL"), "Ok", false);
            reasonDialog.setReasonFieldText(this.room.getSubject());
            int result = reasonDialog.showDialog();
            if (result == 0) {
                try {
                    this.room.setSubject(reasonDialog.getReason().trim());
                }
                catch (OperationFailedException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (menuItemName.equals("changeNicknameItem")) {
            ChatOperationReasonDialog reasonDialog = new ChatOperationReasonDialog(this.chatPanel.getChatContainer().getFrame(), GuiActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME"), GuiActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME_LABEL"), "Ok", false, true);
            reasonDialog.setIconImage((Image)ImageLoader.getImage(ImageLoader.CHANGE_NICKNAME_ICON));
            reasonDialog.setReasonFieldText(this.chatContact.getName());
            int result = reasonDialog.showDialog();
            if (result == 0) {
                String nickname = reasonDialog.getReason().trim();
                try {
                    this.room.setUserNickname(nickname);
                    ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)this.room.getParentProvider(), (String)this.room.getIdentifier(), (String)"userNickName", (String)nickname);
                }
                catch (OperationFailedException ex) {
                    String errorMessage = null;
                    errorMessage = ex.getErrorCode() == 10 ? GuiActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME_CONFLICT_ERROR") : ex.getLocalizedMessage();
                    this.chatPanel.addErrorMessage(nickname, GuiActivator.getResources().getI18NString("service.gui.CHANGE_NICKNAME_ERROR"), errorMessage);
                }
            }
        } else if (menuItemName.equals("grantVoiceItem")) {
            this.room.grantVoice(this.chatContact.getName());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.MEMBER);
        } else if (menuItemName.equals("grantMembershipItem")) {
            this.room.grantMembership(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.MEMBER);
        } else if (menuItemName.equals("grantModeratorItem")) {
            this.room.grantModerator(this.chatContact.getName());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.MODERATOR);
        } else if (menuItemName.equals("grantAdminItem")) {
            this.room.grantAdmin(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.ADMINISTRATOR);
        } else if (menuItemName.equals("grantOwnershipItem")) {
            this.room.grantOwnership(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.OWNER);
        } else if (menuItemName.equals("revokeOwnershipItem")) {
            this.room.revokeOwnership(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.ADMINISTRATOR);
        } else if (menuItemName.equals("revokeAdminItem")) {
            this.room.revokeAdmin(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.MEMBER);
        } else if (menuItemName.equals("revokeModeratorItem")) {
            this.room.revokeModerator(this.chatContact.getName());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.MEMBER);
        } else if (menuItemName.equals("revokeMembershipItem")) {
            this.room.revokeMembership(((ChatRoomMember)this.chatContact.getDescriptor()).getContactAddress());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.GUEST);
        } else if (menuItemName.equals("revokeVoiceItem")) {
            this.room.revokeVoice(this.chatContact.getName());
            ((ChatRoomMember)this.chatContact.getDescriptor()).setRole(ChatRoomMemberRole.SILENT_MEMBER);
        } else if (menuItemName.equals("sendPrivateMessageItem")) {
            ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
            chatWindowManager.openPrivateChatForChatRoomMember(this.room, this.chatContact.getName());
        }
    }

    public void loadSkin() {
        this.grantOwnershipItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_OWNER), (int)16, (int)16));
        this.grantAdminItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_ADMIN), (int)16, (int)16));
        this.grantMembershipItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_STANDARD), (int)16, (int)16));
        this.grantModeratorItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_MODERATOR), (int)16, (int)16));
        this.grantVoiceItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_STANDARD), (int)16, (int)16));
        this.revokeAdminItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_STANDARD), (int)16, (int)16));
        this.revokeMembershipItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_GUEST), (int)16, (int)16));
        this.revokeModeratorItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_STANDARD), (int)16, (int)16));
        this.revokeOwnershipItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHATROOM_MEMBER_ADMIN), (int)16, (int)16));
        this.revokeVoiceItem.setIcon(ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.CHAT_ROOM_REVOKE_VOICE), (int)16, (int)16));
        this.kickItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.KICK_ICON_16x16)));
        this.banItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.BAN_ICON_16x16)));
        this.changeNicknameItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CHANGE_NICKNAME_ICON_16x16)));
        this.changeRoomSubjectItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CHANGE_ROOM_SUBJECT_ICON_16x16)));
    }

    private class BanParticipantThread
    extends Thread {
        private final ChatRoom chatRoom;
        private final String reason;

        BanParticipantThread(ChatRoom chatRoom, String reason) {
            this.chatRoom = chatRoom;
            this.reason = reason;
        }

        @Override
        public void run() {
            try {
                this.chatRoom.banParticipant((ChatRoomMember)ChatContactRightButtonMenu.this.chatContact.getDescriptor(), this.reason);
            }
            catch (OperationFailedException e) {
                String errorMessageKey;
                ChatContactRightButtonMenu.this.logger.error((Object)"Failed to ban participant.", (Throwable)e);
                String errorTitle = GuiActivator.getResources().getI18NString("service.gui.BAN_FAILED");
                switch (e.getErrorCode()) {
                    case 12: {
                        errorMessageKey = "service.gui.BAN_FAILED_NOT_ENOUGH_PERMISSIONS";
                        break;
                    }
                    case 403: {
                        errorMessageKey = "service.gui.BAN_FAILED_NOT_ALLOWED";
                        break;
                    }
                    default: {
                        errorMessageKey = "service.gui.BAN_FAILED_GENERAL_ERROR";
                    }
                }
                new ErrorDialog(ChatContactRightButtonMenu.this.chatPanel.getChatContainer().getFrame(), errorTitle, GuiActivator.getResources().getI18NString(errorMessageKey, new String[]{ChatContactRightButtonMenu.this.chatContact.getName()}), (Throwable)e).showDialog();
            }
        }
    }

    private class KickParticipantThread
    extends Thread {
        private final ChatRoom chatRoom;
        private final String reason;

        KickParticipantThread(ChatRoom chatRoom, String reason) {
            this.chatRoom = chatRoom;
            this.reason = reason;
        }

        @Override
        public void run() {
            try {
                this.chatRoom.kickParticipant((ChatRoomMember)ChatContactRightButtonMenu.this.chatContact.getDescriptor(), this.reason);
            }
            catch (OperationFailedException e) {
                ChatContactRightButtonMenu.this.logger.error((Object)"Failed to kick participant.", (Throwable)e);
                if (e.getErrorCode() == 12) {
                    ErrorDialog errorDialog = new ErrorDialog(ChatContactRightButtonMenu.this.chatPanel.getChatContainer().getFrame(), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED"), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED_NOT_ENOUGH_PERMISSIONS", new String[]{ChatContactRightButtonMenu.this.chatContact.getName()}), (Throwable)e);
                    errorDialog.showDialog();
                }
                if (e.getErrorCode() == 403) {
                    new ErrorDialog(ChatContactRightButtonMenu.this.chatPanel.getChatContainer().getFrame(), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED"), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED_NOT_ALLOWED", new String[]{ChatContactRightButtonMenu.this.chatContact.getName()}), (Throwable)e).showDialog();
                }
                new ErrorDialog(ChatContactRightButtonMenu.this.chatPanel.getChatContainer().getFrame(), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED"), GuiActivator.getResources().getI18NString("service.gui.KICK_FAILED_GENERAL_ERROR", new String[]{ChatContactRightButtonMenu.this.chatContact.getName()}), (Throwable)e).showDialog();
            }
        }
    }
}

