/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.html.HTML;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.IncomingMessageStyle;
import net.java.sip.communicator.impl.gui.main.chat.OutgoingMessageStyle;
import net.java.sip.communicator.util.GuiUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class ChatHtmlUtils {
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DATE_ATTRIBUTE = "date";
    public static final String ORIGINAL_MESSAGE_ATTRIBUTE = "original_message";
    public static final String MESSAGE_HEADER_ID = "dateHeader";
    public static final String MESSAGE_TEXT_ID = "message";
    public static final String HTML_CONTENT_TYPE = "text/html";
    public static final String TEXT_CONTENT_TYPE = "text/plain";
    public static final String MSG_NAME_BACKGROUND = "#efefef";
    public static final String MSG_IN_NAME_FOREGROUND = "#488fe7";

    public static String createIncomingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory, boolean isSimpleTheme) {
        if (isSimpleTheme) {
            return ChatHtmlUtils.createSimpleIncomingMessageTag(messageID, contactName, contactDisplayName, avatarPath, date, message, contentType, isHistory);
        }
        return ChatHtmlUtils.createAdvancedIncomingMessageTag(messageID, contactName, contactDisplayName, avatarPath, date, message, contentType, isHistory);
    }

    public static String createOutgoingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory, boolean isSimpleTheme) {
        if (isSimpleTheme) {
            return ChatHtmlUtils.createSimpleOutgoingMessageTag(messageID, contactName, contactDisplayName, avatarPath, date, message, contentType, isHistory);
        }
        return ChatHtmlUtils.createAdvancedOutgoingMessageTag(messageID, contactName, contactDisplayName, avatarPath, date, message, contentType, isHistory);
    }

    public static String createMessageTag(String messageID, String contactName, String message, String contentType, Date date, boolean isEdited, boolean isHistory, boolean isSimpleTheme) {
        if (isSimpleTheme) {
            return ChatHtmlUtils.createSimpleMessageTag(messageID, contactName, message, contentType, date, isEdited, isHistory);
        }
        return ChatHtmlUtils.createAdvancedMessageTag(messageID, contactName, message, contentType, date, isEdited, isHistory);
    }

    private static String createSimpleIncomingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory) {
        StringBuilder headerBuffer = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        headerBuffer.append("<h2 id=\"").append(MESSAGE_HEADER_ID).append("\" ");
        headerBuffer.append(DATE_ATTRIBUTE).append("=\"").append(sdf.format(date)).append("\">");
        headerBuffer.append("<a style=\"color:");
        headerBuffer.append(MSG_IN_NAME_FOREGROUND).append(";");
        headerBuffer.append("font-weight:bold;");
        headerBuffer.append("text-decoration:none;\" ");
        headerBuffer.append("href=\"").append(contactName).append("\">");
        headerBuffer.append(contactDisplayName).append(ChatHtmlUtils.createEditedAtTag(messageID, -1L));
        headerBuffer.append("</a>");
        headerBuffer.append("</h2>");
        StringBuilder messageBuff = new StringBuilder();
        messageBuff.append("<table width=\"100%\" ");
        messageBuff.append(NAME_ATTRIBUTE).append("=\"").append(HTML.Tag.TABLE.toString()).append("\" id=\"messageHeader\" ");
        messageBuff.append("style=\"background-color:");
        messageBuff.append(MSG_NAME_BACKGROUND).append(";\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td align=\"left\" >");
        messageBuff.append(headerBuffer.toString());
        messageBuff.append("</td>");
        messageBuff.append("<td align=\"right\"><h2>");
        messageBuff.append(ChatHtmlUtils.getDateString(date)).append(GuiUtils.formatTime((Date)date));
        messageBuff.append("</h2></td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        messageBuff.append(ChatHtmlUtils.createSimpleMessageTag(messageID, contactName, message, contentType, date, false, isHistory));
        return messageBuff.toString();
    }

    private static String createSimpleOutgoingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory) {
        StringBuilder headerBuffer = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        headerBuffer.append("<h3 id=\"").append(MESSAGE_HEADER_ID).append("\" ");
        headerBuffer.append(DATE_ATTRIBUTE).append("=\"").append(sdf.format(date)).append("\">");
        headerBuffer.append("<a style=\"color:#535353;");
        headerBuffer.append("font-weight:bold;");
        headerBuffer.append("text-decoration:none;\" ");
        headerBuffer.append("href=\"").append(contactName).append("\">");
        headerBuffer.append(contactDisplayName).append(ChatHtmlUtils.createEditedAtTag(messageID, -1L));
        headerBuffer.append("</a>");
        headerBuffer.append("</h3>");
        StringBuffer messageBuff = new StringBuffer();
        messageBuff.append("<table width=\"100%\" ");
        messageBuff.append(NAME_ATTRIBUTE).append("=\"").append(HTML.Tag.TABLE.toString()).append("\" id=\"messageHeader\"");
        messageBuff.append("style=\"background-color:");
        messageBuff.append(MSG_NAME_BACKGROUND).append(";\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td align=\"left\" >");
        messageBuff.append(headerBuffer.toString());
        messageBuff.append("</td>");
        messageBuff.append("<td align=\"right\"><h3>");
        messageBuff.append(ChatHtmlUtils.getDateString(date)).append(GuiUtils.formatTime((Date)date));
        messageBuff.append("</h3></td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        messageBuff.append(ChatHtmlUtils.createSimpleMessageTag(messageID, contactName, message, contentType, date, false, isHistory));
        return messageBuff.toString();
    }

    private static String createAdvancedIncomingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory) {
        StringBuilder headerBuffer = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        headerBuffer.append("<h2 id=\"").append(MESSAGE_HEADER_ID).append("\" ");
        headerBuffer.append(DATE_ATTRIBUTE).append("='").append(sdf.format(date)).append("' ");
        headerBuffer.append(IncomingMessageStyle.createHeaderStyle()).append(">");
        headerBuffer.append("<a style=\"color:");
        headerBuffer.append(MSG_IN_NAME_FOREGROUND).append(";");
        headerBuffer.append("font-weight:bold;");
        headerBuffer.append("text-decoration:none;\" ");
        headerBuffer.append("href=\"").append(contactName).append("\">");
        headerBuffer.append(contactDisplayName).append(ChatHtmlUtils.createEditedAtTag(messageID, -1L));
        headerBuffer.append("</a></h2>");
        StringBuffer messageBuff = new StringBuffer();
        messageBuff.append("<table width=\"100%\" ");
        messageBuff.append(NAME_ATTRIBUTE).append("=\"").append(HTML.Tag.TABLE.toString()).append("\" id=\"messageHeader\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td valign=\"top\">");
        messageBuff.append("<table ").append(IncomingMessageStyle.createTableBubbleStyle()).append(" cellspacing=\"0px\" cellpadding=\"0px\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td style=\"width:26px;\"></td>");
        messageBuff.append("<td style=\"width:9px;\"></td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleTlStyle()).append(">");
        messageBuff.append(ChatHtmlUtils.createAdvancedMessageHeaderTag(headerBuffer.toString(), date));
        messageBuff.append("</td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleTrStyle()).append("></td>");
        messageBuff.append("</tr>");
        messageBuff.append("<tr>");
        messageBuff.append("<td><img src=\"").append(avatarPath).append("\" width=\"26px\" height=\"26px\"/> </td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createIndicatorStyle()).append("></td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleMessageStyle()).append(">");
        messageBuff.append(ChatHtmlUtils.createAdvancedMessageTag(messageID, contactName, message, contentType, date, false, isHistory));
        messageBuff.append("</td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleMessageRightStyle()).append("></td>");
        messageBuff.append("</tr>");
        messageBuff.append("<tr>");
        messageBuff.append("<td style=\"width:26px;\"></td>");
        messageBuff.append("<td style=\"width:9px;\"></td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleBlStyle()).append("></td>");
        messageBuff.append("<td ").append(IncomingMessageStyle.createTableBubbleBrStyle()).append("></td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        messageBuff.append("</td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        return messageBuff.toString();
    }

    private static String createAdvancedOutgoingMessageTag(String messageID, String contactName, String contactDisplayName, String avatarPath, Date date, String message, String contentType, boolean isHistory) {
        StringBuilder headerBuffer = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        headerBuffer.append("<h3 id=\"").append(MESSAGE_HEADER_ID).append("\" ");
        headerBuffer.append(DATE_ATTRIBUTE).append("='").append(sdf.format(date)).append("' ");
        headerBuffer.append(IncomingMessageStyle.createHeaderStyle()).append(">");
        headerBuffer.append("<a style=\"color:#6a6868;");
        headerBuffer.append("font-weight:bold;");
        headerBuffer.append("float:left;");
        headerBuffer.append("text-decoration:none;\" ");
        headerBuffer.append("href=\"").append(contactName).append("\">");
        headerBuffer.append(contactDisplayName).append(ChatHtmlUtils.createEditedAtTag(messageID, -1L));
        headerBuffer.append("</a></h3>");
        StringBuffer messageBuff = new StringBuffer();
        messageBuff.append("<table width=\"100%\" ");
        messageBuff.append(NAME_ATTRIBUTE).append("=\"").append(HTML.Tag.TABLE.toString()).append("\" id=\"messageHeader\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td valign=\"top\">");
        messageBuff.append("<table ").append(OutgoingMessageStyle.createTableBubbleStyle()).append(" cellspacing=\"0px\" cellpadding=\"0px\">");
        messageBuff.append("<tr>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleTlStyle()).append(">");
        messageBuff.append(ChatHtmlUtils.createAdvancedMessageHeaderTag(headerBuffer.toString(), date));
        messageBuff.append("</td>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleTrStyle()).append("></td>");
        messageBuff.append("<td style=\"width:9px;\"></td>");
        messageBuff.append("<td style=\"width:26px;\"></td>");
        messageBuff.append("</tr>");
        messageBuff.append("<tr>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleMessageStyle()).append(">");
        messageBuff.append(ChatHtmlUtils.createAdvancedMessageTag(messageID, contactName, message, contentType, date, false, isHistory));
        messageBuff.append("</td>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleMessageRightStyle()).append("></td>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createIndicatorStyle()).append("></td>");
        messageBuff.append("<td><div width=\"26px\" height=\"26px\"><img src=\"").append(avatarPath).append("\" width=\"26px\" height=\"26px\"/></div></td>");
        messageBuff.append("</tr>");
        messageBuff.append("<tr>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleBlStyle()).append("></td>");
        messageBuff.append("<td ").append(OutgoingMessageStyle.createTableBubbleBrStyle()).append("></td>");
        messageBuff.append("<td style=\"width:9px;\"></td>");
        messageBuff.append("<td style=\"width:26px;\"></td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        messageBuff.append("</td>");
        messageBuff.append("</tr>");
        messageBuff.append("</table>");
        return messageBuff.toString();
    }

    private static String createAdvancedMessageHeaderTag(String nameHeader, Date date) {
        StringBuilder messageHeader = new StringBuilder();
        messageHeader.append("<table width=\"100%\">");
        messageHeader.append("<tr>");
        messageHeader.append("<td nowrap=\"nowrap\">");
        messageHeader.append(nameHeader);
        messageHeader.append("</td>");
        messageHeader.append("<td nowrap=\"nowrap\" ").append(OutgoingMessageStyle.createDateStyle()).append(">");
        messageHeader.append(ChatHtmlUtils.getDateString(date));
        messageHeader.append(GuiUtils.formatTime((Date)date));
        messageHeader.append("</td>");
        messageHeader.append("</tr>");
        messageHeader.append("</table>");
        return messageHeader.toString();
    }

    public static String createEditedAtTag(String messageUID, long date) {
        StringBuilder res = new StringBuilder();
        res.append("<cite id=\"");
        res.append(messageUID);
        res.append("-editedAt\"> ");
        if (date > 0L) {
            res.append("&nbsp;");
            String contents = GuiActivator.getResources().getI18NString("service.gui.EDITED_AT", new String[]{GuiUtils.formatTime((long)date)});
            res.append(contents);
        }
        res.append("</cite>");
        return res.toString();
    }

    private static String createSimpleMessageTag(String messageID, String contactName, String message, String contentType, Date date, boolean isEdited, boolean isHistory) {
        StringBuilder messageTag = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        messageTag.append(String.format("<div id=\"%s\" %s=\"%s\" ", MESSAGE_TEXT_ID + messageID, NAME_ATTRIBUTE, contactName));
        messageTag.append(DATE_ATTRIBUTE).append("=\"").append(sdf.format(date)).append("\" ");
        messageTag.append(String.format("%s=\"%s\" ", ORIGINAL_MESSAGE_ATTRIBUTE, StringEscapeUtils.escapeXml((String)message)));
        messageTag.append(IncomingMessageStyle.createSingleMessageStyle(isHistory, isEdited, true));
        messageTag.append(">");
        if (HTML_CONTENT_TYPE.equalsIgnoreCase(contentType)) {
            messageTag.append(message);
        } else {
            messageTag.append(StringEscapeUtils.escapeHtml4((String)message));
        }
        if (isEdited) {
            messageTag.append("    ");
        }
        if (isEdited) {
            messageTag.append(ChatHtmlUtils.createEditedAt(date));
        }
        messageTag.append("</div>");
        return messageTag.toString();
    }

    private static String createAdvancedMessageTag(String messageID, String contactName, String message, String contentType, Date date, boolean isEdited, boolean isHistory) {
        StringBuilder messageTag = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        messageTag.append(String.format("<div id=\"%s\" %s=\"%s\" ", MESSAGE_TEXT_ID + messageID, NAME_ATTRIBUTE, contactName));
        messageTag.append(DATE_ATTRIBUTE).append("=\"").append(sdf.format(date)).append("\" ");
        messageTag.append(String.format("%s=\"%s\" ", ORIGINAL_MESSAGE_ATTRIBUTE, StringEscapeUtils.escapeXml((String)message)));
        messageTag.append(IncomingMessageStyle.createSingleMessageStyle(isHistory, isEdited, false));
        messageTag.append(">");
        if (HTML_CONTENT_TYPE.equalsIgnoreCase(contentType)) {
            messageTag.append(message);
        } else {
            messageTag.append(StringEscapeUtils.escapeHtml4((String)message));
        }
        if (isEdited) {
            messageTag.append("    ");
            messageTag.append(ChatHtmlUtils.createEditedAt(date));
        }
        messageTag.append("</div>");
        return messageTag.toString();
    }

    private static byte[] getMessageBytes(String message) {
        try {
            return message.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This should not happen since we hard-code the required character encoding.");
        }
    }

    public static String getDateString(Date date) {
        if (GuiUtils.compareDatesOnly((Date)date, (Date)new Date()) <= 0) {
            StringBuffer dateStrBuf = new StringBuffer();
            GuiUtils.formatDate((Date)date, (StringBuffer)dateStrBuf);
            dateStrBuf.append(" ");
            return dateStrBuf.toString();
        }
        return "";
    }

    private static String createEditedAt(Date date) {
        return "<font color=\"#b7b7b7\">(" + GuiActivator.getResources().getI18NString("service.gui.EDITED_AT", new String[]{GuiUtils.formatTime((Date)date)}) + ")</font>";
    }
}

