/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;

public class ChatTransportSelectorBox
extends SIPCommMenuBar
implements ActionListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(ChatTransportSelectorBox.class);
    private static final long serialVersionUID = 0L;
    private final Map<ChatTransport, JCheckBoxMenuItem> transportMenuItems = new Hashtable<ChatTransport, JCheckBoxMenuItem>();
    private final SIPCommMenu menu = new SelectorMenu();
    private final ChatSession chatSession;
    private final ChatPanel chatPanel;
    private ButtonGroup buttonGroup = new ButtonGroup();

    public ChatTransportSelectorBox(ChatPanel chatPanel, ChatSession chatSession, ChatTransport selectedChatTransport) {
        this.chatPanel = chatPanel;
        this.chatSession = chatSession;
        this.setPreferredSize(new Dimension(30, 28));
        this.setMaximumSize(new Dimension(30, 28));
        this.setMinimumSize(new Dimension(30, 28));
        this.menu.setPreferredSize(new Dimension(30, 45));
        this.menu.setMaximumSize(new Dimension(30, 45));
        this.add((JMenu)this.menu);
        this.setBorder(null);
        this.menu.setBorder(null);
        this.menu.setOpaque(false);
        this.setOpaque(false);
        this.menu.setEnabled(false);
        Iterator<ChatTransport> chatTransports = chatSession.getChatTransports();
        while (chatTransports.hasNext()) {
            this.addChatTransport(chatTransports.next());
        }
        if (this.menu.getItemCount() > 0) {
            if (selectedChatTransport != null && (selectedChatTransport.allowsInstantMessage() || selectedChatTransport.allowsSmsMessage())) {
                this.setSelected(selectedChatTransport);
            } else {
                this.setSelected(this.menu.getItem(0));
            }
        }
    }

    private void updateEnableStatus() {
        this.menu.setEnabled(this.menu.getItemCount() > 0);
    }

    public void addChatTransport(ChatTransport chatTransport) {
        if (chatTransport.allowsInstantMessage() || chatTransport.allowsSmsMessage()) {
            Image img = this.createTransportStatusImage(chatTransport);
            boolean isIndent = false;
            String toString = "";
            if (chatTransport.getResourceName() != null && chatTransport.isDisplayResourceOnly()) {
                toString = chatTransport.getResourceName();
                isIndent = true;
            } else {
                toString = "<b>" + chatTransport.getName() + "</b> " + (chatTransport.getResourceName() == null ? "" : chatTransport.getResourceName()) + " <i>(" + GuiActivator.getResources().getI18NString("service.gui.VIA") + ": " + chatTransport.getProtocolProvider().getAccountID().getDisplayName() + ")</i>";
            }
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("<html><font size=\"3\">" + toString + "</font></html>", new ImageIcon(img));
            if (isIndent) {
                menuItem.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            }
            menuItem.addActionListener(this);
            this.transportMenuItems.put(chatTransport, menuItem);
            this.buttonGroup.add(menuItem);
            this.menu.add((JMenuItem)menuItem);
            this.updateEnableStatus();
            this.updateTransportStatus(chatTransport);
        }
        if (!this.allowsInstantMessage() && this.allowsSmsMessage()) {
            this.chatPanel.getChatWritePanel().setSmsSelected(true);
        } else {
            this.chatPanel.getChatWritePanel().setSmsSelected(false);
        }
    }

    public void removeChatTransport(ChatTransport chatTransport) {
        JCheckBoxMenuItem menuItem = this.transportMenuItems.get(chatTransport);
        this.menu.remove((JMenuItem)menuItem);
        this.buttonGroup.remove(menuItem);
        this.transportMenuItems.remove(chatTransport);
        this.updateEnableStatus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
        for (Map.Entry<ChatTransport, JCheckBoxMenuItem> transportMenuItem : this.transportMenuItems.entrySet()) {
            ChatTransport chatTransport = transportMenuItem.getKey();
            if (!transportMenuItem.getValue().equals(menuItem)) continue;
            this.setSelected(menuItem, chatTransport, (ImageIcon)menuItem.getIcon());
            this.chatSession.getChatSessionRenderer().setChatIcon(new ImageIcon(Constants.getStatusIcon(chatTransport.getStatus())));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not find contact for menu item " + menuItem.getText() + ". contactsTable(" + this.transportMenuItems.size() + ") is : " + this.transportMenuItems));
        }
    }

    public Image createTransportStatusImage(ChatTransport chatTransport) {
        return ImageLoader.getIndexedProtocolImage(ImageUtils.getBytesInImage((byte[])chatTransport.getStatus().getStatusIcon()), chatTransport.getProtocolProvider());
    }

    public void updateTransportStatus(ChatTransport chatTransport) {
        JMenuItem menuItem;
        if (chatTransport.equals(this.chatSession.getCurrentChatTransport()) && !chatTransport.getStatus().isOnline()) {
            ChatTransport newChatTransport = this.getParentContactTransport(chatTransport);
            ChatTransport onlineTransport = this.getTransport(true);
            if (newChatTransport != null && newChatTransport.getStatus().isOnline()) {
                this.setSelected(newChatTransport);
            } else if (onlineTransport != null) {
                this.setSelected(onlineTransport);
            } else {
                ChatTransport offlineTransport = this.getTransport(false);
                if (offlineTransport != null) {
                    this.setSelected(offlineTransport);
                }
            }
        }
        if ((menuItem = (JMenuItem)this.transportMenuItems.get(chatTransport)) == null) {
            return;
        }
        ImageIcon icon = new ImageIcon(this.createTransportStatusImage(chatTransport));
        menuItem.setIcon(icon);
        if (this.menu.getSelectedObject() != null && this.menu.getSelectedObject().equals(chatTransport)) {
            this.menu.setIcon((Icon)icon);
            this.chatSession.fireCurrentChatTransportUpdated(1);
        }
    }

    private void setSelected(JCheckBoxMenuItem menuItem, ChatTransport chatTransport, ImageIcon icon) {
        menuItem.setSelected(true);
        this.chatSession.setCurrentChatTransport(chatTransport);
        SelectedObject selectedObject = new SelectedObject((Icon)icon, (Object)chatTransport);
        this.menu.setSelected(selectedObject);
        this.chatSession.fireCurrentChatTransportUpdated(1);
        String resourceName = chatTransport.getResourceName() != null ? " (" + chatTransport.getResourceName() + ")" : "";
        String displayName = !chatTransport.getDisplayName().equals(chatTransport.getName()) ? chatTransport.getDisplayName() + " (" + chatTransport.getName() + ")" : chatTransport.getDisplayName();
        String tooltipText = "<html><font size=\"3\"><b>" + displayName + "</b>" + resourceName + "<br/><i>" + GuiActivator.getResources().getI18NString("service.gui.VIA") + ": " + chatTransport.getProtocolProvider().getAccountID().getAccountAddress() + "</i></font></html>";
        this.menu.setToolTipText(tooltipText);
        this.chatPanel.getChatWritePanel().setSmsLabelVisible(chatTransport.allowsSmsMessage());
    }

    public void setSelected(ChatTransport chatTransport) {
        JCheckBoxMenuItem menuItem = this.transportMenuItems.get(chatTransport);
        if (menuItem == null) {
            return;
        }
        this.setSelected(menuItem, chatTransport, new ImageIcon(this.createTransportStatusImage(chatTransport)));
    }

    boolean hasSelectedTransport() {
        for (JCheckBoxMenuItem item : this.transportMenuItems.values()) {
            if (!item.isSelected()) continue;
            return true;
        }
        return false;
    }

    public SIPCommMenu getMenu() {
        return this.menu;
    }

    private ChatTransport getParentContactTransport(ChatTransport chatTransport) {
        for (ChatTransport comboChatTransport : this.transportMenuItems.keySet()) {
            if (!comboChatTransport.getDescriptor().equals(chatTransport.getDescriptor()) || !StringUtils.isEmpty((CharSequence)comboChatTransport.getResourceName())) continue;
            return comboChatTransport;
        }
        return null;
    }

    private ChatTransport getTransport(boolean online) {
        for (ChatTransport comboChatTransport : this.transportMenuItems.keySet()) {
            if (online && comboChatTransport.getStatus().isOnline()) {
                return comboChatTransport;
            }
            if (online || comboChatTransport.getStatus().isOnline()) continue;
            return comboChatTransport;
        }
        return null;
    }

    private boolean allowsInstantMessage() {
        for (ChatTransport tr : this.transportMenuItems.keySet()) {
            if (!tr.allowsInstantMessage()) continue;
            return true;
        }
        return false;
    }

    private boolean allowsSmsMessage() {
        for (ChatTransport tr : this.transportMenuItems.keySet()) {
            if (!tr.allowsSmsMessage()) continue;
            return true;
        }
        return false;
    }

    private class SelectorMenu
    extends SIPCommMenu {
        private static final long serialVersionUID = 0L;
        Image image = ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON);

        private SelectorMenu() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.image, this.getWidth() - this.image.getWidth((ImageObserver)((Object)this)) - 1, (this.getHeight() - this.image.getHeight((ImageObserver)((Object)this)) - 1) / 2, (ImageObserver)((Object)this));
        }
    }
}

