/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.SIPCommMsgTextArea;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindow;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomProviderWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chatroomslist.AdHocChatRoomList;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.event.ChatListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;
import org.jitsi.util.OSUtils;

public class ChatWindowManager {
    private static final Logger logger = Logger.getLogger(ChatWindowManager.class);
    private final List<ChatPanel> chatPanels = new ArrayList<ChatPanel>();
    private final List<ChatListener> chatListeners = new ArrayList<ChatListener>();
    private final Object chatSyncRoot = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChat(final ChatPanel chatPanel, final boolean setSelected) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWindowManager.this.openChat(chatPanel, setSelected);
                }
            });
            return;
        }
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatContainer chatContainer = chatPanel.getChatContainer();
            if (!chatPanel.isShown()) {
                chatContainer.addChat(chatPanel);
            }
            chatContainer.openChat(chatPanel, setSelected);
        }
    }

    public void openPrivateChatForChatRoomMember(final ChatRoom room, final String nickname) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWindowManager.this.openPrivateChatForChatRoomMember(room, nickname);
                }
            });
            return;
        }
        Contact sourceContact = room.getPrivateContactByNickname(nickname);
        this.openPrivateChatForChatRoomMember(room, sourceContact);
    }

    public void openPrivateChatForChatRoomMember(final ChatRoom room, final Contact sourceContact) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWindowManager.this.openPrivateChatForChatRoomMember(room, sourceContact);
                }
            });
            return;
        }
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(sourceContact);
        room.updatePrivateContactPresenceStatus(sourceContact);
        ChatPanel chatPanel = this.getContactChat(metaContact, sourceContact);
        chatPanel.setPrivateMessagingChat(true);
        this.openChat(chatPanel, true);
    }

    public boolean isChatOpenedFor(MetaContact metaContact) {
        return this.isChatOpenedForDescriptor(metaContact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isChatOpenedForDescriptor(Object descriptor) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatPanel chatPanel = this.findChatPanelForDescriptor(descriptor);
            return chatPanel != null && chatPanel.isShown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChat(final ChatPanel chatPanel) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatWindowManager.this.closeChat(chatPanel);
                }
            });
            return;
        }
        Object object = this.chatSyncRoot;
        synchronized (object) {
            if (this.containsChat(chatPanel)) {
                Date lastMsgTimestamp = chatPanel.getChatConversationPanel().getLastIncomingMsgTimestamp();
                if (!chatPanel.isWriteAreaEmpty()) {
                    int answer = ChatWindowManager.showWarningMessage("service.gui.NON_EMPTY_CHAT_WINDOW_CLOSE", (Component)((Object)chatPanel));
                    if (answer == 0) {
                        this.closeChatPanel(chatPanel);
                    }
                } else if (System.currentTimeMillis() - lastMsgTimestamp.getTime() < 2000L) {
                    int answer = ChatWindowManager.showWarningMessage("service.gui.CLOSE_CHAT_AFTER_NEW_MESSAGE", (Component)((Object)chatPanel));
                    if (answer == 0) {
                        this.closeChatPanel(chatPanel);
                    }
                } else if (chatPanel.containsActiveFileTransfers()) {
                    int answer = ChatWindowManager.showWarningMessage("service.gui.CLOSE_CHAT_ACTIVE_FILE_TRANSFER", (Component)((Object)chatPanel));
                    if (answer == 0) {
                        chatPanel.cancelActiveFileTransfers();
                        this.closeChatPanel(chatPanel);
                    }
                } else if (chatPanel.getChatSession() instanceof AdHocConferenceChatSession) {
                    AdHocConferenceChatSession adHocSession = (AdHocConferenceChatSession)chatPanel.getChatSession();
                    GuiActivator.getUIService().getConferenceChatManager().leaveChatRoom((AdHocChatRoomWrapper)adHocSession.getDescriptor());
                    this.closeChatPanel(chatPanel);
                } else {
                    this.closeChatPanel(chatPanel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllChats(ChatContainer chatContainer) {
        HashSet<ChatPanel> chatPanelsToClose = new HashSet<ChatPanel>();
        chatPanelsToClose.addAll(chatContainer.getChats());
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            chatPanelsToClose.addAll(this.chatPanels);
        }
        ChatPanel currentChat = chatContainer.getCurrentChat();
        for (ChatPanel chatPanel : chatPanelsToClose) {
            if (chatPanel == currentChat) continue;
            try {
                this.closeChatPanel(chatPanel);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to close chat: " + chatPanel), (Throwable)e);
            }
        }
        if (currentChat != null && this.chatPanels.contains(currentChat)) {
            this.closeChatPanel(currentChat);
        }
        if (chatContainer.getChatCount() <= 0) {
            GuiActivator.getContactList().deactivateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllChats(ChatContainer chatContainer, boolean warningEnabled) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            int answer;
            if (!warningEnabled) {
                this.closeAllChats(chatContainer);
                return;
            }
            ChatPanel activePanel = null;
            for (ChatPanel chatPanel : this.chatPanels) {
                if (chatPanel.getChatSession() instanceof AdHocConferenceChatSession) {
                    AdHocConferenceChatSession adHocSession = (AdHocConferenceChatSession)chatPanel.getChatSession();
                    GuiActivator.getUIService().getConferenceChatManager().leaveChatRoom((AdHocChatRoomWrapper)adHocSession.getDescriptor());
                }
                Date lastMsgTimestamp = chatPanel.getChatConversationPanel().getLastIncomingMsgTimestamp();
                if (chatPanel.isWriteAreaEmpty() && !chatPanel.containsActiveFileTransfers() && System.currentTimeMillis() - lastMsgTimestamp.getTime() >= 2000L) continue;
                activePanel = chatPanel;
            }
            if (activePanel == null) {
                this.closeAllChats(chatContainer);
                return;
            }
            Date lastMsgTimestamp = activePanel.getChatConversationPanel().getLastIncomingMsgTimestamp();
            if (!activePanel.isWriteAreaEmpty()) {
                int answer2 = ChatWindowManager.showWarningMessage("service.gui.NON_EMPTY_CHAT_WINDOW_CLOSE", chatContainer.getFrame());
                if (answer2 == 0) {
                    this.closeAllChats(chatContainer);
                }
            } else if (System.currentTimeMillis() - lastMsgTimestamp.getTime() < 2000L) {
                int answer3 = ChatWindowManager.showWarningMessage("service.gui.CLOSE_CHAT_AFTER_NEW_MESSAGE", chatContainer.getFrame());
                if (answer3 == 0) {
                    this.closeAllChats(chatContainer);
                }
            } else if (activePanel.containsActiveFileTransfers() && (answer = ChatWindowManager.showWarningMessage("service.gui.CLOSE_CHAT_ACTIVE_FILE_TRANSFER", chatContainer.getFrame())) == 0) {
                for (ChatPanel chatPanel : this.chatPanels) {
                    chatPanel.cancelActiveFileTransfers();
                }
                this.closeAllChats(chatContainer);
            }
        }
    }

    public ChatPanel getContactChat(MetaContact metaContact, boolean create) {
        if (!create) {
            return this.getContactChat(metaContact, null, null, false, null);
        }
        MetaContactChatCreateRunnable runnable = new MetaContactChatCreateRunnable(metaContact, null, null, null);
        return runnable.getChatPanel();
    }

    public ChatPanel getContactChat(MetaContact metaContact, boolean create, String escapedMessageID) {
        if (!create) {
            return this.getContactChat(metaContact, null, null, false, escapedMessageID);
        }
        MetaContactChatCreateRunnable runnable = new MetaContactChatCreateRunnable(metaContact, null, null, escapedMessageID);
        return runnable.getChatPanel();
    }

    public ChatPanel getContactChat(MetaContact metaContact, Contact protocolContact) {
        return this.getContactChat(metaContact, protocolContact, null, null);
    }

    public ChatPanel getContactChat(MetaContact metaContact, Contact protocolContact, ContactResource contactResource, String escapedMessageID) {
        MetaContactChatCreateRunnable runnable = new MetaContactChatCreateRunnable(metaContact, protocolContact, contactResource, escapedMessageID);
        return runnable.getChatPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel getContactChat(MetaContact metaContact, Contact protocolContact, ContactResource contactResource, boolean create, String escapedMessageID) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatPanel chatPanel = this.findChatPanelForDescriptor(metaContact);
            if (chatPanel == null && create) {
                chatPanel = this.createChat(metaContact, protocolContact, contactResource, escapedMessageID);
            }
            return chatPanel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatPanel getSelectedChat() {
        ChatPanel selectedChat = null;
        Iterator<ChatPanel> chatPanelsIter = this.chatPanels.iterator();
        Object object = this.chatSyncRoot;
        synchronized (object) {
            if (ConfigurationUtils.isMultiChatWindowEnabled()) {
                if (chatPanelsIter.hasNext()) {
                    ChatPanel firstChatPanel = chatPanelsIter.next();
                    selectedChat = firstChatPanel.getChatContainer().getCurrentChat();
                }
            } else {
                while (chatPanelsIter.hasNext()) {
                    ChatPanel chatPanel = chatPanelsIter.next();
                    if (!chatPanel.getChatContainer().getFrame().isFocusOwner()) continue;
                    selectedChat = chatPanel;
                }
            }
            return selectedChat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel getMultiChatInternal(ChatRoomWrapper chatRoomWrapper, boolean create) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatPanel chatPanel = this.findChatPanelForDescriptor(chatRoomWrapper);
            if (chatPanel == null && create) {
                chatPanel = this.createChat(chatRoomWrapper);
            }
            return chatPanel;
        }
    }

    public ChatPanel getMultiChat(ChatRoomWrapper chatRoomWrapper, boolean create) {
        if (!create) {
            return this.getMultiChatInternal(chatRoomWrapper, false);
        }
        return new CreateChatRoomWrapperRunner(chatRoomWrapper).getChatPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel getMultiChatInternal(AdHocChatRoomWrapper chatRoomWrapper, boolean create) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatPanel chatPanel = this.findChatPanelForDescriptor(chatRoomWrapper);
            if (chatPanel == null && create) {
                chatPanel = this.createChat(chatRoomWrapper);
            }
            return chatPanel;
        }
    }

    public ChatPanel getMultiChat(AdHocChatRoomWrapper chatRoomWrapper, boolean create) {
        if (!create) {
            return this.getMultiChatInternal(chatRoomWrapper, false);
        }
        return new CreateAdHocChatRoomWrapperRunner(chatRoomWrapper).getChatPanel();
    }

    public ChatPanel getMultiChat(AdHocChatRoom adHocChatRoom, boolean create) {
        return this.getMultiChat(adHocChatRoom, create, null);
    }

    public ChatPanel getMultiChat(ChatRoom chatRoom, boolean create) {
        return this.getMultiChat(chatRoom, create, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel getMultiChatInternal(ChatRoom chatRoom, boolean create, String escapedMessageID) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            ChatRoomWrapper chatRoomWrapper = GuiActivator.getMUCService().getChatRoomWrapperByChatRoom(chatRoom, create);
            ChatPanel chatPanel = null;
            if (chatRoomWrapper != null && (chatPanel = this.findChatPanelForDescriptor(chatRoomWrapper)) == null && create) {
                chatPanel = this.createChat(chatRoomWrapper, escapedMessageID);
            }
            return chatPanel;
        }
    }

    public ChatPanel getMultiChat(ChatRoom chatRoom, boolean create, String escapedMessageID) {
        if (!create) {
            return this.getMultiChatInternal(chatRoom, false, escapedMessageID);
        }
        return new CreateChatRoomRunner(chatRoom, escapedMessageID).getChatPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel getMultiChatInternal(AdHocChatRoom adHocChatRoom, boolean create, String escapedMessageID) {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            AdHocChatRoomList chatRoomList = GuiActivator.getUIService().getConferenceChatManager().getAdHocChatRoomList();
            AdHocChatRoomWrapper chatRoomWrapper = chatRoomList.findChatRoomWrapperFromAdHocChatRoom(adHocChatRoom);
            if (chatRoomWrapper == null && create) {
                AdHocChatRoomProviderWrapper parentProvider = chatRoomList.findServerWrapperFromProvider(adHocChatRoom.getParentProvider());
                chatRoomWrapper = new AdHocChatRoomWrapper(parentProvider, adHocChatRoom);
                chatRoomList.addAdHocChatRoom(chatRoomWrapper);
            }
            ChatPanel chatPanel = null;
            if (chatRoomWrapper != null && (chatPanel = this.findChatPanelForDescriptor(chatRoomWrapper)) == null && create) {
                chatPanel = this.createChat(chatRoomWrapper, escapedMessageID);
            }
            return chatPanel;
        }
    }

    public ChatPanel getMultiChat(AdHocChatRoom adHocChatRoom, boolean create, String escapedMessageID) {
        if (!create) {
            return this.getMultiChatInternal(adHocChatRoom, false, escapedMessageID);
        }
        return new CreateAdHocChatRoomRunner(adHocChatRoom, escapedMessageID).getChatPanel();
    }

    public List<ChatPanel> getChatPanels() {
        return this.chatPanels;
    }

    public void startChat(MetaContact metaContact) {
        SwingUtilities.invokeLater(new RunChatWindow(metaContact));
    }

    public void startChat(MetaContact metaContact, Contact protocolContact, boolean isSmsMessage) {
        SwingUtilities.invokeLater(new RunChatWindow(metaContact, protocolContact, isSmsMessage));
    }

    public boolean startChat(String contactString) {
        return this.startChat(contactString, false);
    }

    public boolean startChat(String contactID, ProtocolProviderService pps) {
        Contact c;
        OperationSetPersistentPresence opSet = (OperationSetPersistentPresence)pps.getOperationSet(OperationSetPersistentPresence.class);
        if (opSet != null && (c = opSet.findContactByID(contactID)) != null) {
            MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(c);
            if (metaContact == null) {
                logger.error((Object)("Chat not started. Cannot find metacontact for " + contactID + " and protocol:" + pps));
                return false;
            }
            this.startChat(metaContact, c, false);
            return true;
        }
        logger.error((Object)("Cannot start chat for " + contactID + " for " + pps.getAccountID().getAccountAddress()));
        return false;
    }

    public boolean startChat(String contactString, boolean isSmsEnabled) {
        List imProviders = AccountUtils.getRegisteredProviders(OperationSetBasicInstantMessaging.class);
        List smsProviders = AccountUtils.getRegisteredProviders(OperationSetSmsMessaging.class);
        if (imProviders.size() + (smsProviders == null ? 0 : smsProviders.size()) < 1) {
            return false;
        }
        Contact contact = null;
        MetaContactListService metaContactListService = GuiActivator.getContactListService();
        MetaContact metaContact = null;
        boolean startChat = false;
        for (ProtocolProviderService imProvider : imProviders) {
            try {
                OperationSetPresence presenceOpSet = (OperationSetPresence)imProvider.getOperationSet(OperationSetPresence.class);
                if (presenceOpSet == null) continue;
                contact = presenceOpSet.findContactByID(contactString);
                if (contact != null) {
                    metaContact = metaContactListService.findMetaContactByContact(contact);
                    if (metaContact == null) continue;
                    startChat = true;
                    break;
                }
                contact = presenceOpSet.createUnresolvedContact(contactString, null);
                metaContact = metaContactListService.findMetaContactByContact(contact);
                if (metaContact == null) continue;
                startChat = true;
                break;
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        if (startChat) {
            this.startChat(metaContact, contact, isSmsEnabled);
            return true;
        }
        if (isSmsEnabled) {
            if (smsProviders == null || smsProviders.size() == 0) {
                return false;
            }
            OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)((ProtocolProviderService)smsProviders.get(0)).getOperationSet(OperationSetSmsMessaging.class);
            contact = smsOpSet.getContact(contactString);
            if (contact != null && (metaContact = metaContactListService.findMetaContactByContact(contact)) != null) {
                this.startChat(metaContact, contact, true);
                return true;
            }
        }
        return false;
    }

    public void removeNonReadChatState(ChatPanel chatPanel) {
        ChatSession chatSession = chatPanel.getChatSession();
        if (chatSession instanceof MetaContactChatSession) {
            MetaContact selectedMetaContact = (MetaContact)chatSession.getDescriptor();
            TreeContactList clist = GuiActivator.getContactList();
            if (clist.isContactActive(selectedMetaContact)) {
                clist.setActiveContact(selectedMetaContact, false);
            }
            chatPanel.fireChatFocusEvent(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChatPanel(ChatPanel chatPanel) {
        boolean isChatPanelContained;
        ChatContainer chatContainer = chatPanel.getChatContainer();
        if (chatContainer != null) {
            chatContainer.removeChat(chatPanel);
        }
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            isChatPanelContained = this.chatPanels.remove(chatPanel);
        }
        if (isChatPanelContained) {
            chatPanel.dispose();
            this.fireChatClosed(chatPanel);
        }
    }

    private Contact getDefaultContact(MetaContact metaContact) {
        Contact defaultContact = metaContact.getDefaultContact(OperationSetBasicInstantMessaging.class);
        if (defaultContact == null && (defaultContact = metaContact.getDefaultContact(OperationSetSmsMessaging.class)) == null) {
            return null;
        }
        ProtocolProviderService defaultProvider = defaultContact.getProtocolProvider();
        OperationSetBasicInstantMessaging defaultIM = (OperationSetBasicInstantMessaging)defaultProvider.getOperationSet(OperationSetBasicInstantMessaging.class);
        if (!(defaultContact.getPresenceStatus().getStatus() >= 1 || defaultIM.isOfflineMessagingSupported() && defaultProvider.isRegistered())) {
            Iterator protoContacts = metaContact.getContacts();
            while (protoContacts.hasNext()) {
                Contact contact = (Contact)protoContacts.next();
                ProtocolProviderService protoContactProvider = contact.getProtocolProvider();
                OperationSetBasicInstantMessaging protoContactIM = (OperationSetBasicInstantMessaging)protoContactProvider.getOperationSet(OperationSetBasicInstantMessaging.class);
                if (protoContactIM == null || !protoContactIM.isOfflineMessagingSupported() || !protoContactProvider.isRegistered()) continue;
                defaultContact = contact;
            }
        }
        return defaultContact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel createChat(MetaContact metaContact, Contact protocolContact, ContactResource contactResource, String escapedMessageID) {
        if (protocolContact == null) {
            protocolContact = this.getDefaultContact(metaContact);
        }
        if (protocolContact == null) {
            return null;
        }
        ChatContainer chatContainer = this.getChatContainer();
        ChatPanel chatPanel = new ChatPanel(chatContainer);
        MetaContactChatSession chatSession = new MetaContactChatSession(chatPanel, metaContact, protocolContact, contactResource);
        chatPanel.setChatSession(chatSession);
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            this.chatPanels.add(chatPanel);
        }
        chatPanel.loadHistory(escapedMessageID);
        this.fireChatCreated(chatPanel);
        return chatPanel;
    }

    private ChatContainer getChatContainer() {
        ChatContainer chatContainer = GuiActivator.getUIService().getSingleWindowContainer();
        if (chatContainer != null) {
            return chatContainer;
        }
        if (ConfigurationUtils.isMultiChatWindowEnabled()) {
            Iterator<ChatPanel> chatPanelsIter = this.chatPanels.iterator();
            if (chatPanelsIter.hasNext()) {
                chatContainer = chatPanelsIter.next().getChatContainer();
            } else {
                chatContainer = new ChatWindow();
                GuiActivator.getUIService().registerExportedWindow((ExportedWindow)chatContainer);
            }
        } else {
            chatContainer = new ChatWindow();
        }
        return chatContainer;
    }

    private ChatPanel createChat(ChatRoomWrapper chatRoomWrapper) {
        return this.createChat(chatRoomWrapper, null);
    }

    private ChatPanel createChat(AdHocChatRoomWrapper chatRoomWrapper) {
        return this.createChat(chatRoomWrapper, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel createChat(ChatRoomWrapper chatRoomWrapper, String escapedMessageID) {
        ChatContainer chatContainer = this.getChatContainer();
        ChatPanel chatPanel = new ChatPanel(chatContainer);
        ConferenceChatSession chatSession = new ConferenceChatSession(chatPanel, chatRoomWrapper);
        chatPanel.setChatSession(chatSession);
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            this.chatPanels.add(chatPanel);
        }
        chatPanel.loadHistory(escapedMessageID);
        this.fireChatCreated(chatPanel);
        return chatPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatPanel createChat(AdHocChatRoomWrapper chatRoomWrapper, String escapedMessageID) {
        ChatContainer chatContainer = this.getChatContainer();
        ChatPanel chatPanel = new ChatPanel(chatContainer);
        AdHocConferenceChatSession chatSession = new AdHocConferenceChatSession(chatPanel, chatRoomWrapper);
        chatPanel.setChatSession(chatSession);
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            this.chatPanels.add(chatPanel);
        }
        chatPanel.loadHistory(escapedMessageID);
        this.fireChatCreated(chatPanel);
        return chatPanel;
    }

    private ChatPanel findChatPanelForDescriptor(Object descriptor) {
        for (ChatPanel chatPanel : this.chatPanels) {
            if (!chatPanel.getChatSession().getDescriptor().equals(descriptor)) continue;
            return chatPanel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChatClosed(Chat chat) {
        ArrayList<ChatListener> listeners;
        List<ChatListener> list = this.chatListeners;
        synchronized (list) {
            listeners = new ArrayList<ChatListener>(this.chatListeners);
        }
        for (ChatListener listener : listeners) {
            listener.chatClosed(chat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChatCreated(Chat chat) {
        ArrayList<ChatListener> listeners;
        List<ChatListener> list = this.chatListeners;
        synchronized (list) {
            listeners = new ArrayList<ChatListener>(this.chatListeners);
        }
        for (ChatListener listener : listeners) {
            listener.chatCreated(chat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChat(ChatPanel chatPanel) {
        List<ChatPanel> list = this.chatPanels;
        synchronized (list) {
            return this.chatPanels.contains(chatPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ChatPanel> getAllChats() {
        Object object = this.chatSyncRoot;
        synchronized (object) {
            return this.chatPanels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatListener(ChatListener listener) {
        List<ChatListener> list = this.chatListeners;
        synchronized (list) {
            if (!this.chatListeners.contains(listener)) {
                this.chatListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatListener(ChatListener listener) {
        List<ChatListener> list = this.chatListeners;
        synchronized (list) {
            this.chatListeners.remove(listener);
        }
    }

    private static int showWarningMessage(String resourceString, Component parentComponent) {
        SIPCommMsgTextArea msgText;
        JComponent textComponent = msgText = new SIPCommMsgTextArea(GuiActivator.getResources().getI18NString(resourceString));
        if (OSUtils.IS_LINUX) {
            JScrollPane jScrollPane = new JScrollPane(msgText);
            jScrollPane.setBorder(null);
            textComponent = jScrollPane;
        }
        return JOptionPane.showConfirmDialog(parentComponent, textComponent, GuiActivator.getResources().getI18NString("service.gui.WARNING"), 2, 2);
    }

    private class CreateAdHocChatRoomRunner
    extends AbstractChatPanelCreateRunnable {
        private AdHocChatRoom adHocChatRoom;
        private String escapedMessageID;

        private CreateAdHocChatRoomRunner(AdHocChatRoom adHocChatRoom, String escapedMessageID) {
            this.adHocChatRoom = adHocChatRoom;
            this.escapedMessageID = escapedMessageID;
        }

        @Override
        protected ChatPanel createChatPanel() {
            return ChatWindowManager.this.getMultiChatInternal(this.adHocChatRoom, true, this.escapedMessageID);
        }
    }

    private class CreateChatRoomRunner
    extends AbstractChatPanelCreateRunnable {
        private ChatRoom chatRoom;
        private String escapedMessageID;

        private CreateChatRoomRunner(ChatRoom chatRoom, String escapedMessageID) {
            this.chatRoom = chatRoom;
            this.escapedMessageID = escapedMessageID;
        }

        @Override
        protected ChatPanel createChatPanel() {
            return ChatWindowManager.this.getMultiChatInternal(this.chatRoom, true, this.escapedMessageID);
        }
    }

    private class CreateAdHocChatRoomWrapperRunner
    extends AbstractChatPanelCreateRunnable {
        private AdHocChatRoomWrapper chatRoomWrapper;

        private CreateAdHocChatRoomWrapperRunner(AdHocChatRoomWrapper chatRoomWrapper) {
            this.chatRoomWrapper = chatRoomWrapper;
        }

        @Override
        protected ChatPanel createChatPanel() {
            return ChatWindowManager.this.getMultiChatInternal(this.chatRoomWrapper, true);
        }
    }

    private class CreateChatRoomWrapperRunner
    extends AbstractChatPanelCreateRunnable {
        private ChatRoomWrapper chatRoomWrapper;

        private CreateChatRoomWrapperRunner(ChatRoomWrapper chatRoomWrapper) {
            this.chatRoomWrapper = chatRoomWrapper;
        }

        @Override
        protected ChatPanel createChatPanel() {
            return ChatWindowManager.this.getMultiChatInternal(this.chatRoomWrapper, true);
        }
    }

    private class MetaContactChatCreateRunnable
    extends AbstractChatPanelCreateRunnable {
        private final MetaContact metaContact;
        private final Contact protocolContact;
        private final ContactResource contactResource;
        private final String escapedMessageID;

        private MetaContactChatCreateRunnable(MetaContact metaContact, Contact protocolContact, ContactResource contactResource, String escapedMessageID) {
            this.metaContact = metaContact;
            this.protocolContact = protocolContact;
            this.contactResource = contactResource;
            this.escapedMessageID = escapedMessageID;
        }

        @Override
        protected ChatPanel createChatPanel() {
            return ChatWindowManager.this.getContactChat(this.metaContact, this.protocolContact, this.contactResource, true, this.escapedMessageID);
        }
    }

    private abstract class AbstractChatPanelCreateRunnable
    implements Runnable {
        private ChatPanel chatPanel;

        private AbstractChatPanelCreateRunnable() {
        }

        public ChatPanel getChatPanel() {
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(this);
                } else {
                    this.run();
                }
            }
            catch (Throwable t) {
                logger.warn((Object)"Cannot dispatch on event dispatch thread", t);
                this.run();
            }
            return this.chatPanel;
        }

        @Override
        public void run() {
            this.chatPanel = this.createChatPanel();
        }

        protected abstract ChatPanel createChatPanel();
    }

    private class RunChatWindow
    implements Runnable {
        private final MetaContact metaContact;
        private final Contact protocolContact;
        private final Boolean isSmsSelected;

        public RunChatWindow(MetaContact metaContact) {
            this(metaContact, null);
        }

        public RunChatWindow(MetaContact metaContact, Contact protocolContact) {
            this(metaContact, protocolContact, null);
        }

        public RunChatWindow(MetaContact metaContact, Contact protocolContact, Boolean isSmsSelected) {
            this.metaContact = metaContact;
            this.protocolContact = protocolContact;
            this.isSmsSelected = isSmsSelected;
        }

        @Override
        public void run() {
            ChatPanel chatPanel = ChatWindowManager.this.getContactChat(this.metaContact, this.protocolContact);
            if (chatPanel == null) {
                return;
            }
            if (this.isSmsSelected != null) {
                chatPanel.setSmsSelected(this.isSmsSelected);
            }
            ChatWindowManager.this.openChat(chatPanel, true);
        }
    }
}

