/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactRoleIcon;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatContactCellRenderer
extends JPanel
implements ListCellRenderer<ChatContact<?>>,
Icon,
Skinnable {
    private static final Color COLOR_AVAILABILITY_THRESHOLD = Color.BLACK;
    private static final Color COLOR_AWAY_THRESHOLD = Color.GRAY;
    private static final long serialVersionUID = 0L;
    private static final int AVATAR_HEIGHT = 30;
    private static final int AVATAR_WIDTH = 30;
    private static final String AVATAR_DATA_KEY = ChatContactCellRenderer.class.getName() + ".avatar";
    private ImageIcon openedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.OPENED_GROUP_ICON));
    private ImageIcon closedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSED_GROUP_ICON));
    private Color groupForegroundColor;
    protected Color contactForegroundColor;
    protected final JLabel nameLabel = new JLabel();
    protected final JLabel statusMessageLabel = new JLabel();
    protected final JLabel rightLabel = new JLabel();
    private final Image msgReceivedImage = ImageLoader.getImage(ImageLoader.MESSAGE_RECEIVED_ICON);
    private final JLabel statusLabel = new JLabel();
    protected final ImageIcon statusIcon = new ImageIcon();
    private final TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    protected boolean isSelected = false;
    protected int index = 0;
    protected boolean isLeaf = true;

    public ChatContactCellRenderer() {
        super(new BorderLayout());
        int contactForegroundProperty;
        int groupForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_FOREGROUND");
        if (groupForegroundProperty > -1) {
            this.groupForegroundColor = new Color(groupForegroundProperty);
        }
        if ((contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_CONTACT_FOREGROUND")) > -1) {
            this.contactForegroundColor = new Color(contactForegroundProperty);
        }
        this.setOpaque(false);
        this.nameLabel.setOpaque(false);
        this.nameLabel.setPreferredSize(new Dimension(10, 20));
        this.statusMessageLabel.setFont(this.getFont().deriveFont(9.0f));
        this.statusMessageLabel.setForeground(Color.GRAY);
        this.rightLabel.setFont(this.rightLabel.getFont().deriveFont(9.0f));
        this.rightLabel.setHorizontalAlignment(4);
        this.centerPanel.add((Component)this.nameLabel);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.rightLabel, "East");
        this.setToolTipText("");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ChatContact<?>> list, ChatContact<?> chatContact, int index, boolean isSelected, boolean cellHasFocus) {
        this.index = index;
        this.rightLabel.setIcon(null);
        if (chatContact == null) {
            return this;
        }
        ChatRoomMember member = null;
        if (chatContact.getDescriptor() instanceof ChatRoomMember) {
            member = (ChatRoomMember)chatContact.getDescriptor();
        }
        this.setPreferredSize(new Dimension(20, 30));
        String displayName = chatContact.getName();
        if (displayName == null || displayName.length() < 1) {
            displayName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN");
        }
        this.nameLabel.setFont(this.getFont().deriveFont(0));
        this.nameLabel.setText(displayName);
        if (member != null) {
            int presenceStatus;
            ChatRoomMemberRole memberRole = member.getRole();
            if (memberRole != null) {
                this.nameLabel.setIcon(ChatContactRoleIcon.getRoleIcon(memberRole));
            }
            if ((presenceStatus = member.getPresenceStatus().getStatus()) >= 50) {
                this.nameLabel.setForeground(COLOR_AVAILABILITY_THRESHOLD);
            } else if (presenceStatus >= 36) {
                this.nameLabel.setForeground(COLOR_AWAY_THRESHOLD);
            }
        } else if (this.contactForegroundColor != null) {
            this.nameLabel.setForeground(this.contactForegroundColor);
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
        ImageIcon avatar = chatContact.getAvatar();
        if (avatar != null) {
            this.rightLabel.setIcon(avatar);
        } else if (member != null) {
            ChatRoom memberChatRoom = member.getChatRoom();
            ProtocolProviderService protocolProvider = memberChatRoom.getParentProvider();
            if (chatContact.getName().equals(memberChatRoom.getUserNickname())) {
                ChatRoomMemberRole role;
                OperationSetServerStoredAccountInfo opSet = (OperationSetServerStoredAccountInfo)protocolProvider.getOperationSet(OperationSetServerStoredAccountInfo.class);
                if (opSet != null) {
                    Iterator itr;
                    try {
                        itr = opSet.getAllAvailableDetails();
                    }
                    catch (IllegalStateException isex) {
                        itr = null;
                    }
                    if (itr != null) {
                        while (itr.hasNext()) {
                            ServerStoredDetails.GenericDetail detail = (ServerStoredDetails.GenericDetail)itr.next();
                            if (!(detail instanceof ServerStoredDetails.BinaryDetail)) continue;
                            ServerStoredDetails.BinaryDetail bin = (ServerStoredDetails.BinaryDetail)detail;
                            byte[] binBytes = bin.getBytes();
                            if (binBytes == null) break;
                            this.rightLabel.setIcon(ImageUtils.getScaledRoundedIcon((byte[])binBytes, (int)25, (int)25));
                            break;
                        }
                    }
                }
                try {
                    role = memberChatRoom.getUserRole();
                }
                catch (UnsupportedOperationException uoex) {
                    role = member.getRole();
                }
                if (role != null) {
                    this.nameLabel.setIcon(ChatContactRoleIcon.getRoleIcon(role));
                }
            } else {
                byte[] cImage;
                Contact c;
                OperationSetPersistentPresence opSet = (OperationSetPersistentPresence)protocolProvider.getOperationSet(OperationSetPersistentPresence.class);
                if (opSet != null && (c = opSet.findContactByID(member.getContactAddress())) != null && (cImage = c.getImage()) != null) {
                    this.rightLabel.setIcon(ImageUtils.getScaledRoundedIcon((byte[])cImage, (int)25, (int)25));
                }
            }
        }
        int listWidth = list.getWidth();
        this.setBounds(0, 0, listWidth - 2, 30);
        this.nameLabel.setBounds(0, 0, listWidth - 28, 17);
        this.rightLabel.setBounds(listWidth - 28, 0, 25, 30);
        this.isLeaf = true;
        this.isSelected = isSelected;
        return this;
    }

    private ImageIcon getAvatar(MetaContact metaContact) {
        byte[] avatarBytes = metaContact.getAvatar(true);
        ImageIcon avatar = null;
        Object[] avatarCache = (Object[])metaContact.getData((Object)AVATAR_DATA_KEY);
        if (avatarCache != null && avatarCache[0] == avatarBytes) {
            avatar = (ImageIcon)avatarCache[1];
        }
        if (avatar == null && avatarBytes != null && avatarBytes.length > 0) {
            avatar = ImageUtils.getScaledRoundedIcon((byte[])avatarBytes, (int)30, (int)30);
        }
        if (avatarCache == null) {
            if (avatar != null) {
                metaContact.setData((Object)AVATAR_DATA_KEY, (Object)new Object[]{avatarBytes, avatar});
            }
        } else {
            avatarCache[0] = avatarBytes;
            avatarCache[1] = avatar;
        }
        return avatar;
    }

    private String getStatusMessage(MetaContact metaContact) {
        Iterator protoContacts = metaContact.getContacts();
        while (protoContacts.hasNext()) {
            Contact protoContact = (Contact)protoContacts.next();
            String statusMessage = protoContact.getStatusMessage();
            if (statusMessage == null || statusMessage.length() <= 0) continue;
            return statusMessage;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        if (!this.isLeaf) {
            int width = this.getWidth();
            GradientPaint p = new GradientPaint(0.0f, 0.0f, Constants.CONTACT_LIST_GROUP_BG_COLOR, width - 5, 0.0f, Constants.CONTACT_LIST_GROUP_BG_GRADIENT_COLOR);
            g2.setPaint(p);
            g2.fillRoundRect(1, 1, width - 2, this.getHeight() - 1, 10, 10);
        }
        if (this.isSelected) {
            g2.setColor(Constants.SELECTED_COLOR);
            g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 1, 10, 10);
        }
    }

    @Override
    public int getIconHeight() {
        return this.getHeight() + 10;
    }

    @Override
    public int getIconWidth() {
        return this.getWidth() + 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g2);
            g2.setColor(Color.WHITE);
            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2.fillRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.setColor(Color.DARK_GRAY);
            g2.drawRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.translate(x + 5, y + 5);
            super.paint(g2);
            g2.translate(x, y);
        }
        finally {
            g.dispose();
        }
    }

    public void loadSkin() {
        int contactForegroundProperty;
        this.openedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON));
        this.closedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSED_GROUP_ICON));
        int groupForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_FOREGROUND");
        if (groupForegroundProperty > -1) {
            this.groupForegroundColor = new Color(groupForegroundProperty);
        }
        if ((contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_CONTACT_FOREGROUND")) > -1) {
            this.contactForegroundColor = new Color(contactForegroundProperty);
        }
    }
}

