/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatContact;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;

public class ChatContactListModel
extends AbstractListModel<ChatContact<?>>
implements ChatRoomMemberPropertyChangeListener {
    private final List<ChatContact<?>> chatContacts = new ArrayList();
    private ChatSession chatSession;
    private final Comparator<ChatContact<?>> sorter = new Comparator<ChatContact<?>>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ChatContact<?> chatContact0, ChatContact<?> chatContact1) {
            if (chatContact0 instanceof ConferenceChatContact) {
                int role1;
                if (!(chatContact1 instanceof ConferenceChatContact)) return -1;
                int role0 = ((ConferenceChatContact)chatContact0).getRole().getRoleIndex();
                if (role0 > (role1 = ((ConferenceChatContact)chatContact1).getRole().getRoleIndex())) {
                    return -1;
                }
                if (role0 >= role1) return chatContact0.getName().compareToIgnoreCase(chatContact1.getName());
                return 1;
            }
            if (!(chatContact1 instanceof ConferenceChatContact)) return chatContact0.getName().compareToIgnoreCase(chatContact1.getName());
            return 1;
        }
    };

    public ChatContactListModel(ChatSession chatSession) {
        this.chatSession = chatSession;
        Object descriptor = chatSession.getDescriptor();
        if (descriptor instanceof ChatRoomWrapper) {
            ((ChatRoomWrapper)descriptor).getChatRoom().addMemberPropertyChangeListener((ChatRoomMemberPropertyChangeListener)this);
        }
    }

    public void chatRoomPropertyChanged(ChatRoomMemberPropertyChangeEvent ev) {
        int chatContactCount = this.chatContacts.size();
        for (int i = 0; i < chatContactCount; ++i) {
            ChatContact<?> chatContact = this.chatContacts.get(i);
            if (!chatContact.getDescriptor().equals(ev.getSourceChatRoomMember())) continue;
            this.fireContentsChanged(chatContact, i, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(ChatContact<?> chatContact) {
        if (chatContact == null) {
            throw new IllegalArgumentException("chatContact");
        }
        int index = -1;
        List<ChatContact<?>> list = this.chatContacts;
        synchronized (list) {
            int chatContactCount = this.chatContacts.size();
            for (int i = 0; i < chatContactCount; ++i) {
                ChatContact<?> containedChatContact = this.chatContacts.get(i);
                if (chatContact.equals(containedChatContact)) {
                    return;
                }
                if (index != -1 || this.sorter.compare(containedChatContact, chatContact) <= 0) continue;
                index = i;
            }
            if (index == -1) {
                index = chatContactCount;
            }
            this.chatContacts.add(index, chatContact);
        }
        this.fireIntervalAdded(this, index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChatContact<?> getElementAt(int index) {
        List<ChatContact<?>> list = this.chatContacts;
        synchronized (list) {
            return this.chatContacts.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        List<ChatContact<?>> list = this.chatContacts;
        synchronized (list) {
            return this.chatContacts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ChatContact<?> chatContact) {
        List<ChatContact<?>> list = this.chatContacts;
        synchronized (list) {
            int index = this.chatContacts.indexOf(chatContact);
            if (index >= 0 && this.chatContacts.remove(chatContact)) {
                this.fireIntervalRemoved(this, index, index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        if (this.chatContacts == null || this.chatContacts.size() <= 0) {
            return;
        }
        List<ChatContact<?>> list = this.chatContacts;
        synchronized (list) {
            int contactsSize = this.chatContacts.size();
            this.chatContacts.clear();
            this.fireIntervalRemoved(this, 0, contactsSize - 1);
        }
    }

    public void dispose() {
        Object descriptor = this.chatSession.getDescriptor();
        if (descriptor instanceof ChatRoomWrapper) {
            ((ChatRoomWrapper)descriptor).getChatRoom().removeMemberPropertyChangeListener((ChatRoomMemberPropertyChangeListener)this);
        }
    }
}

