/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactCellRenderer;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.MetaContactListManager;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;

public class ChatRoomContactListTransferHandler
extends ExtendedTransferHandler {
    private static final Logger logger = Logger.getLogger(ChatRoomContactListTransferHandler.class);
    private static final DataFlavor metaContactDataFlavor = new DataFlavor(MetaContact.class, "MetaContact");
    private final ChatRoomContactList contactList;

    public ChatRoomContactListTransferHandler(ChatRoomContactList contactList) {
        this.contactList = contactList;
    }

    public Transferable createTransferable(JComponent component) {
        if (component instanceof JList) {
            JList list = (JList)component;
            return new ContactListTransferable(list.getSelectedIndex(), list.getSelectedValue());
        }
        return super.createTransferable(component);
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            if (!flavor[i].equals(metaContactDataFlavor)) continue;
            return true;
        }
        return super.canImport(comp, flavor);
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (t.isDataFlavorSupported(metaContactDataFlavor)) {
            Object o;
            block10: {
                o = null;
                try {
                    o = t.getTransferData(metaContactDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                }
            }
            if (o instanceof ChatContact && comp instanceof ChatRoomContactList) {
                ChatContact chatContact = (ChatContact)o;
                Contact transferredContact = (Contact)chatContact.getDescriptor();
                ChatRoomContactList list = (ChatRoomContactList)comp;
                Object dest = list.getSelectedValue();
                if (transferredContact != null) {
                    if (dest instanceof MetaContact) {
                        MetaContact destContact = (MetaContact)dest;
                        if (transferredContact != destContact) {
                            MetaContactListManager.moveContactToMetaContact(transferredContact, destContact);
                        }
                        return true;
                    }
                    if (dest instanceof MetaContactGroup) {
                        MetaContactGroup destGroup = (MetaContactGroup)dest;
                        MetaContactListManager.moveContactToGroup(transferredContact, destGroup);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Icon getVisualRepresentation(Transferable t) {
        ChatContactCellRenderer renderer;
        block5: {
            renderer = null;
            if (t instanceof ContactListTransferable) {
                ContactListTransferable transferable = (ContactListTransferable)t;
                try {
                    renderer = (ChatContactCellRenderer)this.contactList.getCellRenderer().getListCellRendererComponent(this.contactList, (ChatContact)transferable.getTransferData(metaContactDataFlavor), transferable.getTransferIndex(), false, false);
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unsupported flavor while obtaining transfer data.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"The data for the request flavor is no longer available.", (Throwable)e);
                }
            }
        }
        return renderer;
    }

    public class ContactListTransferable
    implements Transferable {
        private int transferredIndex;
        private Object transferredObject;

        public ContactListTransferable(int index, Object o) {
            this.transferredIndex = index;
            this.transferredObject = o;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{metaContactDataFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return metaContactDataFlavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (metaContactDataFlavor.equals(flavor)) {
                return this.transferredObject;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                if (this.transferredObject instanceof ChatContact) {
                    return ((ChatContact)this.transferredObject).getUID();
                }
            } else {
                throw new UnsupportedFlavorException(flavor);
            }
            return null;
        }

        public int getTransferIndex() {
            return this.transferredIndex;
        }
    }
}

