/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.Frame;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomProviderWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.InvitationReceivedDialog;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.main.chatroomslist.AdHocChatRoomList;
import net.java.sip.communicator.impl.gui.main.chatroomslist.AdHocChatRoomListChangeEvent;
import net.java.sip.communicator.impl.gui.main.chatroomslist.AdHocChatRoomListChangeListener;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.AdHocChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationRejectedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class ConferenceChatManager
implements ChatRoomMessageListener,
ChatRoomInvitationListener,
ChatRoomInvitationRejectionListener,
AdHocChatRoomMessageListener,
AdHocChatRoomInvitationListener,
AdHocChatRoomInvitationRejectionListener,
LocalUserChatRoomPresenceListener,
LocalUserAdHocChatRoomPresenceListener,
ServiceListener,
ChatRoomLocalUserRoleListener {
    private static final Logger logger = Logger.getLogger(ConferenceChatManager.class);
    private final Hashtable<ChatRoomWrapper, HistoryWindow> chatRoomHistory = new Hashtable();
    private final AdHocChatRoomList adHocChatRoomList = new AdHocChatRoomList();
    private final Vector<AdHocChatRoomListChangeListener> adHoclistChangeListeners = new Vector();

    public ConferenceChatManager() {
        new Thread(){

            @Override
            public void run() {
                ConferenceChatManager.this.adHocChatRoomList.loadList();
            }
        }.start();
        GuiActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    public AdHocChatRoomList getAdHocChatRoomList() {
        return this.adHocChatRoomList;
    }

    public void invitationReceived(ChatRoomInvitationReceivedEvent evt) {
        InvitationReceivedDialog dialog = new InvitationReceivedDialog(this, evt.getSourceOperationSet(), evt.getInvitation());
        dialog.setVisible(true);
    }

    public void invitationRejected(ChatRoomInvitationRejectedEvent evt) {
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
        ChatPanel chatPanel;
        ChatRoom sourceChatRoom = (ChatRoom)evt.getSource();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MESSAGE DELIVERED to chat room: " + sourceChatRoom.getName()));
        }
        if ((chatPanel = GuiActivator.getUIService().getChatWindowManager().getMultiChat(sourceChatRoom, false)) != null) {
            String messageType;
            switch (evt.getEventType()) {
                case 1: {
                    messageType = "OutgoingMessage";
                    break;
                }
                case 2: {
                    messageType = "ActionMessage";
                    break;
                }
                default: {
                    messageType = null;
                }
            }
            Message msg = evt.getMessage();
            chatPanel.addMessage(sourceChatRoom.getUserNickname(), null, evt.getTimestamp(), messageType, msg.getContent(), msg.getContentType(), msg.getMessageUID(), null);
        }
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
        ChatRoom sourceChatRoom = evt.getSourceChatRoom();
        ChatRoomMember sourceMember = evt.getSourceChatRoomMember();
        String messageType = null;
        switch (evt.getEventType()) {
            case 1: {
                messageType = "IncomingMessage";
                break;
            }
            case 3: {
                messageType = "SystemMessage";
                break;
            }
            case 2: {
                messageType = "ActionMessage";
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MESSAGE RECEIVED from contact: " + sourceMember.getContactAddress()));
        }
        Message message = evt.getMessage();
        ChatPanel chatPanel = null;
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        boolean createWindow = false;
        String autoOpenConfig = MUCService.getChatRoomAutoOpenOption((ProtocolProviderService)sourceChatRoom.getParentProvider(), (String)sourceChatRoom.getIdentifier());
        if (autoOpenConfig == null) {
            autoOpenConfig = MUCService.DEFAULT_AUTO_OPEN_BEHAVIOUR;
        }
        if (autoOpenConfig.equals(MUCService.OPEN_ON_ACTIVITY) || autoOpenConfig.equals(MUCService.OPEN_ON_MESSAGE) && !evt.isHistoryMessage() || evt.isImportantMessage()) {
            createWindow = true;
        }
        if (sourceChatRoom.isSystem()) {
            ChatRoomProviderWrapper serverWrapper = GuiActivator.getMUCService().findServerWrapperFromProvider(sourceChatRoom.getParentProvider());
            chatPanel = chatWindowManager.getMultiChat(serverWrapper.getSystemRoomWrapper(), createWindow);
        } else {
            chatPanel = chatWindowManager.getMultiChat(sourceChatRoom, createWindow, message.getMessageUID());
        }
        if (chatPanel == null) {
            return;
        }
        String messageContent = message.getContent();
        if (evt.isHistoryMessage()) {
            Date timeStamp = chatPanel.getChatConversationPanel().getLastIncomingMsgTimestamp();
            Collection<Object> c = chatPanel.getChatSession().getHistoryBeforeDate(new Date(timeStamp.equals(new Date(0L)) ? System.currentTimeMillis() - 10000L : timeStamp.getTime()), 20);
            if (c.size() > 0) {
                boolean isPresent = false;
                for (Object o : c) {
                    Message m2;
                    ChatRoomMessageDeliveredEvent ev;
                    if (o instanceof ChatRoomMessageDeliveredEvent) {
                        ev = (ChatRoomMessageDeliveredEvent)o;
                        if (evt.getTimestamp() != null && evt.getTimestamp().equals(ev.getTimestamp())) {
                            isPresent = true;
                            break;
                        }
                    } else if (o instanceof ChatRoomMessageReceivedEvent) {
                        ev = (ChatRoomMessageReceivedEvent)o;
                        if (evt.getTimestamp() != null && evt.getTimestamp().equals(ev.getTimestamp())) {
                            isPresent = true;
                            break;
                        }
                    }
                    if ((m2 = evt.getMessage()) == null || !m2.getContent().equals(messageContent)) continue;
                    isPresent = true;
                    break;
                }
                if (isPresent) {
                    return;
                }
            }
        }
        chatPanel.addMessage(sourceMember.getName(), null, evt.getTimestamp(), messageType, messageContent, message.getContentType(), message.getMessageUID(), null);
        if (createWindow) {
            chatWindowManager.openChat(chatPanel, false);
        }
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
        ChatRoom sourceChatRoom = evt.getSourceChatRoom();
        String errorMsg = null;
        Message sourceMessage = evt.getMessage();
        ChatRoomMember destMember = evt.getDestinationChatRoomMember();
        errorMsg = evt.getErrorCode() == 5 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_NOT_SUPPORTED", new String[]{destMember.getName()}) : (evt.getErrorCode() == 2 ? GuiActivator.getResources().getI18NString("service.gui.MSG_NOT_DELIVERED") : (evt.getErrorCode() == 3 ? GuiActivator.getResources().getI18NString("service.gui.MSG_SEND_CONNECTION_PROBLEM") : (evt.getErrorCode() == 4 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_INTERNAL_ERROR") : (evt.getErrorCode() == 6 ? GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_SEND_MSG_FORBIDDEN") : (evt.getErrorCode() == 7 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_UNSUPPORTED_OPERATION") : GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_UNKNOWN_ERROR"))))));
        String reason = evt.getReason();
        if (reason != null) {
            errorMsg = errorMsg + " " + GuiActivator.getResources().getI18NString("service.gui.ERROR_WAS", new String[]{reason});
        }
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(sourceChatRoom, true);
        chatPanel.addMessage(destMember != null ? destMember.getName() : sourceChatRoom.getName(), new Date(), "OutgoingMessage", sourceMessage.getContent(), sourceMessage.getContentType());
        chatPanel.addErrorMessage(destMember != null ? destMember.getName() : sourceChatRoom.getName(), errorMsg);
        chatWindowManager.openChat(chatPanel, false);
    }

    public void localUserAdHocPresenceChanged(LocalUserAdHocChatRoomPresenceChangeEvent evt) {
        AdHocChatRoom sourceAdHocChatRoom = evt.getAdHocChatRoom();
        AdHocChatRoomWrapper adHocChatRoomWrapper = this.adHocChatRoomList.findChatRoomWrapperFromAdHocChatRoom(sourceAdHocChatRoom);
        String eventType = evt.getEventType();
        if ("LocalUserJoined".equals(eventType)) {
            if (adHocChatRoomWrapper != null) {
                this.fireAdHocChatRoomListChangedEvent(adHocChatRoomWrapper, 3);
                ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
                ChatPanel chatPanel = chatWindowManager.getMultiChat(adHocChatRoomWrapper, true);
                if (chatPanel.isShown()) {
                    ((AdHocConferenceChatSession)chatPanel.getChatSession()).loadChatRoom(sourceAdHocChatRoom);
                } else {
                    chatWindowManager.openChat(chatPanel, true);
                }
            }
            sourceAdHocChatRoom.addMessageListener((AdHocChatRoomMessageListener)this);
        } else if (evt.getEventType().equals("LocalUserJoinFailed")) {
            GuiActivator.getAlertUIService().showAlertPopup(GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.FAILED_TO_JOIN_CHAT_ROOM", new String[]{sourceAdHocChatRoom.getName()}) + evt.getReason());
        } else if ("LocalUserLeft".equals(eventType) || "LocalUserDropped".equals(eventType)) {
            this.closeAdHocChatRoom(adHocChatRoomWrapper);
            this.fireAdHocChatRoomListChangedEvent(adHocChatRoomWrapper, 3);
            sourceAdHocChatRoom.removeMessageListener((AdHocChatRoomMessageListener)this);
        }
    }

    public void localUserPresenceChanged(final LocalUserChatRoomPresenceChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConferenceChatManager.this.localUserPresenceChanged(evt);
                }
            });
            return;
        }
        ChatRoom sourceChatRoom = evt.getChatRoom();
        ChatRoomWrapper chatRoomWrapper = GuiActivator.getMUCService().findChatRoomWrapperFromChatRoom(sourceChatRoom);
        String eventType = evt.getEventType();
        if ("LocalUserJoined".equals(eventType)) {
            if (chatRoomWrapper != null) {
                ChatWindowManager chatWindowManager;
                ChatPanel chatPanel;
                GuiActivator.getMUCService().fireChatRoomListChangedEvent(chatRoomWrapper, 3);
                boolean createWindow = false;
                String autoOpenConfig = MUCService.getChatRoomAutoOpenOption((ProtocolProviderService)sourceChatRoom.getParentProvider(), (String)sourceChatRoom.getIdentifier());
                if (autoOpenConfig != null && autoOpenConfig.equals(MUCService.OPEN_ON_ACTIVITY)) {
                    createWindow = true;
                }
                if ((chatPanel = (chatWindowManager = GuiActivator.getUIService().getChatWindowManager()).getMultiChat(chatRoomWrapper, createWindow)) != null) {
                    chatPanel.setChatIcon(chatPanel.getChatSession().getChatStatusIcon());
                    if (chatPanel.isShown()) {
                        ((ConferenceChatSession)chatPanel.getChatSession()).loadChatRoom(sourceChatRoom);
                    } else {
                        chatWindowManager.openChat(chatPanel, true);
                    }
                }
            }
            if (sourceChatRoom.isSystem()) {
                ChatRoomProviderWrapper serverWrapper = GuiActivator.getMUCService().findServerWrapperFromProvider(sourceChatRoom.getParentProvider());
                serverWrapper.setSystemRoom(sourceChatRoom);
            }
            sourceChatRoom.addMessageListener((ChatRoomMessageListener)this);
            sourceChatRoom.addLocalUserRoleListener((ChatRoomLocalUserRoleListener)this);
        } else if ("LocalUserJoinFailed".equals(eventType)) {
            GuiActivator.getAlertUIService().showAlertPopup(GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.FAILED_TO_JOIN_CHAT_ROOM", new String[]{sourceChatRoom.getName()}) + evt.getReason());
        } else if ("LocalUserLeft".equals(eventType) || "LocalUserKicked".equals(eventType) || "LocalUserDropped".equals(eventType)) {
            if (chatRoomWrapper != null) {
                if (StringUtils.isEmpty((CharSequence)evt.getReason())) {
                    GuiActivator.getUIService().closeChatRoomWindow(chatRoomWrapper);
                } else {
                    ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
                    ChatPanel chatPanel = chatWindowManager.getMultiChat(sourceChatRoom, false);
                    if (chatPanel != null) {
                        chatPanel.addMessage(sourceChatRoom.getName(), null, new Date(), "SystemMessage", evt.getReason(), "text/plain", null, null);
                        if (StringUtils.isNotEmpty((CharSequence)evt.getAlternateAddress())) {
                            chatPanel.addMessage(sourceChatRoom.getName(), null, new Date(), "SystemMessage", GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_ALTERNATE_ADDRESS", new String[]{evt.getAlternateAddress()}), "text/plain", null, null);
                        }
                    }
                }
                GuiActivator.getMUCService().fireChatRoomListChangedEvent(chatRoomWrapper, 3);
            }
            sourceChatRoom.removeMessageListener((ChatRoomMessageListener)this);
            sourceChatRoom.removelocalUserRoleListener((ChatRoomLocalUserRoleListener)this);
        }
    }

    public void acceptInvitation(AdHocChatRoomInvitation invitation, OperationSetAdHocMultiUserChat multiUserChatOpSet) throws OperationFailedException {
        AdHocChatRoom chatRoom = invitation.getTargetAdHocChatRoom();
        chatRoom.join();
    }

    public void rejectInvitation(OperationSetAdHocMultiUserChat multiUserChatAdHocOpSet, AdHocChatRoomInvitation invitation, String reason) {
        multiUserChatAdHocOpSet.rejectInvitation(invitation, reason);
    }

    public AdHocChatRoomWrapper createAdHocChatRoom(ProtocolProviderService protocolProvider, Collection<String> contacts, String reason) {
        AdHocChatRoomWrapper chatRoomWrapper = null;
        OperationSetAdHocMultiUserChat groupChatOpSet = (OperationSetAdHocMultiUserChat)protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class);
        if (groupChatOpSet == null) {
            return null;
        }
        AdHocChatRoom chatRoom = null;
        try {
            LinkedList<String> members = new LinkedList<String>();
            for (String address : contacts) {
                members.add(address);
            }
            chatRoom = groupChatOpSet.createAdHocChatRoom("chatroom-" + new Date().getTime(), members, reason);
        }
        catch (OperationFailedException ex) {
            new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM_ERROR", new String[]{protocolProvider.getProtocolDisplayName()}), (Throwable)ex).showDialog();
        }
        catch (OperationNotSupportedException ex) {
            new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM_ERROR", new String[]{protocolProvider.getProtocolDisplayName()}), (Throwable)ex).showDialog();
        }
        if (chatRoom != null) {
            AdHocChatRoomProviderWrapper parentProvider = this.adHocChatRoomList.findServerWrapperFromProvider(protocolProvider);
            chatRoomWrapper = new AdHocChatRoomWrapper(parentProvider, chatRoom);
            parentProvider.addAdHocChatRoom(chatRoomWrapper);
            this.adHocChatRoomList.addAdHocChatRoom(chatRoomWrapper);
            this.fireAdHocChatRoomListChangedEvent(chatRoomWrapper, 1);
        }
        return chatRoomWrapper;
    }

    public void joinChatRoom(AdHocChatRoomWrapper chatRoomWrapper) {
        AdHocChatRoom chatRoom = chatRoomWrapper.getAdHocChatRoom();
        if (chatRoom == null) {
            new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.WARNING"), GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{chatRoomWrapper.getAdHocChatRoomName()})).showDialog();
            return;
        }
        new JoinAdHocChatRoomTask(chatRoomWrapper).execute();
    }

    public void removeChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoom chatRoom = chatRoomWrapper.getChatRoom();
        if (chatRoom != null) {
            this.leaveChatRoom(chatRoomWrapper);
        }
        GuiActivator.getUIService().closeChatRoomWindow(chatRoomWrapper);
        GuiActivator.getMUCService().removeChatRoom(chatRoomWrapper);
    }

    public void joinChatRoom(AdHocChatRoom chatRoom) {
        AdHocChatRoomWrapper chatRoomWrapper = this.adHocChatRoomList.findChatRoomWrapperFromAdHocChatRoom(chatRoom);
        if (chatRoomWrapper == null) {
            AdHocChatRoomProviderWrapper parentProvider = this.adHocChatRoomList.findServerWrapperFromProvider(chatRoom.getParentProvider());
            chatRoomWrapper = new AdHocChatRoomWrapper(parentProvider, chatRoom);
            this.adHocChatRoomList.addAdHocChatRoom(chatRoomWrapper);
            this.fireAdHocChatRoomListChangedEvent(chatRoomWrapper, 1);
        }
        this.joinChatRoom(chatRoomWrapper);
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        chatWindowManager.openChat(chatWindowManager.getMultiChat(chatRoomWrapper, true), true);
    }

    public void leaveChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoomWrapper leavedRoomWrapped = GuiActivator.getMUCService().leaveChatRoom(chatRoomWrapper);
        if (leavedRoomWrapped != null) {
            GuiActivator.getUIService().closeChatRoomWindow(leavedRoomWrapped);
        }
    }

    public void leaveChatRoom(AdHocChatRoomWrapper chatRoomWrapper) {
        AdHocChatRoom chatRoom = chatRoomWrapper.getAdHocChatRoom();
        if (chatRoom != null) {
            chatRoom.leave();
        } else {
            new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.WARNING"), GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_LEAVE_NOT_CONNECTED")).showDialog();
        }
    }

    public boolean containsHistoryWindowForChatRoom(ChatRoomWrapper chatRoomWrapper) {
        return this.chatRoomHistory.containsKey(chatRoomWrapper);
    }

    public HistoryWindow getHistoryWindowForChatRoom(ChatRoomWrapper chatRoomWrapper) {
        return this.chatRoomHistory.get(chatRoomWrapper);
    }

    public void addHistoryWindowForChatRoom(ChatRoomWrapper chatRoomWrapper, HistoryWindow historyWindow) {
        this.chatRoomHistory.put(chatRoomWrapper, historyWindow);
    }

    public void removeHistoryWindowForChatRoom(ChatRoomWrapper chatRoomWrapper) {
        this.chatRoomHistory.remove(chatRoomWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdHocChatRoomListChangeListener(AdHocChatRoomListChangeListener l) {
        Vector<AdHocChatRoomListChangeListener> vector = this.adHoclistChangeListeners;
        synchronized (vector) {
            this.adHoclistChangeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdHocChatRoomListChangeListener(AdHocChatRoomListChangeListener l) {
        Vector<AdHocChatRoomListChangeListener> vector = this.adHoclistChangeListeners;
        synchronized (vector) {
            this.adHoclistChangeListeners.remove(l);
        }
    }

    private void fireAdHocChatRoomListChangedEvent(AdHocChatRoomWrapper adHocChatRoomWrapper, int eventID) {
        AdHocChatRoomListChangeEvent evt = new AdHocChatRoomListChangeEvent(adHocChatRoomWrapper, eventID);
        for (AdHocChatRoomListChangeListener l : this.adHoclistChangeListeners) {
            l.contentChanged(evt);
        }
    }

    private void closeAdHocChatRoom(AdHocChatRoomWrapper chatRoomWrapper) {
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(chatRoomWrapper, false);
        if (chatPanel != null) {
            chatWindowManager.closeChat(chatPanel);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getServiceReference().getBundle().getState() == 16) {
            return;
        }
        Object service = GuiActivator.bundleContext.getService(event.getServiceReference());
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        ProtocolProviderService protocolProvider = (ProtocolProviderService)service;
        OperationSet multiUserChatAdHocOpSet = protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class);
        if (multiUserChatAdHocOpSet != null) {
            if (event.getType() == 1) {
                this.adHocChatRoomList.addChatProvider(protocolProvider);
            } else if (event.getType() == 4) {
                this.adHocChatRoomList.removeChatProvider(protocolProvider);
            }
        }
    }

    public void invitationReceived(AdHocChatRoomInvitationReceivedEvent evt) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Invitation received: " + evt.toString()));
        }
        OperationSetAdHocMultiUserChat multiUserChatOpSet = evt.getSourceOperationSet();
        InvitationReceivedDialog dialog = new InvitationReceivedDialog(this, multiUserChatOpSet, evt.getInvitation());
        dialog.setVisible(true);
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent evt) {
        ChatPanel chatPanel;
        AdHocChatRoom sourceChatRoom = (AdHocChatRoom)evt.getSource();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("MESSAGE DELIVERED to ad-hoc chat room: " + sourceChatRoom.getName()));
        }
        if ((chatPanel = GuiActivator.getUIService().getChatWindowManager().getMultiChat(sourceChatRoom, false)) != null) {
            String messageType;
            switch (evt.getEventType()) {
                case 1: {
                    messageType = "OutgoingMessage";
                    break;
                }
                case 2: {
                    messageType = "ActionMessage";
                    break;
                }
                default: {
                    messageType = null;
                }
            }
            Message msg = evt.getMessage();
            chatPanel.addMessage(sourceChatRoom.getParentProvider().getAccountID().getUserID(), null, evt.getTimestamp(), messageType, msg.getContent(), msg.getContentType(), msg.getMessageUID(), null);
        } else {
            logger.error((Object)"chat panel is null, message NOT DELIVERED !");
        }
    }

    public void messageDeliveryFailed(AdHocChatRoomMessageDeliveryFailedEvent evt) {
        AdHocChatRoom sourceChatRoom = evt.getSourceChatRoom();
        Message sourceMessage = evt.getMessage();
        Contact destParticipant = evt.getDestinationParticipant();
        String errorMsg = null;
        errorMsg = evt.getErrorCode() == 5 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_NOT_SUPPORTED", new String[]{destParticipant.getDisplayName()}) : (evt.getErrorCode() == 2 ? GuiActivator.getResources().getI18NString("service.gui.MSG_NOT_DELIVERED") : (evt.getErrorCode() == 3 ? GuiActivator.getResources().getI18NString("service.gui.MSG_SEND_CONNECTION_PROBLEM") : (evt.getErrorCode() == 4 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_INTERNAL_ERROR") : (evt.getErrorCode() == 7 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_UNSUPPORTED_OPERATION") : GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_UNKNOWN_ERROR")))));
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(sourceChatRoom, true);
        chatPanel.addMessage(destParticipant.getDisplayName(), new Date(), "OutgoingMessage", sourceMessage.getContent(), sourceMessage.getContentType());
        chatPanel.addErrorMessage(destParticipant.getDisplayName(), errorMsg);
        chatWindowManager.openChat(chatPanel, false);
    }

    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) {
        AdHocChatRoom sourceChatRoom = evt.getSourceChatRoom();
        Contact sourceParticipant = evt.getSourceChatRoomParticipant();
        String messageType = null;
        switch (evt.getEventType()) {
            case 1: {
                messageType = "IncomingMessage";
                break;
            }
            case 3: {
                messageType = "SystemMessage";
                break;
            }
            case 2: {
                messageType = "ActionMessage";
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("MESSAGE RECEIVED from contact: " + sourceParticipant.getAddress()));
        }
        Message message = evt.getMessage();
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(sourceChatRoom, true, message.getMessageUID());
        String messageContent = message.getContent();
        chatPanel.addMessage(sourceParticipant.getDisplayName(), null, evt.getTimestamp(), messageType, messageContent, message.getContentType(), message.getMessageUID(), null);
        chatWindowManager.openChat(chatPanel, false);
    }

    public void invitationRejected(AdHocChatRoomInvitationRejectedEvent evt) {
    }

    public void localUserRoleChanged(ChatRoomLocalUserRoleChangeEvent evt) {
        if (evt.isInitial()) {
            return;
        }
        ChatRoom sourceChatRoom = evt.getSourceChatRoom();
        ChatRoomWrapper chatRoomWrapper = GuiActivator.getMUCService().findChatRoomWrapperFromChatRoom(sourceChatRoom);
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        ChatPanel chatPanel = chatWindowManager.getMultiChat(chatRoomWrapper, true);
        chatWindowManager.openChat(chatPanel, true);
    }

    private static class JoinAdHocChatRoomTask
    extends SwingWorker<String, Object> {
        private static final String SUCCESS = "Success";
        private static final String AUTHENTICATION_FAILED = "AuthenticationFailed";
        private static final String REGISTRATION_REQUIRED = "RegistrationRequired";
        private static final String PROVIDER_NOT_REGISTERED = "ProviderNotRegistered";
        private static final String SUBSCRIPTION_ALREADY_EXISTS = "SubscriptionAlreadyExists";
        private static final String UNKNOWN_ERROR = "UnknownError";
        private final AdHocChatRoomWrapper adHocChatRoomWrapper;

        JoinAdHocChatRoomTask(AdHocChatRoomWrapper chatRoomWrapper) {
            this.adHocChatRoomWrapper = chatRoomWrapper;
        }

        @Override
        public String doInBackground() {
            AdHocChatRoom chatRoom = this.adHocChatRoomWrapper.getAdHocChatRoom();
            try {
                chatRoom.join();
                return SUCCESS;
            }
            catch (OperationFailedException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to join ad-hoc chat room: " + chatRoom.getName()), (Throwable)e);
                }
                switch (e.getErrorCode()) {
                    case 401: {
                        return AUTHENTICATION_FAILED;
                    }
                    case 13: {
                        return REGISTRATION_REQUIRED;
                    }
                    case 3: {
                        return PROVIDER_NOT_REGISTERED;
                    }
                    case 5: {
                        return SUBSCRIPTION_ALREADY_EXISTS;
                    }
                }
                return UNKNOWN_ERROR;
            }
        }

        @Override
        protected void done() {
            String returnCode = null;
            try {
                returnCode = (String)this.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            ConfigurationUtils.updateChatRoomStatus((ProtocolProviderService)this.adHocChatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.adHocChatRoomWrapper.getAdHocChatRoomID(), (String)"Online");
            String errorMessage = null;
            errorMessage = PROVIDER_NOT_REGISTERED.equals(returnCode) ? GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{this.adHocChatRoomWrapper.getAdHocChatRoomName()}) : (SUBSCRIPTION_ALREADY_EXISTS.equals(returnCode) ? GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_ALREADY_JOINED", new String[]{this.adHocChatRoomWrapper.getAdHocChatRoomName()}) : GuiActivator.getResources().getI18NString("service.gui.FAILED_TO_JOIN_CHAT_ROOM", new String[]{this.adHocChatRoomWrapper.getAdHocChatRoomName()}));
            if (!SUCCESS.equals(returnCode) && !AUTHENTICATION_FAILED.equals(returnCode)) {
                GuiActivator.getAlertUIService().showAlertPopup(GuiActivator.getResources().getI18NString("service.gui.ERROR"), errorMessage);
            }
        }
    }
}

