/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.filetransfer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.FileTransferConversationComponent;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;
import net.java.sip.communicator.util.Logger;

public class ReceiveFileConversationComponent
extends FileTransferConversationComponent
implements ActionListener,
FileTransferStatusListener,
FileTransferListener {
    private final Logger logger = Logger.getLogger(ReceiveFileConversationComponent.class);
    private final IncomingFileTransferRequest fileTransferRequest;
    private final OperationSetFileTransfer fileTransferOpSet;
    private final ChatPanel chatPanel;
    private final Date date;
    private final String dateString;
    private File downloadFile;

    public ReceiveFileConversationComponent(ChatPanel chatPanel, OperationSetFileTransfer opSet, IncomingFileTransferRequest request, Date date) {
        this.chatPanel = chatPanel;
        this.fileTransferOpSet = opSet;
        this.fileTransferRequest = request;
        this.date = date;
        this.dateString = this.getDateString(date);
        this.fileTransferOpSet.addFileTransferListener((FileTransferListener)this);
        byte[] thumbnail = request.getThumbnail();
        if (thumbnail != null && thumbnail.length > 0) {
            ImageIcon thumbnailIcon = new ImageIcon(thumbnail);
            if (thumbnailIcon.getIconWidth() > 64 || thumbnailIcon.getIconHeight() > 64) {
                thumbnailIcon = ImageUtils.getScaledRoundedIcon((byte[])thumbnail, (int)64, (int)64);
            }
            this.imageLabel.setIcon(thumbnailIcon);
        }
        this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_REQUEST_RECIEVED", new String[]{this.fileTransferRequest.getSender().getDisplayName()}));
        String fileName = this.getFileLabel(request.getFileName(), request.getFileSize());
        this.fileLabel.setText(fileName);
        this.acceptButton.setVisible(true);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiveFileConversationComponent.this.titleLabel.setText(ReceiveFileConversationComponent.this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_PREPARING", new String[]{ReceiveFileConversationComponent.this.fileTransferRequest.getSender().getDisplayName()}));
                ReceiveFileConversationComponent.this.acceptButton.setVisible(false);
                ReceiveFileConversationComponent.this.rejectButton.setVisible(false);
                ReceiveFileConversationComponent.this.cancelButton.setVisible(true);
                ReceiveFileConversationComponent.this.progressBar.setVisible(true);
                ReceiveFileConversationComponent.this.downloadFile = ReceiveFileConversationComponent.this.createFile(ReceiveFileConversationComponent.this.fileTransferRequest);
                new AcceptFile(ReceiveFileConversationComponent.this.downloadFile).start();
            }
        });
        this.rejectButton.setVisible(true);
        this.rejectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReceiveFileConversationComponent.this.fileTransferRequest.rejectFile();
                    ReceiveFileConversationComponent.this.acceptButton.setVisible(false);
                    ReceiveFileConversationComponent.this.rejectButton.setVisible(false);
                    ReceiveFileConversationComponent.this.setWarningStyle(true);
                    ReceiveFileConversationComponent.this.fileLabel.setText("");
                    ReceiveFileConversationComponent.this.titleLabel.setText(ReceiveFileConversationComponent.this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_REFUSED"));
                    ReceiveFileConversationComponent.this.chatPanel.removeActiveFileTransfer(ReceiveFileConversationComponent.this.fileTransferRequest.getID());
                }
                catch (OperationFailedException e1) {
                    ReceiveFileConversationComponent.this.logger.error((Object)"Failed to reject file", (Throwable)e1);
                }
            }
        });
        this.progressBar.setMaximum((int)this.fileTransferRequest.getFileSize());
    }

    private File createFile(IncomingFileTransferRequest fileTransferRequest) {
        String incomingFileName;
        File downloadDir;
        File downloadFile;
        block8: {
            downloadFile = null;
            downloadDir = null;
            incomingFileName = fileTransferRequest.getFileName();
            incomingFileName = incomingFileName.replaceAll("[\\\\/:*?\"<>|]", "_");
            try {
                downloadDir = GuiActivator.getFileAccessService().getDefaultDownloadDirectory();
                if (!downloadDir.exists()) {
                    if (!downloadDir.mkdirs()) {
                        this.logger.error((Object)("Could not create the download directory : " + downloadDir.getAbsolutePath()));
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Download directory created : " + downloadDir.getAbsolutePath()));
                    }
                }
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug((Object)"Unable to find download directory.", (Throwable)e);
            }
        }
        downloadFile = new File(downloadDir, incomingFileName);
        int index = 0;
        int filenameLenght = incomingFileName.lastIndexOf(".");
        if (filenameLenght == -1) {
            filenameLenght = incomingFileName.length();
        }
        while (downloadFile.exists()) {
            String newFileName = incomingFileName.substring(0, filenameLenght) + "-" + ++index + incomingFileName.substring(filenameLenght);
            downloadFile = new File(downloadDir, newFileName);
        }
        if (!downloadFile.getName().equals(fileTransferRequest.getFileName())) {
            String fileName = this.getFileLabel(downloadFile.getName(), fileTransferRequest.getFileSize());
            this.fileLabel.setText(fileName);
        }
        return downloadFile;
    }

    public void statusChanged(FileTransferStatusChangeEvent event) {
        FileTransfer fileTransfer = event.getFileTransfer();
        int status = event.getNewStatus();
        String fromContactName = this.fileTransferRequest.getSender().getDisplayName();
        if (status == 0 || status == 1 || status == 2 || status == 3) {
            fileTransfer.removeStatusListener((FileTransferStatusListener)this);
        }
        if (status == 6) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_PREPARING", new String[]{fromContactName}));
        } else if (status == 2) {
            this.hideProgressRelatedComponents();
            this.cancelButton.setVisible(false);
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_RECEIVE_FAILED", new String[]{fromContactName}));
            this.setWarningStyle(true);
        } else if (status == 4) {
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_RECEIVING_FROM", new String[]{fromContactName}));
            this.setWarningStyle(false);
            if (!this.progressBar.isVisible()) {
                this.progressBar.setVisible(true);
            }
        } else if (status == 0) {
            this.setCompletedDownloadFile(this.downloadFile);
            this.hideProgressRelatedComponents();
            this.cancelButton.setVisible(false);
            this.openFileButton.setVisible(true);
            this.openFolderButton.setVisible(true);
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_RECEIVE_COMPLETED", new String[]{fromContactName}));
        } else if (status == 1) {
            this.hideProgressRelatedComponents();
            this.cancelButton.setVisible(false);
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_CANCELED"));
            this.setWarningStyle(true);
        } else if (status == 3) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_REFUSED", new String[]{fromContactName}));
            this.cancelButton.setVisible(false);
            this.openFileButton.setVisible(false);
            this.openFolderButton.setVisible(false);
            this.setWarningStyle(true);
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    protected String getProgressLabel(String bytesString) {
        return resources.getI18NString("service.gui.RECEIVED", new String[]{bytesString});
    }

    public void fileTransferCreated(FileTransferCreatedEvent event) {
    }

    public void fileTransferRequestCanceled(FileTransferRequestEvent event) {
        IncomingFileTransferRequest request = event.getRequest();
        if (request.equals(this.fileTransferRequest)) {
            this.acceptButton.setVisible(false);
            this.rejectButton.setVisible(false);
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_CANCELED"));
            this.setWarningStyle(true);
        }
    }

    public void fileTransferRequestReceived(FileTransferRequestEvent event) {
    }

    public void fileTransferRequestRejected(FileTransferRequestEvent event) {
    }

    private class AcceptFile
    extends SwingWorker {
        private FileTransfer fileTransfer;
        private final File downloadFile;

        public AcceptFile(File downloadFile) {
            this.downloadFile = downloadFile;
        }

        public Object construct() {
            this.fileTransfer = ReceiveFileConversationComponent.this.fileTransferRequest.acceptFile(this.downloadFile);
            ReceiveFileConversationComponent.this.chatPanel.addActiveFileTransfer(this.fileTransfer.getID(), this.fileTransfer);
            ReceiveFileConversationComponent.this.fileTransferOpSet.removeFileTransferListener((FileTransferListener)ReceiveFileConversationComponent.this);
            this.fileTransfer.addStatusListener((FileTransferStatusListener)ReceiveFileConversationComponent.this.chatPanel);
            this.fileTransfer.addStatusListener((FileTransferStatusListener)ReceiveFileConversationComponent.this);
            return "";
        }

        public void finished() {
            if (this.fileTransfer != null) {
                ReceiveFileConversationComponent.this.setFileTransfer(this.fileTransfer, ReceiveFileConversationComponent.this.fileTransferRequest.getFileSize());
            }
        }
    }
}

