/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.SourceUIContact;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class SourceContactRightButtonMenu
extends SIPCommPopupMenu
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private final SourceUIContact sourceUIContact;
    private final SourceContact sourceContact;
    private SIPCommMenu callContactMenu;
    private Component addContactComponent;
    private JMenuItem sendMessageItem;

    public SourceContactRightButtonMenu(SourceUIContact sourceUIContact) {
        this.sourceUIContact = sourceUIContact;
        this.sourceContact = (SourceContact)sourceUIContact.getDescriptor();
        this.initItems();
    }

    private void initItems() {
        Component c;
        ContactDetail cDetail = this.sourceContact.getPreferredContactDetail(OperationSetBasicTelephony.class);
        if (cDetail != null && (c = this.initCallMenu()) != null) {
            this.add(c);
        }
        if (!GuiActivator.getMUCService().isMUCSourceContact(this.sourceContact) && !ConfigurationUtils.isAddContactDisabled()) {
            this.addContactComponent = TreeContactList.createAddContactMenu(this.sourceContact);
        }
        List imProviders = AccountUtils.getRegisteredProviders(OperationSetBasicInstantMessaging.class);
        List smsProviders = AccountUtils.getRegisteredProviders(OperationSetSmsMessaging.class);
        if (imProviders.size() + (smsProviders == null ? 0 : smsProviders.size()) >= 1) {
            this.initSendMessageMenu();
        }
        if (this.addContactComponent != null) {
            this.add(this.addContactComponent);
        }
        for (JMenuItem item : this.sourceUIContact.getContactCustomActionMenuItems(true)) {
            this.add(item);
        }
    }

    private void initSendMessageMenu() {
        this.sendMessageItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SEND_MESSAGE"));
        this.sendMessageItem.setName("sendMessage");
        this.sendMessageItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEND_MESSAGE"));
        this.sendMessageItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEND_MESSAGE_16x16_ICON)));
        this.sendMessageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiActivator.getUIService().getChatWindowManager().startChat(SourceContactRightButtonMenu.this.sourceContact.getContactAddress())) {
                    new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.NO_ONLINE_MESSAGING_ACCOUNT")).showDialog();
                    return;
                }
            }
        });
        this.add(this.sendMessageItem);
    }

    private Component initCallMenu() {
        this.callContactMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.CALL"));
        this.callContactMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_16x16_ICON)));
        List details = this.sourceContact.getContactDetails(OperationSetBasicTelephony.class);
        for (final ContactDetail detail : details) {
            List providers = AccountUtils.getOpSetRegisteredProviders(OperationSetBasicTelephony.class, (ProtocolProviderService)detail.getPreferredProtocolProvider(OperationSetBasicTelephony.class), (String)detail.getPreferredProtocol(OperationSetBasicTelephony.class));
            int providersCount = providers.size();
            if (providers == null || providersCount <= 0) continue;
            JMenuItem callContactItem = new JMenuItem();
            callContactItem.setText(detail.getDetail());
            callContactItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List providers = AccountUtils.getOpSetRegisteredProviders(OperationSetBasicTelephony.class, (ProtocolProviderService)detail.getPreferredProtocolProvider(OperationSetBasicTelephony.class), (String)detail.getPreferredProtocol(OperationSetBasicTelephony.class));
                    int providersCount = providers.size();
                    if (providers == null || providersCount <= 0) {
                        new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.CALL_FAILED"), GuiActivator.getResources().getI18NString("service.gui.NO_ONLINE_TELEPHONY_ACCOUNT")).showDialog();
                        return;
                    }
                    if (providersCount > 1) {
                        ChooseCallAccountDialog dialog = new ChooseCallAccountDialog(detail.getDetail(), OperationSetBasicTelephony.class, providers);
                        dialog.setUIContact(SourceContactRightButtonMenu.this.sourceUIContact);
                        dialog.setVisible(true);
                    } else {
                        CallManager.createCall((ProtocolProviderService)providers.get(0), detail.getDetail(), SourceContactRightButtonMenu.this.sourceUIContact);
                    }
                }
            });
            callContactItem.setEnabled(detail.getSupportedOperationSets().contains(OperationSetBasicTelephony.class));
            this.callContactMenu.add(callContactItem);
        }
        if (this.callContactMenu.getMenuComponentCount() == 0) {
            return null;
        }
        if (this.callContactMenu.getMenuComponentCount() == 1) {
            JMenuItem menu = (JMenuItem)this.callContactMenu.getMenuComponent(0);
            menu.setIcon(this.callContactMenu.getIcon());
            menu.setText(this.callContactMenu.getText());
            return menu;
        }
        return this.callContactMenu;
    }

    public void loadSkin() {
        this.callContactMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_16x16_ICON)));
        this.sendMessageItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEND_MESSAGE_16x16_ICON)));
        if (this.addContactComponent instanceof JMenuItem) {
            ((JMenuItem)this.addContactComponent).setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
        }
    }
}

