/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommOpaquePanelUI;
import net.java.sip.communicator.impl.gui.main.presence.GlobalStatusSelectorBox;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.impl.gui.utils.PluginContainer;
import net.java.sip.communicator.plugin.desktoputil.EmphasizedLabel;
import net.java.sip.communicator.plugin.desktoputil.FramedImage;
import net.java.sip.communicator.plugin.desktoputil.FramedImageWithMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.SelectAvatarMenu;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalAvatarChangeEvent;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalDisplayDetailsListener;
import net.java.sip.communicator.service.globaldisplaydetails.event.GlobalDisplayNameChangeEvent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;

public class AccountStatusPanel
extends TransparentPanel
implements RegistrationStateChangeListener,
PluginComponentListener,
GlobalDisplayDetailsListener,
Skinnable {
    private static final String uiClassID = AccountStatusPanel.class.getName() + "OpaquePanelUI";
    private static final String PNAME_DISABLE_AVATAR_MENU = "net.java.sip.communicator.gui.DISABLE_AVATAR_MENU";
    private static final int AVATAR_ICON_HEIGHT = 50;
    private static final int AVATAR_ICON_WIDTH = 50;
    private final FramedImage accountImageLabel;
    private final JLabel accountNameLabel = new EmphasizedLabel(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT_ME"));
    private Color bgColor;
    private Image logoBgImage;
    private final GlobalStatusSelectorBox statusComboBox;
    private TexturePaint texture;
    private final TransparentPanel toolbarPluginPanel;
    private final TransparentPanel southPluginPanel;
    private final PluginContainer southPluginContainer;
    private final PluginContainer mainToolbarPluginContainer;
    private final JLabel statusMessageLabel = new JLabel();
    private final TransparentPanel rightPanel = new TransparentPanel();

    public AccountStatusPanel() {
        super((LayoutManager)new BorderLayout(10, 0));
        FramedImageWithMenu imageWithMenu = new FramedImageWithMenu(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO)), 50, 50);
        if (!GuiActivator.getConfigurationService().getBoolean(PNAME_DISABLE_AVATAR_MENU, false)) {
            imageWithMenu.setPopupMenu((JPopupMenu)new SelectAvatarMenu(imageWithMenu));
        }
        this.accountImageLabel = imageWithMenu;
        this.accountNameLabel.setFont(this.accountNameLabel.getFont().deriveFont(12.0f));
        this.accountNameLabel.setOpaque(false);
        this.statusComboBox = new GlobalStatusSelectorBox(this);
        this.statusComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        TransparentPanel statusToolsPanel = new TransparentPanel((LayoutManager)new BorderLayout(0, 0));
        SIPCommMenuBar statusMenuBar = new SIPCommMenuBar();
        statusMenuBar.add((JMenu)((Object)this.statusComboBox));
        statusToolsPanel.add((Component)statusMenuBar, (Object)"West");
        this.toolbarPluginPanel = new TransparentPanel((LayoutManager)new FlowLayout(2, 0, 0));
        this.mainToolbarPluginContainer = new PluginContainer((JComponent)this.toolbarPluginPanel, Container.CONTAINER_MAIN_TOOL_BAR);
        statusToolsPanel.add((Component)this.toolbarPluginPanel, (Object)"East");
        this.statusMessageLabel.setFont(this.statusMessageLabel.getFont().deriveFont(9.0f));
        this.statusMessageLabel.setForeground(Color.GRAY);
        this.rightPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.rightPanel.add((Component)this.accountNameLabel, (Object)"North");
        this.rightPanel.add((Component)this.statusMessageLabel, (Object)"Center");
        this.rightPanel.add((Component)statusToolsPanel, (Object)"South");
        this.add((Component)this.accountImageLabel, "West");
        this.add((Component)this.rightPanel, "Center");
        this.southPluginPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.southPluginContainer = new PluginContainer((JComponent)this.southPluginPanel, Container.CONTAINER_ACCOUNT_SOUTH);
        this.add((Component)this.southPluginPanel, "South");
        this.loadSkin();
        GuiActivator.getUIService().addPluginComponentListener(this);
        GlobalDisplayDetailsService gDService = GuiActivator.getGlobalDisplayDetailsService();
        if (gDService != null) {
            gDService.addGlobalDisplayDetailsListener((GlobalDisplayDetailsListener)this);
            String globalDisplayName = gDService.getGlobalDisplayName();
            if (StringUtils.isNotEmpty((CharSequence)globalDisplayName)) {
                this.accountNameLabel.setText(globalDisplayName);
            }
        }
    }

    void setStatusMessage(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            this.rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        } else {
            this.rightPanel.setBorder(null);
            this.statusMessageLabel.setText(text);
        }
    }

    public void addAccount(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.addAccount(protocolProvider);
                }
            });
            return;
        }
        this.statusComboBox.addAccount(protocolProvider);
        protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    public void removeAccount(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.removeAccount(protocolProvider);
                }
            });
            return;
        }
        if (this.containsAccount(protocolProvider)) {
            this.statusComboBox.removeAccount(protocolProvider);
            protocolProvider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    public boolean containsAccount(ProtocolProviderService protocolProvider) {
        return this.statusComboBox.containsAccount(protocolProvider);
    }

    public void updateStatus(final ProtocolProviderService protocolProvider, final PresenceStatus newStatus) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.updateStatus(protocolProvider, newStatus);
                }
            });
            return;
        }
        if (newStatus != null) {
            this.statusComboBox.updateStatus(protocolProvider, newStatus);
        } else {
            this.statusComboBox.updateStatus(protocolProvider);
        }
    }

    public void updateStatus(ProtocolProviderService protocolProvider) {
        this.updateStatus(protocolProvider, null);
    }

    public void updateImage(ImageIcon img) {
        this.accountImageLabel.setImageIcon(img.getImage());
        this.accountImageLabel.setMaximumSize(new Dimension(50, 50));
        this.revalidate();
        this.repaint();
    }

    public void startConnecting(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.startConnecting(protocolProvider);
                }
            });
            return;
        }
        this.statusComboBox.startConnecting(protocolProvider);
    }

    public void stopConnecting(final ProtocolProviderService protocolProvider) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.stopConnecting(protocolProvider);
                }
            });
            return;
        }
        this.statusComboBox.stopConnecting(protocolProvider);
    }

    public boolean hasSelectedMenus() {
        return this.statusComboBox.hasSelectedMenus();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.logoBgImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g.setColor(this.bgColor);
            g2.setPaint(this.texture);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.logoBgImage, this.getWidth() - this.logoBgImage.getWidth(null), 0, null);
        }
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory pluginComponent = event.getPluginComponentFactory();
        Container containerID = pluginComponent.getContainer();
        if (containerID.equals((Object)Container.CONTAINER_MAIN_TOOL_BAR) || containerID.equals((Object)Container.CONTAINER_ACCOUNT_SOUTH)) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory pluginComponent = event.getPluginComponentFactory();
        Container pluginContainer = pluginComponent.getContainer();
        if (pluginContainer.equals((Object)Container.CONTAINER_MAIN_TOOL_BAR) || pluginContainer.equals((Object)Container.CONTAINER_ACCOUNT_SOUTH)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void globalDisplayNameChanged(final GlobalDisplayNameChangeEvent event) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.globalDisplayNameChanged(event);
                }
            });
            return;
        }
        String displayName = event.getNewDisplayName();
        if (StringUtils.isNotEmpty((CharSequence)displayName)) {
            this.accountNameLabel.setText(displayName);
        }
    }

    public void globalDisplayAvatarChanged(final GlobalAvatarChangeEvent event) {
        byte[] avatarImage;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountStatusPanel.this.globalDisplayAvatarChanged(event);
                }
            });
        }
        if ((avatarImage = event.getNewAvatar()) != null) {
            this.accountImageLabel.setImageIcon(avatarImage);
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        ProtocolProviderService protocolProvider = evt.getProvider();
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERING)) {
            this.startConnecting(protocolProvider);
        } else {
            this.updateStatus(protocolProvider);
        }
    }

    public void loadSkin() {
        this.bgColor = new Color(GuiActivator.getResources().getColor("service.gui.LOGO_BAR_BACKGROUND"));
        this.logoBgImage = ImageLoader.getImage(ImageLoader.WINDOW_TITLE_BAR);
        BufferedImage bgImage = ImageLoader.getImage(ImageLoader.WINDOW_TITLE_BAR_BG);
        this.texture = new TexturePaint(bgImage, new Rectangle(0, 0, bgImage.getWidth(null), bgImage.getHeight(null)));
        GuiActivator.getUIService().addPluginComponentListener(this);
        byte[] avatar = null;
        if (GuiActivator.getGlobalDisplayDetailsService() != null) {
            avatar = GuiActivator.getGlobalDisplayDetailsService().getGlobalDisplayAvatar();
        }
        if (avatar == null || avatar.length <= 0) {
            this.accountImageLabel.setImageIcon((Image)ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO));
        } else {
            this.accountImageLabel.setImageIcon(avatar);
        }
    }

    public String getUIClassID() {
        if (ConfigurationUtils.isTransparentWindowEnabled()) {
            return uiClassID;
        }
        return super.getUIClassID();
    }

    static {
        UIManager.getDefaults().put(uiClassID, SIPCommOpaquePanelUI.class.getName());
    }
}

