/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommStatusMenuUI;
import net.java.sip.communicator.impl.gui.main.presence.AccountStatusPanel;
import net.java.sip.communicator.impl.gui.main.presence.PresenceStatusMenu;
import net.java.sip.communicator.impl.gui.main.presence.ReadonlyStatusItem;
import net.java.sip.communicator.impl.gui.main.presence.SimpleStatusMenu;
import net.java.sip.communicator.impl.gui.main.presence.StatusEntry;
import net.java.sip.communicator.impl.gui.main.presence.StatusSelectorMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.plugin.desktoputil.presence.GlobalStatusMessageMenu;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import org.apache.commons.lang3.StringUtils;

public class GlobalStatusSelectorBox
extends StatusSelectorMenu
implements ActionListener {
    private static final String uiClassID = GlobalStatusSelectorBox.class.getName() + "StatusMenuUI";
    private static final int IMAGE_INDENT = 10;
    private static final String HIDE_GLOBAL_STATUS_MESSAGE = "net.java.sip.communicator.impl.gui.main.HIDE_GLOBAL_STATUS_MESSAGE";
    private Image arrowImage = ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON);
    private int textWidth = 0;
    private boolean isFirstAccount = true;
    private ButtonGroup group = new ButtonGroup();
    private GlobalStatusMessageMenu globalStatusMessageMenu = null;
    private final AccountStatusPanel accountStatusPanel;
    private int firstStatusIndex = -1;

    public GlobalStatusSelectorBox(AccountStatusPanel accountStatusPanel) {
        this.accountStatusPanel = accountStatusPanel;
        JLabel titleLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SET_GLOBAL_STATUS"));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add(titleLabel);
        this.addSeparator();
        GlobalStatusEnum offlineStatus = GlobalStatusEnum.ONLINE;
        this.group.add(this.createMenuItem(offlineStatus, -1));
        this.firstStatusIndex = this.getItemCount();
        if (this.isPresenceOpSetForProvidersAvailable()) {
            this.addAvailableStatuses();
        }
        this.group.add(this.createMenuItem(GlobalStatusEnum.OFFLINE, -1));
        if (!GuiActivator.getConfigurationService().getBoolean(HIDE_GLOBAL_STATUS_MESSAGE, false) && this.isPresenceOpSetForProvidersAvailable()) {
            this.addSeparator();
            this.globalStatusMessageMenu = new GlobalStatusMessageMenu(true);
            this.globalStatusMessageMenu.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("STATUS_MESSAGE_UPDATED")) {
                        GlobalStatusSelectorBox.this.changeTooltip((String)evt.getNewValue());
                    }
                }
            });
            this.add((JMenu)this.globalStatusMessageMenu.getMenu());
        }
        if (!ConfigurationUtils.isHideAccountStatusSelectorsEnabled()) {
            this.addSeparator();
        }
        this.setFont(titleLabel.getFont().deriveFont(0, 11.0f));
        if (offlineStatus != null) {
            this.setIcon(new ImageIcon(offlineStatus.getStatusIcon()));
        }
        this.setIconTextGap(2);
        this.setOpaque(false);
        this.setText("Offline");
        this.changeTooltip(null);
        this.fitSizeToText();
    }

    private void addAvailableStatuses() {
        if (this.hasAvailableStatuses()) {
            return;
        }
        int index = this.firstStatusIndex;
        for (GlobalStatusEnum status : GlobalStatusEnum.globalStatusSet) {
            if (status.equals((Object)GlobalStatusEnum.OFFLINE) || status.equals((Object)GlobalStatusEnum.ONLINE)) continue;
            this.group.add(this.createMenuItem(status, index++));
        }
    }

    private void removeAvailableStatuses() {
        for (GlobalStatusEnum status : GlobalStatusEnum.globalStatusSet) {
            JCheckBoxMenuItem item;
            if (status.equals((Object)GlobalStatusEnum.OFFLINE) || status.equals((Object)GlobalStatusEnum.ONLINE) || (item = this.getItemFromStatus((PresenceStatus)status)) == null) continue;
            this.group.remove(item);
            this.remove(item);
        }
    }

    private boolean hasAvailableStatuses() {
        for (GlobalStatusEnum status : GlobalStatusEnum.globalStatusSet) {
            if (status.equals((Object)GlobalStatusEnum.OFFLINE) || status.equals((Object)GlobalStatusEnum.ONLINE) || this.getItemFromStatus((PresenceStatus)status) == null) continue;
            return true;
        }
        return false;
    }

    private void changeTooltip(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            if (this.globalStatusMessageMenu != null) {
                this.globalStatusMessageMenu.clearSelectedItems();
            }
            this.setToolTipText("<html><b>" + GuiActivator.getResources().getI18NString("service.gui.SET_GLOBAL_STATUS") + "</b></html>");
            this.accountStatusPanel.setStatusMessage(null);
        } else {
            this.setToolTipText("<html><b>" + message + "</b></html>");
            this.accountStatusPanel.setStatusMessage(message);
        }
    }

    private JCheckBoxMenuItem createMenuItem(GlobalStatusEnum status, int index) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(GlobalStatusEnum.getI18NStatusName((GlobalStatusEnum)status), new ImageIcon(status.getStatusIcon()));
        menuItem.setName(status.getStatusName());
        menuItem.addActionListener(this);
        if (index == -1) {
            this.add(menuItem);
        } else {
            this.add(menuItem, index);
        }
        return menuItem;
    }

    public void addAccount(ProtocolProviderService protocolProvider) {
        ImageObserver itemToAdd;
        if (protocolProvider.getAccountID().isHidden()) {
            return;
        }
        OperationSetPersistentPresence presenceOpSet = (OperationSetPersistentPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (protocolProvider.getAccountID().isStatusMenuHidden()) {
            itemToAdd = new ReadonlyStatusItem(protocolProvider);
        } else {
            StatusEntry statusEntry = itemToAdd = presenceOpSet != null ? new PresenceStatusMenu(protocolProvider) : new SimpleStatusMenu(protocolProvider);
        }
        if (ConfigurationUtils.isHideAccountStatusSelectorsEnabled()) {
            ((JComponent)itemToAdd).setVisible(false);
        }
        if (this.isFirstAccount) {
            this.add((JMenuItem)itemToAdd);
            this.isFirstAccount = false;
            if (presenceOpSet != null) {
                this.addAvailableStatuses();
            }
            return;
        }
        boolean isMenuAdded = false;
        AccountID accountId = protocolProvider.getAccountID();
        for (Component c : this.getPopupMenu().getComponents()) {
            if (!(c instanceof StatusEntry)) continue;
            StatusEntry menu = (StatusEntry)((Object)c);
            int menuIndex = this.getPopupMenu().getComponentIndex(menu.getEntryComponent());
            AccountID menuAccountID = menu.getProtocolProvider().getAccountID();
            int protocolCompare = accountId.getProtocolDisplayName().compareTo(menuAccountID.getProtocolDisplayName());
            if (protocolCompare < 0) {
                this.insert((JMenuItem)itemToAdd, menuIndex);
                isMenuAdded = true;
                break;
            }
            if (protocolCompare != 0 || accountId.getDisplayName().compareTo(menuAccountID.getDisplayName()) >= 0) continue;
            this.insert((JMenuItem)itemToAdd, menuIndex);
            isMenuAdded = true;
            break;
        }
        if (!isMenuAdded) {
            this.add((JMenuItem)itemToAdd);
        }
        if (presenceOpSet != null) {
            this.addAvailableStatuses();
        }
    }

    public void removeAccount(ProtocolProviderService protocolProvider) {
        StatusEntry menu = this.getStatusEntry(protocolProvider);
        if (menu != null) {
            menu.dispose();
            this.remove(menu.getEntryComponent());
        }
        if (!this.isPresenceOpSetForProvidersAvailable()) {
            this.removeAvailableStatuses();
        }
    }

    private boolean isPresenceOpSetForProvidersAvailable() {
        for (Component c : this.getPopupMenu().getComponents()) {
            StatusEntry menu;
            if (!(c instanceof StatusEntry) || (menu = (StatusEntry)((Object)c)).getProtocolProvider().getOperationSet(OperationSetPresence.class) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsAccount(ProtocolProviderService protocolProvider) {
        return this.getStatusEntry(protocolProvider) != null;
    }

    public void startConnecting(ProtocolProviderService protocolProvider) {
        StatusEntry menu = this.getStatusEntry(protocolProvider);
        if (menu != null) {
            menu.startConnecting();
        }
    }

    public void stopConnecting(ProtocolProviderService protocolProvider) {
        StatusEntry menu = this.getStatusEntry(protocolProvider);
        if (menu != null) {
            menu.stopConnecting();
        }
    }

    public boolean hasSelectedMenus() {
        for (Component c : this.getComponents()) {
            StatusEntry menu;
            if (!(c instanceof StatusEntry) || !(menu = (StatusEntry)((Object)c)).isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemName = menuItem.getName();
        if (GuiActivator.getGlobalStatusService() != null) {
            GuiActivator.getGlobalStatusService().publishStatus(GlobalStatusEnum.getStatusByName((String)itemName));
        }
    }

    public void updateStatus(ProtocolProviderService protocolProvider) {
        PresenceStatus presenceStatus;
        StatusEntry accountMenu = this.getStatusEntry(protocolProvider);
        if (accountMenu == null) {
            return;
        }
        if (!protocolProvider.isRegistered()) {
            presenceStatus = accountMenu.getOfflineStatus();
        } else {
            presenceStatus = AccountStatusUtils.getPresenceStatus((ProtocolProviderService)protocolProvider);
            if (presenceStatus == null) {
                presenceStatus = accountMenu.getOnlineStatus();
            }
        }
        accountMenu.updateStatus(presenceStatus);
        accountMenu.repaint();
        this.updateGlobalStatus();
    }

    public void updateStatus(ProtocolProviderService protocolProvider, PresenceStatus presenceStatus) {
        StatusEntry accountMenu = this.getStatusEntry(protocolProvider);
        if (accountMenu == null) {
            return;
        }
        accountMenu.updateStatus(presenceStatus);
        this.updateGlobalStatus();
    }

    private void updateGlobalStatus() {
        if (GuiActivator.getGlobalStatusService() == null) {
            return;
        }
        PresenceStatus globalStatus = GuiActivator.getGlobalStatusService().getGlobalPresenceStatus();
        JCheckBoxMenuItem item = this.getItemFromStatus(globalStatus);
        item.setSelected(true);
        this.setSelected(new SelectedObject(item.getText(), item.getIcon(), (Object)item));
        this.fitSizeToText();
        this.revalidate();
        this.setSystrayIcon(globalStatus);
        if (!globalStatus.isOnline()) {
            this.changeTooltip(null);
        }
    }

    private void setSystrayIcon(PresenceStatus globalStatus) {
        SystrayService trayService = GuiActivator.getSystrayService();
        if (trayService == null) {
            return;
        }
        int imgType = 2;
        if (globalStatus.equals((Object)GlobalStatusEnum.OFFLINE)) {
            imgType = 2;
        } else if (globalStatus.equals((Object)GlobalStatusEnum.DO_NOT_DISTURB)) {
            imgType = 5;
        } else if (globalStatus.equals((Object)GlobalStatusEnum.AWAY)) {
            imgType = 3;
        } else if (globalStatus.equals((Object)GlobalStatusEnum.EXTENDED_AWAY)) {
            imgType = 6;
        } else if (globalStatus.equals((Object)GlobalStatusEnum.ONLINE)) {
            imgType = 0;
        } else if (globalStatus.equals((Object)GlobalStatusEnum.FREE_FOR_CHAT)) {
            imgType = 4;
        }
        trayService.setSystrayIcon(imgType);
    }

    private JCheckBoxMenuItem getItemFromStatus(PresenceStatus globalStatus) {
        for (Component c : this.getMenuComponents()) {
            if (!(c instanceof JCheckBoxMenuItem) || !globalStatus.getStatusName().equals(c.getName())) continue;
            return (JCheckBoxMenuItem)c;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.textWidth != 0) {
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                g.drawImage(this.arrowImage, this.textWidth + 20 + 2, this.getX() + (this.getHeight() - this.arrowImage.getHeight(null)) / 2 + 1, null);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void fitSizeToText() {
        String text = this.getText();
        this.textWidth = text == null ? 0 : ComponentUtils.getStringWidth((Component)((Object)this), (String)text);
        this.setPreferredSize(new Dimension(this.textWidth + 20 + this.arrowImage.getWidth(null) + 5, 20));
    }

    private StatusEntry getStatusEntry(ProtocolProviderService protocolProvider) {
        for (Component c : this.getPopupMenu().getComponents()) {
            StatusEntry menu;
            if (!(c instanceof StatusEntry) || (menu = (StatusEntry)((Object)c)).getProtocolProvider() == null || !menu.getProtocolProvider().equals(protocolProvider)) continue;
            return menu;
        }
        return null;
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        this.arrowImage = ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON);
        this.updateGlobalStatus();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateStatus(PresenceStatus presenceStatus) {
    }

    static {
        UIManager.getDefaults().put(uiClassID, SIPCommStatusMenuUI.class.getName());
    }
}

