/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.presence.StatusSelectorMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.plugin.desktoputil.presence.StatusMessageMenu;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.utils.logging.Logger;

public class PresenceStatusMenu
extends StatusSelectorMenu
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(PresenceStatusMenu.class);
    private JLabel titleArea;
    private JLabel messageArea;
    private StatusMessageMenu statusMessageMenu;
    private ButtonGroup group = new ButtonGroup();

    public PresenceStatusMenu(ProtocolProviderService protocolProvider) {
        super(protocolProvider.getAccountID().getDisplayName(), ImageLoader.getAccountStatusImage(protocolProvider), protocolProvider);
        this.presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        Iterator statusIterator = this.presence.getSupportedStatusSet();
        String tooltip = "<html><b>" + protocolProvider.getAccountID().getDisplayName() + "</b><br>Connecting</html>";
        this.setToolTipText(tooltip);
        this.titleArea = new JLabel();
        this.titleArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.titleArea.setOpaque(false);
        this.titleArea.setFont(this.titleArea.getFont().deriveFont(1));
        this.messageArea = new JLabel();
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.messageArea.setOpaque(false);
        this.messageArea.setVisible(false);
        this.messageArea.setFont(this.messageArea.getFont().deriveFont(0));
        this.statusMessageMenu = new StatusMessageMenu(protocolProvider, true);
        this.statusMessageMenu.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateTitleArea();
        this.add(this.titleArea);
        this.add(this.messageArea);
        this.addSeparator();
        while (statusIterator.hasNext()) {
            PresenceStatus status = (PresenceStatus)statusIterator.next();
            byte[] statusIcon = status.getStatusIcon();
            this.addItem(status.getStatusName(), statusIcon == null ? null : new ImageIcon(statusIcon), this);
        }
        this.addSeparator();
        this.add((JMenu)this.statusMessageMenu.getMenu());
        this.setSelectedStatus(this.getOfflineStatus());
        this.updateStatus(this.getOfflineStatus());
    }

    public void addItem(String text, Icon icon, ActionListener actionListener) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(text, icon);
        item.setName(text);
        this.group.add(item);
        item.addActionListener(actionListener);
        this.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String menuItemText = ((JMenuItem)e.getSource()).getText();
            Iterator statusSet = this.presence.getSupportedStatusSet();
            while (statusSet.hasNext()) {
                PresenceStatus status = (PresenceStatus)statusSet.next();
                if (!status.getStatusName().equals(menuItemText)) continue;
                if (GuiActivator.getGlobalStatusService() != null) {
                    GuiActivator.getGlobalStatusService().publishStatus(this.protocolProvider, status);
                }
                this.setSelectedStatus(status);
                break;
            }
        }
    }

    @Override
    public void updateStatus(PresenceStatus presenceStatus) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Update status for provider: " + this.protocolProvider.getAccountID().getAccountAddress() + ". The new status will be: " + presenceStatus.getStatusName()));
        }
        this.setSelectedStatus(presenceStatus);
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem item = this.getItem(i);
            if (!(item instanceof JCheckBoxMenuItem)) continue;
            if (item.getName().equals(presenceStatus.getStatusName())) {
                item.setSelected(true);
                continue;
            }
            item.setText(item.getName());
        }
    }

    private void updateTitleArea() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PresenceStatusMenu.this.updateTitleArea();
                }
            });
            return;
        }
        this.titleArea.setText(this.protocolProvider.getAccountID().getDisplayName());
        String statusMessage = this.statusMessageMenu.getCurrentMessage();
        if (StringUtils.isEmpty((CharSequence)statusMessage)) {
            this.messageArea.setText("");
            this.messageArea.setVisible(false);
        } else {
            this.messageArea.setText(statusMessage);
            this.messageArea.setVisible(true);
        }
    }

    public void setSelectedStatus(PresenceStatus status) {
        ImageIcon statusImage = ImageLoader.getAccountStatusImage(this.protocolProvider);
        SelectedObject selectedObject = new SelectedObject((Icon)statusImage, (Object)status.getStatusName());
        this.setSelected(selectedObject);
        String tooltip = this.getToolTipText();
        tooltip = tooltip.substring(0, tooltip.lastIndexOf("<br>"));
        this.setToolTipText(tooltip.concat("<br>" + status.getStatusName()));
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        this.setIcon(ImageLoader.getAccountStatusImage(this.protocolProvider));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("STATUS_MESSAGE_UPDATED")) {
            this.updateTitleArea();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.presence = null;
        this.titleArea = null;
        if (this.statusMessageMenu != null) {
            this.statusMessageMenu.removePropertyChangeListener((PropertyChangeListener)this);
            this.statusMessageMenu.dispose();
        }
        this.statusMessageMenu = null;
    }
}

