/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.net.URI;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.OtrPolicyImpl;
import net.java.otr4j.OtrSessionManager;
import net.java.otr4j.OtrSessionManagerImpl;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.crypto.OtrCryptoException;
import net.java.otr4j.session.FragmenterInstructions;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionStatus;
import net.java.sip.communicator.plugin.otr.OtrActionHandler;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrConfigurator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.ScOtrEngine;
import net.java.sip.communicator.plugin.otr.ScOtrEngineListener;
import net.java.sip.communicator.plugin.otr.ScSessionID;
import net.java.sip.communicator.plugin.otr.ScSessionStatus;
import net.java.sip.communicator.plugin.otr.authdialog.SmpAuthenticateBuddyDialog;
import net.java.sip.communicator.plugin.otr.authdialog.SmpProgressDialog;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.ChatLinkClickedListener;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessagingTransport;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ScOtrEngineImpl
implements ScOtrEngine,
ChatLinkClickedListener,
ServiceListener {
    private static final int SESSION_TIMEOUT = OtrActivator.configService.getInt("net.java.sip.communicator.plugin.otr.SESSION_STATUS_TIMEOUT", 30000);
    private ScSessionStatusScheduler scheduler = new ScSessionStatusScheduler();
    private Map<SessionID, ScSessionStatus> scSessionStatusMap = new ConcurrentHashMap<SessionID, ScSessionStatus>();
    private static final Map<ScSessionID, OtrContactManager.OtrContact> contactsMap = new Hashtable<ScSessionID, OtrContactManager.OtrContact>();
    private static final Map<OtrContactManager.OtrContact, SmpProgressDialog> progressDialogMap = new ConcurrentHashMap<OtrContactManager.OtrContact, SmpProgressDialog>();
    private final OtrConfigurator configurator = new OtrConfigurator();
    private final List<String> injectedMessageUIDs = new Vector<String>();
    private final List<ScOtrEngineListener> listeners = new Vector<ScOtrEngineListener>();
    private final Logger logger = Logger.getLogger(ScOtrEngineImpl.class);
    private final OtrEngineHost otrEngineHost = new ScOtrEngineHost();
    private final OtrSessionManager otrEngine = new OtrSessionManagerImpl(this.otrEngineHost);

    public static OtrContactManager.OtrContact getOtrContact(SessionID sessionID) {
        return contactsMap.get(new ScSessionID(sessionID));
    }

    public static ScSessionID getScSessionForGuid(UUID guid) {
        for (ScSessionID scSessionID : contactsMap.keySet()) {
            if (!scSessionID.getGUID().equals(guid)) continue;
            return scSessionID;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionID getSessionID(OtrContactManager.OtrContact otrContact) {
        ProtocolProviderService pps = otrContact.contact.getProtocolProvider();
        String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
        SessionID sessionID = new SessionID(pps.getAccountID().getAccountUniqueID(), otrContact.contact.getAddress() + resourceName, pps.getProtocolName());
        Map<ScSessionID, OtrContactManager.OtrContact> map = contactsMap;
        synchronized (map) {
            if (contactsMap.containsKey(new ScSessionID(sessionID))) {
                return sessionID;
            }
            ScSessionID scSessionID = new ScSessionID(sessionID);
            contactsMap.put(scSessionID, otrContact);
        }
        return sessionID;
    }

    public ScOtrEngineImpl() {
        contactsMap.clear();
        this.scSessionStatusMap.clear();
        this.otrEngine.addOtrEngineListener(new OtrEngineListener(){

            @Override
            public void sessionStatusChanged(SessionID sessionID) {
                OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
                if (otrContact == null) {
                    return;
                }
                String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
                Contact contact = otrContact.contact;
                ScOtrEngineImpl.this.scheduler.cancel(otrContact);
                ScSessionStatus scSessionStatus = ScOtrEngineImpl.this.getSessionStatus(otrContact);
                String message = "";
                Session session = ScOtrEngineImpl.this.otrEngine.getSession(sessionID);
                switch (session.getSessionStatus()) {
                    case ENCRYPTED: {
                        scSessionStatus = ScSessionStatus.ENCRYPTED;
                        ScOtrEngineImpl.this.scSessionStatusMap.put(sessionID, scSessionStatus);
                        PublicKey remotePubKey = session.getRemotePublicKey();
                        String remoteFingerprint = null;
                        try {
                            remoteFingerprint = new OtrCryptoEngineImpl().getFingerprint(remotePubKey);
                        }
                        catch (OtrCryptoException e) {
                            ScOtrEngineImpl.this.logger.debug((Object)("Could not get the fingerprint from the public key of contact: " + contact));
                        }
                        List<String> allFingerprintsOfContact = OtrActivator.scOtrKeyManager.getAllRemoteFingerprints(contact);
                        if (allFingerprintsOfContact != null && !allFingerprintsOfContact.contains(remoteFingerprint)) {
                            OtrActivator.scOtrKeyManager.saveFingerprint(contact, remoteFingerprint);
                        }
                        if (!OtrActivator.scOtrKeyManager.isVerified(contact, remoteFingerprint)) {
                            OtrActivator.scOtrKeyManager.unverify(otrContact, remoteFingerprint);
                            UUID sessionGuid = null;
                            for (ScSessionID scSessionID : contactsMap.keySet()) {
                                if (!scSessionID.getSessionID().equals(sessionID)) continue;
                                sessionGuid = scSessionID.getGUID();
                                break;
                            }
                            OtrActivator.uiService.getChat(contact).addChatLinkClickedListener((ChatLinkClickedListener)ScOtrEngineImpl.this);
                            String unverifiedSessionWarning = OtrActivator.resourceService.getI18NString("plugin.otr.activator.unverifiedsessionwarning", new String[]{contact.getDisplayName() + resourceName, this.getClass().getName(), "AUTHENTIFICATION", sessionGuid.toString()});
                            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", unverifiedSessionWarning, "text/html");
                        }
                        String otrAndHistoryMessage = !OtrActivator.getMessageHistoryService().isHistoryLoggingEnabled() || !ScOtrEngineImpl.this.isHistoryLoggingEnabled(contact) ? OtrActivator.resourceService.getI18NString("plugin.otr.activator.historyoff", new String[]{OtrActivator.resourceService.getSettingsString("service.gui.APPLICATION_NAME"), this.getClass().getName(), "showHistoryPopupMenu"}) : OtrActivator.resourceService.getI18NString("plugin.otr.activator.historyon", new String[]{OtrActivator.resourceService.getSettingsString("service.gui.APPLICATION_NAME"), this.getClass().getName(), "showHistoryPopupMenu"});
                        OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", otrAndHistoryMessage, "text/html");
                        message = OtrActivator.resourceService.getI18NString("plugin.otr.activator.multipleinstancesdetected", new String[]{contact.getDisplayName()});
                        if (contact.supportResources() && contact.getResources() != null && contact.getResources().size() > 1) {
                            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", message, "text/plain");
                        }
                        message = OtrActivator.resourceService.getI18NString(OtrActivator.scOtrKeyManager.isVerified(contact, remoteFingerprint) ? "plugin.otr.activator.sessionstared" : "plugin.otr.activator.unverifiedsessionstared", new String[]{contact.getDisplayName() + resourceName});
                        break;
                    }
                    case FINISHED: {
                        scSessionStatus = ScSessionStatus.FINISHED;
                        ScOtrEngineImpl.this.scSessionStatusMap.put(sessionID, scSessionStatus);
                        message = OtrActivator.resourceService.getI18NString("plugin.otr.activator.sessionfinished", new String[]{contact.getDisplayName() + resourceName});
                        break;
                    }
                    case PLAINTEXT: {
                        scSessionStatus = ScSessionStatus.PLAINTEXT;
                        ScOtrEngineImpl.this.scSessionStatusMap.put(sessionID, scSessionStatus);
                        message = OtrActivator.resourceService.getI18NString("plugin.otr.activator.sessionlost", new String[]{contact.getDisplayName() + resourceName});
                    }
                }
                OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", message, "text/html");
                for (ScOtrEngineListener l : ScOtrEngineImpl.this.getListeners()) {
                    l.sessionStatusChanged(otrContact);
                }
            }

            @Override
            public void multipleInstancesDetected(SessionID sessionID) {
                OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
                if (otrContact == null) {
                    return;
                }
                for (ScOtrEngineListener l : ScOtrEngineImpl.this.getListeners()) {
                    l.multipleInstancesDetected(otrContact);
                }
            }

            @Override
            public void outgoingSessionChanged(SessionID sessionID) {
                OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
                if (otrContact == null) {
                    return;
                }
                for (ScOtrEngineListener l : ScOtrEngineImpl.this.getListeners()) {
                    l.outgoingSessionChanged(otrContact);
                }
            }
        });
    }

    private boolean isHistoryLoggingEnabled(Contact contact) {
        MetaContact metaContact = OtrActivator.getContactListService().findMetaContactByContact(contact);
        if (metaContact != null) {
            return OtrActivator.getMessageHistoryService().isHistoryLoggingEnabled(metaContact.getMetaUID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ScOtrEngineListener l) {
        List<ScOtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    public void chatLinkClicked(URI url) {
        String action = url.getPath();
        if (action.equals("/AUTHENTIFICATION")) {
            UUID guid = UUID.fromString(url.getQuery());
            if (guid == null) {
                throw new RuntimeException("No UUID found in OTR authenticate URL");
            }
            OtrActionHandler actionHandler = (OtrActionHandler)ServiceUtils.getService((BundleContext)OtrActivator.bundleContext, OtrActionHandler.class);
            if (actionHandler != null) {
                actionHandler.onAuthenticateLinkClicked(guid);
            } else {
                this.logger.error((Object)"No OtrActionHandler registered");
            }
        }
    }

    @Override
    public void endSession(OtrContactManager.OtrContact otrContact) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(otrContact);
        try {
            this.setSessionStatus(otrContact, ScSessionStatus.PLAINTEXT);
            this.otrEngine.getSession(sessionID).endSession();
        }
        catch (OtrException e) {
            this.showError(sessionID, e.getMessage());
        }
    }

    @Override
    public OtrPolicy getContactPolicy(Contact contact) {
        ProtocolProviderService pps = contact.getProtocolProvider();
        SessionID sessionID = new SessionID(pps.getAccountID().getAccountUniqueID(), contact.getAddress(), pps.getProtocolName());
        int policy = this.configurator.getPropertyInt(sessionID + "contact_policy", -1);
        if (policy < 0) {
            return this.getGlobalPolicy();
        }
        return new OtrPolicyImpl(policy);
    }

    @Override
    public OtrPolicy getGlobalPolicy() {
        int defaultScOtrPolicy = 115;
        return new OtrPolicyImpl(this.configurator.getPropertyInt("GLOBAL_POLICY", defaultScOtrPolicy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScOtrEngineListener[] getListeners() {
        List<ScOtrEngineListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new ScOtrEngineListener[this.listeners.size()]);
        }
    }

    private void setSessionStatus(OtrContactManager.OtrContact contact, ScSessionStatus status) {
        this.scSessionStatusMap.put(ScOtrEngineImpl.getSessionID(contact), status);
        this.scheduler.cancel(contact);
        for (ScOtrEngineListener l : this.getListeners()) {
            l.sessionStatusChanged(contact);
        }
    }

    @Override
    public ScSessionStatus getSessionStatus(OtrContactManager.OtrContact contact) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(contact);
        SessionStatus sessionStatus = this.otrEngine.getSession(sessionID).getSessionStatus();
        ScSessionStatus scSessionStatus = null;
        if (!this.scSessionStatusMap.containsKey(sessionID)) {
            switch (sessionStatus) {
                case PLAINTEXT: {
                    scSessionStatus = ScSessionStatus.PLAINTEXT;
                    break;
                }
                case ENCRYPTED: {
                    scSessionStatus = ScSessionStatus.ENCRYPTED;
                    break;
                }
                case FINISHED: {
                    scSessionStatus = ScSessionStatus.FINISHED;
                }
            }
            this.scSessionStatusMap.put(sessionID, scSessionStatus);
        }
        return this.scSessionStatusMap.get(sessionID);
    }

    @Override
    public boolean isMessageUIDInjected(String mUID) {
        return this.injectedMessageUIDs.contains(mUID);
    }

    @Override
    public void launchHelp() {
        ServiceReference ref = OtrActivator.bundleContext.getServiceReference(BrowserLauncherService.class.getName());
        if (ref == null) {
            return;
        }
        BrowserLauncherService service = (BrowserLauncherService)OtrActivator.bundleContext.getService(ref);
        service.openURL(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.HELP_URI"));
    }

    @Override
    public void refreshSession(OtrContactManager.OtrContact otrContact) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(otrContact);
        try {
            this.otrEngine.getSession(sessionID).refreshSession();
        }
        catch (OtrException e) {
            this.logger.error((Object)"Error refreshing session", (Throwable)e);
            this.showError(sessionID, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ScOtrEngineListener l) {
        List<ScOtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent ev) {
        Object service = OtrActivator.bundleContext.getService(ev.getServiceReference());
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        if (ev.getType() == 4) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Unregistering a ProtocolProviderService, cleaning OTR's ScSessionID to Contact map.");
                this.logger.debug((Object)"Unregistering a ProtocolProviderService, cleaning OTR's Contact to SpmProgressDialog map.");
            }
            ProtocolProviderService provider = (ProtocolProviderService)service;
            Map<ScSessionID, OtrContactManager.OtrContact> map = contactsMap;
            synchronized (map) {
                Iterator<OtrContactManager.OtrContact> i = contactsMap.values().iterator();
                while (i.hasNext()) {
                    OtrContactManager.OtrContact otrContact = i.next();
                    if (!provider.equals(otrContact.contact.getProtocolProvider())) continue;
                    this.scSessionStatusMap.remove(ScOtrEngineImpl.getSessionID(otrContact));
                    i.remove();
                }
            }
            Iterator<OtrContactManager.OtrContact> i = progressDialogMap.keySet().iterator();
            while (i.hasNext()) {
                if (!provider.equals(i.next().contact.getProtocolProvider())) continue;
                i.remove();
            }
            this.scheduler.serviceChanged(ev);
        }
    }

    @Override
    public void setContactPolicy(Contact contact, OtrPolicy policy) {
        ProtocolProviderService pps = contact.getProtocolProvider();
        SessionID sessionID = new SessionID(pps.getAccountID().getAccountUniqueID(), contact.getAddress(), pps.getProtocolName());
        String propertyID = sessionID + "contact_policy";
        if (policy == null) {
            this.configurator.removeProperty(propertyID);
        } else {
            this.configurator.setProperty(propertyID, policy.getPolicy());
        }
        for (ScOtrEngineListener l : this.getListeners()) {
            l.contactPolicyChanged(contact);
        }
    }

    @Override
    public void setGlobalPolicy(OtrPolicy policy) {
        if (policy == null) {
            this.configurator.removeProperty("GLOBAL_POLICY");
        } else {
            this.configurator.setProperty("GLOBAL_POLICY", policy.getPolicy());
        }
        for (ScOtrEngineListener l : this.getListeners()) {
            l.globalPolicyChanged();
        }
    }

    public void showError(SessionID sessionID, String err) {
        OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
        if (otrContact == null) {
            return;
        }
        Contact contact = otrContact.contact;
        OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "ErrorMessage", err, "text/plain");
    }

    @Override
    public void startSession(OtrContactManager.OtrContact otrContact) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(otrContact);
        ScSessionStatus scSessionStatus = this.getSessionStatus(otrContact);
        scSessionStatus = ScSessionStatus.LOADING;
        this.scSessionStatusMap.put(sessionID, scSessionStatus);
        for (ScOtrEngineListener l : this.getListeners()) {
            l.sessionStatusChanged(otrContact);
        }
        this.scheduler.scheduleScSessionStatusChange(otrContact, ScSessionStatus.TIMED_OUT);
        try {
            this.otrEngine.getSession(sessionID).startSession();
        }
        catch (OtrException e) {
            this.logger.error((Object)"Error starting session", (Throwable)e);
            this.showError(sessionID, e.getMessage());
        }
    }

    @Override
    public String transformReceiving(OtrContactManager.OtrContact otrContact, String msgText) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(otrContact);
        try {
            return this.otrEngine.getSession(sessionID).transformReceiving(msgText);
        }
        catch (OtrException e) {
            this.logger.error((Object)"Error receiving the message", (Throwable)e);
            this.showError(sessionID, e.getMessage());
            return null;
        }
    }

    @Override
    public String[] transformSending(OtrContactManager.OtrContact otrContact, String msgText) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(otrContact);
        try {
            return this.otrEngine.getSession(sessionID).transformSending(msgText);
        }
        catch (OtrException e) {
            this.logger.error((Object)"Error transforming the message", (Throwable)e);
            this.showError(sessionID, e.getMessage());
            return null;
        }
    }

    private Session getSession(OtrContactManager.OtrContact contact) {
        SessionID sessionID = ScOtrEngineImpl.getSessionID(contact);
        return this.otrEngine.getSession(sessionID);
    }

    @Override
    public void initSmp(OtrContactManager.OtrContact otrContact, String question, String secret) {
        Session session = this.getSession(otrContact);
        try {
            session.initSmp(question, secret);
            SmpProgressDialog progressDialog = progressDialogMap.get(otrContact);
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(otrContact.contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.init();
            progressDialog.setVisible(true);
        }
        catch (OtrException e) {
            this.logger.error((Object)("Error initializing SMP session with contact " + otrContact.contact.getDisplayName()), (Throwable)e);
            this.showError(session.getSessionID(), e.getMessage());
        }
    }

    @Override
    public void respondSmp(OtrContactManager.OtrContact otrContact, InstanceTag receiverTag, String question, String secret) {
        Session session = this.getSession(otrContact);
        try {
            session.respondSmp(receiverTag, question, secret);
            SmpProgressDialog progressDialog = progressDialogMap.get(otrContact);
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(otrContact.contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.incrementProgress();
            progressDialog.setVisible(true);
        }
        catch (OtrException e) {
            this.logger.error((Object)("Error occured when sending SMP response to contact " + otrContact.contact.getDisplayName()), (Throwable)e);
            this.showError(session.getSessionID(), e.getMessage());
        }
    }

    @Override
    public void abortSmp(OtrContactManager.OtrContact otrContact) {
        Session session = this.getSession(otrContact);
        try {
            session.abortSmp();
            SmpProgressDialog progressDialog = progressDialogMap.get(otrContact);
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(otrContact.contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.dispose();
        }
        catch (OtrException e) {
            this.logger.error((Object)("Error aborting SMP session with contact " + otrContact.contact.getDisplayName()), (Throwable)e);
            this.showError(session.getSessionID(), e.getMessage());
        }
    }

    @Override
    public PublicKey getRemotePublicKey(OtrContactManager.OtrContact otrContact) {
        if (otrContact == null) {
            return null;
        }
        Session session = this.getSession(otrContact);
        return session.getRemotePublicKey();
    }

    @Override
    public List<Session> getSessionInstances(OtrContactManager.OtrContact otrContact) {
        if (otrContact == null) {
            return Collections.emptyList();
        }
        return this.getSession(otrContact).getInstances();
    }

    @Override
    public boolean setOutgoingSession(OtrContactManager.OtrContact contact, InstanceTag tag) {
        if (contact == null) {
            return false;
        }
        Session session = this.getSession(contact);
        this.scSessionStatusMap.remove(session.getSessionID());
        return session.setOutgoingInstance(tag);
    }

    @Override
    public Session getOutgoingSession(OtrContactManager.OtrContact contact) {
        if (contact == null) {
            return null;
        }
        SessionID sessionID = ScOtrEngineImpl.getSessionID(contact);
        return this.otrEngine.getSession(sessionID).getOutgoingInstance();
    }

    private class ScSessionStatusScheduler {
        private final Timer timer = new Timer();
        private final Map<OtrContactManager.OtrContact, TimerTask> tasks = new ConcurrentHashMap<OtrContactManager.OtrContact, TimerTask>();

        private ScSessionStatusScheduler() {
        }

        public void scheduleScSessionStatusChange(final OtrContactManager.OtrContact otrContact, final ScSessionStatus status) {
            this.cancel(otrContact);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    ScOtrEngineImpl.this.setSessionStatus(otrContact, status);
                }
            };
            this.timer.schedule(task, SESSION_TIMEOUT);
            this.tasks.put(otrContact, task);
        }

        public void cancel(OtrContactManager.OtrContact otrContact) {
            TimerTask task = this.tasks.get(otrContact);
            if (task != null) {
                task.cancel();
            }
            this.tasks.remove(otrContact);
        }

        public void serviceChanged(ServiceEvent ev) {
            Object service = OtrActivator.bundleContext.getService(ev.getServiceReference());
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            if (ev.getType() == 4) {
                ProtocolProviderService provider = (ProtocolProviderService)service;
                Iterator<OtrContactManager.OtrContact> i = this.tasks.keySet().iterator();
                while (i.hasNext()) {
                    OtrContactManager.OtrContact otrContact = i.next();
                    if (!provider.equals(otrContact.contact.getProtocolProvider())) continue;
                    this.cancel(otrContact);
                    i.remove();
                }
            }
        }
    }

    private class ScOtrEngineHost
    implements OtrEngineHost {
        private ScOtrEngineHost() {
        }

        @Override
        public KeyPair getLocalKeyPair(SessionID sessionID) {
            AccountID accountID = OtrActivator.getAccountIDByUID(sessionID.getAccountID());
            KeyPair keyPair = OtrActivator.scOtrKeyManager.loadKeyPair(accountID);
            if (keyPair == null) {
                OtrActivator.scOtrKeyManager.generateKeyPair(accountID);
            }
            return OtrActivator.scOtrKeyManager.loadKeyPair(accountID);
        }

        @Override
        public OtrPolicy getSessionPolicy(SessionID sessionID) {
            return ScOtrEngineImpl.this.getContactPolicy(ScOtrEngineImpl.getOtrContact((SessionID)sessionID).contact);
        }

        @Override
        public void injectMessage(SessionID sessionID, String messageText) throws OtrException {
            Collection resources;
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            Contact contact = otrContact.contact;
            ContactResource resource = null;
            if (contact.supportResources() && (resources = contact.getResources()) != null) {
                for (ContactResource r : resources) {
                    if (!r.equals((Object)otrContact.resource)) continue;
                    resource = r;
                    break;
                }
            }
            OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
            String otrHtmlFallbackMessage = "<a href=\"http://en.wikipedia.org/wiki/Off-the-Record_Messaging\">";
            String contentType = messageText.contains(otrHtmlFallbackMessage) ? "text/html" : "text/plain";
            Message message = imOpSet.createMessage(messageText, contentType, "UTF-8", null);
            ScOtrEngineImpl.this.injectedMessageUIDs.add(message.getMessageUID());
            try {
                imOpSet.sendInstantMessage(contact, resource, message);
            }
            catch (OperationFailedException e) {
                throw new OtrException((Exception)((Object)e));
            }
        }

        @Override
        public void showError(SessionID sessionID, String err) {
            ScOtrEngineImpl.this.showError(sessionID, err);
        }

        public void showWarning(SessionID sessionID, String warn) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", warn, "text/plain");
        }

        @Override
        public void unreadableMessageReceived(SessionID sessionID) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
            Contact contact = otrContact.contact;
            String error = OtrActivator.resourceService.getI18NString("plugin.otr.activator.unreadablemsgreceived", new String[]{contact.getDisplayName() + resourceName});
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "ErrorMessage", error, "text/plain");
        }

        @Override
        public void unencryptedMessageReceived(SessionID sessionID, String msg) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            String warn = OtrActivator.resourceService.getI18NString("plugin.otr.activator.unencryptedmsgreceived");
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", warn, "text/plain");
        }

        @Override
        public void smpError(SessionID sessionID, int tlvType, boolean cheated) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            ScOtrEngineImpl.this.logger.debug((Object)("SMP error occurred. Contact: " + contact.getDisplayName() + ". TLV type: " + tlvType + ". Cheated: " + cheated));
            String error = OtrActivator.resourceService.getI18NString("plugin.otr.activator.smperror");
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "ErrorMessage", error, "text/plain");
            SmpProgressDialog progressDialog = (SmpProgressDialog)((Object)progressDialogMap.get(otrContact));
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.setProgressFail();
            progressDialog.setVisible(true);
        }

        @Override
        public void smpAborted(SessionID sessionID) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            Session session = ScOtrEngineImpl.this.otrEngine.getSession(sessionID);
            if (session.isSmpInProgress()) {
                String warn = OtrActivator.resourceService.getI18NString("plugin.otr.activator.smpaborted", new String[]{contact.getDisplayName()});
                OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", warn, "text/plain");
                SmpProgressDialog progressDialog = (SmpProgressDialog)((Object)progressDialogMap.get(otrContact));
                if (progressDialog == null) {
                    progressDialog = new SmpProgressDialog(contact);
                    progressDialogMap.put(otrContact, progressDialog);
                }
                progressDialog.setProgressFail();
                progressDialog.setVisible(true);
            }
        }

        @Override
        public void finishedSessionMessage(SessionID sessionID, String msgText) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
            Contact contact = otrContact.contact;
            String error = OtrActivator.resourceService.getI18NString("plugin.otr.activator.sessionfinishederror", new String[]{msgText, contact.getDisplayName() + resourceName});
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "ErrorMessage", error, "text/plain");
        }

        @Override
        public void requireEncryptedMessage(SessionID sessionID, String msgText) throws OtrException {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            String error = OtrActivator.resourceService.getI18NString("plugin.otr.activator.requireencryption", new String[]{msgText});
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "ErrorMessage", error, "text/plain");
        }

        @Override
        public byte[] getLocalFingerprintRaw(SessionID sessionID) {
            AccountID accountID = OtrActivator.getAccountIDByUID(sessionID.getAccountID());
            return OtrActivator.scOtrKeyManager.getLocalFingerprintRaw(accountID);
        }

        @Override
        public void askForSecret(SessionID sessionID, InstanceTag receiverTag, String question) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            SmpAuthenticateBuddyDialog dialog = new SmpAuthenticateBuddyDialog(otrContact, receiverTag, question);
            dialog.setVisible(true);
            SmpProgressDialog progressDialog = (SmpProgressDialog)((Object)progressDialogMap.get(otrContact));
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.init();
            progressDialog.setVisible(true);
        }

        @Override
        public void verify(SessionID sessionID, String fingerprint, boolean approved) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            OtrActivator.scOtrKeyManager.verify(otrContact, fingerprint);
            SmpProgressDialog progressDialog = (SmpProgressDialog)((Object)progressDialogMap.get(otrContact));
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.setProgressSuccess();
            progressDialog.setVisible(true);
        }

        @Override
        public void unverify(SessionID sessionID, String fingerprint) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            Contact contact = otrContact.contact;
            OtrActivator.scOtrKeyManager.unverify(otrContact, fingerprint);
            SmpProgressDialog progressDialog = (SmpProgressDialog)((Object)progressDialogMap.get(otrContact));
            if (progressDialog == null) {
                progressDialog = new SmpProgressDialog(contact);
                progressDialogMap.put(otrContact, progressDialog);
            }
            progressDialog.setProgressFail();
            progressDialog.setVisible(true);
        }

        @Override
        public String getReplyForUnreadableMessage(SessionID sessionID) {
            AccountID accountID = OtrActivator.getAccountIDByUID(sessionID.getAccountID());
            return OtrActivator.resourceService.getI18NString("plugin.otr.activator.unreadablemsgreply", new String[]{accountID.getDisplayName(), accountID.getDisplayName()});
        }

        @Override
        public String getFallbackMessage(SessionID sessionID) {
            AccountID accountID = OtrActivator.getAccountIDByUID(sessionID.getAccountID());
            return OtrActivator.resourceService.getI18NString("plugin.otr.activator.fallbackmessage", new String[]{accountID.getDisplayName()});
        }

        @Override
        public void multipleInstancesDetected(SessionID sessionID) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
            Contact contact = otrContact.contact;
            String message = OtrActivator.resourceService.getI18NString("plugin.otr.activator.multipleinstancesdetected", new String[]{contact.getDisplayName() + resourceName});
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", message, "text/html");
        }

        @Override
        public void messageFromAnotherInstanceReceived(SessionID sessionID) {
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            if (otrContact == null) {
                return;
            }
            String resourceName = otrContact.resource != null ? "/" + otrContact.resource.getResourceName() : "";
            Contact contact = otrContact.contact;
            String message = OtrActivator.resourceService.getI18NString("plugin.otr.activator.msgfromanotherinstance", new String[]{contact.getDisplayName() + resourceName});
            OtrActivator.uiService.getChat(contact).addMessage(contact.getDisplayName(), new Date(), "SystemMessage", message, "text/html");
        }

        @Override
        public FragmenterInstructions getFragmenterInstructions(SessionID sessionID) {
            int numberOfMessages;
            OtrContactManager.OtrContact otrContact = ScOtrEngineImpl.getOtrContact(sessionID);
            OperationSetBasicInstantMessagingTransport transport = (OperationSetBasicInstantMessagingTransport)otrContact.contact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessagingTransport.class);
            if (transport == null) {
                if (ScOtrEngineImpl.this.logger.isDebugEnabled()) {
                    ScOtrEngineImpl.this.logger.debug((Object)"No implementation of BasicInstantMessagingTransport available. Assuming OTR defaults for OTR fragmentation instructions.");
                }
                return null;
            }
            int messageSize = transport.getMaxMessageSize(otrContact.contact);
            if (messageSize == -1) {
                messageSize = -1;
            }
            if ((numberOfMessages = transport.getMaxNumberOfMessages(otrContact.contact)) == -1) {
                numberOfMessages = -1;
            }
            if (ScOtrEngineImpl.this.logger.isDebugEnabled()) {
                ScOtrEngineImpl.this.logger.debug((Object)("OTR fragmentation instructions for sending a message to " + otrContact.contact.getDisplayName() + " (" + otrContact.contact.getAddress() + "). Maximum number of messages: " + numberOfMessages + ", maximum message size: " + messageSize));
            }
            return new FragmenterInstructions(numberOfMessages, messageSize);
        }
    }
}

