/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptAcceptRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_PUBLICVALUE = 1003;
    private final BigInteger publicValue;

    public TrillianCryptAcceptRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getExtraTlvs();
        Tlv codeTlv = chain.getLastTlv(1003);
        BigInteger publicValue = null;
        if (codeTlv != null) {
            publicValue = TrillianCryptAcceptRvCmd.getBigIntFromHexBlock(codeTlv.getData());
        }
        this.publicValue = publicValue;
    }

    public TrillianCryptAcceptRvCmd(BigInteger publicValue) {
        super(1);
        this.publicValue = publicValue;
    }

    public final BigInteger getPublicValue() {
        return this.publicValue;
    }

    protected void writeExtraTlvs(OutputStream out) throws IOException {
        if (this.publicValue != null) {
            byte[] hexBlock = TrillianCryptAcceptRvCmd.getBigIntHexBlock(this.publicValue);
            new Tlv(1003, ByteBlock.wrap(hexBlock)).write(out);
        }
    }

    public String toString() {
        return "TrillianEncryptAcceptRvCmd: code=" + this.publicValue;
    }
}

