/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.phonenumbercontactsource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.plugin.phonenumbercontactsource.PNContactSourceActivator;
import net.java.sip.communicator.plugin.phonenumbercontactsource.PhoneNumberContactSource;
import net.java.sip.communicator.plugin.phonenumbercontactsource.PhoneNumberSourceContact;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import org.apache.commons.lang3.StringUtils;

public class PhoneNumberContactQuery
extends AsyncContactQuery<PhoneNumberContactSource>
implements ContactPresenceStatusListener {
    private String queryString;
    private int contactCount;
    private List<OperationSetPersistentPresence> operationSetPersistentPresences = Collections.synchronizedList(new LinkedList());
    private final boolean isQueryPhoneNumber;

    public PhoneNumberContactQuery(PhoneNumberContactSource contactSource, String queryString, int contactCount) {
        super((ContactSourceService)contactSource, Pattern.compile(queryString, 18), true);
        this.queryString = queryString;
        this.contactCount = contactCount;
        this.isQueryPhoneNumber = PNContactSourceActivator.getPhoneNumberI18nService().isPhoneNumber(queryString);
    }

    public void run() {
        Iterator<ProtocolProviderService> providers = PNContactSourceActivator.getPhoneNumberProviders().iterator();
        while (providers.hasNext() && (this.contactCount <= 0 || this.getQueryResultCount() <= this.contactCount)) {
            ProtocolProviderService provider = providers.next();
            OperationSetPersistentPresence persPresOpSet = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
            if (persPresOpSet == null) continue;
            if (!this.operationSetPersistentPresences.contains(persPresOpSet)) {
                this.operationSetPersistentPresences.add(persPresOpSet);
            }
            persPresOpSet.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
            ContactGroup rootGroup = persPresOpSet.getServerStoredContactListRoot();
            this.addResultContactsForGroup(rootGroup);
            Iterator subgroups = rootGroup.subgroups();
            while (subgroups.hasNext()) {
                ContactGroup group = (ContactGroup)subgroups.next();
                this.addResultContactsForGroup(group);
            }
        }
        if (this.getStatus() != 1) {
            this.setStatus(0);
        }
    }

    private void addResultContactsForGroup(ContactGroup group) {
        Iterator contacts = group.contacts();
        while (contacts.hasNext() && (this.contactCount <= 0 || this.getQueryResultCount() <= this.contactCount)) {
            Contact contact = (Contact)contacts.next();
            this.addAdditionalNumbers(contact);
        }
    }

    private void addAdditionalNumbers(Contact contact) {
        OperationSetServerStoredContactInfo infoOpSet = (OperationSetServerStoredContactInfo)contact.getProtocolProvider().getOperationSet(OperationSetServerStoredContactInfo.class);
        if (infoOpSet != null) {
            Iterator details = infoOpSet.getAllDetailsForContact(contact);
            while (details.hasNext() && (this.contactCount <= 0 || this.getQueryResultCount() <= this.contactCount)) {
                ServerStoredDetails.PhoneNumberDetail pnd;
                ServerStoredDetails.GenericDetail d = (ServerStoredDetails.GenericDetail)details.next();
                if (!(d instanceof ServerStoredDetails.PhoneNumberDetail) || d instanceof ServerStoredDetails.PagerDetail || d instanceof ServerStoredDetails.FaxDetail || (pnd = (ServerStoredDetails.PhoneNumberDetail)d).getNumber() == null || pnd.getNumber().length() <= 0) continue;
                String localizedType = null;
                localizedType = d instanceof ServerStoredDetails.WorkPhoneDetail ? PNContactSourceActivator.getResources().getI18NString("service.gui.WORK_PHONE") : (d instanceof ServerStoredDetails.MobilePhoneDetail ? PNContactSourceActivator.getResources().getI18NString("service.gui.MOBILE_PHONE") : (d instanceof ServerStoredDetails.VideoDetail ? PNContactSourceActivator.getResources().getI18NString("service.gui.VIDEO_PHONE") : PNContactSourceActivator.getResources().getI18NString("service.gui.HOME")));
                String contactName = contact.getDisplayName();
                String contactAddress = contact.getAddress();
                String numberString = pnd.getNumber();
                if (!StringUtils.isEmpty((CharSequence)this.queryString) && !this.query.matcher(numberString).find() && !this.query.matcher(contactName).find() && !this.query.matcher(contactAddress).find() && (!this.isQueryPhoneNumber || !PNContactSourceActivator.getPhoneNumberI18nService().phoneNumbersMatch(this.queryString, numberString))) continue;
                ArrayList<ContactDetail> contactDetails = new ArrayList<ContactDetail>();
                String detailDisplayName = pnd.getNumber() + "(" + localizedType + ")";
                ContactDetail detail = new ContactDetail(pnd.getNumber(), detailDisplayName);
                ArrayList<Class<OperationSetBasicTelephony>> supportedOpSets = new ArrayList<Class<OperationSetBasicTelephony>>();
                supportedOpSets.add(OperationSetBasicTelephony.class);
                detail.setSupportedOpSets(supportedOpSets);
                contactDetails.add(detail);
                PhoneNumberSourceContact numberSourceContact = new PhoneNumberSourceContact((ContactQuery)this, (PhoneNumberContactSource)this.getContactSource(), contact, contactDetails, detailDisplayName);
                this.addQueryResult((SourceContact)numberSourceContact);
            }
        }
    }

    protected String normalizePhoneNumber(String phoneNumber) {
        return null;
    }

    protected boolean phoneNumberMatches(String phoneNumber) {
        return false;
    }

    public void cancel() {
        this.clearListeners();
        super.cancel();
    }

    private void clearListeners() {
        for (OperationSetPersistentPresence opSetPresence : this.operationSetPersistentPresences) {
            opSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
        this.operationSetPersistentPresences.clear();
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        for (SourceContact sc : this.getQueryResults()) {
            Contact contact;
            if (!(sc instanceof PhoneNumberSourceContact) || !(contact = ((PhoneNumberSourceContact)sc).getContact()).equals(evt.getSource())) continue;
            ((PhoneNumberSourceContact)sc).setPresenceStatus(evt.getNewStatus());
            this.fireContactChanged(sc);
        }
    }

    public void setStatus(int status) {
        if (status == 1) {
            this.clearListeners();
        }
        super.setStatus(status);
    }
}

