/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.Date;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.TransformLayer;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.protocol.generic.ImEventCollector;
import net.java.sip.communicator.slick.protocol.generic.PredictableTransformLayer;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetInstantMessageTransformJabberImpl
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetInstantMessageTransformJabberImpl.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetBasicInstantMessaging opSetBasicIM1 = null;
    private OperationSetBasicInstantMessaging opSetBasicIM2 = null;
    private OperationSetInstantMessageTransform opSetTransform1 = null;
    private OperationSetInstantMessageTransform opSetTransform2 = null;
    private OperationSetPresence opSetPresence1 = null;
    private OperationSetPresence opSetPresence2 = null;
    private static final long timeout = 1000L;

    public TestOperationSetInstantMessageTransformJabberImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetBasicIM1 = (OperationSetBasicInstantMessaging)supportedOperationSets1.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM1 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetTransform1 = (OperationSetInstantMessageTransform)supportedOperationSets1.get(OperationSetInstantMessageTransform.class.getName());
        if (this.opSetTransform1 == null) {
            throw new NullPointerException("An implementation of the service must provide an OperationSetInstantMessageTransform implementation");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetBasicIM2 = (OperationSetBasicInstantMessaging)supportedOperationSets2.get(OperationSetBasicInstantMessaging.class.getName());
        if (this.opSetBasicIM2 == null) {
            throw new NullPointerException("No implementation for basic IM was found");
        }
        this.opSetTransform2 = (OperationSetInstantMessageTransform)supportedOperationSets2.get(OperationSetInstantMessageTransform.class.getName());
        if (this.opSetTransform2 == null) {
            throw new NullPointerException("An implementation of the service must provide an OperationSetInstantMessageTransform implementation");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetInstantMessageTransformJabberImpl("firstTestTransformLayerInstallation"));
        suite.addTestSuite(TestOperationSetInstantMessageTransformJabberImpl.class);
        return suite;
    }

    public void firstTestTransformLayerInstallation() {
        PredictableTransformLayer transformLayer = new PredictableTransformLayer();
        this.opSetTransform1.addTransformLayer((TransformLayer)transformLayer);
        if (!this.opSetTransform1.containsLayer((TransformLayer)transformLayer)) {
            TestOperationSetInstantMessageTransformJabberImpl.fail((String)"Transform layer did not install.");
        }
        this.opSetTransform2.addTransformLayer((TransformLayer)transformLayer);
        if (!this.opSetTransform2.containsLayer((TransformLayer)transformLayer)) {
            TestOperationSetInstantMessageTransformJabberImpl.fail((String)"Transform layer did not install.");
        }
    }

    public void testMessageReceivedTransform() throws OperationFailedException {
        String body = "This is an IM coming from the tester agent on " + new Date().toString();
        String expectedReceivedBody = "__RECEIVED____DELIVERY_PENDING__" + body;
        ImEventCollector receiversEventCollector = new ImEventCollector();
        this.opSetBasicIM1.addMessageListener((MessageListener)receiversEventCollector);
        Contact contact1 = this.opSetPresence2.findContactByID(this.fixture.userID1);
        logger.debug((Object)("Will send message \"" + body + "\" to: \"" + contact1 + "\". We expect to get back: \"" + expectedReceivedBody + "\""));
        this.opSetBasicIM2.sendInstantMessage(contact1, this.opSetBasicIM2.createMessage(body));
        receiversEventCollector.waitForEvent(1000L);
        this.opSetBasicIM1.removeMessageListener((MessageListener)receiversEventCollector);
        TestOperationSetInstantMessageTransformJabberImpl.assertTrue((String)"No events delivered upon a received message", (receiversEventCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetInstantMessageTransformJabberImpl.assertTrue((String)("Received evt was not an instance of " + MessageReceivedEvent.class.getName()), (boolean)(receiversEventCollector.collectedEvents.get(0) instanceof MessageReceivedEvent));
        MessageReceivedEvent evt = (MessageReceivedEvent)receiversEventCollector.collectedEvents.get(0);
        TestOperationSetInstantMessageTransformJabberImpl.assertEquals((String)"message sender ", (String)evt.getSourceContact().getAddress(), (String)this.fixture.userID2);
        logger.debug((Object)("We got back: \"" + evt.getSourceMessage().getContent() + "\""));
        TestOperationSetInstantMessageTransformJabberImpl.assertEquals((String)"message body", (String)expectedReceivedBody, (String)evt.getSourceMessage().getContent());
    }

    public void testMessageDeliveredTransform() throws OperationFailedException {
        String body = "This is an IM coming from the tester agent on " + new Date().toString();
        String expectedReceivedBody = "__DELIVERED__" + body;
        ImEventCollector sendersEventCollector = new ImEventCollector();
        this.opSetBasicIM2.addMessageListener((MessageListener)sendersEventCollector);
        Contact contact1 = this.opSetPresence2.findContactByID(this.fixture.userID1);
        logger.debug((Object)("Will send message \"" + body + "\" to: \"" + contact1 + "\". We expect to get back: \"" + expectedReceivedBody + "\""));
        this.opSetBasicIM2.sendInstantMessage(contact1, this.opSetBasicIM2.createMessage(body));
        sendersEventCollector.waitForEvent(1000L);
        this.opSetBasicIM2.removeMessageListener((MessageListener)sendersEventCollector);
        TestOperationSetInstantMessageTransformJabberImpl.assertTrue((String)"No events delivered upon a sent message", (sendersEventCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        TestOperationSetInstantMessageTransformJabberImpl.assertTrue((String)("Received evt was not an instance of " + MessageDeliveredEvent.class.getName()), (boolean)(sendersEventCollector.collectedEvents.get(0) instanceof MessageDeliveredEvent));
        MessageDeliveredEvent evtDelivered = (MessageDeliveredEvent)sendersEventCollector.collectedEvents.get(0);
        TestOperationSetInstantMessageTransformJabberImpl.assertEquals((String)"message sender ", (String)evtDelivered.getDestinationContact().getAddress(), (String)this.fixture.userID1);
        logger.debug((Object)("We got back: \"" + evtDelivered.getSourceMessage().getContent() + "\""));
        TestOperationSetInstantMessageTransformJabberImpl.assertEquals((String)"message body", (String)expectedReceivedBody, (String)evtDelivered.getSourceMessage().getContent());
    }

    public void testMessageDeliveryFailedTransform() {
    }
}

