/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;

public class TestOperationSetMultiUserChat2
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetMultiUserChat2.class);
    private static String testRoomBaseName = "lmuctestroom";
    private static int roomID = 0;
    private final JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetMultiUserChat opSetMUC1;
    private OperationSetMultiUserChat opSetMUC2;
    private OperationSetMultiUserChat opSetMUC3;
    private OperationSetPresence opSetPresence1;
    private OperationSetPresence opSetPresence2;
    private OperationSetPresence opSetPresence3;

    public TestOperationSetMultiUserChat2(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetMUC1 = (OperationSetMultiUserChat)supportedOperationSets1.get(OperationSetMultiUserChat.class.getName());
        if (this.opSetMUC1 == null) {
            throw new NullPointerException("No implementation for MUC was found");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetMUC2 = (OperationSetMultiUserChat)supportedOperationSets2.get(OperationSetMultiUserChat.class.getName());
        if (this.opSetMUC2 == null) {
            throw new NullPointerException("No implementation for MUC was found");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets3 = this.fixture.provider3.getSupportedOperationSets();
        if (supportedOperationSets3 == null || supportedOperationSets3.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetMUC3 = (OperationSetMultiUserChat)supportedOperationSets3.get(OperationSetMultiUserChat.class.getName());
        if (this.opSetMUC3 == null) {
            throw new NullPointerException("No implementation for MUC was found");
        }
        this.opSetPresence3 = (OperationSetPresence)supportedOperationSets3.get(OperationSetPresence.class.getName());
        if (this.opSetPresence3 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object o;
        this.fixture.clearProvidersLists();
        Object object = o = new Object();
        synchronized (object) {
            o.wait(2000L);
        }
        try {
            this.opSetPresence1.subscribe(this.fixture.userID2);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence1.subscribe(this.fixture.userID3);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence2.subscribe(this.fixture.userID1);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence2.subscribe(this.fixture.userID3);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence3.subscribe(this.fixture.userID1);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        try {
            this.opSetPresence3.subscribe(this.fixture.userID2);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        logger.info((Object)"will wait till the list prepare is completed");
        object = o;
        synchronized (object) {
            o.wait(4000L);
        }
    }

    private boolean nameIsOnMemberList(String name, List<ChatRoomMember> memberList) {
        for (ChatRoomMember member : memberList) {
            if (!member.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testCreateChatRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testJoinRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testGetJoinedChatRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testFindRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testInviteReject"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testInviteJoin"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testLeave"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testMemberBan"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testMemberKick"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testInitialParticipantsRoles"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testGrantModerator"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testRevokeVoice"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testGrantVoice"));
        suite.addTest((Test)new TestOperationSetMultiUserChat2("testRevokeModerator"));
        return suite;
    }

    public void testCreateChatRoom() throws OperationNotSupportedException, OperationFailedException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        TestOperationSetMultiUserChat2.assertNotNull((String)"createChatRoom returned null", (Object)opSet1Room);
    }

    public void testJoinRoom() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        MUCEventCollector opSet1Collector = new MUCEventCollector(this.opSetMUC1, 2);
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        opSet1Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"user1 didn't get an event since he joined", (int)1, (int)opSet1Collector.collectedEvents.size());
        LocalUserChatRoomPresenceChangeEvent changeEvent = (LocalUserChatRoomPresenceChangeEvent)opSet1Collector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the event user1 received after he joined is no LOCAL_USER_JOINED", (String)"LocalUserJoined", (String)changeEvent.getEventType());
        TestOperationSetMultiUserChat2.assertTrue((String)"we are not in the room we just joined", (boolean)opSet1Room.isJoined());
        TestOperationSetMultiUserChat2.assertTrue((String)"user is not listed in the room with his nickname", (boolean)this.nameIsOnMemberList(opSet1Room.getUserNickname(), opSet1Room.getMembers()));
    }

    public void testGetJoinedChatRoom() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        TestOperationSetMultiUserChat2.assertTrue((String)"we are not in the room we just joined", (boolean)opSet1Room.isJoined());
        List joinedRooms = this.opSetMUC1.getCurrentlyJoinedChatRooms();
        for (ChatRoom room : joinedRooms) {
            if (!room.getName().equals(opSet1Room.getName())) continue;
            return;
        }
        TestOperationSetMultiUserChat2.fail((String)"the joined room list does not contains a joined room");
    }

    public void testFindRoom() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        ChatRoom foundRoom = null;
        try {
            foundRoom = this.opSetMUC2.findRoom(testRoomName);
        }
        catch (Exception ex) {
            logger.warn((Object)ex);
        }
        TestOperationSetMultiUserChat2.assertNotNull((String)"failed to find an existing room on server", (Object)foundRoom);
        TestOperationSetMultiUserChat2.assertEquals((String)"the room found is not exactly the one we were looking for", (String)opSet1Room.getName(), (String)foundRoom.getName());
    }

    public void testInviteReject() throws OperationFailedException, OperationNotSupportedException, XmppStringprepException {
        MUCEventCollector opSet1Collector = new MUCEventCollector(this.opSetMUC1, 1);
        MUCEventCollector opSet2Collector = new MUCEventCollector(this.opSetMUC2, 1);
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        opSet1Room.invite(this.fixture.userID2, "testInviteReject");
        opSet2Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"The invitation sent from user1 to user2 has not been received ", (int)1, (int)opSet2Collector.collectedEvents.size());
        ChatRoomInvitationReceivedEvent invitationReceivedEvent = (ChatRoomInvitationReceivedEvent)opSet2Collector.collectedEvents.get(0);
        ChatRoomInvitation invitation = invitationReceivedEvent.getInvitation();
        TestOperationSetMultiUserChat2.assertEquals((String)"The inviter is not the expected user", (Object)JidCreate.bareFrom((String)this.fixture.userID1), (Object)JidCreate.bareFrom((String)invitation.getInviter()));
        TestOperationSetMultiUserChat2.assertEquals((String)"The invitation reason received differs from the one sent", (String)"testInviteReject", (String)invitation.getReason());
        this.opSetMUC2.rejectInvitation(invitation, invitation.getReason());
        opSet1Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"no response received from the invitation sent to user 2", (int)1, (int)opSet1Collector.collectedEvents.size());
        ChatRoomInvitationRejectedEvent invitationRejectedEvent = (ChatRoomInvitationRejectedEvent)opSet1Collector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the invitation has been declined  by an unexpected user", (Object)JidCreate.bareFrom((String)this.fixture.userID2), (Object)JidCreate.bareFrom((String)invitationRejectedEvent.getInvitee()));
        TestOperationSetMultiUserChat2.assertEquals((String)"the invitation is not declined for the expected reason", (String)"testInviteReject", (String)invitationRejectedEvent.getReason());
    }

    public void testInviteJoin() throws OperationFailedException, OperationNotSupportedException, XmppStringprepException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet1Room, 2);
        MUCEventCollector opSet2Collector = new MUCEventCollector(this.opSetMUC2, 1);
        opSet1Room.invite(this.fixture.userID2, "testInviteAccept");
        opSet2Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"the invitation has not been received", (int)1, (int)opSet2Collector.collectedEvents.size());
        ChatRoomInvitationReceivedEvent invitationReceivedEvent = (ChatRoomInvitationReceivedEvent)opSet2Collector.collectedEvents.get(0);
        ChatRoomInvitation invitation = invitationReceivedEvent.getInvitation();
        TestOperationSetMultiUserChat2.assertEquals((String)"The inviter is not the expected user", (Object)JidCreate.bareFrom((String)this.fixture.userID1), (Object)JidCreate.bareFrom((String)invitation.getInviter()));
        TestOperationSetMultiUserChat2.assertEquals((String)"The invitation reason received differs from the one sent", (String)"testInviteAccept", (String)invitation.getReason());
        ChatRoom opSet2Room = invitation.getTargetChatRoom();
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 2);
        opSet2Collector = new MUCEventCollector(this.opSetMUC2, 2);
        opSet2Room.join();
        opSet2Collector.waitForEvent(10000L);
        opSet2RoomCollector.waitForEvent(10000L);
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"a room member has not been notified that someone joined the room", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertEquals((String)"a room member has not been notified that someone joined the room", (int)1, (int)opSet2RoomCollector.collectedEvents.size());
        ChatRoomMemberPresenceChangeEvent memberEvent = (ChatRoomMemberPresenceChangeEvent)opSet1RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"user received an event of the wrong type ", (String)"MemberJoined", (String)memberEvent.getEventType());
        TestOperationSetMultiUserChat2.assertEquals((String)"the user who joined is not the one who was invited", (String)this.fixture.userID2, (String)memberEvent.getChatRoomMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"there is not exactly two members in the room", (int)2, (int)opSet1Room.getMembersCount());
        TestOperationSetMultiUserChat2.assertEquals((String)"user hasn't been notified of its own join", (int)1, (int)opSet2Collector.collectedEvents.size());
        LocalUserChatRoomPresenceChangeEvent localEvent = (LocalUserChatRoomPresenceChangeEvent)opSet2Collector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the event user2 received is not LOCAL_USER_JOINED", (String)"LocalUserJoined", (String)localEvent.getEventType());
        TestOperationSetMultiUserChat2.assertEquals((String)"the same room reports different members count from one side to other", (int)opSet1Room.getMembers().size(), (int)opSet2Room.getMembers().size());
        TestOperationSetMultiUserChat2.assertTrue((String)"user is not listed in the room with his nickname", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet2Room.getMembers()));
        TestOperationSetMultiUserChat2.assertTrue((String)"user is not listed in the room with his nickname ,from peer side", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet1Room.getMembers()));
    }

    public void testLeave() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        if (opSet2Room.isJoined()) {
            opSet2Room.leave();
        }
        TestOperationSetMultiUserChat2.assertFalse((String)"user is in a room he left or didnt joined", (boolean)opSet2Room.isJoined());
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet1Room, 2);
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 2);
        opSet2Room.join();
        opSet2RoomCollector.waitForEvent(10000L);
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"a room member has not been notified that someone else joined the room", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertTrue((String)"user failed to join a room", (boolean)opSet2Room.isJoined());
        TestOperationSetMultiUserChat2.assertTrue((String)"user nickname not found in the room after join ", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet2Room.getMembers()));
        TestOperationSetMultiUserChat2.assertTrue((String)"user nickname not found in the room after join, from peer side", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet1Room.getMembers()));
        opSet1RoomCollector.collectedEvents.clear();
        opSet2Room.leave();
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertFalse((String)"an user is reported present in a room he left", (boolean)opSet2Room.isJoined());
        TestOperationSetMultiUserChat2.assertFalse((String)"user nickname is still on the room list after he left", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet2Room.getMembers()));
        TestOperationSetMultiUserChat2.assertEquals((String)"an user joined and left and a room member missed events ", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        ChatRoomMemberPresenceChangeEvent memberEvent = (ChatRoomMemberPresenceChangeEvent)opSet1RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"user received an event of the wrong type ", (String)"MemberLeft", (String)memberEvent.getEventType());
        TestOperationSetMultiUserChat2.assertEquals((String)"the user who left is not the expected one", (String)this.fixture.userID2, (String)memberEvent.getChatRoomMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertFalse((String)"user nickname is still on the room list after he left, from the peer side", (boolean)this.nameIsOnMemberList(opSet2Room.getUserNickname(), opSet1Room.getMembers()));
    }

    public void testNickName() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        String user1FirstNick = opSet1Room.getUserNickname();
        String user1SecondNick = "user1nickchange";
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        opSet2Room.join();
        TestOperationSetMultiUserChat2.assertTrue((String)"user nickname not found by peer ", (boolean)this.nameIsOnMemberList(user1FirstNick, opSet2Room.getMembers()));
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 4);
        opSet1Room.setUserNickname(user1SecondNick);
        TestOperationSetMultiUserChat2.assertEquals((String)"failed to change user nickname", (String)user1SecondNick, (String)opSet1Room.getUserNickname());
        TestOperationSetMultiUserChat2.assertTrue((String)"user nickname not found on member list after modification", (boolean)this.nameIsOnMemberList(user1SecondNick, opSet1Room.getMembers()));
        opSet2RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"no event received since a member changed his nick", (int)1, (int)opSet2RoomCollector.collectedEvents.size());
        ChatRoomMemberPropertyChangeEvent changeEvent = (ChatRoomMemberPropertyChangeEvent)opSet2RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the change event doesnt comes from the expected member", (String)this.fixture.userID1, (String)changeEvent.getSourceChatRoomMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertTrue((String)"user nickname not found on member list after modification, from peer side", (boolean)this.nameIsOnMemberList(user1SecondNick, opSet2Room.getMembers()));
        TestOperationSetMultiUserChat2.assertFalse((String)"both old and new nick are listed in a room after nick change", (boolean)this.nameIsOnMemberList(user1FirstNick, opSet1Room.getMembers()));
        TestOperationSetMultiUserChat2.assertFalse((String)"both old and new nick are listed in a room after nick change, from the peer side", (boolean)this.nameIsOnMemberList(user1FirstNick, opSet2Room.getMembers()));
        try {
            opSet2Room.setUserNickname(user1SecondNick);
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
        if (opSet1Room.getUserNickname().equals(opSet2Room.getUserNickname())) {
            TestOperationSetMultiUserChat2.fail((String)"different users are holding the same nick in the same room");
        }
    }

    public void testRoomSubject() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        String newSubjet = "bingo";
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        opSet2Room.join();
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 4);
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet2Room, 4);
        String oldSubject = opSet1Room.getSubject();
        opSet1Room.setSubject(newSubjet);
        opSet1RoomCollector.waitForEvent(20000L);
        opSet2RoomCollector.waitForEvent(20000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"user1 didnt received an event for room subject change", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertEquals((String)"user2 didnt received an event for room subject change", (int)1, (int)opSet2RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertEquals((String)"the room subject is not up to date ", (String)newSubjet, (String)opSet1Room.getSubject());
        TestOperationSetMultiUserChat2.assertEquals((String)"the room subject is not up to date from peer side", (String)newSubjet, (String)opSet2Room.getSubject());
        ChatRoomPropertyChangeEvent changeEvent = (ChatRoomPropertyChangeEvent)opSet1RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the old subject provided by the change event is not the good one", (Object)oldSubject, (Object)changeEvent.getOldValue());
        TestOperationSetMultiUserChat2.assertEquals((String)"the new subject provided by the change event is not the good one", (Object)newSubjet, (Object)changeEvent.getNewValue());
        ChatRoomPropertyChangeEvent peerEvent = (ChatRoomPropertyChangeEvent)opSet2RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"both sides didn't received similar change event ", (Object)changeEvent.getOldValue(), (Object)peerEvent.getOldValue());
        TestOperationSetMultiUserChat2.assertEquals((String)"both sides didn't received similar change event ", (Object)changeEvent.getNewValue(), (Object)peerEvent.getNewValue());
    }

    public void testConferenceChat() throws OperationFailedException, OperationNotSupportedException {
        String testRoomName = testRoomBaseName + roomID++;
        logger.info((Object)("--- Start testConferenceChat room:" + testRoomName));
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        opSet2Room.join();
        String message1 = "lorem ipsum first";
        Message opSet1Message = opSet1Room.createMessage(message1);
        TestOperationSetMultiUserChat2.assertEquals((String)"created message content differ from the one provided ", (String)message1, (String)opSet1Message.getContent());
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet1Room, 3, true);
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 3, true);
        opSet1Room.sendMessage(opSet1Message);
        opSet1RoomCollector.waitForEvent(10000L);
        opSet2RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"user1 didn't received an event for message delivery ", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertEquals((String)"user2 didn't received the message", (int)1, (int)opSet2RoomCollector.collectedEvents.size());
        ChatRoomMessageDeliveredEvent deliveryEvent = (ChatRoomMessageDeliveredEvent)opSet1RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"message type is not CONVERSATION_MESSAGE_DELIVERED", (int)1, (int)deliveryEvent.getEventType());
        TestOperationSetMultiUserChat2.assertSame((String)"the message has been delivered to another room instance", (Object)opSet1Room, (Object)deliveryEvent.getSourceChatRoom());
        TestOperationSetMultiUserChat2.assertEquals((String)"delivered message differ from sent message", (String)message1, (String)deliveryEvent.getMessage().getContent());
        ChatRoomMessageReceivedEvent messageEvent = (ChatRoomMessageReceivedEvent)opSet2RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"message type is not CONVERSATION_MESSAGE_RECEIVED", (int)1, (int)messageEvent.getEventType());
        TestOperationSetMultiUserChat2.assertSame((String)"the message comes from another room instance", (Object)opSet2Room, (Object)messageEvent.getSourceChatRoom());
        ChatRoomMember member = messageEvent.getSourceChatRoomMember();
        TestOperationSetMultiUserChat2.assertEquals((String)"message comes from an unexpected user", (String)opSet1Room.getUserNickname(), (String)member.getName());
        TestOperationSetMultiUserChat2.assertEquals((String)"received message differ from sent message", (String)message1, (String)messageEvent.getMessage().getContent());
        logger.info((Object)("--- End testConferenceChat room:" + testRoomName));
    }

    public void testMemberBan() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String testRoomName = testRoomBaseName + roomID++;
        logger.info((Object)("--- Start testMemberBan room:" + testRoomName));
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet1Room, 2);
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        opSet2Room.join();
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 not on member list after join", (boolean)this.nameIsOnMemberList(this.fixture.userID2, opSet1Room.getMembers()));
        List members = opSet1Room.getMembers();
        ChatRoomMember memberToBan = null;
        for (ChatRoomMember member : members) {
            if (!member.getContactAddress().equals(this.fixture.userID2)) continue;
            memberToBan = member;
            break;
        }
        if (memberToBan == null) {
            throw new IllegalStateException("member to ban not found");
        }
        opSet1RoomCollector = new MUCEventCollector(opSet1Room, 5);
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 not in a room he joined ", (boolean)opSet2Room.isJoined());
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 2);
        opSet1Room.banParticipant(memberToBan, "testMemberBan");
        opSet2RoomCollector.waitForEvent(2000L);
        TestOperationSetMultiUserChat2.assertFalse((String)"user2 still in a room after been banned", (boolean)opSet2Room.isJoined());
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"user1 didnt received an event for user2 ban", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        TestOperationSetMultiUserChat2.assertFalse((String)"user2 still on member list after ban", (boolean)this.nameIsOnMemberList(this.fixture.userID2, opSet1Room.getMembers()));
        try {
            opSet2Room.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestOperationSetMultiUserChat2.assertFalse((String)"user2 just joined a room where he is banned", (boolean)opSet2Room.isJoined());
        logger.info((Object)("--- End testMemberBan room:" + testRoomName));
    }

    public void testMemberKick() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String testRoomName = testRoomBaseName + roomID++;
        logger.info((Object)("--- Start testMemberKick room:" + testRoomName));
        ChatRoom opSet1Room = this.opSetMUC1.createChatRoom(testRoomName, null);
        opSet1Room.join();
        MUCEventCollector opSet1RoomCollector = new MUCEventCollector(opSet1Room, 2);
        ChatRoom opSet2Room = this.opSetMUC2.findRoom(testRoomName);
        opSet2Room.join();
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 not on member list after join", (boolean)this.nameIsOnMemberList(this.fixture.userID2, opSet1Room.getMembers()));
        List members = opSet1Room.getMembers();
        ChatRoomMember memberToKick = null;
        for (ChatRoomMember member : members) {
            if (!member.getContactAddress().equals(this.fixture.userID2)) continue;
            memberToKick = member;
            break;
        }
        if (memberToKick == null) {
            throw new IllegalStateException("member to kick not found");
        }
        opSet1RoomCollector = new MUCEventCollector(opSet1Room, 2);
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 not in a room he joined ", (boolean)opSet2Room.isJoined());
        MUCEventCollector opSet2RoomCollector = new MUCEventCollector(opSet2Room, 2);
        opSet1Room.kickParticipant(memberToKick, "testMemberKick");
        opSet2RoomCollector.waitForEvent(2000L);
        TestOperationSetMultiUserChat2.assertFalse((String)"user2 still in a room after been kicked", (boolean)opSet2Room.isJoined());
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"user1 didnt received an event for user2 kick", (int)1, (int)opSet1RoomCollector.collectedEvents.size());
        ChatRoomMemberPresenceChangeEvent changeEvent = (ChatRoomMemberPresenceChangeEvent)opSet1RoomCollector.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"the event received by user1 is not ", (String)"MemberKicked", (String)changeEvent.getEventType());
        TestOperationSetMultiUserChat2.assertEquals((String)"the kicked member is not the one expected", (String)memberToKick.getContactAddress(), (String)changeEvent.getChatRoomMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertFalse((String)"user2 still on member list after kick", (boolean)this.nameIsOnMemberList(this.fixture.userID2, opSet1Room.getMembers()));
        opSet2Room.join();
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 can't join after been kicked ", (boolean)opSet2Room.isJoined());
        opSet1RoomCollector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertTrue((String)"user2 not on list when joining after a kick", (boolean)this.nameIsOnMemberList(this.fixture.userID2, opSet1Room.getMembers()));
        logger.info((Object)("--- End testMemberKick room:" + testRoomName));
    }

    public void testInitialParticipantsRoles() throws OperationFailedException, OperationNotSupportedException {
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testInitialParticipantsRoles room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.createChatRoom(roomName, null);
        roomUser1.join();
        MUCEventCollector roomUser1Collector = new MUCEventCollector(roomUser1, 2);
        roomUser1Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected role for user1", (Object)roomUser1.getUserRole(), (Object)ChatRoomMemberRole.OWNER);
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected role for user1", (Object)roomUser1.getUserRole(), (Object)this.getRole(this.fixture.userID1, roomUser1.getMembers(), roomUser1.getName(), true));
        ChatRoom roomUser2 = this.opSetMUC2.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"Room can't be retrieved on user2's side", (Object)roomUser2);
        roomUser2.join();
        roomUser1Collector.waitForEvent(10000L);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"Room can't be retrieved on user3's side", (Object)roomUser2);
        roomUser3.join();
        roomUser1Collector.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertTrue((String)"User2 not on member list after having join the room", (boolean)this.nameIsOnMemberList(this.fixture.userID2, roomUser1.getMembers()));
        TestOperationSetMultiUserChat2.assertTrue((String)"User3 not on member list after having join the room", (boolean)this.nameIsOnMemberList(this.fixture.userID3, roomUser1.getMembers()));
        List members = roomUser1.getMembers();
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected members count", (int)3, (int)members.size());
        TestOperationSetMultiUserChat2.assertEquals((String)"The current implementation requires that room's new comers must have MEMBER role", (Object)ChatRoomMemberRole.MEMBER, (Object)this.getRole(this.fixture.userID2, members, roomName, true));
        TestOperationSetMultiUserChat2.assertEquals((String)"The current implementation requires that room's new comers must have the MEMBER role", (Object)ChatRoomMemberRole.MEMBER, (Object)this.getRole(this.fixture.userID3, members, roomName, true));
        logger.info((Object)("--- End testInitialParticipantsRoles room:" + roomName));
    }

    private ChatRoomMemberRole getRole(String userID, List<ChatRoomMember> members, String roomName, boolean printDebugInfo) {
        if (printDebugInfo) {
            logger.info((Object)("Search in mems of " + roomName + " for " + userID));
        }
        ChatRoomMemberRole roleFound = null;
        for (int i = 0; i < members.size(); ++i) {
            ChatRoomMember mem = members.get(i);
            if (mem.getContactAddress().equals(userID)) {
                roleFound = mem.getRole();
            }
            if (!printDebugInfo) continue;
            logger.info((Object)("m[" + i + "] " + mem.getContactAddress() + " r:" + mem.getRole()));
        }
        if (printDebugInfo) {
            logger.info((Object)("found role: " + roleFound));
        }
        return roleFound;
    }

    public void testGrantMembership() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testGrantMembership room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.grantMembership(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.GUEST, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.GUEST, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testGrantMembership room:" + roomName));
    }

    public void testGrantModerator() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testGrantModerator room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.grantModerator(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testGrantModerator room:" + roomName));
    }

    public void testRevokeVoice() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("---= Start test for RevokeVoice =--- room: " + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser2 = this.opSetMUC2.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user2's side", (Object)roomUser2);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser2Col = new MUCEventCollector(roomUser2, 5);
        roomUser2.revokeVoice(this.fixture.userID3);
        roomUser1Col.waitForEvent(10000L);
        roomUser2Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user2's side", (int)1, (int)roomUser2Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser2 = (ChatRoomMemberRoleChangeEvent)roomUser2Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID3, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User3's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser2.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID3, (String)roleEventUser2.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User3's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser2.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)roleEventUser2.getNewRole());
        logger.info((Object)("---= End test for RevokeVoice =--- room: " + roomName));
    }

    public void testGrantVoice() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("---= Start test for GrantVoice =--- room: " + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser2 = this.opSetMUC2.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user2's side", (Object)roomUser2);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser2Col = new MUCEventCollector(roomUser2, 5);
        roomUser2.grantVoice(this.fixture.userID3);
        roomUser1Col.waitForEvent(10000L);
        roomUser2Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser2Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser2 = (ChatRoomMemberRoleChangeEvent)roomUser2Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID3, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User3's previous role does not match", (Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser2.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID3, (String)roleEventUser2.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User3's previous role does not match", (Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)roleEventUser2.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser2.getNewRole());
        logger.info((Object)("---= End test for GrantVoice =--- room: " + roomName));
    }

    public void testGrantAdmin() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testGrantAdmin room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser2 = this.opSetMUC2.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser2);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.grantAdmin(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testGrantAdmin room:" + roomName));
    }

    public void testGrantOwnership() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testGrantOwnership room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.grantOwnership(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.OWNER, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.OWNER, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testGrantOwnership room:" + roomName));
    }

    public void testRevokeMembership() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testRevokeMembership room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.revokeMembership(this.fixture.userID2);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.GUEST, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testRevokeMembership room:" + roomName));
    }

    public void testRevokeModerator() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testRevokeModerator room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.revokeModerator(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MEMBER, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testRevokeModerator room:" + roomName));
    }

    public void testRevokeAdmin() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testRevokeAdmin room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.revokeAdmin(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.MODERATOR, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testRevokeAdmin room:" + roomName));
    }

    public void testRevokeOwnership() throws OperationFailedException, OperationNotSupportedException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String roomName = testRoomBaseName + roomID;
        logger.info((Object)("--- Start testRevokeOwnership room:" + roomName));
        ChatRoom roomUser1 = this.opSetMUC1.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user1's side", (Object)roomUser1);
        ChatRoom roomUser3 = this.opSetMUC3.findRoom(roomName);
        TestOperationSetMultiUserChat2.assertNotNull((String)"The room can't be retrieved on user3's side", (Object)roomUser3);
        MUCEventCollector roomUser1Col = new MUCEventCollector(roomUser1, 5);
        MUCEventCollector roomUser3Col = new MUCEventCollector(roomUser3, 5);
        roomUser1.revokeOwnership(this.fixture.userID2);
        roomUser1Col.waitForEvent(10000L);
        roomUser3Col.waitForEvent(10000L);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user1's side", (int)1, (int)roomUser1Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser1 = (ChatRoomMemberRoleChangeEvent)roomUser1Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Wrong count of collected events on user3's side", (int)1, (int)roomUser3Col.collectedEvents.size());
        ChatRoomMemberRoleChangeEvent roleEventUser3 = (ChatRoomMemberRoleChangeEvent)roomUser3Col.collectedEvents.get(0);
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser1.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser1.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.OWNER, (Object)roleEventUser1.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser1.getNewRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the right chatroom", (String)roomName, (String)XmppStringUtils.parseLocalpart((String)roleEventUser3.getSourceChatRoom().getName()));
        TestOperationSetMultiUserChat2.assertEquals((String)"Collected event does not belong to the expected user", (String)this.fixture.userID2, (String)roleEventUser3.getSourceMember().getContactAddress());
        TestOperationSetMultiUserChat2.assertEquals((String)"User2's previous role does not match", (Object)ChatRoomMemberRole.OWNER, (Object)roleEventUser3.getPreviousRole());
        TestOperationSetMultiUserChat2.assertEquals((String)"Unexpected new role", (Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)roleEventUser3.getNewRole());
        logger.info((Object)("--- End testRevokeOwnership room:" + roomName));
    }

    class MUCEventCollector
    implements ChatRoomInvitationRejectionListener,
    ChatRoomInvitationListener,
    LocalUserChatRoomPresenceListener,
    ChatRoomMemberPresenceListener,
    ChatRoomMessageListener,
    ChatRoomMemberPropertyChangeListener,
    ChatRoomPropertyChangeListener,
    ChatRoomMemberRoleListener,
    ChatRoomLocalUserRoleListener {
        private final ArrayList<EventObject> collectedEvents = new ArrayList();
        private int waitCount = 0;
        private final OperationSetMultiUserChat opSet;
        private final ChatRoom room;
        private static final int EVENT_INVITE = 1;
        private static final int EVENT_PRESENCE = 2;
        private static final int EVENT_MESSAGE = 3;
        private static final int EVENT_PROPERTY = 4;
        private static final int EVENT_ROLE = 5;
        private boolean skipSystemMsgs = false;

        public MUCEventCollector(OperationSetMultiUserChat opSet, int eventType) {
            this.opSet = opSet;
            this.room = null;
            switch (eventType) {
                case 1: {
                    opSet.addInvitationListener((ChatRoomInvitationListener)this);
                    opSet.addInvitationRejectionListener((ChatRoomInvitationRejectionListener)this);
                    break;
                }
                case 2: {
                    opSet.addPresenceListener((LocalUserChatRoomPresenceListener)this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid event category " + eventType);
                }
            }
        }

        public MUCEventCollector(ChatRoom room, int eventType) {
            this(room, eventType, false);
        }

        public MUCEventCollector(ChatRoom room, int eventType, boolean skipSystemMsgs) {
            this.room = room;
            this.skipSystemMsgs = skipSystemMsgs;
            this.opSet = null;
            switch (eventType) {
                case 2: {
                    room.addMemberPresenceListener((ChatRoomMemberPresenceListener)this);
                    break;
                }
                case 3: {
                    room.addMessageListener((ChatRoomMessageListener)this);
                    break;
                }
                case 4: {
                    room.addMemberPropertyChangeListener((ChatRoomMemberPropertyChangeListener)this);
                    room.addPropertyChangeListener((ChatRoomPropertyChangeListener)this);
                    break;
                }
                case 5: {
                    room.addMemberRoleListener((ChatRoomMemberRoleListener)this);
                    room.addLocalUserRoleListener((ChatRoomLocalUserRoleListener)this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid event category " + eventType);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a MUC Event");
            MUCEventCollector mUCEventCollector = this;
            synchronized (mUCEventCollector) {
                if (this.collectedEvents.size() > this.waitCount) {
                    ++this.waitCount;
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedEvents.size() > this.waitCount) {
                        logger.trace((Object)"Received a MUC event.");
                    } else {
                        logger.trace((Object)("MUC event missed after " + waitFor + "ms."));
                    }
                    ++this.waitCount;
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a MUC event", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectEvent(EventObject evt) {
            MUCEventCollector mUCEventCollector = this;
            synchronized (mUCEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add(evt);
                this.notifyAll();
            }
        }

        public void invitationRejected(ChatRoomInvitationRejectedEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void invitationReceived(ChatRoomInvitationReceivedEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void memberPresenceChanged(ChatRoomMemberPresenceChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void messageReceived(ChatRoomMessageReceivedEvent evt) {
            if (this.skipSystemMsgs && evt.getEventType() == 3) {
                return;
            }
            this.collectEvent((EventObject)evt);
        }

        public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void chatRoomPropertyChanged(ChatRoomMemberPropertyChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void chatRoomPropertyChanged(ChatRoomPropertyChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void chatRoomPropertyChangeFailed(ChatRoomPropertyChangeFailedEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void memberRoleChanged(ChatRoomMemberRoleChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }

        public void localUserRoleChanged(ChatRoomLocalUserRoleChangeEvent evt) {
            this.collectEvent((EventObject)evt);
        }
    }
}

